/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.analysis;

import edu.sysu.pmglab.analysis.GenomeRegion;
import edu.sysu.pmglab.container.indexable.IndexableSet;
import edu.sysu.pmglab.container.list.IntList;
import edu.sysu.pmglab.container.list.List;
import gnu.trove.set.hash.THashSet;
import java.util.Arrays;
import java.util.HashSet;

public class CalcRegionSet {
    List<GenomeRegion> regions;
    double interactedMutCountScoreCase = Double.NaN;
    double interactedMutCountCase = Double.NaN;
    double interactedMutCountScoreCtl = Double.NaN;
    double interactedMutCountCtl = Double.NaN;
    String allRegionIDsFull;
    String allRegionNameFull;
    String allRegionIDs;
    String name;
    String description;
    int[] types;
    double[] finalFeatureScore;
    double z = Double.NaN;
    double p = Double.NaN;
    double q = Double.NaN;

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public CalcRegionSet(String name, String description) {
        this.name = name;
        this.description = description;
    }

    public void setFinalFeatureScore(double[] finalFeatureScore) {
        this.finalFeatureScore = finalFeatureScore;
    }

    public void preComputeAllMutScores() {
        this.getMutNumCase(0.5);
        this.getInteractedMutNumCase(0.5, false);
        this.getMutNumRef(0.5, false);
        this.getInteractedMutNumControl(0.5, false);
        this.getMutNumControl(0.5);
    }

    public double[] getFinalFeatureScore() {
        return this.finalFeatureScore;
    }

    public CalcRegionSet() {
    }

    public void setRegions(List<GenomeRegion> regions) {
        this.regions = regions;
    }

    public void addRegion(GenomeRegion region) {
        if (this.regions == null) {
            this.regions = new List();
        }
        this.regions.add(region);
    }

    public List<GenomeRegion> getRegions() {
        return this.regions;
    }

    public String getStart() {
        if (this.regions == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (GenomeRegion region : this.regions) {
            sb.append(region.start);
            sb.append(";");
        }
        return sb.substring(0, sb.length() - 1);
    }

    public String getChromID() {
        if (this.regions == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (GenomeRegion region : this.regions) {
            sb.append(region.getChromID());
            sb.append(";");
        }
        return sb.substring(0, sb.length() - 1);
    }

    public String getEnd() {
        if (this.regions == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (GenomeRegion region : this.regions) {
            sb.append(region.end);
            sb.append(";");
        }
        return sb.substring(0, sb.length() - 1);
    }

    public int[] getTypes() {
        if (this.regions == null) {
            return null;
        }
        if (this.types == null) {
            this.types = new int[this.regions.size()];
            for (int i = 0; i < this.types.length; ++i) {
                this.types[i] = this.regions.get(i).getType();
            }
        }
        return this.types;
    }

    public String getAllRegionIDsFull() {
        if (this.regions == null) {
            return null;
        }
        if (this.allRegionIDsFull == null) {
            StringBuilder sb = new StringBuilder();
            for (GenomeRegion region : this.regions) {
                sb.append(region.getLabel()).append("#").append(region.getType());
                sb.append(";");
            }
            this.allRegionIDsFull = sb.substring(0, sb.length() - 1);
        }
        return this.allRegionIDsFull;
    }

    public String getAllRegionNameFull(IndexableSet<String> geneSymbolMap) {
        if (this.regions == null) {
            return null;
        }
        if (this.allRegionNameFull == null) {
            StringBuilder sb = new StringBuilder();
            for (GenomeRegion region : this.regions) {
                sb.append(geneSymbolMap.valueOf(Integer.parseInt(region.getLabel())));
                sb.append(";");
            }
            this.allRegionNameFull = sb.substring(0, sb.length() - 1);
        }
        return this.allRegionNameFull;
    }

    public String getAllRegionIDs() {
        if (this.regions == null) {
            return null;
        }
        if (this.allRegionIDs == null) {
            StringBuilder sb = new StringBuilder();
            for (GenomeRegion region : this.regions) {
                sb.append(region.getLabel());
                sb.append(";");
            }
            this.allRegionIDs = sb.substring(0, sb.length() - 1);
        }
        return this.allRegionIDs;
    }

    public int getInteractedMutNumCaseFull(double bin) {
        if (this.regions == null) {
            return 0;
        }
        int size = this.regions.size();
        if (!Double.isNaN(this.interactedMutCountScoreCase)) {
            if (bin <= 0.0) {
                return (int)this.interactedMutCountCase;
            }
            return (int)(this.interactedMutCountScoreCase / bin);
        }
        THashSet<String> intersectIDs = new THashSet<String>(this.regions.get((int)0).caseIDMutMaxScoreMap.keySet());
        for (int i = 1; i < size; ++i) {
            intersectIDs.retainAll(this.regions.get((int)i).caseIDMutMaxScoreMap.keySet());
            if (!intersectIDs.isEmpty()) continue;
            this.interactedMutCountCase = 0.0;
            this.interactedMutCountScoreCase = 0.0;
            return 0;
        }
        this.interactedMutCountCase = intersectIDs.size();
        this.interactedMutCountScoreCase = 0.0;
        for (String id : intersectIDs) {
            double combinedScore = 1.0;
            for (GenomeRegion region : this.regions) {
                combinedScore *= (double)region.getScoreByCaseID(id);
            }
            this.interactedMutCountScoreCase += combinedScore;
        }
        if (bin <= 0.0) {
            return intersectIDs.size();
        }
        double combinedScore = this.interactedMutCountScoreCase / bin;
        return (int)combinedScore;
    }

    public int getInteractedMutNumCase(double bin, boolean cutoffModel) {
        if (cutoffModel) {
            return this.getInteractedMutNumCaseCutoff(bin);
        }
        return this.getInteractedMutNumCaseFull(bin);
    }

    public int getInteractedMutNumCaseCutoff(double bin) {
        if (this.regions == null) {
            return 0;
        }
        int size = this.regions.size();
        THashSet<String> intersectIDs = new THashSet<String>(this.regions.get((int)0).caseIDMutMaxScoreMap.keySet());
        for (int i = 1; i < size; ++i) {
            intersectIDs.retainAll(this.regions.get((int)i).caseIDMutMaxScoreMap.keySet());
            if (!intersectIDs.isEmpty()) continue;
            return 0;
        }
        if (bin <= 0.0) {
            return intersectIDs.size();
        }
        float score = 0.0f;
        float combinedScore = 0.0f;
        for (String id : intersectIDs) {
            float number = 1.0f;
            for (GenomeRegion region : this.regions) {
                score = region.getScoreByCaseID(id);
                score = Float.isNaN(score) ? ((double)region.getMidMutScoreCase() >= bin ? 1.0f : 0.0f) : ((double)score >= bin ? 1.0f : 0.0f);
                if ((number *= score) != 0.0f) continue;
                break;
            }
            combinedScore += number;
        }
        return (int)combinedScore;
    }

    /*
     * Exception decompiling
     */
    public double[][] getInteractedMutNumCaseControlCutoff(double bin, double[][] mutCountIndiv, boolean hasIntercept, int[] altCountIndiv) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public double[][] getMutScores4CaseControl(int subjectNum, List<String> availableGenes) {
        if (this.regions == null) {
            return null;
        }
        float score = 0.0f;
        int regionNum = this.regions.size();
        double[][] indiviGeneMutScores = new double[subjectNum][regionNum];
        for (int i = 0; i < subjectNum; ++i) {
            Arrays.fill(indiviGeneMutScores[i], 0.0);
        }
        IntList nonZeroRegions = new IntList();
        HashSet<String> availableGeneSet = new HashSet<String>();
        for (int i = 0; i < regionNum; ++i) {
            int subID;
            GenomeRegion region = this.regions.fastGet(i);
            boolean hasNonZero = false;
            for (String id : region.caseIDMutMaxScoreMap.keySet()) {
                score = region.getScoreByCaseID(id);
                availableGeneSet.add(region.label);
                if (!Float.isNaN(score)) {
                    hasNonZero = true;
                }
                subID = Integer.parseInt(id);
                indiviGeneMutScores[subID][i] = score;
            }
            for (String id : region.controlIDMutMaxScoreMap.keySet()) {
                score = region.getScoreByControlID(id);
                if (!Float.isNaN(score)) {
                    hasNonZero = true;
                }
                subID = Integer.parseInt(id);
                indiviGeneMutScores[subID][i] = score;
            }
            if (!hasNonZero) continue;
            nonZeroRegions.add(i);
        }
        if (nonZeroRegions.size() < regionNum) {
            regionNum = nonZeroRegions.size();
            availableGenes.clear();
            availableGenes.addAll(availableGeneSet);
            double[][] indiviGeneMutScoreTmp = indiviGeneMutScores;
            indiviGeneMutScores = new double[subjectNum][regionNum];
            for (int i = 0; i < subjectNum; ++i) {
                for (int j = 0; j < regionNum; ++j) {
                    indiviGeneMutScores[i][j] = indiviGeneMutScoreTmp[i][nonZeroRegions.fastGet(j)];
                }
            }
        }
        return indiviGeneMutScores;
    }

    public int getInteractedMutNumControl(double bin, boolean cutoffModel) {
        if (cutoffModel) {
            return this.getInteractedMutNumControlCutoff(bin);
        }
        return this.getInteractedMutNumControlFull(bin);
    }

    private int getInteractedMutNumControlFull(double bin) {
        if (this.regions == null) {
            return 0;
        }
        int size = this.regions.size();
        if (!Double.isNaN(this.interactedMutCountScoreCtl)) {
            if (bin <= 0.0) {
                return (int)this.interactedMutCountCtl;
            }
            return (int)(this.interactedMutCountScoreCtl / bin);
        }
        HashSet<String> intersectIDs = new HashSet<String>(this.regions.get((int)0).controlIDMutMaxScoreMap.keySet());
        for (int i = 1; i < size; ++i) {
            intersectIDs.retainAll(this.regions.get((int)i).controlIDMutMaxScoreMap.keySet());
            if (!intersectIDs.isEmpty()) continue;
            this.interactedMutCountCtl = 0.0;
            this.interactedMutCountScoreCtl = 0.0;
            return 0;
        }
        this.interactedMutCountCtl = intersectIDs.size();
        this.interactedMutCountScoreCtl = 0.0;
        for (String id : intersectIDs) {
            double combinedScore = 1.0;
            for (GenomeRegion region : this.regions) {
                combinedScore *= (double)region.getScoreByControlID(id);
            }
            this.interactedMutCountScoreCtl += combinedScore;
        }
        if (bin <= 0.0) {
            return intersectIDs.size();
        }
        double combinedScore = this.interactedMutCountScoreCtl / bin;
        return (int)combinedScore;
    }

    public int getInteractedMutNumControlCutoff(double bin) {
        if (this.regions == null) {
            return 0;
        }
        int size = this.regions.size();
        HashSet<String> intersectIDs = new HashSet<String>(this.regions.get((int)0).controlIDMutMaxScoreMap.keySet());
        for (int i = 1; i < size; ++i) {
            intersectIDs.retainAll(this.regions.get((int)i).controlIDMutMaxScoreMap.keySet());
            if (!intersectIDs.isEmpty()) continue;
            return 0;
        }
        if (bin <= 0.0) {
            return intersectIDs.size();
        }
        float totalScore = 0.0f;
        for (String id : intersectIDs) {
            float combinedScore = 1.0f;
            for (GenomeRegion region : this.regions) {
                float score = region.getScoreByControlID(id);
                score = Float.isNaN(score) ? ((double)region.getMidMutScoreControl() >= bin ? 1.0f : 0.0f) : ((double)score >= bin ? 1.0f : 0.0f);
                if ((combinedScore *= score) != 0.0f) continue;
                break;
            }
            totalScore += combinedScore;
        }
        return (int)totalScore;
    }

    public double getMutNumControl(double bin) {
        if (this.regions == null) {
            return 0.0;
        }
        double mutNum = 1.0;
        for (GenomeRegion region : this.regions) {
            mutNum *= (double)region.getMutNumControl(bin);
        }
        return mutNum;
    }

    public double getMutNumCase(double bin) {
        if (this.regions == null) {
            return 0.0;
        }
        double mutNum = 1.0;
        for (GenomeRegion region : this.regions) {
            mutNum *= (double)region.getMutNumCase(bin);
        }
        return mutNum;
    }

    public double getMutNumRef(double bin, boolean cutoffModel) {
        if (this.regions == null) {
            return 0.0;
        }
        double mutNum = 1.0;
        for (GenomeRegion region : this.regions) {
            if (cutoffModel) {
                mutNum *= region.getRefMutNumCutoff(bin);
                continue;
            }
            mutNum *= region.getRefMutNumFull(bin);
        }
        return mutNum;
    }

    public int getDiff(double bin, boolean cutoffModel) {
        if (this.regions == null) {
            return 0;
        }
        float mutNum = (float)this.getInteractedMutNumCase(bin, cutoffModel) - (float)this.getMutNumRef(bin, cutoffModel);
        return Math.round(mutNum);
    }

    public double[] getRegionScores() {
        if (this.regions == null) {
            return null;
        }
        if (this.regions.size() == 1) {
            return this.regions.get(0).getRegionScores();
        }
        double[] regionScores = new double[this.regions.get(0).getRegionScores().length];
        Arrays.fill(regionScores, 1.0);
        for (GenomeRegion region : this.regions) {
            double[] regionScores1 = region.getRegionScores();
            for (int i = 0; i < regionScores.length; ++i) {
                int n = i;
                regionScores[n] = regionScores[n] * regionScores1[i];
            }
        }
        return regionScores;
    }

    public double getZ() {
        return this.z;
    }

    public void setZ(double z) {
        this.z = z;
    }

    public double getP() {
        return this.p;
    }

    public void setP(double p) {
        this.p = p;
    }

    public double getQ() {
        return this.q;
    }

    public void setQ(double q) {
        this.q = q;
    }

    private static /* synthetic */ int[] lambda$getInteractedMutNumCaseControlCutoff$1(String k) {
        return new int[]{0};
    }
}

