/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.analysis;

import edu.sysu.pmglab.analysis.CalcRegionSet;
import edu.sysu.pmglab.bytecode.Bytes;
import edu.sysu.pmglab.container.indexable.IndexableSet;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.executor.Context;
import edu.sysu.pmglab.executor.ITask;
import edu.sysu.pmglab.executor.Status;
import edu.sysu.pmglab.progressbar.ProgressBar;
import edu.sysu.pmglab.stat.Logistic2ThresholdEstimator1;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.rosuda.REngine.REXPMismatchException;
import org.rosuda.REngine.REngineException;
import org.rosuda.REngine.Rserve.RConnection;
import org.rosuda.REngine.Rserve.RserveException;

public class CalculateEffectThresholdThread
implements ITask {
    RConnection rcon;
    double[] phenotypes;
    double[][] covariables;
    CalcRegionSet geneSet;
    final ConcurrentLinkedQueue<Bytes[]> geneSetAssocResults;
    ProgressBar bar;
    IndexableSet<String> geneSymbolMap;
    int subjectNum;
    boolean isBinary;

    public CalculateEffectThresholdThread(String rHost, int rPort, double[] phenotypes, double[][] covariables, ConcurrentLinkedQueue<Bytes[]> geneSetAssocResults, int subjectNum, boolean isBinary, IndexableSet<String> geneSymbolMap, ProgressBar bar) throws REngineException {
        this.geneSetAssocResults = geneSetAssocResults;
        this.bar = bar;
        this.phenotypes = phenotypes;
        this.covariables = covariables;
        this.subjectNum = subjectNum;
        this.isBinary = isBinary;
        this.geneSymbolMap = geneSymbolMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(Status status, Context context) throws Exception, Error {
        block10: {
            try {
                String cutoffType = "step";
                double[] statRes = this.calculateEffectThreshold(cutoffType);
                if (statRes == null) break block10;
                Bytes[] res = new Bytes[statRes.length + 3];
                res[0] = new Bytes(this.geneSet.getName());
                res[1] = new Bytes(this.geneSet.getDescription());
                for (int i = 0; i < statRes.length; ++i) {
                    res[i + 2] = new Bytes(String.valueOf(statRes[i]));
                }
                res[statRes.length + 2] = new Bytes(this.geneSet.getAllRegionNameFull(this.geneSymbolMap));
                ConcurrentLinkedQueue<Bytes[]> concurrentLinkedQueue = this.geneSetAssocResults;
                synchronized (concurrentLinkedQueue) {
                    this.geneSetAssocResults.add(res);
                }
            }
            catch (RserveException e) {
                e.printStackTrace();
                if (this.rcon != null) {
                    this.rcon.close();
                }
            }
            finally {
                this.bar.step(1L);
            }
        }
    }

    public void updateGeneSet(CalcRegionSet geneSet) {
        this.geneSet = geneSet;
    }

    private double[] calculateEffectThreshold(String cutoffType) throws Exception {
        double[] results = null;
        int m = this.covariables[0].length;
        if (m == 0) {
            throw new IllegalArgumentException("Invalid input dimensions");
        }
        List<String> availableGenes = new List<String>();
        double[][] geneScores = this.geneSet.getMutScores4CaseControl(this.subjectNum, availableGenes);
        if (geneScores == null || geneScores.length == 0 || geneScores[0].length == 0) {
            return null;
        }
        Logistic2ThresholdEstimator1 estimator = new Logistic2ThresholdEstimator1(this.phenotypes, geneScores, this.covariables);
        estimator.setTauMinProportion(0.05);
        estimator.setNumQuantilesForC(30);
        estimator.setMinPermutations(200);
        estimator.setMaxPermutations(10000);
        estimator.setStopAfterNHits(20);
        Logistic2ThresholdEstimator1.ThresholdModelResult result = estimator.fit(1000L, 1);
        results = new double[]{result.k_hat, result.k_stdErr, result.k_zValue, result.k_pValue, result.pValuePermutation, result.c_hat, result.d_hat};
        return results;
    }

    private double[] runRCutoffRegression(RConnection conn, double[][] geneScores) throws REngineException, REXPMismatchException, IOException {
        int n = geneScores.length;
        int m = geneScores[0].length;
        double[] flatArray = new double[n * m];
        int idx = 0;
        double[][] dArray = geneScores;
        int n2 = dArray.length;
        for (int i = 0; i < n2; ++i) {
            double[] row;
            for (double val : row = dArray[i]) {
                flatArray[idx++] = val;
            }
        }
        conn.assign("X_sample", flatArray);
        String rCmd = String.format("%s <- matrix(%s, nrow=%d, ncol=%d, byrow=TRUE)", "X_sample", "X_sample", n, m);
        conn.eval(rCmd);
        conn.assign("m_dim_X", String.valueOf(m));
        rCmd = "# Candidates for c and d\n# Assuming X_sample values are within [0,1] as runif was used.\nc_cand_davies_logit <- quantile(as.vector(X_sample), probs = seq(0.05, 0.95, length.out = 30), na.rm=TRUE) # Reduced for speed\nc_cand_davies_logit <- unique(pmax(0, pmin(1, c_cand_davies_logit[!is.na(c_cand_davies_logit)])))\nif(length(c_cand_davies_logit)==0) c_cand_davies_logit <- seq(0,1,length.out=10)\nd_cand_davies_logit <- 1:m_dim_X # m_dim_X is 10 in your example data\n\n";
        conn.eval(rCmd);
        rCmd = "cat(\"\\n--- Running Davies-like Test Approximation for Logit Model ---\\n\")\ndavies_logit_results <- estimate_logit_davies_like_test(\n  Y_sample, X_sample, Z_sample,\n  c_candidates = c_cand_davies_logit,\n  d_candidates = d_cand_davies_logit,\n  n_obs = length(Y_sample)\n)";
        conn.eval(rCmd);
        boolean debug = true;
        if (debug) {
            int j;
            BufferedWriter debugOut = new BufferedWriter(new FileWriter("debug.txt"));
            debugOut.write("y");
            for (j = 0; j < geneScores[0].length; ++j) {
                debugOut.write("\tx" + j);
            }
            for (j = 0; j < this.covariables[0].length; ++j) {
                debugOut.write("\tz" + j);
            }
            debugOut.write(10);
            for (int i = 0; i < this.phenotypes.length; ++i) {
                int j2;
                debugOut.write(String.valueOf(this.phenotypes[i]));
                for (j2 = 0; j2 < geneScores[i].length; ++j2) {
                    debugOut.write("\t" + geneScores[i][j2]);
                }
                for (j2 = 0; j2 < this.covariables[i].length; ++j2) {
                    debugOut.write("\t" + this.covariables[i][j2]);
                }
                debugOut.write(10);
            }
            debugOut.close();
        }
        double sup_LRT_statistic = conn.eval("davies_logit_results$sup_LRT_statistic").asDouble();
        double best_c = conn.eval("davies_logit_results$best_c").asDouble();
        double best_d = conn.eval("davies_logit_results$best_d").asDouble();
        double nominal_p_value_at_sup_LRT = conn.eval("davies_logit_results$nominal_p_value_at_sup_LRT").asDouble();
        double V_approx = conn.eval("davies_logit_results$V_approx").asDouble();
        double davies_p_upper_bound = conn.eval("davies_logit_results$davies_p_upper_bound").asDouble();
        return new double[]{sup_LRT_statistic, best_c, best_d, nominal_p_value_at_sup_LRT, V_approx, davies_p_upper_bound};
    }

    private String buildFormula(int covarCount) {
        if (covarCount == 0) {
            return "y ~ 1";
        }
        StringBuilder sb = new StringBuilder("y ~ ");
        for (int i = 1; i <= covarCount; ++i) {
            sb.append("z").append(i);
            if (i >= covarCount) continue;
            sb.append(" + ");
        }
        return sb.toString();
    }
}

