/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.analysis;

import edu.sysu.pmglab.analysis.GenomeRegion;
import edu.sysu.pmglab.container.list.DoubleList;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.executor.Context;
import edu.sysu.pmglab.executor.ITask;
import edu.sysu.pmglab.executor.Status;
import edu.sysu.pmglab.gtb.genome.Variant;
import edu.sysu.pmglab.gtb.genome.genotype.IGenotypes;
import edu.sysu.pmglab.kgga.command.SetupApplication;
import edu.sysu.pmglab.stat.LogisticRegression;
import java.io.BufferedWriter;
import java.io.FileWriter;

public class GeneAssocThread
implements ITask {
    GenomeRegion gene;
    int caseEnd;
    int subSize;
    String[] scoreNames;

    public GeneAssocThread(GenomeRegion gene, int caseEnd, int subSize, String[] scoreNames) {
        this.gene = gene;
        this.caseEnd = caseEnd;
        this.subSize = subSize;
        this.scoreNames = scoreNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(Status status, Context context) throws Exception, Error {
        List returns;
        float tmpScore;
        int effectNum;
        double avgScore;
        int mutCountGty;
        IGenotypes genotypes;
        Variant var;
        int j;
        int varSize;
        List<Variant> variants;
        int i;
        DoubleList muts = new DoubleList();
        double[][] x = new double[this.subSize][2];
        double[] y = new double[this.subSize];
        int countCase = 0;
        int countControl = 0;
        for (i = 0; i < this.caseEnd; ++i) {
            y[i] = 1.0;
            x[i][0] = 1.0;
            variants = this.gene.getVariants();
            varSize = variants.size();
            muts.clear();
            for (j = 0; j < varSize; ++j) {
                var = variants.get(j);
                genotypes = var.getGenotypes();
                mutCountGty = genotypes.get(i).getAC();
                if (mutCountGty <= 0) continue;
                avgScore = 0.0;
                effectNum = 0;
                for (String name : this.scoreNames) {
                    tmpScore = ((Float)var.getProperty(name)).floatValue();
                    if (Double.isNaN(tmpScore)) continue;
                    ++effectNum;
                    avgScore += (double)tmpScore;
                }
                if (effectNum <= 0) continue;
                muts.add(avgScore /= (double)effectNum);
            }
            if (muts.isEmpty()) {
                x[i][1] = 0.0;
                continue;
            }
            muts.sort();
            ++countCase;
            x[i][1] = muts.get(muts.size() - 1);
        }
        if (countCase < 20) {
            return;
        }
        for (i = this.caseEnd; i < this.subSize; ++i) {
            y[i] = 0.0;
            x[i][0] = 1.0;
            variants = this.gene.getVariants();
            varSize = variants.size();
            muts.clear();
            for (j = 0; j < varSize; ++j) {
                var = variants.get(j);
                genotypes = var.getGenotypes();
                mutCountGty = genotypes.get(i).getAC();
                if (mutCountGty <= 0) continue;
                avgScore = 0.0;
                effectNum = 0;
                for (String name : this.scoreNames) {
                    tmpScore = ((Float)var.getProperty(name)).floatValue();
                    if (Double.isNaN(tmpScore)) continue;
                    ++effectNum;
                    avgScore += (double)tmpScore;
                }
                if (effectNum <= 0) continue;
                muts.add(avgScore /= (double)effectNum);
            }
            if (muts.isEmpty()) {
                x[i][1] = 0.0;
                continue;
            }
            muts.sort();
            ++countControl;
            x[i][1] = muts.get(muts.size() - 1);
        }
        if (countControl < 20) {
            return;
        }
        if (this.gene.getLabel().equals("HMCN1") && this.scoreNames[0].equals("dbNSFP@MutationTaster")) {
            BufferedWriter bw = new BufferedWriter(new FileWriter("./test.txt"));
            for (int i2 = 0; i2 < this.subSize; ++i2) {
                bw.write(String.valueOf(y[i2]));
                for (int j2 = 0; j2 < x[i2].length; ++j2) {
                    bw.write("\t" + x[i2][j2]);
                }
                bw.newLine();
            }
            bw.close();
        }
        LogisticRegression lr = new LogisticRegression();
        lr.setX(x);
        lr.setY(y);
        try {
            lr.standardiseIndependent();
            lr.fitLM();
        }
        catch (IllegalArgumentException ex) {
            return;
        }
        double p = lr.getCoefPValue(1);
        String[] results = new String[]{this.gene.getLabel(), String.valueOf(this.gene.getChromID()), String.valueOf(this.gene.getStart()), String.valueOf(this.gene.getEnd()), String.valueOf(this.gene.getVariants().size()), String.valueOf(lr.getCoef(1)), String.valueOf(lr.getSE()[1]), String.valueOf(lr.getCoefPValue(1))};
        List list = returns = (List)context.cast(GeneAssocThread.class);
        synchronized (list) {
            returns.add(results);
        }
        if (!(p < 0.01)) {
            return;
        }
        SetupApplication.GlobalLogger.info("Gene: {}\t{}\t{}\t{}\t{}", results[0], p, lr.getCoef(1), lr.getSE()[1], this.scoreNames[0]);
    }
}

