/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.analysis;

import edu.sysu.pmglab.analysis.GenomeRegion;
import edu.sysu.pmglab.bytecode.Bytes;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.gtb.genome.Variant;
import edu.sysu.pmglab.gtb.genome.genotype.IGenotypes;
import edu.sysu.pmglab.stat.LogisticRegression;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeneBasedAnalyzer {
    private final Logger logger = LoggerFactory.getLogger("Gene Analyzer");

    List<Bytes[]> testMutationPerturbationDiff(GenomeRegion gene, int caseEnd, int subSize, String[][] scoreNameGroups) throws Exception {
        List<Bytes[]> groupedResults = new List<Bytes[]>();
        for (int i = 0; i < scoreNameGroups.length; ++i) {
            Bytes[] result = this.testMutationPerturbationDiff(gene, caseEnd, subSize, scoreNameGroups[i]);
            if (result == null) continue;
            groupedResults.add(result);
        }
        return groupedResults;
    }

    Bytes[] testMutationPerturbationDiff(GenomeRegion gene, int caseEnd, int subSize, String[] scoreNames) throws Exception {
        float tmpScore;
        int effectNum;
        double avgScore;
        int mutCountGty;
        IGenotypes genotypes;
        Variant var;
        int j;
        int varSize;
        List<Variant> variants;
        int i;
        List<Double> muts = new List<Double>();
        double[][] x = new double[subSize][2];
        double[] y = new double[subSize];
        int countCase = 0;
        int countControl = 0;
        for (i = 0; i < caseEnd; ++i) {
            y[i] = 1.0;
            x[i][0] = 1.0;
            variants = gene.getVariants();
            varSize = variants.size();
            muts.clear();
            for (j = 0; j < varSize; ++j) {
                var = variants.get(j);
                genotypes = var.getGenotypes();
                mutCountGty = genotypes.get(i).getAC();
                if (mutCountGty <= 0) continue;
                avgScore = 0.0;
                effectNum = 0;
                for (String name : scoreNames) {
                    tmpScore = ((Float)var.getProperty(name)).floatValue();
                    if (Double.isNaN(tmpScore)) continue;
                    ++effectNum;
                    avgScore += (double)tmpScore;
                }
                if (effectNum <= 0) continue;
                muts.add(avgScore /= (double)effectNum);
            }
            if (muts.isEmpty()) {
                x[i][1] = 1.0;
                continue;
            }
            muts.sort();
            ++countCase;
            x[i][1] = 1.0 - (Double)muts.get(muts.size() - 1);
        }
        if (countCase < 20) {
            return null;
        }
        for (i = caseEnd; i < subSize; ++i) {
            y[i] = 0.0;
            x[i][0] = 1.0;
            variants = gene.getVariants();
            varSize = variants.size();
            muts.clear();
            for (j = 0; j < varSize; ++j) {
                var = variants.get(j);
                genotypes = var.getGenotypes();
                mutCountGty = genotypes.get(i).getAC();
                if (mutCountGty <= 0) continue;
                avgScore = 0.0;
                effectNum = 0;
                for (String name : scoreNames) {
                    tmpScore = ((Float)var.getProperty(name)).floatValue();
                    if (Double.isNaN(tmpScore)) continue;
                    ++effectNum;
                    avgScore += (double)tmpScore;
                }
                if (effectNum <= 0) continue;
                muts.add(avgScore /= (double)effectNum);
            }
            if (muts.isEmpty()) {
                x[i][1] = 1.0;
                continue;
            }
            muts.sort();
            ++countControl;
            x[i][1] = 1.0 - (Double)muts.get(muts.size() - 1);
        }
        if (countControl < 20) {
            return null;
        }
        LogisticRegression lr = new LogisticRegression();
        lr.setX(x);
        lr.setY(y);
        try {
            lr.fitLM();
        }
        catch (IllegalArgumentException ex) {
            return null;
        }
        double p = lr.getCoefPValue(1);
        if (p < 1.0E-4) {
            Bytes[] results = new Bytes[]{new Bytes(gene.label), new Bytes(gene.getChromID().toString()), new Bytes(String.valueOf(gene.getStart())), new Bytes(String.valueOf(gene.getEnd())), new Bytes(String.valueOf(gene.getVariants().size())), new Bytes(String.valueOf(lr.getCoef(1))), new Bytes(String.valueOf(lr.getSE()[1])), new Bytes(String.valueOf(lr.getCoefPValue(1)))};
            this.logger.info("Gene: {}\t{}\t{}\t{}\t{}", gene.label, p, lr.getCoef(1), lr.getSE()[1], scoreNames[0]);
            return results;
        }
        return null;
    }
}

