/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.analysis;

import cern.colt.list.IntArrayList;
import edu.sysu.pmglab.ccf.field.FieldGroupMetas;
import edu.sysu.pmglab.ccf.record.IRecord;
import edu.sysu.pmglab.ccf.record.Record;
import edu.sysu.pmglab.container.interval.FloatInterval;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.executor.Context;
import edu.sysu.pmglab.executor.ITask;
import edu.sysu.pmglab.executor.Status;
import edu.sysu.pmglab.gtb.genome.Variant;
import gnu.trove.list.array.TFloatArrayList;
import java.util.Arrays;
import java.util.Map;

public class GeneMutationFreqScoreCalcuThread
implements ITask {
    String name;
    int regionTypeID;
    int chromID;
    int startPos;
    int endPos;
    List<Variant> variants;
    String[] freqFieldNames;
    String[] scoreFieldNames;
    FloatInterval mafCut;
    FloatInterval altFreqCut;
    Map<Integer, Map<Integer, int[]>> geneRegionLength;
    FieldGroupMetas outputFields;
    IRecord iRecord = null;

    public void setGeneProperties(String name, int regionTypeID, int chromID, List<Variant> variants) {
        this.name = name;
        this.regionTypeID = regionTypeID;
        this.chromID = chromID;
        if (variants.size() > 0) {
            this.startPos = variants.get(0).getPosition();
            this.endPos = variants.get(variants.size() - 1).getPosition();
        }
        this.variants = variants;
        this.iRecord = null;
    }

    public IRecord getiRecord() {
        return this.iRecord;
    }

    public GeneMutationFreqScoreCalcuThread(String[] freqFieldNames, String[] scoreFieldNames, FieldGroupMetas outputFields, Map<Integer, Map<Integer, int[]>> geneRegionLength) {
        this.freqFieldNames = freqFieldNames;
        this.scoreFieldNames = scoreFieldNames;
        this.outputFields = outputFields;
        this.geneRegionLength = geneRegionLength;
    }

    public void setParameters(FloatInterval mafCut, FloatInterval altFreqCut) {
        this.mafCut = mafCut;
        this.altFreqCut = altFreqCut;
    }

    @Override
    public void execute(Status status, Context context) throws Exception, Error {
        int i;
        int i2;
        int varSize = this.variants.size();
        int freqNum = this.freqFieldNames.length;
        int scoreNum = this.scoreFieldNames.length;
        IntArrayList erasedIDDs = new IntArrayList();
        Map<Integer, int[]> typeLenMap = this.geneRegionLength.get(Integer.parseInt(this.name));
        if (typeLenMap == null) {
            this.iRecord = null;
            return;
        }
        int[] lens = typeLenMap.get(this.regionTypeID);
        float exonLengthDouble = 1.0f;
        if (lens != null) {
            exonLengthDouble = lens[0];
            exonLengthDouble /= 1000.0f;
        }
        TFloatArrayList[] varScores = new TFloatArrayList[scoreNum];
        TFloatArrayList[] varFreqs = new TFloatArrayList[freqNum];
        for (i2 = 0; i2 < freqNum; ++i2) {
            varFreqs[i2] = new TFloatArrayList();
        }
        for (i2 = 0; i2 < scoreNum; ++i2) {
            varScores[i2] = new TFloatArrayList();
        }
        float[] freqs = new float[freqNum];
        float[] vals = new float[scoreNum];
        for (int j = 0; j < varSize; ++j) {
            int i3;
            Variant var = this.variants.get(j);
            Arrays.fill(freqs, 0.0f);
            erasedIDDs.clear();
            boolean valid = true;
            for (int i4 = 0; i4 < freqNum; ++i4) {
                float tmpFreq = ((Float)var.getProperty(this.freqFieldNames[i4])).floatValue();
                if (Float.isNaN(tmpFreq)) {
                    tmpFreq = 0.0f;
                }
                freqs[i4] = tmpFreq;
                if (this.mafCut != null && !this.mafCut.contains(tmpFreq, true)) {
                    valid = false;
                    break;
                }
                if (this.altFreqCut == null || this.altFreqCut.contains(tmpFreq, true)) continue;
                valid = false;
                break;
            }
            if (valid) continue;
            int naNum = 0;
            for (i3 = 0; i3 < scoreNum; ++i3) {
                float tmpScore;
                vals[i3] = tmpScore = ((Float)var.getProperty(this.scoreFieldNames[i3])).floatValue();
                if (!Float.isNaN(tmpScore)) continue;
                ++naNum;
            }
            if (naNum >= scoreNum - 1) continue;
            for (i3 = 0; i3 < freqNum; ++i3) {
                varFreqs[i3].add(freqs[i3]);
            }
            for (i3 = 0; i3 < scoreNum; ++i3) {
                varScores[i3].add(vals[i3]);
            }
        }
        if (varFreqs[0].isEmpty()) {
            return;
        }
        this.iRecord = new Record(this.outputFields);
        this.iRecord.set("Basic@SymbolID", (Object)this.name);
        this.iRecord.set("Basic@GeneSubRegionTypeID", (Object)this.regionTypeID);
        this.iRecord.set("Basic@Chromosome", (Object)this.chromID);
        this.iRecord.set("Basic@Start", (Object)this.startPos);
        this.iRecord.set("Basic@End", (Object)this.endPos);
        for (i = 0; i < freqNum; ++i) {
            this.iRecord.set(this.freqFieldNames[i], (Object)varFreqs[i]);
        }
        for (i = 0; i < scoreNum; ++i) {
            this.iRecord.set(this.scoreFieldNames[i], (Object)varScores[i]);
        }
    }
}

