/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.analysis;

import cern.colt.list.FloatArrayList;
import cern.colt.list.IntArrayList;
import edu.sysu.pmglab.ccf.field.FieldGroupMetas;
import edu.sysu.pmglab.ccf.record.IRecord;
import edu.sysu.pmglab.ccf.record.Record;
import edu.sysu.pmglab.container.array.FloatArray;
import edu.sysu.pmglab.container.indexable.IndexableSet;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.executor.Context;
import edu.sysu.pmglab.executor.ITask;
import edu.sysu.pmglab.executor.Status;
import edu.sysu.pmglab.gtb.genome.Variant;
import edu.sysu.pmglab.gtb.genome.coordinate.Chromosome;
import edu.sysu.pmglab.stat.SimpleLinearRegression;
import gnu.trove.map.hash.THashMap;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;

public class GeneMutationFuncImpactFreqCalcuThread
implements ITask {
    String name;
    int regionTypeID;
    Chromosome chromID;
    int startPos;
    int endPos;
    List<Variant> variants;
    IndexableSet<String> geneSymbolMap;
    String[] freqFieldNames;
    String[] scoreFieldNames;
    int[] scales;
    Map<Integer, Map<Integer, int[]>> geneRegionLength;
    FieldGroupMetas outputFields;
    IRecord iRecord;

    public void setGeneProperties(String name, int regionTypeID, Chromosome chromID, List<Variant> variants) {
        this.name = name;
        this.regionTypeID = regionTypeID;
        this.chromID = chromID;
        if (variants.size() > 0) {
            this.startPos = variants.get(0).getPosition();
            this.endPos = variants.get(variants.size() - 1).getPosition();
        }
        this.variants = variants;
        this.iRecord = null;
    }

    public void setGeneSymbolMap(IndexableSet<String> geneSymbolMap) {
        this.geneSymbolMap = geneSymbolMap;
    }

    public IRecord getiRecord() {
        return this.iRecord;
    }

    public GeneMutationFuncImpactFreqCalcuThread(String[] freqFieldNames, String[] scoreFieldNames, FieldGroupMetas outputFields, Map<Integer, Map<Integer, int[]>> geneRegionLength) {
        this.freqFieldNames = freqFieldNames;
        this.scoreFieldNames = scoreFieldNames;
        this.outputFields = outputFields;
        this.geneRegionLength = geneRegionLength;
    }

    public void setParameters(int[] scales) {
        this.scales = new int[scales.length];
        System.arraycopy(scales, 0, this.scales, 0, scales.length);
    }

    @Override
    public void execute(Status status, Context context) throws Exception, Error {
        Variant var;
        int varSize = this.variants.size();
        int freqNum = this.freqFieldNames.length;
        float[][] varFreqs = new float[varSize][freqNum];
        int folder = 1000;
        FloatArrayList floatArrayList = new FloatArrayList(freqNum);
        IntArrayList ereasedIDs = new IntArrayList();
        Map<Integer, int[]> typeLenMap = this.geneRegionLength.get(Integer.parseInt(this.name));
        if (typeLenMap == null) {
            this.iRecord = null;
            return;
        }
        int[] lens = typeLenMap.get(this.regionTypeID);
        float exonLengthDouble = 1.0f;
        if (lens != null) {
            exonLengthDouble = lens[0];
            exonLengthDouble /= 1000.0f;
        }
        exonLengthDouble = 1.0f;
        for (int j = 0; j < varSize; ++j) {
            int i;
            var = this.variants.get(j);
            Arrays.fill(varFreqs[j], 0.0f);
            ereasedIDs.clear();
            for (i = 0; i < freqNum; ++i) {
                float tmpFreq = ((Float)var.getProperty(this.freqFieldNames[i])).floatValue();
                if (Float.isNaN(tmpFreq) || tmpFreq == 0.0f) continue;
                varFreqs[j][i] = tmpFreq;
            }
            floatArrayList.elements(varFreqs[j]);
            floatArrayList.quickSort();
            for (i = 1; i < freqNum; ++i) {
                if (!(varFreqs[j][i - 1] > 0.0f) || !(varFreqs[j][i] > varFreqs[j][i - 1] * (float)folder)) continue;
                ereasedIDs.add(i);
            }
            if (ereasedIDs.isEmpty()) continue;
            int num = ereasedIDs.size();
            for (i = 0; i < num; ++i) {
                varFreqs[j][ereasedIDs.getQuick((int)i)] = 0.0f;
            }
        }
        THashMap<String, float[]> scoreFreqMap = new THashMap<String, float[]>();
        List<double[]> scoreFreqs = new List<double[]>();
        for (String scoreName : this.scoreFieldNames) {
            scoreFreqs.clear();
            for (int j = 0; j < varSize; ++j) {
                var = this.variants.get(j);
                float tmpScore = ((Float)var.getProperty(scoreName)).floatValue();
                if (Double.isNaN(tmpScore)) continue;
                double maxFreq = varFreqs[j][freqNum - 1];
                if (freqNum > 1) {
                    int ii = freqNum - 2;
                    while (maxFreq < (double)varFreqs[j][ii]) {
                        maxFreq = varFreqs[j][ii];
                        if (--ii >= 0) continue;
                    }
                }
                scoreFreqs.add(new double[]{tmpScore, maxFreq / (double)exonLengthDouble});
            }
            if (scoreFreqs.isEmpty()) continue;
            float[] results = this.generateFreqImpact(scoreFreqs);
            scoreFreqMap.put(scoreName, results);
        }
        if (scoreFreqMap.isEmpty()) {
            this.iRecord = null;
            return;
        }
        this.iRecord = new Record(this.outputFields);
        this.iRecord.set("Basic@SymbolID", (Object)Integer.parseInt(this.name));
        this.iRecord.set("Basic@GeneSubRegionTypeID", (Object)this.regionTypeID);
        this.iRecord.set("Basic@Chromosome", (Object)this.chromID);
        this.iRecord.set("Basic@Start", (Object)this.startPos);
        this.iRecord.set("Basic@End", (Object)this.endPos);
        String[] stringArray = this.scoreFieldNames;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String fieldName;
            float[] scoreWeights = (float[])scoreFreqMap.get(fieldName = stringArray[i]);
            this.iRecord.set(fieldName, (Object)(scoreWeights == null ? new FloatArray(0) : new FloatArray(scoreWeights)));
        }
    }

    float[] generateFreqImpactNew(List<double[]> scoreFreqs) {
        int t;
        double[] impacts;
        int i;
        scoreFreqs.sort((doubles, t1) -> Double.compare(t1[0], doubles[0]));
        int size = scoreFreqs.size();
        double curScore = scoreFreqs.get(0)[0];
        List<double[]> scoreWeights = new List<double[]>();
        double freqScoreSum = scoreFreqs.get(0)[1] * curScore;
        for (i = 1; i < size; ++i) {
            if (curScore != scoreFreqs.get(i)[0]) {
                impacts = new double[this.scales.length + 1];
                impacts[0] = curScore;
                for (t = 1; t < impacts.length; ++t) {
                    impacts[t] = (double)this.scales[t - 1] / freqScoreSum;
                }
                scoreWeights.add(impacts);
                curScore = scoreFreqs.get(i)[0];
            }
            freqScoreSum += scoreFreqs.get(i)[1] * curScore;
        }
        impacts = new double[this.scales.length + 1];
        impacts[0] = curScore;
        for (t = 1; t < impacts.length; ++t) {
            impacts[t] = (double)this.scales[t - 1] / freqScoreSum;
        }
        scoreWeights.add(impacts);
        scoreWeights.sort(Comparator.comparingDouble(doubles -> doubles[0]));
        size = scoreWeights.size();
        float[] results = new float[size * (this.scales.length + 1)];
        for (i = 0; i < size; ++i) {
            results[i] = (float)((double[])scoreWeights.get(i))[0];
        }
        for (int j = 0; j < this.scales.length; ++j) {
            int base = size * (j + 1);
            for (i = 0; i < size; ++i) {
                results[i + base] = (float)((double[])scoreWeights.get(i))[j + 1];
            }
        }
        return results;
    }

    float[] generateFreqImpact(List<double[]> scoreFreqs) {
        int t;
        double[] impacts;
        int i;
        scoreFreqs.sort((doubles, t1) -> Double.compare(t1[0], doubles[0]));
        int size = scoreFreqs.size();
        double curScore = scoreFreqs.get(0)[0];
        List<double[]> scoreWeights = new List<double[]>();
        double freqSum = scoreFreqs.get(0)[1];
        for (i = 1; i < size; ++i) {
            if (curScore != scoreFreqs.get(i)[0]) {
                impacts = new double[this.scales.length + 1];
                impacts[0] = curScore;
                for (t = 1; t < impacts.length; ++t) {
                    impacts[t] = Math.exp((double)(-this.scales[t - 1]) * freqSum);
                }
                scoreWeights.add(impacts);
                curScore = scoreFreqs.get(i)[0];
            }
            freqSum += scoreFreqs.get(i)[1];
        }
        impacts = new double[this.scales.length + 1];
        impacts[0] = curScore;
        for (t = 1; t < impacts.length; ++t) {
            impacts[t] = Math.exp((double)(-this.scales[t - 1]) * freqSum);
        }
        scoreWeights.add(impacts);
        scoreWeights.sort(Comparator.comparingDouble(doubles -> doubles[0]));
        size = scoreWeights.size();
        float[] results = new float[size * (this.scales.length + 1)];
        for (i = 0; i < size; ++i) {
            results[i] = (float)((double[])scoreWeights.get(i))[0];
        }
        for (int j = 0; j < this.scales.length; ++j) {
            int base = size * (j + 1);
            for (i = 0; i < size; ++i) {
                results[i + base] = (float)((double[])scoreWeights.get(i))[j + 1];
            }
        }
        return results;
    }

    float[] generateFreqImpact1(List<double[]> scoreFreqs) {
        double[] impacts;
        scoreFreqs.sort((doubles, t1) -> Double.compare(t1[0], doubles[0]));
        int size = scoreFreqs.size();
        int i = 1;
        double curScore = scoreFreqs.get(0)[0];
        List<double[]> scoreWeights = new List<double[]>();
        double freqSum = scoreFreqs.get(0)[1];
        do {
            if (curScore != scoreFreqs.get(i)[0]) {
                impacts = new double[]{curScore, freqSum};
                scoreWeights.add(impacts);
                curScore = scoreFreqs.get(i)[0];
            }
            freqSum += scoreFreqs.get(i)[1];
        } while (++i < size);
        impacts = new double[]{curScore, freqSum};
        scoreWeights.add(impacts);
        scoreWeights.sort(Comparator.comparingDouble(doubles -> doubles[0]));
        size = scoreWeights.size();
        double[] scores = new double[size];
        double[] weights = new double[size];
        for (i = 0; i < size; ++i) {
            scores[i] = ((double[])scoreWeights.get(i))[0];
        }
        for (i = 0; i < size; ++i) {
            weights[i] = ((double[])scoreWeights.get(i))[1];
        }
        SimpleLinearRegression lr = new SimpleLinearRegression(scores, weights);
        lr.compute();
        return new float[]{(float)lr.getSlope(), (float)lr.getIntercept()};
    }
}

