/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.analysis;

import edu.sysu.pmglab.analysis.CalcRegionSet;
import edu.sysu.pmglab.analysis.CalculateEffectThresholdThread;
import edu.sysu.pmglab.bytecode.Bytes;
import edu.sysu.pmglab.container.indexable.IndexableSet;
import edu.sysu.pmglab.container.indexable.LinkedSet;
import edu.sysu.pmglab.container.list.IntList;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.executor.ThreadQueue;
import edu.sysu.pmglab.io.writer.WriterStream;
import edu.sysu.pmglab.kgga.io.GlobalPedIndividuals;
import edu.sysu.pmglab.progressbar.ProgressBar;
import edu.sysu.pmglab.stat.LogisticRegression;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.net.InetSocketAddress;
import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.Comparator;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.rosuda.REngine.REXPMismatchException;
import org.rosuda.REngine.REngineException;
import org.rosuda.REngine.Rserve.RConnection;
import org.rosuda.REngine.Rserve.RserveException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeneNetworkExplorer {
    private final Logger logger = LoggerFactory.getLogger("Gene Network Explorer");
    String rHost;
    int rPort;
    String mutationCountField;
    String mutationScoreCountField;

    public GeneNetworkExplorer(InetSocketAddress address) {
        this.rHost = address.getHostName();
        this.rPort = address.getPort();
    }

    public static void main(String[] args) {
        GeneNetworkExplorer explorer = new GeneNetworkExplorer(null);
        String inputFilePath = "/media/mxli/data2/java/kgga/resources/module.txt.gz";
        String outputFilePath = "/media/mxli/data2/java/kgga/resources/module.mat";
    }

    public void compareMutationFreq(List<CalcRegionSet> regions, File outputFile, int threadNum, IndexableSet<String> geneSymbolMap) throws Exception {
        int i;
        IntList caseIDsInGTB = new IntList();
        IntList controlIDsInGTB = new IntList();
        int subjectNum = GlobalPedIndividuals.size();
        double[] phenotypes = new double[subjectNum];
        boolean addIntercept = false;
        double[][] covariables = new double[phenotypes.length][];
        boolean isBinaryPhenotype = GlobalPedIndividuals.isBinaryPhenotypes(0);
        LinkedSet<Double> labels = new LinkedSet<Double>();
        if (isBinaryPhenotype) {
            for (int i2 = 0; i2 < subjectNum; ++i2) {
                double phenotype = (Double)GlobalPedIndividuals.get(i2, "phenotype");
                ((AbstractCollection)labels).add(phenotype);
            }
            List<Object> labelsSorted = new List<Object>();
            for (i = 0; i < ((AbstractCollection)labels).size(); ++i) {
                labelsSorted.add(((IndexableSet)labels).valueOf(i));
            }
            labelsSorted.sort((Comparator<Object>)Comparator.comparingDouble(aDouble -> aDouble));
            ((AbstractCollection)labels).clear();
            for (i = 0; i < labelsSorted.size(); ++i) {
                ((AbstractCollection)labels).add(labelsSorted.fastGet(i));
            }
            labelsSorted.clear();
        }
        LinkedSet subjectIDs = new LinkedSet();
        for (i = 0; i < subjectNum; ++i) {
            double phenotype = (Double)GlobalPedIndividuals.get(i, "phenotype");
            if (isBinaryPhenotype) {
                phenotypes[i] = ((IndexableSet)labels).indexOf(phenotype);
                switch ((int)phenotypes[i]) {
                    case 0: {
                        controlIDsInGTB.add(i);
                        break;
                    }
                    case 1: {
                        caseIDsInGTB.add(i);
                        break;
                    }
                }
            } else {
                phenotypes[i] = phenotype;
            }
            double[] vars = (double[])GlobalPedIndividuals.get(i, "covarTraits");
            covariables[i] = Arrays.copyOf(vars, vars.length);
        }
        IntList caseControlSubjectIDSet = new IntList(caseIDsInGTB.size() + controlIDsInGTB.size());
        caseControlSubjectIDSet.addAll(caseIDsInGTB);
        caseControlSubjectIDSet.addAll(controlIDsInGTB);
        this.logger.info("Compare mutations in gene sets ...");
        ConcurrentLinkedQueue<Bytes[]> geneSetAssocResults = new ConcurrentLinkedQueue<Bytes[]>();
        geneSetAssocResults.add(new Bytes[]{new Bytes("SetName"), new Bytes("URL"), new Bytes("Estimate"), new Bytes("SE"), new Bytes("Z"), new Bytes("P"), new Bytes("P_permutation"), new Bytes("CutoffScore"), new Bytes("CutoffGeneNum"), new Bytes("Genes")});
        ProgressBar bar = new ProgressBar.Builder().setTextRenderer("Gene-set based association analyses", "sets").setInitialMax(regions.size()).build();
        ThreadQueue threadPool = new ThreadQueue(threadNum);
        int count = 0;
        for (CalcRegionSet geneSet : regions) {
            if (geneSet.regions.size() > 200) {
                bar.step(1L);
                continue;
            }
            CalculateEffectThresholdThread task = new CalculateEffectThresholdThread(this.rHost, this.rPort, phenotypes, covariables, geneSetAssocResults, subjectNum, isBinaryPhenotype, geneSymbolMap, bar);
            task.updateGeneSet(geneSet);
            threadPool.addTask(task);
            ++count;
        }
        threadPool.close();
        bar.close();
        WriterStream writer = new WriterStream(outputFile, WriterStream.Option.DEFAULT);
        for (Bytes[] graphResult : geneSetAssocResults) {
            if (graphResult == null) continue;
            for (Bytes byteCode : graphResult) {
                writer.write(byteCode);
                writer.write(9);
            }
            writer.write(10);
        }
        writer.close();
        this.logger.info("The gene set association p values are saved in {}", (Object)outputFile.getCanonicalPath());
    }

    private double[] calculateEffectLogistic(double[] phenotypes, double[][] covariables) throws Exception {
        LogisticRegression lr = new LogisticRegression();
        lr.setX(covariables);
        lr.setY(phenotypes);
        try {
            lr.fitLM();
        }
        catch (IllegalArgumentException ex) {
            return null;
        }
        double p = lr.getCoefPValue(1);
        double[] res = new double[]{p, lr.getCoef(1), lr.getSE()[1]};
        return res;
    }

    public static double[] calculateEffectThreshold(RConnection conn, double[] phenotypes, double[][] covariables, String cutoffType) throws Exception {
        try {
            int m = covariables[0].length;
            if (m == 0) {
                throw new IllegalArgumentException("Invalid input dimensions");
            }
            GeneNetworkExplorer.buildCovariablesDataFrame(conn, covariables);
            boolean debug = false;
            if (debug) {
                BufferedWriter debugOut = new BufferedWriter(new FileWriter("debug.txt"));
                debugOut.write("y\tx");
                for (int j = 1; j < covariables[0].length; ++j) {
                    debugOut.write("\tz" + j);
                }
                debugOut.write(10);
                for (int i = 0; i < phenotypes.length; ++i) {
                    debugOut.write(String.valueOf(phenotypes[i]));
                    for (int j = 0; j < covariables[i].length; ++j) {
                        debugOut.write("\t" + covariables[i][j]);
                    }
                    debugOut.write(10);
                }
                debugOut.close();
            }
            String formulaNull = GeneNetworkExplorer.buildFormula(m - 1);
            String cmd = String.format("test_result <- chngpt.test(formula.null = %s, formula.chngpt = ~x, data = df, family = 'binomial', type = '" + cutoffType + "', p.val.method = 'MC', verbose = FALSE); final_model <- chngptm(formula.1 = %s, formula.2 = ~x, family = 'binomial', data = df, type = '" + cutoffType + "'); summ <- summary(final_model); threshold <- test_result$chngpt; threshold_p <- test_result$p.value; m <- dim(summ$coefficients)[1]; if(dim(summ$coefficients)[2]>1) { effect_size <- summ$coefficients[m,1]; effect_se <- summ$coefficients[m,2]; effect_p <- summ$coefficients[m,3]; } else { effect_size <- summ$coefficients[m]; effect_se <- NA; effect_p <- NA; }", formulaNull, formulaNull);
            conn.eval(cmd);
            return new double[]{conn.eval("threshold").asDouble(), conn.eval("threshold_p").asDouble(), conn.eval("effect_size").asDouble(), conn.eval("effect_se").asDouble(), conn.eval("effect_p").asDouble()};
        }
        catch (REXPMismatchException | RserveException e) {
            e.printStackTrace();
            return null;
        }
        catch (REngineException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    private static void buildCovariablesDataFrame(RConnection conn, double[][] covariables) throws REngineException {
        int n = covariables.length;
        int m = covariables[0].length;
        double[] x = new double[n];
        for (int i = 0; i < n; ++i) {
            x[i] = covariables[i][0];
        }
        conn.assign("x", x);
        StringBuilder dfBuilder = new StringBuilder("df <- data.frame(x = x");
        for (int j = 1; j < m; ++j) {
            double[] z = new double[n];
            for (int i = 0; i < n; ++i) {
                z[i] = covariables[i][j];
            }
            String varName = "z" + j;
            conn.assign(varName, z);
            dfBuilder.append(", ").append(varName).append(" = ").append(varName);
        }
        dfBuilder.append(")");
        conn.eval(dfBuilder.toString());
    }

    private static String buildFormula(int covarCount) {
        if (covarCount == 0) {
            return "y ~ 1";
        }
        StringBuilder sb = new StringBuilder("y ~ ");
        for (int i = 1; i <= covarCount; ++i) {
            sb.append("z").append(i);
            if (i >= covarCount) continue;
            sb.append(" + ");
        }
        return sb.toString();
    }
}

