/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.analysis;

import cern.colt.list.DoubleArrayList;
import cern.jet.stat.Descriptive;
import edu.sysu.pmglab.annotation.SeqSegment;
import edu.sysu.pmglab.container.NamedVarInt64RangeList;
import edu.sysu.pmglab.container.list.FloatList;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.container.rangelist.VarInt64RangeList;
import edu.sysu.pmglab.gtb.genome.Variant;
import edu.sysu.pmglab.gtb.genome.coordinate.Chromosome;
import gnu.trove.map.TObjectFloatMap;
import gnu.trove.map.hash.TObjectFloatHashMap;
import java.lang.reflect.Field;
import java.util.Map;

public class GenomeRegion
extends SeqSegment {
    VarInt64RangeList outcomeVarPointers;
    VarInt64RangeList explainVarPointers;
    List<String> sameRegionsLabel = null;
    String label;
    int type;
    long startPointer = -1L;
    long endPointer = -1L;
    List<Variant> variants;
    double midMutScoreCase = Double.NaN;
    double accuMutCountScoreCase = Double.NaN;
    boolean allScoreMissingCase = false;
    double midRefMutScore = Double.NaN;
    double accuMutCountRef = Double.NaN;
    double accuMutCountScoreRef = Double.NaN;
    boolean allScoreMissingRef = false;
    TObjectFloatMap<String> caseIDMutMaxScoreMap;
    FloatList mutUniqueScoreCase;
    TObjectFloatMap<String> controlIDMutMaxScoreMap;
    FloatList mutUniqueScoreControl;
    double midMutScoreControl = Double.NaN;
    double accuMutCountScoreControl = Double.NaN;
    boolean allScoreMissingControl = false;
    Map<String, FloatList> controlIDMutAllScoreMap;
    Map<String, FloatList> caseIDMutAllScoreMap;
    FloatList mutCountScoreListRef;
    double[] regionScores;
    int[] featureScoreCounts;
    double p;

    public void setMutCountScoreListRef(FloatList mutCountScoreListRef) {
        this.mutCountScoreListRef = mutCountScoreListRef;
    }

    public FloatList getMutCountScoreListRef() {
        return this.mutCountScoreListRef;
    }

    public int getMutNumCase(double bin) {
        if (this.caseIDMutMaxScoreMap == null || this.caseIDMutMaxScoreMap.isEmpty()) {
            return 0;
        }
        if (bin <= 0.0) {
            return this.caseIDMutMaxScoreMap.size();
        }
        if (!Double.isNaN(this.accuMutCountScoreCase)) {
            return (int)(this.accuMutCountScoreCase / bin);
        }
        this.getAccuMutCountScoreCase();
        return (int)(this.accuMutCountScoreCase / bin);
    }

    public int getMutNumControl(double bin) {
        if (this.controlIDMutMaxScoreMap == null || this.controlIDMutMaxScoreMap.isEmpty()) {
            return 0;
        }
        if (bin <= 0.0) {
            return this.controlIDMutMaxScoreMap.size();
        }
        if (!Double.isNaN(this.accuMutCountScoreControl)) {
            return (int)(this.accuMutCountScoreControl / bin);
        }
        this.getAccuMutCountScoreControl();
        return (int)(this.accuMutCountScoreControl / bin);
    }

    public float getScoreByCaseID(String caseID) {
        float score = this.caseIDMutMaxScoreMap.get(caseID);
        if (Float.isNaN(score)) {
            return this.getMidMutScoreCase();
        }
        return score;
    }

    public float getScoreByControlID(String ctlID) {
        float score = this.controlIDMutMaxScoreMap.get(ctlID);
        if (Float.isNaN(score)) {
            return this.getMidMutScoreCase();
        }
        return score;
    }

    public void addCaseSubjectIDMutMaxScore(String[] ids, float score) {
        if (this.caseIDMutMaxScoreMap == null) {
            this.caseIDMutMaxScoreMap = new TObjectFloatHashMap<String>();
        }
        if (this.mutUniqueScoreCase == null) {
            this.mutUniqueScoreCase = new FloatList();
        }
        if (ids == null) {
            return;
        }
        if (!Float.isNaN(score)) {
            this.mutUniqueScoreCase.add(score);
        }
        for (String id : ids) {
            if (!this.caseIDMutMaxScoreMap.keySet().contains(id)) {
                this.caseIDMutMaxScoreMap.put(id, score);
                continue;
            }
            float availScore = this.caseIDMutMaxScoreMap.get(id);
            if (!(availScore < score)) continue;
            this.caseIDMutMaxScoreMap.put(id, score);
        }
    }

    public void addControlSubjectIDMutMaxScore(String[] ids, float score) {
        if (this.controlIDMutMaxScoreMap == null) {
            this.controlIDMutMaxScoreMap = new TObjectFloatHashMap<String>();
        }
        if (this.mutUniqueScoreControl == null) {
            this.mutUniqueScoreControl = new FloatList();
        }
        if (ids == null) {
            return;
        }
        if (!Float.isNaN(score)) {
            this.mutUniqueScoreControl.add(score);
        }
        for (String id : ids) {
            if (!this.controlIDMutMaxScoreMap.keySet().contains(id)) {
                this.controlIDMutMaxScoreMap.put(id, score);
                continue;
            }
            float availScore = this.controlIDMutMaxScoreMap.get(id);
            if (!(availScore < score)) continue;
            this.controlIDMutMaxScoreMap.put(id, score);
        }
    }

    public void addCaseSubjectIDMutSumScore(String[] ids, float score) {
        if (this.caseIDMutMaxScoreMap == null) {
            this.caseIDMutMaxScoreMap = new TObjectFloatHashMap<String>();
        }
        if (this.mutUniqueScoreCase == null) {
            this.mutUniqueScoreCase = new FloatList();
        }
        if (ids == null) {
            return;
        }
        if (!Float.isNaN(score)) {
            this.mutUniqueScoreCase.add(score);
        }
        for (String id : ids) {
            if (!this.caseIDMutMaxScoreMap.keySet().contains(id)) {
                this.caseIDMutMaxScoreMap.put(id, score);
                continue;
            }
            StringBuilder idBuilder = new StringBuilder(id);
            do {
                idBuilder.append("+");
            } while (this.caseIDMutMaxScoreMap.keySet().contains(idBuilder.toString()));
            this.caseIDMutMaxScoreMap.put(id, score);
        }
    }

    public void addRefFreqScore(float freq, float score) {
        if (this.mutCountScoreListRef == null) {
            this.mutCountScoreListRef = new FloatList();
        }
        this.mutCountScoreListRef.add(freq);
        this.mutCountScoreListRef.add(score);
    }

    public void addControlSubjectIDMutSumScore(String[] ids, float score) {
        if (this.controlIDMutMaxScoreMap == null) {
            this.controlIDMutMaxScoreMap = new TObjectFloatHashMap<String>();
        }
        if (this.mutUniqueScoreControl == null) {
            this.mutUniqueScoreControl = new FloatList();
        }
        if (ids == null) {
            return;
        }
        if (!Float.isNaN(score)) {
            this.mutUniqueScoreControl.add(score);
        }
        for (String id : ids) {
            if (!this.controlIDMutMaxScoreMap.keySet().contains(id)) {
                this.controlIDMutMaxScoreMap.put(id, score);
                continue;
            }
            StringBuilder idBuilder = new StringBuilder(id);
            do {
                idBuilder.append("+");
            } while (this.controlIDMutMaxScoreMap.keySet().contains(idBuilder.toString()));
            this.controlIDMutMaxScoreMap.put(id, score);
        }
    }

    public void calcMidMutScoreCase() {
        DoubleArrayList values2 = new DoubleArrayList();
        int missingNum = 0;
        int size = this.mutUniqueScoreCase.size();
        for (int i = 0; i < size; ++i) {
            float score = this.mutUniqueScoreCase.get(i);
            if (Double.isNaN(score)) {
                ++missingNum;
                continue;
            }
            values2.add(score);
        }
        if (size - missingNum == 0) {
            this.midMutScoreCase = Double.NaN;
            this.allScoreMissingCase = true;
        } else {
            values2.quickSort();
            this.midMutScoreCase = Descriptive.median(values2);
        }
    }

    public float[] getMutMaxScoreCase() {
        return this.caseIDMutMaxScoreMap.values();
    }

    public FloatList getMutUniqueScoreCase() {
        return this.mutUniqueScoreCase;
    }

    public FloatList getMutUniqueScoreControl() {
        return this.mutUniqueScoreControl;
    }

    public double getAccuMutCountScoreCase() {
        if (!Double.isNaN(this.accuMutCountScoreCase)) {
            return this.accuMutCountScoreCase;
        }
        float[] scores = this.caseIDMutMaxScoreMap.values();
        if (Double.isNaN(this.midMutScoreCase)) {
            this.calcMidMutScoreCase();
            if (this.allScoreMissingCase) {
                return 0.0;
            }
        }
        this.accuMutCountScoreCase = 0.0;
        for (float score : scores) {
            if (Double.isNaN(score)) {
                this.accuMutCountScoreCase += this.midMutScoreCase;
                continue;
            }
            this.accuMutCountScoreCase += (double)score;
        }
        return this.accuMutCountScoreCase;
    }

    public float[] getMutMaxScoreControl() {
        return this.controlIDMutMaxScoreMap.values();
    }

    public void calcMidMutScoreControl() {
        DoubleArrayList values2 = new DoubleArrayList();
        int missingNum = 0;
        int size = this.mutUniqueScoreControl.size();
        for (int i = 0; i < size; ++i) {
            float score = this.mutUniqueScoreControl.get(i);
            if (Double.isNaN(score)) {
                ++missingNum;
                continue;
            }
            values2.add(score);
        }
        if (size - missingNum == 0) {
            this.midMutScoreControl = Double.NaN;
            this.allScoreMissingControl = true;
        } else {
            values2.quickSort();
            this.midMutScoreControl = Descriptive.median(values2);
        }
    }

    public double getAccuMutCountScoreControl() {
        if (!Double.isNaN(this.accuMutCountScoreControl)) {
            return this.accuMutCountScoreControl;
        }
        float[] scores = this.controlIDMutMaxScoreMap.values();
        if (Double.isNaN(this.midMutScoreControl)) {
            this.calcMidMutScoreControl();
            if (this.allScoreMissingControl) {
                return 0.0;
            }
        }
        this.accuMutCountScoreControl = 0.0;
        for (float score : scores) {
            if (Double.isNaN(score)) {
                this.accuMutCountScoreControl += this.midMutScoreControl;
                continue;
            }
            this.accuMutCountScoreControl += (double)score;
        }
        return this.accuMutCountScoreControl;
    }

    public void calcMidScoreRef() {
        if (this.mutCountScoreListRef == null) {
            return;
        }
        DoubleArrayList values2 = new DoubleArrayList();
        int missingNum = 0;
        int size = this.mutCountScoreListRef.size() / 2;
        for (int i = 0; i < size; ++i) {
            if (Double.isNaN(this.mutCountScoreListRef.get(i + i + 1))) {
                ++missingNum;
                continue;
            }
            values2.add(this.mutCountScoreListRef.get(i + i + 1));
        }
        if (size - missingNum == 0) {
            this.midRefMutScore = 0.0;
            this.allScoreMissingRef = true;
        } else {
            values2.quickSort();
            this.midRefMutScore = Descriptive.median(values2);
        }
    }

    public double getRefMutNumFull(double bin) {
        if (this.mutCountScoreListRef == null || this.mutCountScoreListRef.isEmpty()) {
            return 0.0;
        }
        if (this.allScoreMissingRef) {
            return 0.0;
        }
        if (Double.isNaN(this.midRefMutScore)) {
            this.calcMidScoreRef();
        }
        int size = this.mutCountScoreListRef.size() / 2;
        if (Double.isNaN(this.accuMutCountScoreRef)) {
            this.accuMutCountScoreRef = 0.0;
            this.accuMutCountRef = 0.0;
            for (int i = 0; i < size; ++i) {
                float score = Double.isNaN(this.mutCountScoreListRef.get(i + i + 1)) ? (float)this.midRefMutScore : this.mutCountScoreListRef.get(i + i + 1);
                this.accuMutCountScoreRef += (double)(this.mutCountScoreListRef.get(i + i) * score);
                this.accuMutCountRef += (double)this.mutCountScoreListRef.get(i + i);
            }
        }
        if (bin <= 0.0) {
            return this.accuMutCountRef;
        }
        return this.accuMutCountScoreRef / bin;
    }

    public double getRefMutNumCutoff(double bin) {
        if (this.mutCountScoreListRef == null || this.mutCountScoreListRef.isEmpty()) {
            return 0.0;
        }
        if (this.allScoreMissingRef) {
            return 0.0;
        }
        if (Double.isNaN(this.midRefMutScore)) {
            this.calcMidScoreRef();
        }
        int size = this.mutCountScoreListRef.size() / 2;
        double accuMutCountRef1 = 0.0;
        if (bin > 0.0) {
            for (int i = 0; i < size; ++i) {
                float score = Double.isNaN(this.mutCountScoreListRef.get(i + i + 1)) ? (float)this.midRefMutScore : this.mutCountScoreListRef.get(i + i + 1);
                if (!((double)score > bin)) continue;
                accuMutCountRef1 += (double)this.mutCountScoreListRef.get(i + i);
            }
        } else {
            for (int i = 0; i < size; ++i) {
                accuMutCountRef1 += (double)this.mutCountScoreListRef.get(i + i);
            }
        }
        return accuMutCountRef1;
    }

    public void setSameRegionsLabel(List<String> sameRegionsLabel) {
        this.sameRegionsLabel = sameRegionsLabel;
    }

    public GenomeRegion addExplainVarPointer(long varPointer) throws Exception {
        this.explainVarPointers.add(varPointer);
        return this;
    }

    public <T extends VarInt64RangeList> void setOutcomeVarPointers(VarInt64RangeList outcomeVarPointers) {
        this.outcomeVarPointers = outcomeVarPointers;
    }

    public <T extends VarInt64RangeList> void setExplainVarPointers(T explainVarPointers) {
        this.explainVarPointers = explainVarPointers;
    }

    public VarInt64RangeList getOutcomeVarPointers() {
        return this.outcomeVarPointers;
    }

    public VarInt64RangeList getExplainVarPointers() {
        return this.explainVarPointers;
    }

    public void setCoordinate(Chromosome chrID, int startPos, int endPos) {
        this.chromID = chrID;
        this.start = startPos;
        this.end = endPos;
    }

    public long getStartPointer() {
        return this.startPointer;
    }

    public void setStartPointer(long startPointer) {
        this.startPointer = startPointer;
    }

    public long getEndPointer() {
        return this.endPointer;
    }

    public void setEndPointer(long endPointer) {
        this.endPointer = endPointer;
    }

    public void setType(int type) {
        this.type = type;
    }

    public float getMidMutScoreCase() {
        if (Double.isNaN(this.midMutScoreCase)) {
            this.calcMidMutScoreCase();
        }
        return (float)this.midMutScoreCase;
    }

    public float getMidMutScoreControl() {
        if (Double.isNaN(this.midMutScoreControl)) {
            this.calcMidMutScoreControl();
        }
        return (float)this.midMutScoreControl;
    }

    public double getMidRefMutScore() {
        return this.midRefMutScore;
    }

    public void setMidRefMutScore(double midRefMutScore) {
        this.midRefMutScore = midRefMutScore;
    }

    public void setMidMutScoreCase(double midMutScoreCase) {
        this.midMutScoreCase = midMutScoreCase;
    }

    public Map<String, FloatList> getCaseIDMutAllScoreMap() {
        return this.caseIDMutAllScoreMap;
    }

    public Map<String, FloatList> getControlIDMutAllScoreMap() {
        return this.controlIDMutAllScoreMap;
    }

    public TObjectFloatMap<String> getCaseIDMutMaxScoreMap() {
        return this.caseIDMutMaxScoreMap;
    }

    public TObjectFloatMap<String> getControlIDMutMaxScoreMap() {
        return this.controlIDMutMaxScoreMap;
    }

    public int[] getFeatureScoreCounts() {
        return this.featureScoreCounts;
    }

    public void setFeatureScoreCounts(int[] featureScoreCounts) {
        this.featureScoreCounts = featureScoreCounts;
    }

    public GenomeRegion(String regionLabel) {
        this.label = regionLabel;
        this.outcomeVarPointers = new NamedVarInt64RangeList();
    }

    public GenomeRegion(String regionLabel, int type) {
        this.label = regionLabel;
        this.type = type;
        this.variants = new List();
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public List<Variant> getVariants() {
        return this.variants;
    }

    public void addVariant(Variant variant) {
        this.variants.add(variant);
    }

    public int getType() {
        return this.type;
    }

    public String getLabel() {
        return this.label;
    }

    public double[] getRegionScores() {
        return this.regionScores;
    }

    public boolean standardizeFeatureScore(int index, double mean, double sd) {
        if (Double.isNaN(this.regionScores[index])) {
            return false;
        }
        this.regionScores[index] = (this.regionScores[index] - mean) / sd;
        return true;
    }

    public void setRegionScores(double[] regionScores) {
        this.regionScores = regionScores;
    }

    public static void setFieldValue(Object obj, String fieldName, Object value) throws Exception {
        Class<?> clazz = obj.getClass();
        Field field = clazz.getDeclaredField(fieldName);
        field.setAccessible(true);
        field.set(obj, value);
    }

    public static FloatList getFloatListValue(Object obj, String fieldName) throws Exception {
        Class<?> clazz = obj.getClass();
        Field field = clazz.getDeclaredField(fieldName);
        field.setAccessible(true);
        return (FloatList)field.get(obj);
    }

    public static <T> T getFieldValue(Object obj, String fieldName) throws Exception {
        Class<?> clazz = obj.getClass();
        Field field = clazz.getDeclaredField(fieldName);
        field.setAccessible(true);
        return (T)field.get(obj);
    }

    public double getMutNumCase(double bin, FloatList MutCountScore) {
        if (MutCountScore == null || MutCountScore.isEmpty()) {
            return 0.0;
        }
        int size = MutCountScore.size() / 2;
        double num = 0.0;
        if (bin <= 0.0) {
            for (int i = 0; i < size; ++i) {
                num += (double)MutCountScore.get(i + i);
            }
        } else {
            double midMutScore = this.screenMidMutScore(MutCountScore);
            if (Double.isNaN(midMutScore)) {
                return 0.0;
            }
            double intScore = 0.0;
            for (int i = 0; i < size; ++i) {
                intScore = Double.isNaN(MutCountScore.get(i + i + 1)) ? midMutScore / bin : (double)MutCountScore.get(i + i + 1) / bin;
                num += (double)MutCountScore.get(i + i) * intScore;
            }
        }
        return num;
    }

    public double screenMidMutScore(FloatList mutCountScore) {
        double midMutScore;
        if (mutCountScore == null || mutCountScore.isEmpty()) {
            return Double.NaN;
        }
        int size = mutCountScore.size() / 2;
        DoubleArrayList values2 = new DoubleArrayList();
        int missingNum = 0;
        for (int i = 0; i < size; ++i) {
            if (Double.isNaN(mutCountScore.get(i + i + 1))) {
                ++missingNum;
                continue;
            }
            values2.add(mutCountScore.get(i + i + 1));
        }
        if (size - missingNum == 0) {
            midMutScore = Double.NaN;
        } else {
            values2.quickSort();
            midMutScore = Descriptive.median(values2);
        }
        return midMutScore;
    }

    public void setP(double p) {
        this.p = p;
    }
}

