/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.analysis;

import edu.sysu.pmglab.ccf.field.FieldGroupMeta;
import edu.sysu.pmglab.ccf.field.IFieldCollection;
import edu.sysu.pmglab.ccf.record.IRecord;
import edu.sysu.pmglab.ccf.record.Record;
import edu.sysu.pmglab.ccf.type.FieldType;
import edu.sysu.pmglab.container.bits.LongBits;
import edu.sysu.pmglab.gtb.genome.Variant;
import edu.sysu.pmglab.gtb.genome.genotype.BitwiseGenotypes;
import edu.sysu.pmglab.gtb.linkagedisequilibrium.ILDModel;

public enum GenotypeLDUtils {
    INSTANCE;

    public static final IFieldCollection SCORE;

    public IRecord apply(Variant variant1, Variant variant2, int minN) {
        Record record = new Record(SCORE);
        if (!this.apply(variant1, variant2, record, minN)) {
            record.set("CHR1", (Object)variant1.getChromosome());
            record.set("POS1", (Object)variant1.getPosition());
            record.set("CHR2", (Object)variant2.getChromosome());
            record.set("POS2", (Object)variant2.getPosition());
            record.set("R", (Object)Float.valueOf(Float.NaN));
            record.set("R^2", (Object)Float.valueOf(Float.NaN));
        }
        return record;
    }

    public boolean apply(Variant variant1, Variant variant2, IRecord record, int minN) {
        BitwiseGenotypes bitwiseGenotypes1 = (BitwiseGenotypes)variant1.getProperty(BitwiseGenotypes.class.getName());
        BitwiseGenotypes bitwiseGenotypes2 = (BitwiseGenotypes)variant2.getProperty(BitwiseGenotypes.class.getName());
        if (bitwiseGenotypes1 == null) {
            bitwiseGenotypes1 = new BitwiseGenotypes(variant1.getGenotypes(), 2, BitwiseGenotypes.BIALLELIC);
            variant1.setProperty(BitwiseGenotypes.class.getName(), bitwiseGenotypes1);
        }
        if (bitwiseGenotypes2 == null) {
            bitwiseGenotypes2 = new BitwiseGenotypes(variant2.getGenotypes(), 2, BitwiseGenotypes.BIALLELIC);
            variant2.setProperty(BitwiseGenotypes.class.getName(), bitwiseGenotypes2);
        }
        LongBits VALID1 = bitwiseGenotypes1.getBits(0, -1);
        LongBits VALID2 = bitwiseGenotypes2.getBits(0, -1);
        LongBits[] ALT1 = new LongBits[]{bitwiseGenotypes1.getBits(0, 1), bitwiseGenotypes1.getBits(1, 1)};
        LongBits[] ALT2 = new LongBits[]{bitwiseGenotypes2.getBits(0, 1), bitwiseGenotypes2.getBits(1, 1)};
        if (ALT1[0].nextSetBit(0) == -1 || ALT1[1].nextSetBit(0) == -1) {
            return false;
        }
        if (ALT2[0].nextSetBit(0) == -1 || ALT2[1].nextSetBit(0) == -1) {
            return false;
        }
        int N = 0;
        int countA_N_ALLELE_NUM_EQ_1 = 0;
        int countA_N_ALLELE_NUM_EQ_2 = 0;
        int countB_N_ALLELE_NUM_EQ_1 = 0;
        int countB_N_ALLELE_NUM_EQ_2 = 0;
        int countAB_ALLELE_NUM_EQ_1_1 = 0;
        int countAB_ALLELE_NUM_EQ_1_2 = 0;
        int countAB_ALLELE_NUM_EQ_2_2 = 0;
        int start = Math.max(VALID1.wordStart(), VALID2.wordStart());
        int end = Math.min(VALID1.wordEnd(), VALID2.wordEnd());
        if (start != -1 && end != -1) {
            for (int i = start; i <= end; ++i) {
                long mask = VALID1.getWord(i) & VALID2.getWord(i);
                if (mask == 0L) continue;
                N += Long.bitCount(mask);
                long countA_N_ALLELE_NUM_EQ_1_status = (ALT1[0].getWord(i) ^ ALT1[1].getWord(i)) & mask;
                long countB_N_ALLELE_NUM_EQ_1_status = (ALT2[0].getWord(i) ^ ALT2[1].getWord(i)) & mask;
                long countA_N_ALLELE_NUM_EQ_2_status = ALT1[0].getWord(i) & ALT1[1].getWord(i) & mask;
                long countB_N_ALLELE_NUM_EQ_2_status = ALT2[0].getWord(i) & ALT2[1].getWord(i) & mask;
                countA_N_ALLELE_NUM_EQ_1 += Long.bitCount(countA_N_ALLELE_NUM_EQ_1_status);
                countB_N_ALLELE_NUM_EQ_1 += Long.bitCount(countB_N_ALLELE_NUM_EQ_1_status);
                countA_N_ALLELE_NUM_EQ_2 += Long.bitCount(countA_N_ALLELE_NUM_EQ_2_status);
                countB_N_ALLELE_NUM_EQ_2 += Long.bitCount(countB_N_ALLELE_NUM_EQ_2_status);
                countAB_ALLELE_NUM_EQ_1_1 += Long.bitCount(countA_N_ALLELE_NUM_EQ_1_status & countB_N_ALLELE_NUM_EQ_1_status);
                countAB_ALLELE_NUM_EQ_1_2 += Long.bitCount(countA_N_ALLELE_NUM_EQ_1_status & countB_N_ALLELE_NUM_EQ_2_status) + Long.bitCount(countB_N_ALLELE_NUM_EQ_1_status & countA_N_ALLELE_NUM_EQ_2_status);
                countAB_ALLELE_NUM_EQ_2_2 += Long.bitCount(countA_N_ALLELE_NUM_EQ_2_status & countB_N_ALLELE_NUM_EQ_2_status);
            }
        }
        if (N < minN) {
            return false;
        }
        int sumAB = countAB_ALLELE_NUM_EQ_1_1 + (countAB_ALLELE_NUM_EQ_1_2 << 1) + (countAB_ALLELE_NUM_EQ_2_2 << 2);
        int sumA = countA_N_ALLELE_NUM_EQ_1 + (countA_N_ALLELE_NUM_EQ_2 << 1);
        int sumB = countB_N_ALLELE_NUM_EQ_1 + (countB_N_ALLELE_NUM_EQ_2 << 1);
        int sumA_square = countA_N_ALLELE_NUM_EQ_1 + (countA_N_ALLELE_NUM_EQ_2 << 2);
        int sumB_square = countB_N_ALLELE_NUM_EQ_1 + (countB_N_ALLELE_NUM_EQ_2 << 2);
        double r_numerator = (double)sumAB - (double)sumA * (double)sumB / (double)N;
        double r_denominator_square = ((double)sumA_square - (double)sumA * (double)sumA / (double)N) * ((double)sumB_square - (double)sumB * (double)sumB / (double)N);
        if (r_denominator_square == 0.0) {
            if (r_numerator == 0.0) {
                record.set("CHR1", (Object)variant1.getChromosome());
                record.set("POS1", (Object)variant1.getPosition());
                record.set("CHR2", (Object)variant2.getChromosome());
                record.set("POS2", (Object)variant2.getPosition());
                record.set("R", (Object)Float.valueOf(1.0f));
                record.set("R^2", (Object)Float.valueOf(1.0f));
                return true;
            }
            return false;
        }
        float r = (float)(r_numerator / Math.sqrt(r_denominator_square));
        float r2 = r * r;
        record.set("CHR1", (Object)variant1.getChromosome());
        record.set("POS1", (Object)variant1.getPosition());
        record.set("CHR2", (Object)variant2.getChromosome());
        record.set("POS2", (Object)variant2.getPosition());
        record.set("R", (Object)Float.valueOf(r));
        record.set("R^2", (Object)Float.valueOf(r2));
        return true;
    }

    public String toString() {
        return "Genotype LD (Pearson genotypic correlation of variants)";
    }

    static {
        SCORE = ((FieldGroupMeta)new FieldGroupMeta(null).addFields((Iterable)ILDModel.COORDINATE)).addField("R", FieldType.float32).addField("R^2", FieldType.float32).asUnmodifiable();
    }
}

