/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.analysis;

import edu.sysu.pmglab.analysis.GenotypeLDUtils;
import edu.sysu.pmglab.container.list.IntList;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.gtb.GTBReader;
import edu.sysu.pmglab.gtb.genome.Variant;
import java.io.IOException;

public class LDBlockCalculator {
    private int windowSize = 100000;
    private float violatorPercent = 0.15f;
    private float maxR2 = 0.1f;
    private float initR2 = 0.01f;
    private float incR2 = 0.015f;
    private float decayFactor = 0.9f;
    private int minBlockSize = 0;
    private int maxBlockSize = 1000;
    private int minValidSample;
    private float minValidSamplePercent = 0.5f;

    public static void main(String[] args) throws IOException {
        GTBReader reader = new GTBReader("/Users/yiguoshabi/KGGA/resources/M05_2/merged_data_2_hg38_2.gtb");
        List<Variant> variants = new List<Variant>();
        for (int i = 0; i < 50000; ++i) {
            variants.add(reader.read());
        }
        reader.close();
        IntList blocks = new LDBlockCalculator().calculateBlockBoundaries(variants);
        System.out.println(blocks);
    }

    public LDBlockCalculator setWindowSize(int windowSize) {
        this.windowSize = windowSize;
        return this;
    }

    public LDBlockCalculator setViolatorPercent(float violatorPercent) {
        this.violatorPercent = violatorPercent;
        return this;
    }

    public LDBlockCalculator setInitR2(float initR2) {
        this.initR2 = initR2;
        return this;
    }

    public LDBlockCalculator setMaxR2(float maxR2) {
        this.maxR2 = maxR2;
        return this;
    }

    public LDBlockCalculator setIncR2(float incR2) {
        this.incR2 = incR2;
        return this;
    }

    public LDBlockCalculator setDecayFactor(float decayFactor) {
        this.decayFactor = decayFactor;
        return this;
    }

    public LDBlockCalculator setMinBlockSize(int minBlockSize) {
        this.minBlockSize = minBlockSize;
        return this;
    }

    public LDBlockCalculator setMaxBlockSize(int maxBlockSize) {
        this.maxBlockSize = maxBlockSize;
        return this;
    }

    public LDBlockCalculator setMinValidSamplePercent(float minValidSamplePercent) {
        this.minValidSamplePercent = minValidSamplePercent;
        return this;
    }

    public IntList calculateBlockBoundaries(String source2) throws IOException {
        try (GTBReader reader = new GTBReader(source2);){
            List<Variant> variants = new List<Variant>();
            for (long i = 0L; i < reader.numOfVariants(); ++i) {
                variants.add(reader.read());
            }
            IntList intList = this.computeBlockBoundaries(variants);
            return intList;
        }
    }

    public IntList calculateBlockBoundaries(List<Variant> variants) {
        return this.computeBlockBoundaries(variants);
    }

    private IntList computeBlockBoundaries(List<Variant> variants) {
        this.minValidSample = Math.round((float)variants.fastGet(0).getGenotypes().size() * this.minValidSamplePercent);
        int numVariants = variants.size();
        IntList boundaries = new IntList();
        if (numVariants == 0) {
            return boundaries;
        }
        if (numVariants == 1) {
            boundaries.add(0);
            boundaries.add(1);
            return boundaries;
        }
        boundaries.add(0);
        float currentR2 = this.initR2;
        for (int i = 0; i < numVariants; ++i) {
            int lastBoundary;
            int screenLength = this.calculateScreenLength(variants, i, numVariants);
            if (screenLength == 0 || !this.isViolatedInScreen(variants, i, screenLength, currentR2) || !this.checkReverseViolation(variants, lastBoundary = boundaries.fastLastGet(0), i, screenLength, currentR2)) continue;
            boundaries.add(i + 1);
        }
        if (boundaries.fastLastGet(0) != numVariants) {
            boundaries.add(numVariants);
        }
        IntList newBoundaries = new IntList();
        newBoundaries.add(boundaries.get(0));
        for (int i = 0; i < boundaries.size() - 1; ++i) {
            int start = boundaries.get(i);
            int end = boundaries.get(i + 1);
            int blockSize = end - start;
            if (blockSize > this.maxBlockSize) {
                newBoundaries.addAll(this.recursiveSplit(variants, start, end, this.initR2));
                continue;
            }
            newBoundaries.add(end);
        }
        if (this.minBlockSize <= 1) {
            return newBoundaries;
        }
        IntList merged = new IntList();
        merged.add(newBoundaries.fastGet(0));
        int prevIndex = 0;
        int i = 1;
        while (i < newBoundaries.size()) {
            if (newBoundaries.get(i) - newBoundaries.get(prevIndex) >= this.minBlockSize) {
                int j;
                for (j = i + 1; j < newBoundaries.size() && newBoundaries.get(j) - newBoundaries.get(j - 1) < this.minBlockSize; ++j) {
                }
                if (newBoundaries.get(j - 1) - newBoundaries.get(i) < this.minBlockSize) {
                    merged.add(newBoundaries.get(j - 1));
                    prevIndex = j - 1;
                } else {
                    merged.add(newBoundaries.get(i));
                    prevIndex = i;
                }
                i = prevIndex + 1;
                continue;
            }
            ++i;
        }
        if (merged.fastLastGet(0) != newBoundaries.fastLastGet(0)) {
            if (newBoundaries.fastLastGet(0) - merged.fastLastGet(0) <= this.minBlockSize) {
                merged.lastSet(0, newBoundaries.fastLastGet(0));
            } else {
                merged.add(newBoundaries.fastLastGet(0));
            }
        }
        return merged;
    }

    private IntList recursiveSplit(List<Variant> variants, int start, int end, float currentR2) {
        IntList internalBoundaries = new IntList(start);
        int pos = start;
        while (pos < end) {
            int screenLength = this.calculateScreenLength(variants, pos, end);
            if (screenLength == 0) {
                ++pos;
                continue;
            }
            if (this.isViolatedInScreen(variants, pos, screenLength, currentR2)) {
                int reverseStart;
                int n = reverseStart = internalBoundaries.isEmpty() ? start : internalBoundaries.fastLastGet(0);
                if (this.checkReverseViolation(variants, reverseStart, pos, screenLength, currentR2)) {
                    internalBoundaries.add(pos + 1);
                    ++pos;
                    continue;
                }
            }
            ++pos;
        }
        internalBoundaries.add(end);
        IntList result = new IntList();
        int prev = start;
        for (int i = 0; i < internalBoundaries.size(); ++i) {
            int next = internalBoundaries.fastGet(i);
            int subBlockSize = next - prev;
            if (subBlockSize > this.maxBlockSize && currentR2 + this.incR2 <= this.maxR2) {
                result.addAll(this.recursiveSplit(variants, prev, next, currentR2 + this.incR2));
            } else {
                result.add(next);
            }
            prev = next;
        }
        return result;
    }

    private int calculateScreenLength(List<Variant> variants, int currentIndex, int end) {
        Variant next;
        Variant current = variants.get(currentIndex);
        int count = 0;
        for (int j = currentIndex + 1; j < Math.min(variants.size(), end) && (next = variants.get(j)).getChromosome() == current.getChromosome() && next.getPosition() - current.getPosition() <= this.windowSize; ++j) {
            ++count;
        }
        return count;
    }

    private boolean checkReverseViolation(List<Variant> variants, int reverseStart, int currentIndex, int screenLength, float currentR2) {
        for (int k = currentIndex - 1; k >= reverseStart; --k) {
            int targetIndex;
            double totalViolation = 0.0;
            double normalization = 1.0 - Math.pow(this.decayFactor, screenLength);
            for (int j = 1; j <= screenLength && (targetIndex = currentIndex + j) < variants.size(); ++j) {
                float r2 = this.computeR2(variants, k, targetIndex);
                if (!(r2 > currentR2) || !((totalViolation += (double)(1.0f - this.decayFactor) * Math.pow(this.decayFactor, j - 1) / normalization) > (double)this.violatorPercent)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean isViolatedInScreen(List<Variant> variants, int startIndex, int screenLength, float currentR2) {
        int targetIndex;
        double totalViolation = 0.0;
        double normalization = 1.0 - Math.pow(this.decayFactor, screenLength);
        for (int j = 1; j <= screenLength && (targetIndex = startIndex + j) < variants.size(); ++j) {
            float r2 = this.computeR2(variants, startIndex, targetIndex);
            if (!(r2 > currentR2) || !((totalViolation += (double)(1.0f - this.decayFactor) * Math.pow(this.decayFactor, j - 1) / normalization) > (double)this.violatorPercent)) continue;
            return false;
        }
        return true;
    }

    private float computeR2(List<Variant> variants, int index1, int index2) {
        return ((Float)GenotypeLDUtils.INSTANCE.apply(variants.get(index1), variants.get(index2), this.minValidSample).get("R^2")).floatValue();
    }
}

