/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.analysis;

import cern.colt.list.IntArrayList;
import edu.sysu.pmglab.ccf.record.IRecord;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.gtb.genome.Variant;
import edu.sysu.pmglab.gtb.linkagedisequilibrium.GenotypeLD;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public enum LDProcessor {
    INSTANCE;


    public IntArrayList generateLDBlockingBoundaries(List<Variant> varList, float tolerableLDR2Cut, float tolerableViolatorPercents, int minBlockSize, int maxBlockLength) throws IOException {
        IntArrayList globeLDBBlockEndpoints = new IntArrayList();
        if (varList.size() == 1) {
            globeLDBBlockEndpoints.add(0);
            globeLDBBlockEndpoints.add(1);
            return globeLDBBlockEndpoints;
        }
        HashMap<String, Float> sparMatrix = new HashMap<String, Float>();
        int screeningLength = 100;
        double checkingR2Inc = 0.015;
        float currentLDR2Cut = 0.01f;
        globeLDBBlockEndpoints.add(0);
        this.adaptiveBlocking(varList, 0, varList.size(), screeningLength, tolerableLDR2Cut, currentLDR2Cut, checkingR2Inc, tolerableViolatorPercents, maxBlockLength, sparMatrix, globeLDBBlockEndpoints);
        if (minBlockSize > 1) {
            IntArrayList ldBlockEndpointsTmp = new IntArrayList();
            ldBlockEndpointsTmp.add(0);
            int movedIndex = 0;
            for (int i = 1; i < globeLDBBlockEndpoints.size(); ++i) {
                if (globeLDBBlockEndpoints.get(i) - globeLDBBlockEndpoints.get(movedIndex) < minBlockSize) continue;
                ldBlockEndpointsTmp.add(globeLDBBlockEndpoints.get(i));
                movedIndex = i;
            }
            if (movedIndex < globeLDBBlockEndpoints.size() - 1) {
                ldBlockEndpointsTmp.add(globeLDBBlockEndpoints.get(globeLDBBlockEndpoints.size() - 1));
            }
            globeLDBBlockEndpoints.clear();
            globeLDBBlockEndpoints.addAllOf(ldBlockEndpointsTmp);
        }
        return globeLDBBlockEndpoints;
    }

    private void adaptiveBlocking(List<Variant> varList, int startIndex, int endIndex, int screeningLength, float tolerableLDR2Cut, float initialLDR2Cut, double checkingR2Inc, float tolerableViolatorPercents, int maxBlockLength, Map<String, Float> sparMatrix, IntArrayList globeLDBBlockEndpoints) {
        List<float[]> toBeBlocked = new List<float[]>();
        toBeBlocked.add(new float[]{startIndex, endIndex, initialLDR2Cut});
        List<float[]> toBeBlockedTmp = new List<float[]>();
        List<float[]> hasBlocked = new List<float[]>();
        do {
            for (float[] block : toBeBlocked) {
                IntArrayList ldBlockEndpoints = this.onceBlocking(varList, (int)block[0], (int)block[1], screeningLength, block[2], tolerableViolatorPercents, sparMatrix);
                for (int i = 1; i < ldBlockEndpoints.size(); ++i) {
                    if (ldBlockEndpoints.get(i) - ldBlockEndpoints.get(i - 1) > maxBlockLength) {
                        if (block[2] > tolerableLDR2Cut) {
                            hasBlocked.add(new float[]{ldBlockEndpoints.get(i - 1), ldBlockEndpoints.get(i), block[2]});
                            continue;
                        }
                        if (!hasBlocked.isEmpty()) {
                            // empty if block
                        }
                        toBeBlockedTmp.add(new float[]{ldBlockEndpoints.get(i - 1), ldBlockEndpoints.get(i), (float)((double)block[2] + checkingR2Inc)});
                        continue;
                    }
                    hasBlocked.add(new float[]{ldBlockEndpoints.get(i - 1), ldBlockEndpoints.get(i), block[2]});
                }
            }
            toBeBlocked.clear();
            toBeBlocked.addAll(toBeBlockedTmp);
            toBeBlockedTmp.clear();
        } while (!toBeBlocked.isEmpty());
        hasBlocked.sort((o1, o2) -> Float.compare(o1[1], o2[1]));
        for (float[] floats : hasBlocked) {
            globeLDBBlockEndpoints.add((int)floats[1]);
        }
    }

    private IntArrayList onceBlocking(List<Variant> varList, int startIndex, int endIndex, int screeningLength, float initialLDR2, float tolerableViolatorPercents, Map<String, Float> sparMatrix) {
        IntArrayList ldBlockEndpoints = new IntArrayList();
        ldBlockEndpoints.add(startIndex);
        boolean isViolated = false;
        int currentViolators = 0;
        for (int rowIndex = startIndex; rowIndex < endIndex; ++rowIndex) {
            Variant variant0 = varList.get(rowIndex);
            if (variant0.getGenotypes() == null || variant0.getGenotypes().counter().getAN() == 0) continue;
            isViolated = false;
            currentViolators = 0;
            int currentScreeningLength = Math.min(screeningLength, endIndex - rowIndex - 1);
            if (currentScreeningLength == 0) continue;
            int maxViolators = Math.round(tolerableViolatorPercents * (float)currentScreeningLength);
            for (int j = 1; j <= currentScreeningLength; ++j) {
                String id;
                Float r2;
                Variant variant1 = varList.get(j + rowIndex);
                if (variant1.getGenotypes() == null || variant1.getGenotypes().counter().getAN() == 0 || !((r2 = sparMatrix.computeIfAbsent(id = rowIndex + "-" + (j + rowIndex), key -> {
                    IRecord record = GenotypeLD.INSTANCE.apply(variant0, variant1);
                    return Float.valueOf(Math.abs(((Float)record.get("R^2")).floatValue()));
                })).floatValue() > initialLDR2) || ++currentViolators <= maxViolators) continue;
                isViolated = true;
                break;
            }
            if (isViolated) continue;
            int lastBlockBoundary = ldBlockEndpoints.get(ldBlockEndpoints.size() - 1);
            for (int k = rowIndex - 1; k > lastBlockBoundary; --k) {
                Variant variant = varList.get(k);
                if (variant.getGenotypes() == null || variant.getGenotypes().counter().getAN() == 0) continue;
                currentViolators = 0;
                for (int j = 1; j <= currentScreeningLength; ++j) {
                    String id;
                    Float r2;
                    Variant variant1 = varList.get(j + rowIndex);
                    if (variant1.getGenotypes() == null || variant1.getGenotypes().counter().getAN() == 0 || !((r2 = sparMatrix.computeIfAbsent(id = k + "-" + (j + rowIndex), key -> {
                        IRecord record = GenotypeLD.INSTANCE.apply(variant, variant1);
                        return Float.valueOf(Math.abs(((Float)record.get("R^2")).floatValue()));
                    })).floatValue() > initialLDR2) || ++currentViolators <= maxViolators) continue;
                    isViolated = true;
                    break;
                }
                if (isViolated) break;
            }
            if (isViolated) continue;
            ldBlockEndpoints.add(rowIndex + 1);
        }
        ldBlockEndpoints.add(endIndex);
        return ldBlockEndpoints;
    }
}

