/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.analysis;

public enum TNBRegressionRSource {
    INSTANCE;

    public String sourceCodeR0 = "#note: the functions are modified based on the  zerotrunc functions in the \u201ccountreg\u201d R package https://r-forge.r-project.org/R/?group_id=522\n#Please also acknowledge countreg package if you use our codes.\n\nzerotrunc <-\n  function(formula,\n           data,\n           subset,\n           na.action,\n           weights,\n           offset,\n           truncPoint = 0,\n           dist = c(\"poisson\", \"negbin\", \"geometric\", \"negbin-extended\"),\n           theta = Inf,\n           control = zerotrunc.control(...),\n           model = TRUE,\n           y = TRUE,\n           x = FALSE,\n           ...)\n  {\n    ## set up likelihood components\n    llPoisson <- function(parms) {\n      mu <- as.vector(exp(X %*% parms + offset))\n      sum(weights * (\n        dpois(Y, lambda = mu, log = TRUE) - ppois(\n          0,\n          lambda = mu,\n          lower.tail = FALSE,\n          #if TRUE (default), probabilities are P[X \u2264 x], otherwise, P[X > x].\n          log.p = TRUE  #if TRUE, probabilities p are given as log(p).\n        )\n      ))\n    }\n    \n    \n    \n    llNegBin <- function(parms) {\n      ## parameters\n      mu <- as.vector(exp(X %*% parms[1:k] + offset))\n      theta <- exp(parms[k + 1])\n      sum(weights * suppressWarnings(\n        dnbinom(\n          Y,\n          size = theta,\n          mu = mu,\n          log = TRUE\n        ) -\n          pnbinom(\n            0,\n            #An alternative parametrization (often used in ecology) is by the mean mu (see above), and size, the dispersion parameter,\n            #where prob = size/(size+mu). The variance is mu + mu^2/size in this parametrization.\n            #pnbinom(0,...,lower.tail = FALSE , log.p = TRUE)\u6307\u7684\u662flog(P(X>=1))\n            size = theta,\n            mu = mu,\n            lower.tail = FALSE,\n            log.p = TRUE\n          )\n      ))\n    }\n    \n    llGeom <- function(parms)\n      llNegBin(c(parms, 0))\n    \n    llNBFixed <- function(parms)\n      llNegBin(c(parms, log(theta)))\n    \n    llNBExtended <- function(parms) {\n      ## parameters\n      mu <- as.vector(exp(X %*% parms[1:k] + offset))\n      theta <- exp(parms[k + 1])\n      sum(weights * suppressWarnings(\n        dnbinom(\n          Y,\n          size = theta,\n          mu = mu,\n          log = TRUE\n        ) -\n          pnbinom(\n            truncPoint,\n            size = theta,\n            mu = mu,\n            lower.tail = FALSE,\n            log.p = TRUE\n          )\n      ))\n    }\n    \n    gradPoisson <- function(parms) {\n      eta <- as.vector(X %*% parms + offset)\n      mu <- exp(eta)\n      colSums(((Y - mu) - exp(\n        ppois(0, lambda = mu, log.p = TRUE) -\n          ppois(\n            0,\n            lambda = mu,\n            lower.tail = FALSE,\n            log.p = TRUE\n          ) + eta\n      )) * weights * X)\n    }\n    \n    gradGeom <- function(parms) {\n      eta <- as.vector(X %*% parms + offset)\n      mu <- exp(eta)\n      colSums(((Y - mu * (Y + 1) / (mu + 1)) -\n                 exp(\n                   pnbinom(\n                     0,\n                     mu = mu,\n                     size = 1,\n                     log.p = TRUE\n                   ) -\n                     pnbinom(\n                       0,\n                       mu = mu,\n                       size = 1,\n                       lower.tail = FALSE,\n                       log.p = TRUE\n                     ) -\n                     log(mu + 1) + eta\n                 )) * weights * X)\n    }\n    \n    gradNegBin <- function(parms) {\n      eta <- as.vector(X %*% parms[1:k] + offset)\n      mu <- exp(eta)\n      theta <- exp(parms[k + 1])\n      logratio <- pnbinom(0,\n                          mu = mu,\n                          size = theta,\n                          log.p = TRUE) -\n        pnbinom(\n          0,\n          mu = mu,\n          size = theta,\n          lower.tail = FALSE,\n          log.p = TRUE\n        )\n      rval <- colSums(((Y - mu * (Y + theta) / (mu + theta)) -\n                         exp(\n                           logratio + log(theta) - log(mu + theta) + eta\n                         )) * weights * X)\n      rval2 <- sum((\n        digamma(Y + theta) - digamma(theta) +\n          log(theta) - log(mu + theta) + 1 - (Y + theta) / (mu + theta) +\n          exp(logratio) * (log(theta) - log(mu + theta) + 1 - theta /\n                             (mu + theta))\n      ) * weights) * theta\n      c(rval, rval2)\n    }\n    \n    gradNBFixed <- function(parms) {\n      eta <- as.vector(X %*% parms + offset)\n      mu <- exp(eta)\n      logratio <- pnbinom(0,\n                          mu = mu,\n                          size = theta,\n                          log.p = TRUE) -\n        pnbinom(\n          0,\n          mu = mu,\n          size = theta,\n          lower.tail = FALSE,\n          log.p = TRUE\n        )\n      colSums(((Y - mu * (Y + theta) / (mu + theta)) -\n                 exp(\n                   logratio + log(theta) - log(mu + theta) + eta\n                 )) * weights * X)\n    }\n    gradNBExtended <- function(parms) {\n      eta <- as.vector(X %*% parms[1:k] + offset)\n      mu <- exp(eta)\n      theta <- exp(parms[k + 1])\n      \n      derivation <-\n        sapply(seq(0, truncPoint), function(i) {\n          (i - mu * (i + theta) / (mu + theta)) * dnbinom(i, mu = mu, size = theta)\n        })\n      \n      derivation <- if (is.null(dim(derivation))) {\n        sum(derivation)\n      } else{\n        apply(derivation, 1, sum)\n      }\n      # set offset\n      difflogtrunc <-\n        derivation / (pnbinom(\n          truncPoint,\n          mu = mu,\n          size = theta,\n          lower.tail = FALSE\n        ) + 1 / (4 * n))\n      # difflogtrunc <-\n      #   derivation / pnbinom(truncPoint,\n      #                         mu = mu,\n      #                         size = theta,\n      #                         lower.tail = FALSE)\n      rval <-\n        colSums(((Y - mu * (Y + theta) / (mu + theta)) + difflogtrunc) * weights * X)\n      \n      derivation2 <- sapply(seq(0, truncPoint),\n                            function(i) {\n                              (\n                                digamma(i + theta) - digamma(theta) +\n                                  log(theta) - log(mu + theta) + 1 - (i + theta) / (mu + theta)\n                              ) * dnbinom(i, mu = mu, size = theta)\n                            })\n      derivation2 <- if (is.null(dim(derivation2))) {\n        sum(derivation2)\n      } else{\n        apply(derivation2, 1, sum)\n      }\n      #set offset\n      difflogtrunc2 <-\n        derivation2 / (pnbinom(\n          truncPoint,\n          mu = mu,\n          size = theta,\n          lower.tail = FALSE\n        ) + 1 / (4 * n))\n      # difflogtrunc2 <-\n      #   derivation2 / pnbinom(truncPoint,\n      #                          mu = mu,\n      #                          size = theta,\n      #                          lower.tail = FALSE)\n      rval2 <- sum((\n        digamma(Y + theta) - digamma(theta) +\n          log(theta) - log(mu + theta) + 1 - (Y + theta) / (mu + theta) +\n          difflogtrunc2\n      ) * weights) * theta\n      c(rval, rval2)\n    }\n    \n    ## dist/theta processing\n    if (!missing(theta)) {\n      if (!missing(dist))\n        warning(\"supply either 'theta' or 'dist' but not both, 'dist' is ignored\")\n      if (!is.null(theta) && theta <= 0)\n        stop(\"theta has to be > 0\")\n      dist <- if (is.null(theta)) {\n        \"negbin\"\n      } else if (!is.finite(theta)) {\n        \"poisson\"\n      } else if (isTRUE(all.equal(theta, 1))) {\n        \"geometric\"\n      } else {\n        \"negbin-fixed\"\n      }\n    } else {\n      dist <- match.arg(dist)\n      theta <- switch(\n        dist,\n        \"poisson\" = Inf,\n        \"geometric\" = 1,\n        \"negbin\" = NULL,\n        \"negbin-extended\" = NULL\n      )\n    }\n    \n    ## collect likelihood components\n    llfun <- switch(\n      dist,\n      \"poisson\" = llPoisson,\n      \"geometric\" = llGeom,\n      \"negbin\" = llNegBin,\n      \"negbin-fixed\" = llNBFixed,\n      \"negbin-extended\" = llNBExtended\n    )\n    grad <- switch(\n      dist,\n      \"poisson\" = gradPoisson,\n      \"geometric\" = gradGeom,\n      \"negbin\" = gradNegBin,\n      \"negbin-fixed\" = gradNBFixed,\n      \"negbin-extended\" = gradNBExtended\n    )\n    \n    ## call and formula\n    cl <- match.call()\n    if (missing(data))\n      data <- environment(formula)\n    mf <- match.call(expand.dots = FALSE)\n    m <-\n      match(c(\"formula\", \"data\", \"subset\", \"na.action\", \"weights\", \"offset\"),\n            names(mf),\n            0)\n    mf <- mf[c(1, m)]\n    #  print(mf)\n    mf$drop.unused.levels <- TRUE\n    \n    ## call model.frame()\n    mf[[1]] <- as.name(\"model.frame\")\n    # print(mf)\n    mf <- eval(mf, parent.frame())\n    #print(mf)\n    \n    ## extract terms, model matrices, response\n    mt <- terms(formula, data = data)\n    X <- model.matrix(mt, mf)\n    Y <- model.response(mf, \"numeric\")\n    \n    ## sanity checks\n    if (length(Y) < 1)\n      stop(\"empty model\")\n    if (any(Y < 0))\n      stop(\"invalid dependent variable, negative counts\")\n    if (any(Y == 0))\n      stop(\"invalid dependent variable, no zeros allowed\")\n    if (!isTRUE(all.equal(as.vector(Y), as.integer(round(Y + 0.001)))))\n      stop(\"invalid dependent variable, non-integer values\")\n    Y <- as.integer(round(Y + 0.001))\n    \n    ## convenience variables\n    n <- length(Y)\n    k <- NCOL(X)\n    \n    ## weights and offset\n    weights <- model.weights(mf)\n    if (is.null(weights))\n      weights <- 1\n    if (length(weights) == 1)\n      weights <- rep(weights, n)\n    weights <- as.vector(weights)\n    names(weights) <- rownames(mf)\n    \n    offset <- model.offset(mf)\n    if (is.null(offset))\n      offset <- 0\n    if (length(offset) == 1)\n      offset <- rep(offset, n)\n    offset <- as.vector(offset)\n    \n    ## starting values\n    start <- control$start\n    start_theta <- NULL\n    if (!is.null(start)) {\n      if (dist != \"negbin\" && dist != \"negbin-extended\") {\n        start_theta <- NULL\n        if (length(start) != k) {\n          warning(\"invalid starting values, model coefficients not correctly specified\")\n          start <- NULL\n        }\n      } else {\n        if (length(start) == k + 1) {\n          start_theta <- start[k + 1]\n          start <- start[1:k]\n        } else if (length(start) == k) {\n          start_theta <- NULL\n        } else {\n          warning(\"invalid starting values, model coefficients not correctly specified\")\n          start <- start_theta <- NULL\n        }\n      }\n    }\n    \n    ## default starting values\n    if (is.null(start))\n      start <-\n      glm.fit(X,\n              Y,\n              family = poisson(),\n              weights = weights,\n              offset = offset)$coefficients\n    if (is.null(start_theta))\n      start_theta <- 1\n    if (dist == \"negbin\" ||\n        dist == \"negbin-extended\")\n      start <- c(start, log(start_theta))\n    \n    ## model fitting\n    ## control parameters\n    method <- control$method\n    hessian <- control$hessian\n    ocontrol <- control\n    control$method <- control$hessian <- control$start <- NULL\n    \n    ## ML estimation\n    fit <- optim(\n      fn = llfun,\n      gr = grad,\n      par = start,\n      method = method,\n      #set lower bound\n      #lower = c(rep(-exp(5),k),log(0.00001)),\n      hessian = hessian,\n      control = control\n    )\n    \n    ## coefficients\n    cf <- fit$par[1:k]\n    if (dist == \"negbin\" ||\n        dist == \"negbin-extended\")\n      theta <- as.vector(exp(fit$par[k + 1]))\n    names(cf) <- colnames(X)\n    \n    ## covariances\n    library(MASS)\n    vc <- -ginv(as.matrix(fit$hessian))\n    #vc <- -solve(as.matrix(fit$hessian))\n    if (dist == \"negbin\" || dist == \"negbin-extended\") {\n      SE.logtheta <- as.vector(sqrt(diag(vc)[k + 1]))\n      vc <- vc[-(k + 1),-(k + 1), drop = FALSE]\n    } else {\n      SE.logtheta <- NULL\n    }\n    colnames(vc) <- rownames(vc) <- colnames(X)\n    \n    ## fitted and residuals\n    mu <- exp(X %*% cf + offset)[, 1]\n    p0 <-\n      if (dist == \"poisson\")\n        ppois(0,\n              lambda = mu,\n              lower.tail = FALSE,\n              log.p = TRUE)\n    else\n      pnbinom(\n        truncPoint,\n        size = theta,\n        mu = mu,\n        lower.tail = FALSE,\n        log.p = TRUE\n      )\n    Yhat <- exp(log(mu) - p0)\n    res <- sqrt(weights) * (Y - Yhat)\n    \n    ## effective observations\n    nobs <- sum(weights > 0) ## = n - sum(weights == 0)\n    \n    rval <- list(\n      coefficients = cf,\n      residuals = res,\n      fitted.values = Yhat,\n      optim = fit,\n      method = method,\n      control = control,\n      start = start,\n      weights = if (identical(as.vector(weights), rep(1, n)))\n        NULL\n      else\n        weights,\n      offset = if (identical(offset, rep(0, n)))\n        NULL\n      else\n        offset,\n      n = nobs,\n      df.null = nobs - 1 - (dist == \"negbin\" ||\n                              dist == \"negbin-extended\"),\n      df.residual = nobs - k - (dist == \"negbin\" ||\n                                  dist == \"negbin-extended\"),\n      terms = mt,\n      theta = theta,\n      SE.logtheta = SE.logtheta,\n      loglik = fit$value,\n      vcov = vc,\n      dist = dist,\n      converged = fit$convergence < 1,\n      call = cl,\n      formula = formula,\n      levels = .getXlevels(mt, mf),\n      contrasts = attr(X, \"contrasts\")\n    )\n    if (model)\n      rval$model <- mf\n    if (y)\n      rval$y <- Y\n    if (x)\n      rval$x <- X\n    \n    class(rval) <- \"zerotrunc\"\n    return(rval)\n  }\n\nzerotrunc.control <-\n  #function(method = \"L-BFGS-B\",\n  function(method = \"BFGS\",\n           maxit = 10000,\n           start = NULL,\n           ...) {\n    rval <- list(method = method,\n                 maxit = maxit,\n                 start = start)\n    rval <- c(rval, list(...))\n    if (!is.null(rval$fnscale))\n      warning(\"fnscale must not be modified\")\n    rval$fnscale <- -1\n    if (!is.null(rval$hessian))\n      warning(\"hessian must not be modified\")\n    rval$hessian <- TRUE\n    if (is.null(rval$reltol))\n      rval$reltol <- .Machine$double.eps ^ (1 / 1.6)\n    rval\n  }\n\ncoef.zerotrunc <- function(object, ...) {\n  object$coefficients\n}\n\nvcov.zerotrunc <- function(object, ...) {\n  object$vcov\n}\n\nlogLik.zerotrunc <- function(object, ...) {\n  structure(\n    object$loglik,\n    df = object$n - object$df.residual,\n    nobs = object$n,\n    class = \"logLik\"\n  )\n}\n\nnobs.zerotrunc <- function(object, ...)\n  object$n\n\nprint.zerotrunc <-\n  function(x, digits = max(3, getOption(\"digits\") - 3), ...)\n  {\n    if (x$dist == \"negbin-fixed\") {\n      dist <- \"negbin\"\n      fixed <- TRUE\n    } else {\n      dist <- x$dist\n      fixed <- FALSE\n    }\n    \n    cat(\"\\nCall:\", deparse(x$call, width.cutoff = floor(getOption(\"width\") * 0.85)), \"\", sep = \"\\n\")\n    \n    if (!x$converged) {\n      cat(\"model did not converge\\n\")\n    } else {\n      cat(paste(\"Coefficients (truncated \", dist, \" with log link):\\n\", sep = \"\"))\n      print.default(format(x$coefficients, digits = digits),\n                    print.gap = 2,\n                    quote = FALSE)\n      cat(\"\\n\")\n      if (dist == \"negbin\" ||\n          dist == \"negbin-extended\")\n        cat(paste(\n          ifelse(fixed, \"Theta (fixed) =\", \"Theta =\"),\n          round(x$theta, digits),\n          \"\\n\\n\"\n        ))\n    }\n    \n    invisible(x)\n  }\n\nsummary.zerotrunc <- function(object, truncPoint = 0,  ...)\n{\n  ## deviance residuals\n  object$residuals <-\n    residuals(object, truncPoint = truncPoint, type = \"deviance\")\n  \n  ## compute z statistics\n  cf <- object$coefficients\n  se <- sqrt(abs(diag(object$vcov)))\n  k <- length(cf)\n  \n  if (object$dist == \"negbin\" ||\n      object$dist == \"negbin-extended\") {\n    cf <- c(cf, \"Log(theta)\" = as.vector(log(object$theta)))\n    se <- c(se, object$SE.logtheta)\n  }\n  zstat <- cf / se\n  pval <- 2 * pnorm(-abs(zstat))\n  cf <- cbind(cf, se, zstat, pval)\n  colnames(cf) <-\n    c(\"Estimate\", \"Std. Error\", \"z value\", \"Pr(>|z|)\")\n  object$coefficients <- cf\n  \n  ## number of iterations\n  object$iterations <- tail(na.omit(object$optim$count), 1)\n  \n  ## delete some slots\n  object$fitted.values <-\n    object$terms <- object$model <- object$y <-\n    object$x <-\n    object$levels <- object$contrasts <- object$start <- NULL\n  \n  ## return\n  class(object) <- \"summary.zerotrunc\"\n  object\n}\n\nprint.summary.zerotrunc <-\n  function(x, digits = max(3, getOption(\"digits\") - 3), ...)\n  {\n    cat(\"\\nCall:\", deparse(x$call, width.cutoff = floor(getOption(\"width\") * 0.85)), \"\", sep = \"\\n\")\n    \n    if (!x$converged) {\n      cat(\"model did not converge\\n\")\n    } else {\n      if (x$dist == \"negbin-fixed\") {\n        dist <- \"negbin\"\n        fixed <- TRUE\n      } else {\n        dist <- x$dist\n        fixed <- FALSE\n      }\n      \n      cat(\"Deviance residuals:\\n\")\n      print(structure(\n        quantile(x$residuals),\n        names = c(\"Min\", \"1Q\", \"Median\", \"3Q\", \"Max\")\n      ), digits = digits, ...)\n      \n      cat(paste(\"\\nCoefficients (truncated \", dist, \" with log link):\\n\", sep = \"\"))\n      printCoefmat(x$coefficients, digits = digits, ...)\n      \n      if (dist == \"negbin\" ||\n          dist == \"negbin-extended\")\n        cat(paste(\n          ifelse(fixed, \"\\nTheta (fixed) =\", \"\\nTheta =\"),\n          round(x$theta, digits)\n        ))\n      cat(paste(\n        \"\\nNumber of iterations in\",\n        x$method,\n        \"optimization:\",\n        x$iterations,\n        \"\\n\"\n      ))\n      cat(\n        \"Log-likelihood:\",\n        formatC(x$loglik, digits = digits),\n        \"on\",\n        x$n - x$df.residual,\n        \"Df\\n\"\n      )\n    }\n    \n    invisible(x)\n  }\n\nterms.zerotrunc <- function(x, ...) {\n  x$terms\n}\n\nmodel.frame.zerotrunc <- function(formula, ...) {\n  if (!is.null(formula$model))\n    return(formula$model)\n  NextMethod()\n}\n\nmodel.matrix.zerotrunc <- function(object, ...) {\n  rval <- if (!is.null(object$x))\n    object$x\n  else\n    model.matrix(object$terms, model.frame(object), contrasts = object$contrasts)\n  return(rval)\n}\n\npredict.zerotrunc <-\n  function(object,\n           newdata,\n           truncPoint = 0,\n           type = c(\"response\", \"prob\", \"count\", \"zero\"),\n           na.action = na.pass,\n           ...)\n  {\n    type <- match.arg(type)\n    ## if no new data supplied\n    if (missing(newdata)) {\n      if (type != \"response\") {\n        if (!is.null(object$x)) {\n          X <- object$x\n        } else if (!is.null(object$model)) {\n          X <-\n            model.matrix(object$terms, object$model, contrasts = object$contrasts)\n        } else {\n          stop(\"predicted probabilities cannot be computed with missing newdata\")\n        }\n        offset <-\n          if (is.null(object$offset))\n            rep(0, NROW(X))\n        else\n          object$offset\n      } else {\n        return(object$fitted.values)\n      }\n    } else {\n      mf <-\n        model.frame(\n          delete.response(object$terms),\n          newdata,\n          na.action = na.action,\n          xlev = object$levels\n        )\n      X <-\n        model.matrix(delete.response(object$terms), mf, contrasts = object$contrasts)\n      offset <- if (!is.null(off.num <-\n                             attr(object$terms, \"offset\")))\n        eval(attr(object$terms, \"variables\")[[off.num + 1]], newdata)\n      else if (!is.null(object$offset))\n        eval(object$call$offset, newdata)\n      if (is.null(offset))\n        offset <- rep(0, NROW(X))\n    }\n    \n    mu <- exp(X %*% object$coefficients + offset)[, 1]\n    ptrunc <-\n      if (object$dist == \"poisson\")\n        ppois(0,\n              lambda = mu,\n              lower.tail = FALSE,\n              log.p = TRUE)\n    else\n      pnbinom(\n        truncPoint,\n        size = object$theta,\n        mu = mu,\n        lower.tail = FALSE,\n        log.p = TRUE\n      )\n    \n    if (type == \"response\")\n      rval <- exp(log(mu) - ptrunc)\n    if (type == \"count\")\n      rval <- mu\n    if (type == \"zero\")\n      rval <- exp(ptrunc)\n    \n    ## predicted probabilities\n    if (type == \"prob\") {\n      y <-\n        if (!is.null(object$y))\n          object$y\n      else\n        model.response(model.frame(object))\n      yUnique <- 1:max(y)\n      nUnique <- length(yUnique)\n      rval <- matrix(NA, nrow = length(mu), ncol = nUnique)\n      dimnames(rval) <- list(rownames(X), yUnique)\n      \n      if (object$dist == \"poisson\") {\n        for (i in 1:nUnique)\n          rval[, i] <-\n            exp(dpois(yUnique[i], lambda = mu, log = TRUE) - ptrunc)\n      } else {\n        for (i in 1:nUnique)\n          rval[, i] <-\n            exp(dnbinom(\n              yUnique[i],\n              mu = mu,\n              size = object$theta,\n              log = TRUE\n            ) - ptrunc)\n      }\n    }\n    \n    rval\n  }\n\nfitted.zerotrunc <- function(object, ...) {\n  object$fitted.values\n}\n\n\npredprob.zerotrunc <- function(obj, truncPoint, ...) {\n  predict(obj, truncPoint, type = \"prob\", ...)\n}\n\nextractAIC.zerotrunc <-\n  function(fit, scale = NULL, k = 2, ...) {\n    c(attr(logLik(fit), \"df\"), AIC(fit, k = k))\n  }\n\nestfun.zerotrunc <- function(x, truncPoint = 0, ...) {\n  ## extract data\n  Y <- if (is.null(x$y))\n    model.response(model.frame(x))\n  else\n    x$y\n  X <- model.matrix(x)\n  beta <- coef(x)\n  theta <- x$theta\n  offset <- if (is.null(x$offset))\n    0\n  else\n    x$offset\n  wts <- weights(x)\n  if (is.null(wts))\n    wts <- 1\n  \n  ## count component: working residuals\n  eta <- as.vector(X %*% beta + offset)\n  mu <- exp(eta)\n  \n  wres <- as.numeric(Y > 0) * switch(\n    x$dist,\n    \"poisson\" = {\n      (Y - mu) - exp(\n        ppois(0, lambda = mu, log.p = TRUE) -\n          ppois(\n            0,\n            lambda = mu,\n            lower.tail = FALSE,\n            log.p = TRUE\n          ) + eta\n      )\n    },\n    \"geometric\" = {\n      (Y - mu * (Y + 1) / (mu + 1)) - exp(\n        pnbinom(\n          0,\n          mu = mu,\n          size = 1,\n          log.p = TRUE\n        ) -\n          pnbinom(\n            0,\n            mu = mu,\n            size = 1,\n            lower.tail = FALSE,\n            log.p = TRUE\n          ) - log(mu + 1) + eta\n      )\n    },\n    \"negbin\" = {\n      (Y - mu * (Y + theta) / (mu + theta)) - exp(\n        pnbinom(\n          0,\n          mu = mu,\n          size = theta,\n          log.p = TRUE\n        ) -\n          pnbinom(\n            0,\n            mu = mu,\n            size = theta,\n            lower.tail = FALSE,\n            log.p = TRUE\n          ) +\n          log(theta) - log(mu + theta) + eta\n      )\n    },\n    \"negbin-extended\" = {\n      derivation4 <-\n        sapply(seq(0, truncPoint), function(k) {\n          (k - mu * (k + theta) / (mu + theta)) * dnbinom(k, mu = mu, size = theta)\n        })\n      derivation4 <-\n        if (is.null(dim(derivation4))) {\n          sum(derivation4)\n        } else{\n          apply(derivation4, 1, sum)\n        }\n      difflogtrunc4 <-\n        derivation4 / pnbinom(truncPoint,\n                              mu = mu,\n                              size = theta,\n                              lower.tail = FALSE)\n      ((Y - mu * (Y + theta) / (mu + theta)) - difflogtrunc4)\n    }\n  )\n  \n  ## compute gradient from data\n  rval <- cbind(wres * wts * X)\n  colnames(rval) <- names(beta)\n  rownames(rval) <- rownames(X)\n  return(rval)\n}\n\ngetSummary.zerotrunc <- function(obj, alpha = 0.05, ...) {\n  ## extract summary object\n  s <- summary(obj)\n  \n  ## coefficient matrix and confidence interval\n  ## compute confidence interval manually to include Log(theta)\n  cf <- cbind(\n    s$coefficients,\n    s$coefficients[, 1] + qnorm(alpha / 2) * s$coefficients[, 2],\n    s$coefficients[, 1] + qnorm(1 - alpha / 2) * s$coefficients[, 2]\n  )\n  colnames(cf) <- c(\"est\", \"se\", \"stat\", \"p\", \"lwr\", \"upr\")\n  \n  ## further summary statistics\n  sstat <- c(\n    \"theta\" = s$theta,\n    \"N\" = nobs(obj),\n    \"logLik\" = as.vector(logLik(obj)),\n    \"AIC\" = AIC(obj),\n    \"BIC\" = BIC(obj)\n  )\n  \n  ## return everything\n  return(\n    list(\n      coef = cf,\n      sumstat = sstat,\n      contrasts = obj$contrasts,\n      xlevels = obj$levels,\n      call = obj$call\n    )\n  )\n}\n\nsummarySimple.zerotrunc <- function(object, ...)\n{\n  ## pearson residuals\n  #object$residuals <- residuals(object, type = \"pearson\")\n  \n  ## compute z statistics\n  cf <- object$coefficients\n  se <- sqrt(diag(object$vcov))\n  k <- length(cf)\n  \n  if (object$dist == \"negbin\") {\n    cf <- c(cf, \"Log(theta)\" = as.vector(log(object$theta)))\n    se <- c(se, object$SE.logtheta)\n  }\n  zstat <- cf / se\n  pval <- 2 * pnorm(-abs(zstat))\n  #cf <- cbind(cf, se, zstat, pval)\n  len = length(cf)\n  txt <- \"  Variable\\tEstimate\\tStd. Error\\tz value\\tPr(>|z|)\"\n  for (i in 1:len) {\n    txt1 <-\n      paste(paste(\"  \", names(cf)[i], sep = \"\"), cf[i], se[i], zstat[i], pval[i], sep =\n              \"\\t\")\n    txt <- paste(txt, txt1, sep = \"\\n\")\n  }\n  txt1 <- paste(\"  Theta =\", object$theta)\n  txt <- paste(txt, txt1, sep = \"\\n\")\n  txt1 <- paste(\"  Log-likelihood: \", object$loglik)\n  txt <- paste(txt, txt1, sep = \"\\n\")\n  txt1 <- paste(\"  AIC: \", AIC(object))\n  txt <- paste(txt, txt1, sep = \"\\n\")\n  \n  ## number of iterations\n  object$iterations <- tail(na.omit(object$optim$count), 1)\n  txt1 <-\n    paste(\"  Number of iterations in BFGS optimization: \",\n          object$iterations)\n  txt <- paste(txt, txt1, sep = \"\\n\")\n  \n  ## delete some slots\n  object$fitted.values <-\n    object$terms <- object$model <- object$y <-\n    object$x <-\n    object$levels <- object$contrasts <- object$start <- NULL\n  \n  \n  ## return\n  txt\n}\n\n\n# Function to compute residuals for zero-truncated negative binomial regression\nresiduals.zrnbFull <- function(znbr, dfull, truncPoint = 0, type = c(\"deviance\", \"pearson\", \"response\",\"rqr\")) {\n  # Extracting relevant columns from the dataframe\n  X2 <- dfull[, names(znbr$coefficients)[2:length(znbr$coefficients)]]\n  X1 <- rep(1, dim(X2)[1])\n  X <- data.frame(X1, X2)\n  \n  y <- dfull[, 1]\n  wts <- 1\n  \n  # Computing mu\n  X <- data.matrix(X)\n  cf <- matrix(znbr$coefficients, nrow = length(znbr$coefficients), ncol = 1)\n  mu <- exp(X %*% cf)\n  theta <- znbr$theta\n  \n  # Computing p0\n  p0 <- pnbinom(truncPoint, size = theta, mu = mu, lower.tail = FALSE, log.p = TRUE)\n  \n  # Computing yhat and residuals\n  yhat <- exp(log(mu) - p0)\n  res <- (y - yhat)\n  \n  # Switch case for different types of residuals\n  switch(\n    type,\n    \n    \"response\" = {\n      return(res)\n    },\n    \n    \"pearson\" = {\n      p0 <- mu / yhat\n      vv <- (mu + (1 + 1 / theta - 1 / p0) * mu ^ 2) / p0\n      return(res / sqrt(vv))\n    },\n    \n    \"deviance\" = {\n      # Function to compute mu2y\n      mu2y <- function(mu) {\n        derivation3 <- sapply(seq(0, truncPoint), function(i) {\n          (i - mu) * dnbinom(i, mu = mu, size = theta)\n        })\n        derivation3 <- if (is.null(dim(derivation3))) {\n          sum(derivation3)\n        } else{\n          apply(derivation3, 1, sum)\n        }\n        difflogtrunc3 <- derivation3 / ifelse(mu > 0,\n                                              pnbinom(truncPoint, size = theta, mu = mu, lower.tail = FALSE),\n                                              1)\n        mu - difflogtrunc3\n      }\n      # Function to compute y2mu\n      y2mu <- function(y) {\n        yunique <- sort(unique(y))\n        munique <- sapply(yunique, function(z) {\n          f <- function(mu) z - mu2y(mu)\n          ifelse(f(0) * f(z) < 0, uniroot(f, interval = c(0, z))$root, mu)\n        })\n        munique[factor(y, levels = yunique)]\n      }\n      # Function to compute log likelihood\n      ll <- function(mu) {\n        dnbinom(y, size = theta, mu = mu, log = TRUE) -\n          pnbinom(truncPoint, size = theta, mu = mu, lower.tail = FALSE, log.p = TRUE)\n      }\n      # Return deviance residuals\n      return(sqrt(wts) * sign(y - yhat) * sqrt(2 * abs(ll(y2mu(y)) - ll(mu))))\n    },\n    \"rqr\" = {\n      p0 <- pnbinom(truncPoint, size = theta, mu = mu)\n      pdf <- function(y) {\n                 (pnbinom(y, size = theta, mu = mu)-p0)/(1-p0)\n      }\n      a <- ifelse(y > truncPoint, pdf(y), 0)\n      b <- ifelse(y+1 > truncPoint, pdf(y+1), 0)\n      u <- runif(n = length(y), min = a, max = b)\n      \n      \n      #1E-323 may be the minimal values for qnorm\n      u[u<=1E-323]<-1E-323\n      #get quantile close to 1\n      a <- rep(0.1, length(u))\n      u[is.na(u)] <- 1E-323\n      a[u > 0.5] <- u[u > 0.5]\n      a<-1-a\n      a[a<=1E-323]<-1E-323\n      \n      a<--qnorm(a)\n      u<- qnorm(u)\n      u[u > 0] <- a[a>0]\n      \n      u\n    }\n  )\n}\n\n\nresiduals.zerotrunc <-\n  function(object,\n           truncPoint = 0,\n           type = c(\"deviance\", \"pearson\", \"response\",\"rqr\"),\n           ...) {\n    type <- match.arg(type)\n    res <- object$residuals\n    wts <- object$weights\n    if (is.null(wts))\n      wts <- 1\n    \n    switch(\n      type,\n      \n      \"response\" = {\n        return(res)\n      },\n      \n      \"pearson\" = {\n        mu <- predict(object, truncPoint = truncPoint, type = \"count\")\n        p0 <- mu / object$fitted.values\n        theta1 <- 1 / object$theta\n        vv <-\n          (mu + (1 + 1 / object$theta - 1 / p0) * mu ^ 2) / p0\n        return(res / sqrt(vv))\n      },\n      \n      \"deviance\" = {\n        yhat <- object$fitted.values\n        y <- yhat + object$residuals / sqrt(wts)\n        \n        mu <-\n          predict(object, type = \"count\", truncPoint = truncPoint)\n        theta <- object$theta\n        \n        if (object$dist == \"poisson\") {\n          mu2y <-\n            function(mu)\n              mu / ifelse(mu > 0, ppois(0, lambda = mu, lower.tail = FALSE), 1)\n          y2mu <- function(y) {\n            yunique <- sort(unique(y))\n            munique <- sapply(yunique,\n                              function(z)\n                                uniroot(function(mu)\n                                  z - mu2y(mu), interval = c(0, z))$root)\n            munique[factor(y, levels = yunique)]\n          }\n          \n          ll <- function(mu) {\n            dpois(y, lambda = mu, log = TRUE) -\n              ppois(0,\n                    lambda = mu,\n                    lower.tail = FALSE,\n                    log.p = TRUE)\n          }\n        } else {\n          mu2y <- function(mu) {\n            derivation3 <-\n              sapply(seq(0, truncPoint), function(i) {\n                (i - mu) * dnbinom(i, mu = mu, size = theta)\n              })\n            \n            derivation3 <- if (is.null(dim(derivation3))) {\n              sum(derivation3)\n            } else{\n              apply(derivation3, 1, sum)\n            }\n            \n            difflogtrunc3 <-\n              derivation3 / ifelse(mu > 0,\n                                   pnbinom(\n                                     truncPoint,\n                                     size = theta,\n                                     mu = mu,\n                                     lower.tail = FALSE\n                                   ),\n                                   1)\n            mu - difflogtrunc3\n          }\n          y2mu <- function(y) {\n            yunique <- sort(unique(y))\n            \n            munique <- sapply(yunique, function(z) {\n              f <- function(mu)\n                z - mu2y(mu)\n              #print(uniroot(f, interval = c(0, z))$root)\n              # ifelse(f(truncPoint) * f(z) < 0, uniroot(f, interval = c(truncPoint, z))$root, mu)\n              ifelse(f(0) * f(z) < 0, uniroot(f, interval = c(0, z))$root, mu)\n            })\n            \n            munique[factor(y, levels = yunique)]\n          }\n          ll <- function(mu) {\n            dnbinom(y,\n                    size = theta,\n                    mu = mu,\n                    log = TRUE) -  pnbinom(\n                      truncPoint,\n                      size = theta,\n                      mu = mu,\n                      lower.tail = FALSE,\n                      log.p = TRUE\n                    )\n          }\n        }\n        \n        return(sqrt(wts) * sign(y - yhat) * sqrt(2 * abs(ll(y2mu(\n          y\n        )) - ll(mu))))\n      },\n      \n      \"rqr\" = {\n        #yhat <- object$fitted.values\n        #y <- yhat + object$residuals / sqrt(wts)\n        y <- object$y\n        mu <- predict(object, type = \"count\", truncPoint = truncPoint)\n        theta <- object$theta\n        \n        \n        p0 <- pnbinom(truncPoint, size = theta, mu = mu)\n        pdf <- function(y) {\n          (pnbinom(y, size = theta, mu = mu)-p0)/(1-p0)\n        }\n        a <- ifelse(y > truncPoint, pdf(y), 0)\n        b <- ifelse(y+1 > truncPoint, pdf(y+1), 0)\n        u <- runif(n = length(y), min = a, max = b)\n        \n        #1E-323 may be the minimal values for qnorm\n        u[u<=1E-323]<-1E-323\n        #get quantile close to 1\n        a <- rep(0.1, length(u))\n        u[is.na(u)] <- 1E-323\n        a[u > 0.5] <- u[u > 0.5]\n        a<-1-a\n        a[a<=1E-323]<-1E-323\n        #print(paste(length(u),length(a),sep = \" \"))\n        a<--qnorm(a)\n        u<- qnorm(u)\n        #print(paste(length(u),length(a),sep = \" \"))\n        u[u > 0] <- a[a>0]\n        \n        u\n      }\n    )\n  }\n\nresiduals.possionFull <-\n  function(possion, dfull, truncPoint = 0) {\n    X <- dfull[, 1:dim(dfull)[2]]\n    X[, 1] <- 1\n    \n    y <- dfull[, 1]\n    \n    wts <- 1\n    \n    X <- data.matrix(X)\n    cf <-\n      matrix(possion$coefficients,\n             nrow = length(possion$coefficients),\n             ncol = 1)\n    mu <- exp(X %*% cf)\n    \n    p0 <-\n      ppois(\n        truncPoint,\n        lambda = mu,\n        lower.tail = FALSE,\n        log.p = TRUE\n      )\n    \n    yhat <- exp(log(mu) - p0)\n    res <- (y - yhat)\n    \n    mu2y <-\n      function(mu)\n        mu / ifelse(mu > 0, ppois(truncPoint, lambda = mu, lower.tail = FALSE), 1)\n    y2mu <- function(y) {\n      yunique <- sort(unique(y))\n      munique <- sapply(yunique,\n                        function(z)\n                          uniroot(function(mu)\n                            z - mu2y(mu), interval = c(0, z))$root)\n      munique[factor(y, levels = yunique)]\n    }\n    ll <- function(mu) {\n      dpois(y, lambda = mu, log = TRUE) -\n        ppois(\n          truncPoint,\n          lambda = mu,\n          lower.tail = FALSE,\n          log.p = TRUE\n        )\n    }\n    \n    return(sqrt(wts) * sign(y - yhat) * sqrt(2 * abs(ll(y2mu(\n      y\n    )) - ll(mu))))\n  }\n";
    public final String sourceCodeR = "#note: the functions are modified based on the  zerotrunc functions in the \u001ccountreg\u001d R package https://r-forge.r-project.org/R/?group_id=522\n#Please also acknowledge countreg package if you use our codes.\n\nzerotrunc <-\n  function(formula,\n           data,\n           subset,\n           na.action,\n           weights,\n           offset,\n           truncPoint = 0,\n           dist = c(\"poisson\", \"negbin\", \"geometric\", \"negbin-extended\"),\n           theta = Inf,\n           control = zerotrunc.control(...),\n           model = TRUE,\n           y = TRUE,\n           x = FALSE,\n           ...)\n  {\n    ## set up likelihood components\n    llPoisson <- function(parms) {\n      mu <- as.vector(exp(X %*% parms + offset))\n      sum(weights * (\n        dpois(Y, lambda = mu, log = TRUE) - ppois(\n          0,\n          lambda = mu,\n          lower.tail = FALSE,\n          #if TRUE (default), probabilities are P[X d x], otherwise, P[X > x].\n          log.p = TRUE  #if TRUE, probabilities p are given as log(p).\n        )\n      ))\n    }\n    \n    \n    \n    llNegBin <- function(parms) {\n      ## parameters\n      mu <- as.vector(exp(X %*% parms[1:k] + offset))\n      theta <- exp(parms[k + 1])\n      sum(weights * suppressWarnings(\n        dnbinom(\n          Y,\n          size = theta,\n          mu = mu,\n          log = TRUE\n        ) -\n          pnbinom(\n            0,\n            #An alternative parametrization (often used in ecology) is by the mean mu (see above), and size, the dispersion parameter,\n            #where prob = size/(size+mu). The variance is mu + mu^2/size in this parametrization.\n            #pnbinom(0,...,lower.tail = FALSE , log.p = TRUE)\u0007\ufffd/log(P(X>=1))\n            size = theta,\n            mu = mu,\n            lower.tail = FALSE,\n            log.p = TRUE\n          )\n      ))\n    }\n    \n    llGeom <- function(parms)\n      llNegBin(c(parms, 0))\n    \n    llNBFixed <- function(parms)\n      llNegBin(c(parms, log(theta)))\n    \n    llNBExtended <- function(parms) {\n      ## parameters\n      mu <- as.vector(exp(X %*% parms[1:k] + offset))\n      theta <- exp(parms[k + 1])\n      sum(weights * suppressWarnings(\n        dnbinom(\n          Y,\n          size = theta,\n          mu = mu,\n          log = TRUE\n        ) -\n          pnbinom(\n            truncPoint,\n            size = theta,\n            mu = mu,\n            lower.tail = FALSE,\n            log.p = TRUE\n          )\n      ))\n    }\n    \n    gradPoisson <- function(parms) {\n      eta <- as.vector(X %*% parms + offset)\n      mu <- exp(eta)\n      colSums(((Y - mu) - exp(\n        ppois(0, lambda = mu, log.p = TRUE) -\n          ppois(\n            0,\n            lambda = mu,\n            lower.tail = FALSE,\n            log.p = TRUE\n          ) + eta\n      )) * weights * X)\n    }\n    \n    gradGeom <- function(parms) {\n      eta <- as.vector(X %*% parms + offset)\n      mu <- exp(eta)\n      colSums(((Y - mu * (Y + 1) / (mu + 1)) -\n                 exp(\n                   pnbinom(\n                     0,\n                     mu = mu,\n                     size = 1,\n                     log.p = TRUE\n                   ) -\n                     pnbinom(\n                       0,\n                       mu = mu,\n                       size = 1,\n                       lower.tail = FALSE,\n                       log.p = TRUE\n                     ) -\n                     log(mu + 1) + eta\n                 )) * weights * X)\n    }\n    \n    gradNegBin <- function(parms) {\n      eta <- as.vector(X %*% parms[1:k] + offset)\n      mu <- exp(eta)\n      theta <- exp(parms[k + 1])\n      logratio <- pnbinom(0,\n                          mu = mu,\n                          size = theta,\n                          log.p = TRUE) -\n        pnbinom(\n          0,\n          mu = mu,\n          size = theta,\n          lower.tail = FALSE,\n          log.p = TRUE\n        )\n      rval <- colSums(((Y - mu * (Y + theta) / (mu + theta)) -\n                         exp(\n                           logratio + log(theta) - log(mu + theta) + eta\n                         )) * weights * X)\n      rval2 <- sum((\n        digamma(Y + theta) - digamma(theta) +\n          log(theta) - log(mu + theta) + 1 - (Y + theta) / (mu + theta) +\n          exp(logratio) * (log(theta) - log(mu + theta) + 1 - theta /\n                             (mu + theta))\n      ) * weights) * theta\n      c(rval, rval2)\n    }\n    \n    gradNBFixed <- function(parms) {\n      eta <- as.vector(X %*% parms + offset)\n      mu <- exp(eta)\n      logratio <- pnbinom(0,\n                          mu = mu,\n                          size = theta,\n                          log.p = TRUE) -\n        pnbinom(\n          0,\n          mu = mu,\n          size = theta,\n          lower.tail = FALSE,\n          log.p = TRUE\n        )\n      colSums(((Y - mu * (Y + theta) / (mu + theta)) -\n                 exp(\n                   logratio + log(theta) - log(mu + theta) + eta\n                 )) * weights * X)\n    }\n    gradNBExtended <- function(parms) {\n      eta <- as.vector(X %*% parms[1:k] + offset)\n      mu <- exp(eta)\n      theta <- exp(parms[k + 1])\n      \n      derivation <-\n        sapply(seq(0, truncPoint), function(i) {\n          (i - mu * (i + theta) / (mu + theta)) * dnbinom(i, mu = mu, size = theta)\n        })\n      \n      derivation <- if (is.null(dim(derivation))) {\n        sum(derivation)\n      } else{\n        apply(derivation, 1, sum)\n      }\n      # set offset\n      difflogtrunc <-\n        derivation / (pnbinom(\n          truncPoint,\n          mu = mu,\n          size = theta,\n          lower.tail = FALSE\n        ) + 1 / (4 * n))\n      # difflogtrunc <-\n      #   derivation / pnbinom(truncPoint,\n      #                         mu = mu,\n      #                         size = theta,\n      #                         lower.tail = FALSE)\n      rval <-\n        colSums(((Y - mu * (Y + theta) / (mu + theta)) + difflogtrunc) * weights * X)\n      \n      derivation2 <- sapply(seq(0, truncPoint),\n                            function(i) {\n                              (\n                                digamma(i + theta) - digamma(theta) +\n                                  log(theta) - log(mu + theta) + 1 - (i + theta) / (mu + theta)\n                              ) * dnbinom(i, mu = mu, size = theta)\n                            })\n      derivation2 <- if (is.null(dim(derivation2))) {\n        sum(derivation2)\n      } else{\n        apply(derivation2, 1, sum)\n      }\n      #set offset\n      difflogtrunc2 <-\n        derivation2 / (pnbinom(\n          truncPoint,\n          mu = mu,\n          size = theta,\n          lower.tail = FALSE\n        ) + 1 / (4 * n))\n      # difflogtrunc2 <-\n      #   derivation2 / pnbinom(truncPoint,\n      #                          mu = mu,\n      #                          size = theta,\n      #                          lower.tail = FALSE)\n      rval2 <- sum((\n        digamma(Y + theta) - digamma(theta) +\n          log(theta) - log(mu + theta) + 1 - (Y + theta) / (mu + theta) +\n          difflogtrunc2\n      ) * weights) * theta\n      c(rval, rval2)\n    }\n    \n    ## dist/theta processing\n    if (!missing(theta)) {\n      if (!missing(dist))\n        warning(\"supply either 'theta' or 'dist' but not both, 'dist' is ignored\")\n      if (!is.null(theta) && theta <= 0)\n        stop(\"theta has to be > 0\")\n      dist <- if (is.null(theta)) {\n        \"negbin\"\n      } else if (!is.finite(theta)) {\n        \"poisson\"\n      } else if (isTRUE(all.equal(theta, 1))) {\n        \"geometric\"\n      } else {\n        \"negbin-fixed\"\n      }\n    } else {\n      dist <- match.arg(dist)\n      theta <- switch(\n        dist,\n        \"poisson\" = Inf,\n        \"geometric\" = 1,\n        \"negbin\" = NULL,\n        \"negbin-extended\" = NULL\n      )\n    }\n    \n    ## collect likelihood components\n    llfun <- switch(\n      dist,\n      \"poisson\" = llPoisson,\n      \"geometric\" = llGeom,\n      \"negbin\" = llNegBin,\n      \"negbin-fixed\" = llNBFixed,\n      \"negbin-extended\" = llNBExtended\n    )\n    grad <- switch(\n      dist,\n      \"poisson\" = gradPoisson,\n      \"geometric\" = gradGeom,\n      \"negbin\" = gradNegBin,\n      \"negbin-fixed\" = gradNBFixed,\n      \"negbin-extended\" = gradNBExtended\n    )\n    \n    ## call and formula\n    cl <- match.call()\n    if (missing(data))\n      data <- environment(formula)\n    mf <- match.call(expand.dots = FALSE)\n    m <-\n      match(c(\"formula\", \"data\", \"subset\", \"na.action\", \"weights\", \"offset\"),\n            names(mf),\n            0)\n    mf <- mf[c(1, m)]\n    #  print(mf)\n    mf$drop.unused.levels <- TRUE\n    \n    ## call model.frame()\n    mf[[1]] <- as.name(\"model.frame\")\n    # print(mf)\n    mf <- eval(mf, parent.frame())\n    #print(mf)\n    \n    ## extract terms, model matrices, response\n    mt <- terms(formula, data = data)\n    X <- model.matrix(mt, mf)\n    Y <- model.response(mf, \"numeric\")\n    \n    ## sanity checks\n    if (length(Y) < 1)\n      stop(\"empty model\")\n    if (any(Y < 0))\n      stop(\"invalid dependent variable, negative counts\")\n    if (any(Y == 0))\n      stop(\"invalid dependent variable, no zeros allowed\")\n    if (!isTRUE(all.equal(as.vector(Y), as.integer(round(Y + 0.001)))))\n      stop(\"invalid dependent variable, non-integer values\")\n    Y <- as.integer(round(Y + 0.001))\n    \n    ## convenience variables\n    n <- length(Y)\n    k <- NCOL(X)\n    \n    ## weights and offset\n    weights <- model.weights(mf)\n    if (is.null(weights))\n      weights <- 1\n    if (length(weights) == 1)\n      weights <- rep(weights, n)\n    weights <- as.vector(weights)\n    names(weights) <- rownames(mf)\n    \n    offset <- model.offset(mf)\n    if (is.null(offset))\n      offset <- 0\n    if (length(offset) == 1)\n      offset <- rep(offset, n)\n    offset <- as.vector(offset)\n    \n    ## starting values\n    start <- control$start\n    start_theta <- NULL\n    if (!is.null(start)) {\n      if (dist != \"negbin\" && dist != \"negbin-extended\") {\n        start_theta <- NULL\n        if (length(start) != k) {\n          warning(\"invalid starting values, model coefficients not correctly specified\")\n          start <- NULL\n        }\n      } else {\n        if (length(start) == k + 1) {\n          start_theta <- start[k + 1]\n          start <- start[1:k]\n        } else if (length(start) == k) {\n          start_theta <- NULL\n        } else {\n          warning(\"invalid starting values, model coefficients not correctly specified\")\n          start <- start_theta <- NULL\n        }\n      }\n    }\n    \n    ## default starting values\n    if (is.null(start))\n      start <-\n      glm.fit(X,\n              Y,\n              family = poisson(),\n              weights = weights,\n              offset = offset)$coefficients\n    if (is.null(start_theta))\n      start_theta <- 1\n    if (dist == \"negbin\" ||\n        dist == \"negbin-extended\")\n      start <- c(start, log(start_theta))\n    \n    ## model fitting\n    ## control parameters\n    method <- control$method\n    hessian <- control$hessian\n    ocontrol <- control\n    control$method <- control$hessian <- control$start <- NULL\n    \n    ## ML estimation\n    fit <- optim(\n      fn = llfun,\n      gr = grad,\n      par = start,\n      method = method,\n      #set lower bound\n      #lower = c(rep(-exp(5),k),log(0.00001)),\n      hessian = hessian,\n      control = control\n    )\n    \n    ## coefficients\n    cf <- fit$par[1:k]\n    if (dist == \"negbin\" ||\n        dist == \"negbin-extended\")\n      theta <- as.vector(exp(fit$par[k + 1]))\n    names(cf) <- colnames(X)\n    \n    ## covariances\n    library(MASS)\n    vc <- -ginv(as.matrix(fit$hessian))\n    #vc <- -solve(as.matrix(fit$hessian))\n    if (dist == \"negbin\" || dist == \"negbin-extended\") {\n      SE.logtheta <- as.vector(sqrt(diag(vc)[k + 1]))\n      vc <- vc[-(k + 1),-(k + 1), drop = FALSE]\n    } else {\n      SE.logtheta <- NULL\n    }\n    colnames(vc) <- rownames(vc) <- colnames(X)\n    \n    ## fitted and residuals\n    mu <- exp(X %*% cf + offset)[, 1]\n    p0 <-\n      if (dist == \"poisson\")\n        ppois(0,\n              lambda = mu,\n              lower.tail = FALSE,\n              log.p = TRUE)\n    else\n      pnbinom(\n        truncPoint,\n        size = theta,\n        mu = mu,\n        lower.tail = FALSE,\n        log.p = TRUE\n      )\n    Yhat <- exp(log(mu) - p0)\n    res <- sqrt(weights) * (Y - Yhat)\n    \n    ## effective observations\n    nobs <- sum(weights > 0) ## = n - sum(weights == 0)\n    \n    rval <- list(\n      coefficients = cf,\n      residuals = res,\n      fitted.values = Yhat,\n      optim = fit,\n      method = method,\n      control = control,\n      start = start,\n      weights = if (identical(as.vector(weights), rep(1, n)))\n        NULL\n      else\n        weights,\n      offset = if (identical(offset, rep(0, n)))\n        NULL\n      else\n        offset,\n      n = nobs,\n      df.null = nobs - 1 - (dist == \"negbin\" ||\n                              dist == \"negbin-extended\"),\n      df.residual = nobs - k - (dist == \"negbin\" ||\n                                  dist == \"negbin-extended\"),\n      terms = mt,\n      theta = theta,\n      SE.logtheta = SE.logtheta,\n      loglik = fit$value,\n      vcov = vc,\n      dist = dist,\n      converged = fit$convergence < 1,\n      call = cl,\n      formula = formula,\n      levels = .getXlevels(mt, mf),\n      contrasts = attr(X, \"contrasts\")\n    )\n    if (model)\n      rval$model <- mf\n    if (y)\n      rval$y <- Y\n    if (x)\n      rval$x <- X\n    \n    class(rval) <- \"zerotrunc\"\n    return(rval)\n  }\n\nzerotrunc.control <-\n  #function(method = \"L-BFGS-B\",\n  function(method = \"BFGS\",\n           maxit = 10000,\n           start = NULL,\n           ...) {\n    rval <- list(method = method,\n                 maxit = maxit,\n                 start = start)\n    rval <- c(rval, list(...))\n    if (!is.null(rval$fnscale))\n      warning(\"fnscale must not be modified\")\n    rval$fnscale <- -1\n    if (!is.null(rval$hessian))\n      warning(\"hessian must not be modified\")\n    rval$hessian <- TRUE\n    if (is.null(rval$reltol))\n      rval$reltol <- .Machine$double.eps ^ (1 / 1.6)\n    rval\n  }\n\ncoef.zerotrunc <- function(object, ...) {\n  object$coefficients\n}\n\nvcov.zerotrunc <- function(object, ...) {\n  object$vcov\n}\n\nlogLik.zerotrunc <- function(object, ...) {\n  structure(\n    object$loglik,\n    df = object$n - object$df.residual,\n    nobs = object$n,\n    class = \"logLik\"\n  )\n}\n\nnobs.zerotrunc <- function(object, ...)\n  object$n\n\nprint.zerotrunc <-\n  function(x, digits = max(3, getOption(\"digits\") - 3), ...)\n  {\n    if (x$dist == \"negbin-fixed\") {\n      dist <- \"negbin\"\n      fixed <- TRUE\n    } else {\n      dist <- x$dist\n      fixed <- FALSE\n    }\n    \n    cat(\"\\nCall:\", deparse(x$call, width.cutoff = floor(getOption(\"width\") * 0.85)), \"\", sep = \"\\n\")\n    \n    if (!x$converged) {\n      cat(\"model did not converge\\n\")\n    } else {\n      cat(paste(\"Coefficients (truncated \", dist, \" with log link):\\n\", sep = \"\"))\n      print.default(format(x$coefficients, digits = digits),\n                    print.gap = 2,\n                    quote = FALSE)\n      cat(\"\\n\")\n      if (dist == \"negbin\" ||\n          dist == \"negbin-extended\")\n        cat(paste(\n          ifelse(fixed, \"Theta (fixed) =\", \"Theta =\"),\n          round(x$theta, digits),\n          \"\\n\\n\"\n        ))\n    }\n    \n    invisible(x)\n  }\n\nsummary.zerotrunc <- function(object, truncPoint = 0,  ...)\n{\n  ## deviance residuals\n  object$residuals <-\n    residuals(object, truncPoint = truncPoint, type = \"deviance\")\n  \n  ## compute z statistics\n  cf <- object$coefficients\n  se <- sqrt(abs(diag(object$vcov)))\n  k <- length(cf)\n  \n  if (object$dist == \"negbin\" ||\n      object$dist == \"negbin-extended\") {\n    cf <- c(cf, \"Log(theta)\" = as.vector(log(object$theta)))\n    se <- c(se, object$SE.logtheta)\n  }\n  zstat <- cf / se\n  pval <- 2 * pnorm(-abs(zstat))\n  cf <- cbind(cf, se, zstat, pval)\n  colnames(cf) <-\n    c(\"Estimate\", \"Std. Error\", \"z value\", \"Pr(>|z|)\")\n  object$coefficients <- cf\n  \n  ## number of iterations\n  object$iterations <- tail(na.omit(object$optim$count), 1)\n  \n  ## delete some slots\n  object$fitted.values <-\n    object$terms <- object$model <- object$y <-\n    object$x <-\n    object$levels <- object$contrasts <- object$start <- NULL\n  \n  ## return\n  class(object) <- \"summary.zerotrunc\"\n  object\n}\n\nprint.summary.zerotrunc <-\n  function(x, digits = max(3, getOption(\"digits\") - 3), ...)\n  {\n    cat(\"\\nCall:\", deparse(x$call, width.cutoff = floor(getOption(\"width\") * 0.85)), \"\", sep = \"\\n\")\n    \n    if (!x$converged) {\n      cat(\"model did not converge\\n\")\n    } else {\n      if (x$dist == \"negbin-fixed\") {\n        dist <- \"negbin\"\n        fixed <- TRUE\n      } else {\n        dist <- x$dist\n        fixed <- FALSE\n      }\n      \n      cat(\"Deviance residuals:\\n\")\n      print(structure(\n        quantile(x$residuals),\n        names = c(\"Min\", \"1Q\", \"Median\", \"3Q\", \"Max\")\n      ), digits = digits, ...)\n      \n      cat(paste(\"\\nCoefficients (truncated \", dist, \" with log link):\\n\", sep = \"\"))\n      printCoefmat(x$coefficients, digits = digits, ...)\n      \n      if (dist == \"negbin\" ||\n          dist == \"negbin-extended\")\n        cat(paste(\n          ifelse(fixed, \"\\nTheta (fixed) =\", \"\\nTheta =\"),\n          round(x$theta, digits)\n        ))\n      cat(paste(\n        \"\\nNumber of iterations in\",\n        x$method,\n        \"optimization:\",\n        x$iterations,\n        \"\\n\"\n      ))\n      cat(\n        \"Log-likelihood:\",\n        formatC(x$loglik, digits = digits),\n        \"on\",\n        x$n - x$df.residual,\n        \"Df\\n\"\n      )\n    }\n    \n    invisible(x)\n  }\n\nterms.zerotrunc <- function(x, ...) {\n  x$terms\n}\n\nmodel.frame.zerotrunc <- function(formula, ...) {\n  if (!is.null(formula$model))\n    return(formula$model)\n  NextMethod()\n}\n\nmodel.matrix.zerotrunc <- function(object, ...) {\n  rval <- if (!is.null(object$x))\n    object$x\n  else\n    model.matrix(object$terms, model.frame(object), contrasts = object$contrasts)\n  return(rval)\n}\n\npredict.zerotrunc <-\n  function(object,\n           newdata,\n           truncPoint = 0,\n           type = c(\"response\", \"prob\", \"count\", \"zero\"),\n           na.action = na.pass,\n           ...)\n  {\n    type <- match.arg(type)\n    ## if no new data supplied\n    if (missing(newdata)) {\n      if (type != \"response\") {\n        if (!is.null(object$x)) {\n          X <- object$x\n        } else if (!is.null(object$model)) {\n          X <-\n            model.matrix(object$terms, object$model, contrasts = object$contrasts)\n        } else {\n          stop(\"predicted probabilities cannot be computed with missing newdata\")\n        }\n        offset <-\n          if (is.null(object$offset))\n            rep(0, NROW(X))\n        else\n          object$offset\n      } else {\n        return(object$fitted.values)\n      }\n    } else {\n      mf <-\n        model.frame(\n          delete.response(object$terms),\n          newdata,\n          na.action = na.action,\n          xlev = object$levels\n        )\n      X <-\n        model.matrix(delete.response(object$terms), mf, contrasts = object$contrasts)\n      offset <- if (!is.null(off.num <-\n                             attr(object$terms, \"offset\")))\n        eval(attr(object$terms, \"variables\")[[off.num + 1]], newdata)\n      else if (!is.null(object$offset))\n        eval(object$call$offset, newdata)\n      if (is.null(offset))\n        offset <- rep(0, NROW(X))\n    }\n    \n    mu <- exp(X %*% object$coefficients + offset)[, 1]\n    ptrunc <-\n      if (object$dist == \"poisson\")\n        ppois(0,\n              lambda = mu,\n              lower.tail = FALSE,\n              log.p = TRUE)\n    else\n      pnbinom(\n        truncPoint,\n        size = object$theta,\n        mu = mu,\n        lower.tail = FALSE,\n        log.p = TRUE\n      )\n    \n    if (type == \"response\")\n      rval <- exp(log(mu) - ptrunc)\n    if (type == \"count\")\n      rval <- mu\n    if (type == \"zero\")\n      rval <- exp(ptrunc)\n    \n    ## predicted probabilities\n    if (type == \"prob\") {\n      y <-\n        if (!is.null(object$y))\n          object$y\n      else\n        model.response(model.frame(object))\n      yUnique <- 1:max(y)\n      nUnique <- length(yUnique)\n      rval <- matrix(NA, nrow = length(mu), ncol = nUnique)\n      dimnames(rval) <- list(rownames(X), yUnique)\n      \n      if (object$dist == \"poisson\") {\n        for (i in 1:nUnique)\n          rval[, i] <-\n            exp(dpois(yUnique[i], lambda = mu, log = TRUE) - ptrunc)\n      } else {\n        for (i in 1:nUnique)\n          rval[, i] <-\n            exp(dnbinom(\n              yUnique[i],\n              mu = mu,\n              size = object$theta,\n              log = TRUE\n            ) - ptrunc)\n      }\n    }\n    \n    rval\n  }\n\nfitted.zerotrunc <- function(object, ...) {\n  object$fitted.values\n}\n\n\npredprob.zerotrunc <- function(obj, truncPoint, ...) {\n  predict(obj, truncPoint, type = \"prob\", ...)\n}\n\nextractAIC.zerotrunc <-\n  function(fit, scale = NULL, k = 2, ...) {\n    c(attr(logLik(fit), \"df\"), AIC(fit, k = k))\n  }\n\nestfun.zerotrunc <- function(x, truncPoint = 0, ...) {\n  ## extract data\n  Y <- if (is.null(x$y))\n    model.response(model.frame(x))\n  else\n    x$y\n  X <- model.matrix(x)\n  beta <- coef(x)\n  theta <- x$theta\n  offset <- if (is.null(x$offset))\n    0\n  else\n    x$offset\n  wts <- weights(x)\n  if (is.null(wts))\n    wts <- 1\n  \n  ## count component: working residuals\n  eta <- as.vector(X %*% beta + offset)\n  mu <- exp(eta)\n  \n  wres <- as.numeric(Y > 0) * switch(\n    x$dist,\n    \"poisson\" = {\n      (Y - mu) - exp(\n        ppois(0, lambda = mu, log.p = TRUE) -\n          ppois(\n            0,\n            lambda = mu,\n            lower.tail = FALSE,\n            log.p = TRUE\n          ) + eta\n      )\n    },\n    \"geometric\" = {\n      (Y - mu * (Y + 1) / (mu + 1)) - exp(\n        pnbinom(\n          0,\n          mu = mu,\n          size = 1,\n          log.p = TRUE\n        ) -\n          pnbinom(\n            0,\n            mu = mu,\n            size = 1,\n            lower.tail = FALSE,\n            log.p = TRUE\n          ) - log(mu + 1) + eta\n      )\n    },\n    \"negbin\" = {\n      (Y - mu * (Y + theta) / (mu + theta)) - exp(\n        pnbinom(\n          0,\n          mu = mu,\n          size = theta,\n          log.p = TRUE\n        ) -\n          pnbinom(\n            0,\n            mu = mu,\n            size = theta,\n            lower.tail = FALSE,\n            log.p = TRUE\n          ) +\n          log(theta) - log(mu + theta) + eta\n      )\n    },\n    \"negbin-extended\" = {\n      derivation4 <-\n        sapply(seq(0, truncPoint), function(k) {\n          (k - mu * (k + theta) / (mu + theta)) * dnbinom(k, mu = mu, size = theta)\n        })\n      derivation4 <-\n        if (is.null(dim(derivation4))) {\n          sum(derivation4)\n        } else{\n          apply(derivation4, 1, sum)\n        }\n      difflogtrunc4 <-\n        derivation4 / pnbinom(truncPoint,\n                              mu = mu,\n                              size = theta,\n                              lower.tail = FALSE)\n      ((Y - mu * (Y + theta) / (mu + theta)) - difflogtrunc4)\n    }\n  )\n  \n  ## compute gradient from data\n  rval <- cbind(wres * wts * X)\n  colnames(rval) <- names(beta)\n  rownames(rval) <- rownames(X)\n  return(rval)\n}\n\ngetSummary.zerotrunc <- function(obj, alpha = 0.05, ...) {\n  ## extract summary object\n  s <- summary(obj)\n  \n  ## coefficient matrix and confidence interval\n  ## compute confidence interval manually to include Log(theta)\n  cf <- cbind(\n    s$coefficients,\n    s$coefficients[, 1] + qnorm(alpha / 2) * s$coefficients[, 2],\n    s$coefficients[, 1] + qnorm(1 - alpha / 2) * s$coefficients[, 2]\n  )\n  colnames(cf) <- c(\"est\", \"se\", \"stat\", \"p\", \"lwr\", \"upr\")\n  \n  ## further summary statistics\n  sstat <- c(\n    \"theta\" = s$theta,\n    \"N\" = nobs(obj),\n    \"logLik\" = as.vector(logLik(obj)),\n    \"AIC\" = AIC(obj),\n    \"BIC\" = BIC(obj)\n  )\n  \n  ## return everything\n  return(\n    list(\n      coef = cf,\n      sumstat = sstat,\n      contrasts = obj$contrasts,\n      xlevels = obj$levels,\n      call = obj$call\n    )\n  )\n}\n\nsummarySimple.zerotrunc <- function(object, ...)\n{\n  ## pearson residuals\n  #object$residuals <- residuals(object, type = \"pearson\")\n  \n  ## compute z statistics\n  cf <- object$coefficients\n  se <- sqrt(diag(object$vcov))\n  k <- length(cf)\n  \n  if (object$dist == \"negbin\") {\n    cf <- c(cf, \"Log(theta)\" = as.vector(log(object$theta)))\n    se <- c(se, object$SE.logtheta)\n  }\n  zstat <- cf / se\n  pval <- 2 * pnorm(-abs(zstat))\n  #cf <- cbind(cf, se, zstat, pval)\n  len = length(cf)\n  txt <- \"  Variable\\tEstimate\\tStd. Error\\tz value\\tPr(>|z|)\"\n  for (i in 1:len) {\n    txt1 <-\n      paste(paste(\"  \", names(cf)[i], sep = \"\"), cf[i], se[i], zstat[i], pval[i], sep =\n              \"\\t\")\n    txt <- paste(txt, txt1, sep = \"\\n\")\n  }\n  txt1 <- paste(\"  Theta =\", object$theta)\n  txt <- paste(txt, txt1, sep = \"\\n\")\n  txt1 <- paste(\"  Log-likelihood: \", object$loglik)\n  txt <- paste(txt, txt1, sep = \"\\n\")\n  txt1 <- paste(\"  AIC: \", AIC(object))\n  txt <- paste(txt, txt1, sep = \"\\n\")\n  \n  ## number of iterations\n  object$iterations <- tail(na.omit(object$optim$count), 1)\n  txt1 <-\n    paste(\"  Number of iterations in BFGS optimization: \",\n          object$iterations)\n  txt <- paste(txt, txt1, sep = \"\\n\")\n  \n  ## delete some slots\n  object$fitted.values <-\n    object$terms <- object$model <- object$y <-\n    object$x <-\n    object$levels <- object$contrasts <- object$start <- NULL\n  \n  \n  ## return\n  txt\n}\n\n\n# Function to compute residuals for zero-truncated negative binomial regression\nresiduals.zrnbFull <- function(znbr, dfull, truncPoint = 0, type = c(\"deviance\", \"pearson\", \"response\",\"rqr\")) {\n  # Extracting relevant columns from the dataframe\n  X2 <- dfull[, names(znbr$coefficients)[2:length(znbr$coefficients)]]\n  X1 <- rep(1, dim(X2)[1])\n  X <- data.frame(X1, X2)\n  \n  y <- dfull[, 1]\n  wts <- 1\n  \n  # Computing mu\n  X <- data.matrix(X)\n  cf <- matrix(znbr$coefficients, nrow = length(znbr$coefficients), ncol = 1)\n  mu <- exp(X %*% cf)\n  theta <- znbr$theta\n  \n  # Computing p0\n  p0 <- pnbinom(truncPoint, size = theta, mu = mu, lower.tail = FALSE, log.p = TRUE)\n  \n  # Computing yhat and residuals\n  yhat <- exp(log(mu) - p0)\n  res <- (y - yhat)\n  \n  # Switch case for different types of residuals\n  switch(\n    type,\n    \n    \"response\" = {\n      return(res)\n    },\n    \n    \"pearson\" = {\n      p0 <- mu / yhat\n      vv <- (mu + (1 + 1 / theta - 1 / p0) * mu ^ 2) / p0\n      return(res / sqrt(vv))\n    },\n    \n    \"deviance\" = {\n      # Function to compute mu2y\n      mu2y <- function(mu) {\n        derivation3 <- sapply(seq(0, truncPoint), function(i) {\n          (i - mu) * dnbinom(i, mu = mu, size = theta)\n        })\n        derivation3 <- if (is.null(dim(derivation3))) {\n          sum(derivation3)\n        } else{\n          apply(derivation3, 1, sum)\n        }\n        difflogtrunc3 <- derivation3 / ifelse(mu > 0,\n                                              pnbinom(truncPoint, size = theta, mu = mu, lower.tail = FALSE),\n                                              1)\n        mu - difflogtrunc3\n      }\n      # Function to compute y2mu\n      y2mu <- function(y) {\n        yunique <- sort(unique(y))\n        munique <- sapply(yunique, function(z) {\n          f <- function(mu) z - mu2y(mu)\n          ifelse(f(0) * f(z) < 0, uniroot(f, interval = c(0, z))$root, mu)\n        })\n        munique[factor(y, levels = yunique)]\n      }\n      # Function to compute log likelihood\n      ll <- function(mu) {\n        dnbinom(y, size = theta, mu = mu, log = TRUE) -\n          pnbinom(truncPoint, size = theta, mu = mu, lower.tail = FALSE, log.p = TRUE)\n      }\n      # Return deviance residuals\n      return(sqrt(wts) * sign(y - yhat) * sqrt(2 * abs(ll(y2mu(y)) - ll(mu))))\n    },\n    \"rqr\" = {\n      n <- length(y)\n      \n      # \ufffd\ufffd**\ufffd\u001f\ufffdy\u0006\u0003( truncPoint \u0004\ufffd CDF\n      p0 <- pnbinom(truncPoint, size = theta, mu = mu)\n      \n      # \ufffdI*\ufffd\u0006\u0003\ufffd CDF \ufffdp\b\u0011\ufffd\u0016\t\n      cdf_trunc <- function(y_val) {\n        G_y <- pnbinom(y_val, size = theta, mu = mu)\n        cdf <- (G_y - p0) / (1 - p0)\n        cdf[y_val <= truncPoint] <- 0\n        return(cdf)\n      }\n      \n      \n      # \ufffdI*\ufffd\u0006\u0003\ufffd PMF \ufffdp\b\u0011\ufffd\u0016\t\n      pmf_trunc <- function(y_val) {\n        g_y <- dnbinom(y_val, size = theta, mu = mu)\n        pmf <- g_y / (1 - p0)\n        pmf[y_val <= truncPoint] <- 0\n        return(pmf)\n      }\n      \n      # \u001f\u0010@\t u_i\n      u <- runif(n, 0, 1)\n      \n      # \ufffd\ufffd F(y_i - 1) \ufffd p(y_i)\n      F_y_minus1 <- cdf_trunc(y - 1)\n      p_y <- pmf_trunc(y)\n      \n      # \ufffd\ufffd F_star\n      F_star <- F_y_minus1 + u * p_y\n      \n      # n\ufffd F_star ( (0, 1) :\ufffd\n      epsilon <- 1e-10\n      F_star <- pmin(pmax(F_star, epsilon), 1 - epsilon)\n      \n      # \ufffd\ufffd RQR\n      rqr <- qnorm(F_star)\n      \n      return(rqr)\n      \n      \n    }\n  )\n}\n\n\nresiduals.zerotrunc <-\n  function(object,\n           truncPoint = 0,\n           type = c(\"deviance\", \"pearson\", \"response\",\"rqr\"),\n           ...) {\n    type <- match.arg(type)\n    res <- object$residuals\n    wts <- object$weights\n    if (is.null(wts))\n      wts <- 1\n    \n    switch(\n      type,\n      \n      \"response\" = {\n        return(res)\n      },\n      \n      \"pearson\" = {\n        mu <- predict(object, truncPoint = truncPoint, type = \"count\")\n        p0 <- mu / object$fitted.values\n        theta1 <- 1 / object$theta\n        vv <-\n          (mu + (1 + 1 / object$theta - 1 / p0) * mu ^ 2) / p0\n        return(res / sqrt(vv))\n      },\n      \n      \"deviance\" = {\n        yhat <- object$fitted.values\n        y <- yhat + object$residuals / sqrt(wts)\n        \n        mu <-\n          predict(object, type = \"count\", truncPoint = truncPoint)\n        theta <- object$theta\n        \n        if (object$dist == \"poisson\") {\n          mu2y <-\n            function(mu)\n              mu / ifelse(mu > 0, ppois(0, lambda = mu, lower.tail = FALSE), 1)\n          y2mu <- function(y) {\n            yunique <- sort(unique(y))\n            munique <- sapply(yunique,\n                              function(z)\n                                uniroot(function(mu)\n                                  z - mu2y(mu), interval = c(0, z))$root)\n            munique[factor(y, levels = yunique)]\n          }\n          \n          ll <- function(mu) {\n            dpois(y, lambda = mu, log = TRUE) -\n              ppois(0,\n                    lambda = mu,\n                    lower.tail = FALSE,\n                    log.p = TRUE)\n          }\n        } else {\n          mu2y <- function(mu) {\n            derivation3 <-\n              sapply(seq(0, truncPoint), function(i) {\n                (i - mu) * dnbinom(i, mu = mu, size = theta)\n              })\n            \n            derivation3 <- if (is.null(dim(derivation3))) {\n              sum(derivation3)\n            } else{\n              apply(derivation3, 1, sum)\n            }\n            \n            difflogtrunc3 <-\n              derivation3 / ifelse(mu > 0,\n                                   pnbinom(\n                                     truncPoint,\n                                     size = theta,\n                                     mu = mu,\n                                     lower.tail = FALSE\n                                   ),\n                                   1)\n            mu - difflogtrunc3\n          }\n          y2mu <- function(y) {\n            yunique <- sort(unique(y))\n            \n            munique <- sapply(yunique, function(z) {\n              f <- function(mu)\n                z - mu2y(mu)\n              #print(uniroot(f, interval = c(0, z))$root)\n              # ifelse(f(truncPoint) * f(z) < 0, uniroot(f, interval = c(truncPoint, z))$root, mu)\n              ifelse(f(0) * f(z) < 0, uniroot(f, interval = c(0, z))$root, mu)\n            })\n            \n            munique[factor(y, levels = yunique)]\n          }\n          ll <- function(mu) {\n            dnbinom(y,\n                    size = theta,\n                    mu = mu,\n                    log = TRUE) -  pnbinom(\n                      truncPoint,\n                      size = theta,\n                      mu = mu,\n                      lower.tail = FALSE,\n                      log.p = TRUE\n                    )\n          }\n        }\n        \n        return(sqrt(wts) * sign(y - yhat) * sqrt(2 * abs(ll(y2mu(\n          y\n        )) - ll(mu))))\n      },\n      \n      \"rqr\" = {\n                #yhat <- object$fitted.values\n        #y <- yhat + object$residuals / sqrt(wts)\n        y <- object$y\n        mu <- predict(object, type = \"count\", truncPoint = truncPoint)\n        theta <- object$theta\n        n <- length(y)\n        \n        # \ufffd\ufffd**\ufffd\u001f\ufffdy\u0006\u0003( truncPoint \u0004\ufffd CDF\n        p0 <- pnbinom(truncPoint, size = theta, mu = mu)\n        \n        # \ufffdI*\ufffd\u0006\u0003\ufffd CDF \ufffdp\b\u0011\ufffd\u0016\t\n        cdf_trunc <- function(y_val) {\n          G_y <- pnbinom(y_val, size = theta, mu = mu)\n          cdf <- (G_y - p0) / (1 - p0)\n          cdf[y_val <= truncPoint] <- 0\n          return(cdf)\n        }\n        \n        \n        # \ufffdI*\ufffd\u0006\u0003\ufffd PMF \ufffdp\b\u0011\ufffd\u0016\t\n        pmf_trunc <- function(y_val) {\n          g_y <- dnbinom(y_val, size = theta, mu = mu)\n          pmf <- g_y / (1 - p0)\n          pmf[y_val <= truncPoint] <- 0\n          return(pmf)\n        }\n        \n        # \u001f\u0010@\t u_i\n        u <- runif(n, 0, 1)\n        \n        # \ufffd\ufffd F(y_i - 1) \ufffd p(y_i)\n        F_y_minus1 <- cdf_trunc(y - 1)\n        p_y <- pmf_trunc(y)\n        \n        # \ufffd\ufffd F_star\n        F_star <- F_y_minus1 + u * p_y\n        \n        # n\ufffd F_star ( (0, 1) :\ufffd\n        epsilon <- 1e-10\n        F_star <- pmin(pmax(F_star, epsilon), 1 - epsilon)\n        \n        # \ufffd\ufffd RQR\n        rqr <- qnorm(F_star)\n        \n        return(rqr)\n        \n      }\n    )\n  }\n\n\nresiduals.possionFull <-\n  function(possion, dfull, truncPoint = 0) {\n    X <- dfull[, 1:dim(dfull)[2]]\n    X[, 1] <- 1\n    \n    y <- dfull[, 1]\n    \n    wts <- 1\n    \n    X <- data.matrix(X)\n    cf <-\n      matrix(possion$coefficients,\n             nrow = length(possion$coefficients),\n             ncol = 1)\n    mu <- exp(X %*% cf)\n    \n    p0 <-\n      ppois(\n        truncPoint,\n        lambda = mu,\n        lower.tail = FALSE,\n        log.p = TRUE\n      )\n    \n    yhat <- exp(log(mu) - p0)\n    res <- (y - yhat)\n    \n    mu2y <-\n      function(mu)\n        mu / ifelse(mu > 0, ppois(truncPoint, lambda = mu, lower.tail = FALSE), 1)\n    y2mu <- function(y) {\n      yunique <- sort(unique(y))\n      munique <- sapply(yunique,\n                        function(z)\n                          uniroot(function(mu)\n                            z - mu2y(mu), interval = c(0, z))$root)\n      munique[factor(y, levels = yunique)]\n    }\n    ll <- function(mu) {\n      dpois(y, lambda = mu, log = TRUE) -\n        ppois(\n          truncPoint,\n          lambda = mu,\n          lower.tail = FALSE,\n          log.p = TRUE\n        )\n    }\n    \n    return(sqrt(wts) * sign(y - yhat) * sqrt(2 * abs(ll(y2mu(\n      y\n    )) - ll(mu))))\n  }\n\n";
}

