/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.analysis;

import edu.sysu.pmglab.container.indexable.IndexableSet;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.io.text.TextRecord;
import edu.sysu.pmglab.io.text.reader.IHeaderParser;
import edu.sysu.pmglab.io.text.reader.IMetadataParser;
import edu.sysu.pmglab.io.text.reader.Separator;
import edu.sysu.pmglab.io.text.reader.TextReader;
import edu.sysu.pmglab.io.text.writer.IHeaderFormatter;
import edu.sysu.pmglab.io.text.writer.TextWriter;
import edu.sysu.pmglab.kgga.io.ZebraExcelExporter;
import gnu.trove.map.hash.THashMap;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Map;
import jxl.write.WriteException;

public class TNBRegressionResultSet {
    public double scoreBinCut;
    public double freqCut = Double.NaN;
    public int truncationPoint;
    public double MLFC;
    Map<String, double[]> selectedGenes;
    File inputFilePath;
    File outputFilePath;
    int sigGeneNum;
    int geneNumWithHitPaper;
    int hitPaperNum;

    public int getSigGeneNum() {
        return this.sigGeneNum;
    }

    public int getGeneNumWithHitPaper() {
        return this.geneNumWithHitPaper;
    }

    public int getHitPaperNum() {
        return this.hitPaperNum;
    }

    public String toString() {
        return this.outputFilePath + " (SignificantGeneNum: " + this.sigGeneNum + " GeneNumWithHitPaper: " + this.geneNumWithHitPaper + ")";
    }

    public String getInputFilePath() throws IOException {
        return this.inputFilePath.getCanonicalPath();
    }

    public void readData() throws Exception {
        String[] cells;
        String line;
        BufferedReader reader = new BufferedReader(new FileReader(this.inputFilePath));
        String geneStr = "ID";
        String qValueStr = "FDRq";
        int qValueIndex = -1;
        int geneIndex = -1;
        int minGeneNum = 10;
        int maxGeneNum = 20;
        double fdrCut = 0.1;
        this.selectedGenes = new THashMap<String, double[]>();
        while ((line = reader.readLine()) != null && line.startsWith("#")) {
            cells = line.split("\t");
            if (line.startsWith("#MLFC")) {
                this.MLFC = Double.parseDouble(cells[1]);
                continue;
            }
            if (line.startsWith("#scoreBinCut")) {
                this.scoreBinCut = Double.parseDouble(cells[1]);
                continue;
            }
            if (!line.startsWith("#truncationPoint")) continue;
            this.truncationPoint = Integer.parseInt(cells[1]);
        }
        String[] heads = line.split("\t");
        int sigNum = 0;
        for (int i = 0; i < heads.length; ++i) {
            if (heads[i].equals(geneStr)) {
                geneIndex = i;
            } else if (heads[i].equals(qValueStr)) {
                qValueIndex = i;
            }
            if (geneIndex > -1 && qValueIndex > -1) break;
        }
        if (geneIndex < 0 || qValueIndex < 0) {
            if (geneIndex < 0) {
                throw new Exception("Unrecognized column of " + geneStr);
            }
            throw new Exception("Unrecognized column of " + qValueStr);
        }
        int rank = 0;
        StringBuilder sb = new StringBuilder();
        while ((line = reader.readLine()) != null) {
            String[] genes;
            cells = line.split("\t");
            String gene = cells[geneIndex];
            double q = Double.parseDouble(cells[qValueIndex]);
            ++rank;
            if (this.selectedGenes.size() > maxGeneNum) break;
            if (q < fdrCut) {
                if (gene.contains(";")) {
                    for (String geneName : genes = gene.split(";")) {
                        sb.append(geneName);
                        sb.append(" ");
                    }
                    this.selectedGenes.put(sb.substring(0, sb.length() - 1), new double[]{q, rank});
                    sb.delete(0, sb.length());
                } else {
                    this.selectedGenes.put(gene, new double[]{q, rank});
                }
                ++sigNum;
                continue;
            }
            if (this.selectedGenes.size() >= minGeneNum) continue;
            if (gene.contains(";")) {
                for (String geneName : genes = gene.split(";")) {
                    sb.append(geneName);
                    sb.append(" ");
                }
                this.selectedGenes.put(sb.substring(0, sb.length() - 1), new double[]{q, rank});
                sb.delete(0, sb.length());
                continue;
            }
            this.selectedGenes.put(gene, new double[]{q, rank});
        }
        this.sigGeneNum = sigNum;
        reader.close();
    }

    public void countHitPaper(Map<String, String[]> genePubMedIDMap) {
        this.geneNumWithHitPaper = 0;
        this.hitPaperNum = 0;
        int minHit = 1;
        for (Map.Entry<String, double[]> entry : this.selectedGenes.entrySet()) {
            String[] ids = genePubMedIDMap.get(entry.getKey());
            if (ids == null || ids.length <= minHit) continue;
            ++this.geneNumWithHitPaper;
            this.hitPaperNum += ids.length;
        }
    }

    public TNBRegressionResultSet(File inputFilePath, File outputFilePath) {
        this.inputFilePath = inputFilePath;
        this.outputFilePath = outputFilePath;
    }

    public void setSelectedGenes(Map<String, double[]> selectedGenes) {
        this.selectedGenes = selectedGenes;
    }

    public Map<String, double[]> getSelectedGenes() {
        return this.selectedGenes;
    }

    public void setSigGeneNum(int sigGeneNum) {
        this.sigGeneNum = sigGeneNum;
    }

    public void appendOneColumn2TextFile(String colNames, Map<String, String[]> genePubMedIDMap) throws IOException {
        TextRecord input;
        TextReader reader = TextReader.setInput(this.inputFilePath).setHeaderParser(IHeaderParser.beginWith("ID", false)).setMetadataParser(IMetadataParser.BEGIN_WITH_1_NUMBER_SIGN).setSeparator(Separator.TAB).instance();
        TextWriter writer = TextWriter.setOutput(this.outputFilePath).setHeaderFormatter(IHeaderFormatter.DIRECTLY).addFields(reader.getHeader()).addField("PubMedIDs").instance();
        TextRecord output = writer.getRecord();
        int lastIndex = output.size() - 1;
        while ((input = reader.read()) != null) {
            for (int i = 0; i < input.size(); ++i) {
                output.set(i, input.get(i));
            }
            String[] ids = genePubMedIDMap.get(output.get(0).toString());
            if (ids != null) {
                output.set(lastIndex, List.wrap(ids).toString(","));
            } else {
                output.set(lastIndex, ".");
            }
            writer.write(output);
        }
        writer.close();
        reader.close();
    }

    public void appendOneColumn2ExcelFile(String colNames, Map<String, String[]> genePubMedIDMap) throws IOException, WriteException {
        TextRecord input;
        TextReader reader = TextReader.setInput(this.inputFilePath).setHeaderParser(IHeaderParser.beginWith("ID", false)).setMetadataParser(IMetadataParser.BEGIN_WITH_1_NUMBER_SIGN).setSeparator(Separator.TAB).instance();
        List<String[]> dataSheet = new List<String[]>();
        IndexableSet<String> head = reader.getHeader();
        int size = head.size();
        String[] cells = new String[size + 1];
        head.toArray(cells);
        cells[size] = "PubMedIDs";
        dataSheet.add(cells);
        while ((input = reader.read()) != null) {
            cells = new String[size + 1];
            for (int colIndex = 0; colIndex < size; ++colIndex) {
                cells[colIndex] = input.get(colIndex).toString();
            }
            String[] ids = genePubMedIDMap.get(input.get(0).toString());
            cells[size] = ids != null ? List.wrap(ids).toString(",") : ".";
            dataSheet.add(cells);
        }
        reader.close();
        ZebraExcelExporter excelExporter = new ZebraExcelExporter();
        excelExporter.exportToExcel(dataSheet, this.outputFilePath, true);
    }
}

