/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.annotation;

import edu.sysu.pmglab.bytecode.Bytes;
import edu.sysu.pmglab.ccf.type.FieldType;

public class GeneFeature
implements Comparable<GeneFeature> {
    public short dbID;
    byte typeID = (byte)17;
    byte secondTypeID = (byte)-1;
    int geneSymbolID = -1;
    int geneID = -1;
    int transcriptID = -1;
    String sequencePos;
    short exonNum;
    short subRegionID;
    public int pos2CondingEnd = -1;
    public int relativeCodingStartPos = -1;
    public int relativeExonStartPos = -1;
    public int cutCodingLen = 0;
    int offset5P;
    int offset3P;

    public int getGeneSymbolID() {
        return this.geneSymbolID;
    }

    public int getGeneID() {
        return this.geneID;
    }

    public int getTranscriptID() {
        return this.transcriptID;
    }

    public String getSequencePos() {
        return this.sequencePos;
    }

    public short getExonNum() {
        return this.exonNum;
    }

    public short getSubRegionID() {
        return this.subRegionID;
    }

    public byte getTypeID() {
        return this.typeID;
    }

    public GeneFeature() {
    }

    public GeneFeature(byte typeID, byte secondTypeID, int offset5P, int offset3P, short exonNum, int geneSymbolID, int geneID, int transcriptID, String sequencePos, short subRegionID) {
        this.typeID = typeID;
        this.secondTypeID = secondTypeID;
        this.offset5P = offset5P;
        this.offset3P = offset3P;
        this.exonNum = exonNum;
        this.geneSymbolID = geneSymbolID;
        this.geneID = geneID;
        this.transcriptID = transcriptID;
        this.sequencePos = sequencePos;
        this.subRegionID = subRegionID;
    }

    public GeneFeature(byte typeID, byte secondTypeID, int offset5P, int offset3P, short exonNum, int geneSymbolID, int geneID, int transcriptID, String sequencePos, short subRegionID, int relativeCodingStartPos) {
        this.typeID = typeID;
        this.secondTypeID = secondTypeID;
        this.offset5P = offset5P;
        this.offset3P = offset3P;
        this.exonNum = exonNum;
        this.geneSymbolID = geneSymbolID;
        this.geneID = geneID;
        this.transcriptID = transcriptID;
        this.sequencePos = sequencePos;
        this.subRegionID = subRegionID;
        this.relativeCodingStartPos = relativeCodingStartPos;
    }

    public Bytes[] encode() {
        if (this.geneSymbolID < 0) {
            return new Bytes[0];
        }
        Bytes[] encodedSequence = new Bytes[]{FieldType.varInt32.encode(this.geneSymbolID), FieldType.varInt32.encode(this.geneID), FieldType.varInt32.encode(this.transcriptID), new Bytes(this.sequencePos), FieldType.int16.encode(this.exonNum), FieldType.int16.encode(this.subRegionID), FieldType.int8.encode(this.typeID), FieldType.int8.encode(this.secondTypeID)};
        return encodedSequence;
    }

    public GeneFeature(byte id, short exonID, int relativeExonStartPos, int relativeCodingStartPos, int dis) {
        this.typeID = id;
        this.pos2CondingEnd = dis;
        this.relativeExonStartPos = relativeExonStartPos;
        this.relativeCodingStartPos = relativeCodingStartPos;
        this.subRegionID = exonID;
    }

    public byte getSecondTypeID() {
        return this.secondTypeID;
    }

    public String toString() {
        if (this.geneSymbolID < 0) {
            return ".";
        }
        return "TBD";
    }

    @Override
    public int compareTo(GeneFeature o) {
        return this.typeID - o.typeID;
    }
}

