/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.annotation;

import cern.jet.random.Normal;
import cern.jet.stat.Probability;
import edu.sysu.pmglab.ccf.field.FieldGroupMetas;
import edu.sysu.pmglab.ccf.field.FieldMeta;
import edu.sysu.pmglab.ccf.field.IFieldCollection;
import edu.sysu.pmglab.ccf.toolkit.annotator.Database;
import edu.sysu.pmglab.ccf.toolkit.annotator.GTBDatabase;
import edu.sysu.pmglab.container.indexable.IndexableSet;
import edu.sysu.pmglab.container.indexable.LinkedSet;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.gtb.GTBManager;
import edu.sysu.pmglab.gtb.GTBReaderOption;
import edu.sysu.pmglab.gtb.genome.Variant;
import edu.sysu.pmglab.kgga.command.SetupApplication;
import java.io.IOException;
import java.util.Set;

public class GwasSumDatabase
extends Database<Variant, Variant> {
    final GTBReaderOption option;
    final FieldMeta[] afField;
    final FieldMeta[] betaField;
    final FieldMeta[] seField;
    final IFieldCollection fields;
    int betaType = 0;
    boolean hasBeta = false;
    boolean hasSE = false;
    boolean hasAFreq = false;
    boolean transform = true;
    double lp;
    double k0;
    double phi0;
    final long totalRecordNum;
    final String dbName;
    final IndexableSet<String> allPFieldNames;

    private double logisticFun(double x) {
        double y = Math.exp(-x);
        return 1.0 / (1.0 + y);
    }

    @Override
    public String getDatabaseName() {
        return this.dbName;
    }

    public GwasSumDatabase(GTBManager database, List<String> groupNames, int isORBeta, double prevalence, String dbName, Set<String> conservedGroupNames) throws IOException {
        database.getIndexer(true, null);
        this.option = new GTBReaderOption(database, false, true);
        this.totalRecordNum = database.numOfVariants();
        this.dbName = dbName;
        int num = groupNames.size();
        this.afField = new FieldMeta[num];
        this.betaField = new FieldMeta[num];
        this.seField = new FieldMeta[num];
        FieldGroupMetas fieldMetas = new FieldGroupMetas();
        for (int i = 0; i < num; ++i) {
            this.afField[i] = this.option.getField(groupNames.get(i) + "@A1F");
            this.betaField[i] = this.option.getField(groupNames.get(i) + "@Beta");
            this.seField[i] = this.option.getField(groupNames.get(i) + "@SE");
        }
        IFieldCollection allFieldsInGWAS = database.getAllFields();
        this.allPFieldNames = new LinkedSet<String>();
        for (FieldMeta fieldMeta : allFieldsInGWAS) {
            if (conservedGroupNames.contains(fieldMeta.groupName())) continue;
            fieldMetas.addField(fieldMeta);
            if (fieldMeta.fullName().endsWith("@P")) {
                this.allPFieldNames.add(fieldMeta.fullName());
                continue;
            }
            if (fieldMeta.fullName().endsWith("@SE")) {
                this.hasSE = true;
                continue;
            }
            if (fieldMeta.fullName().endsWith("@Beta")) {
                this.hasBeta = true;
                continue;
            }
            if (!fieldMeta.fullName().endsWith("@A1F")) continue;
            this.hasAFreq = true;
        }
        this.fields = fieldMetas.asUnmodifiable();
        this.betaType = isORBeta;
        if (isORBeta > 0) {
            this.lp = Math.log(prevalence / (1.0 - prevalence));
            this.k0 = Probability.normalInverse(prevalence);
            Normal norm = new Normal(0.0, 1.0, null);
            this.k0 = prevalence * (1.0 - prevalence) / norm.pdf(this.k0);
            this.phi0 = this.logisticFun(this.lp);
            this.phi0 = Probability.normalInverse(this.phi0);
        }
    }

    @Override
    public IFieldCollection getAllFields() {
        return this.fields;
    }

    @Override
    public boolean annotate(List<Variant> resourceVariants, long p, Variant targetVariant) {
        float gwasAltFrq = 0.0f;
        boolean flipByFreq = false;
        if (resourceVariants == null || resourceVariants.isEmpty()) {
            return false;
        }
        if (resourceVariants.size() > 1) {
            int size = resourceVariants.size();
            Variant mostSigVar = resourceVariants.fastGet(0);
            for (int i = 1; i < size; ++i) {
                Variant tmpVar = resourceVariants.fastGet(i);
                int count = 0;
                for (String pFieldName : this.allPFieldNames) {
                    double p0 = (Double)mostSigVar.getProperty(pFieldName);
                    double p1 = (Double)tmpVar.getProperty(pFieldName);
                    if (!(p1 < p0)) continue;
                    ++count;
                }
                if (count <= this.allPFieldNames.size() - count) continue;
                mostSigVar = tmpVar;
            }
            resourceVariants.clear();
            resourceVariants.add(mostSigVar);
        }
        boolean isMatched = false;
        double beta = 0.0;
        for (int i = 0; i < this.afField.length; ++i) {
            for (Variant gwasVariant : resourceVariants) {
                float refAltFreq;
                boolean hasGwasAltFrq = this.afField[i] != null;
                flipByFreq = false;
                if (hasGwasAltFrq) {
                    int refHomNum = (Integer)targetVariant.getProperty("GTYSUM@RefHomGtyNum_ALL");
                    int hetNum = (Integer)targetVariant.getProperty("GTYSUM@HetGtyNum_ALL");
                    int altHomNum = (Integer)targetVariant.getProperty("GTYSUM@AltHomGtyNum_ALL");
                    refAltFreq = (float)(((double)altHomNum + (double)hetNum * 0.5) / (double)(altHomNum + hetNum + refHomNum));
                    gwasAltFrq = ((Float)gwasVariant.getProperty(this.afField[i].fullName())).floatValue();
                    boolean bl = hasGwasAltFrq = !Double.isNaN(gwasAltFrq);
                    if ((double)Math.abs(refAltFreq - gwasAltFrq) > 0.2) {
                        flipByFreq = true;
                    }
                }
                isMatched = false;
                if (this.hasBeta && gwasVariant.numOfAlleles() == 2) {
                    beta = (Double)gwasVariant.getProperty(this.betaField[i].fullName());
                    if (gwasVariant.alleleOfIndex(0).charAt(0) == '.') {
                        if (gwasVariant.alleleOfIndex(1).equals(targetVariant.alleleOfIndex(1))) {
                            if (hasGwasAltFrq && flipByFreq && !Double.isNaN(beta)) {
                                beta = this.betaType == 2 ? 1.0 / beta : -beta;
                            }
                            isMatched = true;
                        }
                    } else if (gwasVariant.alleleOfIndex(1).startsWith(".")) {
                        if (gwasVariant.alleleOfIndex(0).equals(targetVariant.alleleOfIndex(0))) {
                            if (hasGwasAltFrq && flipByFreq && !Double.isNaN(beta)) {
                                beta = this.betaType == 2 ? 1.0 / beta : -beta;
                            }
                            isMatched = true;
                        }
                    } else if (gwasVariant.alleleOfIndex(0).equals(targetVariant.alleleOfIndex(0))) {
                        if (gwasVariant.alleleOfIndex(1).equals(targetVariant.alleleOfIndex(1))) {
                            if (hasGwasAltFrq && flipByFreq && !Double.isNaN(beta)) {
                                beta = this.betaType == 2 ? 1.0 / beta : -beta;
                            }
                            isMatched = true;
                        }
                    } else if (gwasVariant.alleleOfIndex(0).equals(targetVariant.alleleOfIndex(1)) && gwasVariant.alleleOfIndex(1).equals(targetVariant.alleleOfIndex(0))) {
                        if (!(hasGwasAltFrq && !flipByFreq || Double.isNaN(beta))) {
                            beta = this.betaType == 2 ? 1.0 / beta : -beta;
                        }
                        isMatched = true;
                    }
                } else {
                    isMatched = true;
                }
                if (!isMatched) continue;
                for (FieldMeta field : this.getAllFields()) {
                    targetVariant.setProperty(field.fullName(), gwasVariant.getProperty(field.fullName()));
                }
                if (!this.hasBeta) continue;
                targetVariant.setProperty(this.betaField[i].fullName(), beta);
                if (!this.transform || this.betaType <= 0) continue;
                beta = (Double)targetVariant.getProperty(this.betaField[i].fullName());
                double betaD = this.betaType == 2 ? Math.log(beta) : beta;
                refAltFreq = 1.0f;
                betaD = (double)refAltFreq * betaD;
                betaD = this.logisticFun(betaD + this.lp);
                try {
                    betaD = Probability.normalInverse(betaD) - this.phi0;
                }
                catch (Exception e) {
                    return false;
                }
                targetVariant.setProperty(this.betaField[i].fullName(), betaD);
                if (!this.hasSE) continue;
                double se = (Double)targetVariant.getProperty(this.seField[i].fullName());
                double seD = this.betaType == 2 ? se / beta : se;
                seD = (double)refAltFreq * seD;
                seD = this.k0 * seD;
                targetVariant.setProperty(this.seField[i].fullName(), seD);
            }
        }
        return true;
    }

    @Override
    public Reader instance() throws IOException {
        return new Reader(this, this.option);
    }

    public static class Reader
    extends GTBDatabase.Reader {
        long hitRecordNum = 0L;
        long totalRecordNum = 0L;

        public Reader(Database<Variant, Variant> database, GTBReaderOption option) throws IOException {
            super(database, option);
        }

        @Override
        public boolean annotate(long pointer, Variant variant) throws IOException {
            ++this.totalRecordNum;
            List<Variant> finds = this.find(pointer, variant);
            if (finds != null && !finds.isEmpty()) {
                ++this.hitRecordNum;
            }
            return this.database.annotate(finds, pointer, variant);
        }

        @Override
        public void close() throws IOException {
            super.close();
            if (this.totalRecordNum > 1000L) {
                double hitRatio = (double)this.hitRecordNum / (double)this.totalRecordNum;
                if ((hitRatio *= 100.0) < 0.5) {
                    SetupApplication.GlobalLogger.warn("Only {}% variants in the {} are available int your reference variants! Please ensure the refG are correctly specified", (Object)hitRatio, (Object)this.database.getDatabaseName());
                }
            }
        }
    }
}

