/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.annotation;

import edu.sysu.pmglab.annotation.CodonTable;
import edu.sysu.pmglab.annotation.GeneFeature;
import edu.sysu.pmglab.annotation.GeneSubRegion;
import edu.sysu.pmglab.annotation.SeqSegment;
import edu.sysu.pmglab.annotation.VarGeneFeatureType;
import edu.sysu.pmglab.container.intervaltree.inttree.IntIntervalTree;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.gtb.genome.Variant;
import edu.sysu.pmglab.progressbar.ProgressBar;
import gnu.trove.set.TIntSet;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Transcript
extends SeqSegment {
    private final Logger logger = LoggerFactory.getLogger("Reference Transcript Gene Feature");
    private char strand = (char)48;
    private String refID;
    private int refIDIndex;
    private String mRnaSequence;
    public List<SeqSegment> exons;
    public int codingStart;
    public int codingEnd;
    boolean noCodingExon = true;
    short exonNum = 0;
    int codingStartRelativeSiteInSequence = -1;
    int codingStartSiteExonID = 0;
    int codingEndSiteExonID = 0;
    List<Integer> intronLength = new List();
    String uniprotID = null;
    String geneSymb = null;
    int geneSymbIndex = -1;
    int geneIDIndex = -1;
    String geneID;
    int[] delSites;
    int[] insSites;
    String delSeq;
    String insSeq;
    boolean multipleMapping = false;
    int codingStartR;
    int codingEndR;
    public IntIntervalTree<GeneSubRegion> exonIntronUDStreamTree = null;
    private final Set<Character> seqSet = new HashSet<Character>(){
        {
            this.add(Character.valueOf('A'));
            this.add(Character.valueOf('T'));
            this.add(Character.valueOf('G'));
            this.add(Character.valueOf('C'));
            this.add(Character.valueOf('a'));
            this.add(Character.valueOf('t'));
            this.add(Character.valueOf('g'));
            this.add(Character.valueOf('c'));
        }
    };

    public String getDelSeq() {
        return this.delSeq;
    }

    public void setDelSeq(String delSeq) {
        this.delSeq = delSeq;
    }

    public String getInsSeq() {
        return this.insSeq;
    }

    public void setInsSeq(String insSeq) {
        this.insSeq = insSeq;
    }

    public boolean isMultipleMapping() {
        return this.multipleMapping;
    }

    public void setMultipleMapping(boolean multipleMapping) {
        this.multipleMapping = multipleMapping;
    }

    public String getGeneSymb() {
        return this.geneSymb;
    }

    public int[] getDelSites() {
        return this.delSites;
    }

    public int[] getInsSites() {
        return this.insSites;
    }

    public void setInsSites(int[] insSites) {
        this.insSites = insSites;
    }

    public void setDelSites(int[] delSites) {
        this.delSites = delSites;
    }

    public int getExonNum() {
        return this.exonNum;
    }

    public void setExonNum(short exonNum) {
        this.exonNum = exonNum;
    }

    public List<SeqSegment> getExons() {
        return this.exons;
    }

    public void setExons(List<SeqSegment> exons) {
        this.exons = exons;
    }

    public void setGeneSymb(String geneSymb) {
        this.geneSymb = geneSymb;
    }

    public void setGeneSymbIndex(int geneSymbIndex) {
        this.geneSymbIndex = geneSymbIndex;
    }

    public void setGeneIDIndex(int geneIDIndex) {
        this.geneIDIndex = geneIDIndex;
    }

    public void setGeneID(String geneID) {
        this.geneID = geneID;
    }

    public void setUniprotID(String uniprotID) {
        this.uniprotID = uniprotID;
    }

    public int getCodingEnd() {
        return this.codingEnd;
    }

    public int getCodingStart() {
        return this.codingStart;
    }

    public void setmRnaSequenceStart(int mRnaSequenceStart) {
    }

    public void setmRnaSequence(String mRnaSequence) {
        this.mRnaSequence = mRnaSequence;
    }

    public Transcript(String refID, int start, int end) {
        super(start, end);
        this.refID = refID;
        this.exons = new List();
    }

    public String getRefID() {
        return this.refID;
    }

    public void setRefID(String refID) {
        this.refID = refID;
    }

    public Transcript(String refID, int start, int end, int codingStart, int codingEnd) {
        super(start, end);
        this.refID = refID;
        this.codingStart = codingStart;
        this.codingEnd = codingEnd;
        this.exons = new List();
        if (codingStart != codingEnd) {
            this.noCodingExon = false;
        }
    }

    public Transcript(String refID, int refIDIndex, char strand, int start, int end, int codingStart, int codingEnd, List<SeqSegment> exons) {
        super(start, end);
        this.refID = refID;
        this.refIDIndex = refIDIndex;
        this.codingStart = codingStart;
        this.codingEnd = codingEnd;
        if (codingStart != codingEnd) {
            this.noCodingExon = false;
        }
        this.exons = exons;
        this.strand = strand;
        this.exonNum = (short)exons.size();
        if (codingStart != codingEnd) {
            this.noCodingExon = false;
        }
    }

    public char getStrand() {
        return this.strand;
    }

    public void setStrand(char strand) {
        this.strand = strand;
    }

    public void addExon(SeqSegment exon) {
        this.exons.add(exon);
        this.exonNum = (short)(this.exonNum + 1);
    }

    public void generateIntervalTree(int upstreamExt, int downstreamExt) throws Exception {
        int i;
        List<Integer> effectiveSites;
        if (this.exons == null || this.exons.isEmpty()) {
            return;
        }
        int accumIntronLen = 0;
        int relativeCodingStartPos = 0;
        int relativeExonStartPos = 0;
        IntIntervalTree.Builder<GeneSubRegion> exonIntronUDStreamTreeBuilder = new IntIntervalTree.Builder<GeneSubRegion>();
        boolean hasUpdatedExonIntronUDStreamTreeBuilder = false;
        switch (this.strand) {
            case '+': {
                GeneSubRegion fr2;
                int j;
                int i2;
                List<GeneSubRegion> locatedRegions;
                GeneSubRegion fr1;
                int i3;
                SeqSegment exon = this.exons.get(0);
                if (this.codingStart >= exon.start && this.codingStart <= exon.end) {
                    this.codingStartRelativeSiteInSequence = this.codingStart - exon.start;
                    this.codingStartSiteExonID = 0;
                }
                if (this.codingEnd >= exon.start && this.codingEnd <= exon.end) {
                    this.codingEndSiteExonID = 0;
                }
                accumIntronLen = 0;
                for (i3 = 1; i3 < this.exonNum; ++i3) {
                    exon = this.exons.get(i3);
                    this.intronLength.add(this.exons.get((int)i3).start - this.exons.get((int)(i3 - 1)).end);
                    accumIntronLen += this.intronLength.get(i3 - 1).intValue();
                    if (this.codingStart >= exon.start && this.codingStart <= exon.end) {
                        this.codingStartRelativeSiteInSequence = this.codingStart - this.exons.get((int)0).start - accumIntronLen;
                        this.codingStartSiteExonID = i3;
                    }
                    if (this.codingEnd < exon.start || this.codingEnd > exon.end) continue;
                    this.codingEndSiteExonID = i3;
                }
                boolean toPrint = false;
                int base = 1;
                for (int i4 = 0; i4 < this.exonNum; ++i4) {
                    fr1 = new GeneSubRegion(1, (short)(i4 + 1), this.exons.get((int)i4).start + base, this.exons.get((int)i4).end);
                    if (toPrint) {
                        System.out.println(fr1.toString());
                    }
                    exonIntronUDStreamTreeBuilder.add(fr1.start, fr1.end, fr1);
                    hasUpdatedExonIntronUDStreamTreeBuilder = true;
                    fr1.setRelativeExonStartPos(relativeExonStartPos);
                    relativeExonStartPos += fr1.end - fr1.start + 1;
                }
                if (hasUpdatedExonIntronUDStreamTreeBuilder) {
                    this.exonIntronUDStreamTree = exonIntronUDStreamTreeBuilder.build();
                    hasUpdatedExonIntronUDStreamTreeBuilder = false;
                }
                if (!(locatedRegions = this.exonIntronUDStreamTree.getContains(this.codingStart)).isEmpty()) {
                    this.codingStartSiteExonID = locatedRegions.get((int)0).index - 1;
                }
                if (!(locatedRegions = this.exonIntronUDStreamTree.getContains(this.codingEnd)).isEmpty()) {
                    this.codingEndSiteExonID = locatedRegions.get((int)0).index - 1;
                }
                if (this.codingStartSiteExonID >= 0) {
                    for (i2 = 0; i2 < this.exonNum; ++i2) {
                        locatedRegions = this.exonIntronUDStreamTree.getContains(this.exons.get((int)i2).start + base, this.exons.get((int)i2).end);
                        if (locatedRegions.size() > 1) {
                            this.logger.error("Duplicated exon [" + this.exons.get((int)i2).start + "," + (this.exons.get((int)i2).end - base) + " in " + this.refID);
                        }
                        fr1 = locatedRegions.get(0);
                        relativeCodingStartPos = 0;
                        if (i2 < this.codingStartSiteExonID) {
                            for (j = i2; j < this.codingStartSiteExonID; ++j) {
                                relativeCodingStartPos += this.exons.get((int)j).end - this.exons.get((int)j).start;
                            }
                            relativeCodingStartPos += this.codingStart - this.exons.get((int)this.codingStartSiteExonID).start;
                            relativeCodingStartPos = -relativeCodingStartPos;
                        } else {
                            for (j = this.codingStartSiteExonID; j < i2; ++j) {
                                relativeCodingStartPos += this.exons.get((int)j).end - this.exons.get((int)j).start;
                            }
                            relativeCodingStartPos -= this.codingStart - this.exons.get((int)this.codingStartSiteExonID).start;
                        }
                        fr1.setRelativeCodingStartPos(relativeCodingStartPos);
                    }
                }
                for (i2 = 1; i2 < this.exonNum; ++i2) {
                    fr1 = new GeneSubRegion(2, (short)i2, this.exons.get((int)(i2 - 1)).end + base, this.exons.get((int)i2).start);
                    if (toPrint) {
                        System.out.println(fr1.toString());
                    }
                    if (fr1.start > fr1.end) continue;
                    exonIntronUDStreamTreeBuilder.add(fr1.start, fr1.end, fr1);
                    hasUpdatedExonIntronUDStreamTreeBuilder = true;
                }
                if (hasUpdatedExonIntronUDStreamTreeBuilder) {
                    this.exonIntronUDStreamTree = exonIntronUDStreamTreeBuilder.build();
                    hasUpdatedExonIntronUDStreamTreeBuilder = false;
                }
                for (i2 = 1; i2 < this.exonNum; ++i2) {
                    locatedRegions = this.exonIntronUDStreamTree.getContains(this.exons.get((int)(i2 - 1)).end + base, this.exons.get((int)i2).start);
                    if (locatedRegions.size() > 1) {
                        this.logger.error("Duplicated inton [" + this.exons.get((int)(i2 - 1)).end + "," + (this.exons.get((int)i2).start - base) + " in " + this.refID);
                    }
                    if (locatedRegions.isEmpty()) continue;
                    fr1 = locatedRegions.get(0);
                    locatedRegions = this.exonIntronUDStreamTree.getContains(this.exons.get((int)i2).start + base, this.exons.get((int)i2).end);
                    fr2 = locatedRegions.get(0);
                    fr1.setRelativeCodingStartPos(fr2.relativeCodingStartPos);
                    fr1.setRelativeExonStartPos(fr2.relativeExonStartPos);
                }
                locatedRegions = this.exonIntronUDStreamTree.getContains(this.exons.get((int)0).start + base, this.exons.get((int)0).end);
                fr2 = locatedRegions.get(0);
                fr1 = new GeneSubRegion(0, -1, this.exons.get((int)0).start - upstreamExt, this.exons.get((int)0).start);
                exonIntronUDStreamTreeBuilder.add(fr1.start, fr1.end, fr1);
                fr1.setRelativeCodingStartPos(fr2.relativeCodingStartPos);
                fr1.setRelativeExonStartPos(0);
                locatedRegions = this.exonIntronUDStreamTree.getContains(this.exons.get((int)(this.exons.size() - 1)).start + base, this.exons.get((int)(this.exons.size() - 1)).end);
                fr2 = locatedRegions.get(0);
                fr1 = new GeneSubRegion(3, -1, this.exons.get((int)(this.exons.size() - 1)).end + base, this.exons.get((int)(this.exons.size() - 1)).end + base + downstreamExt);
                exonIntronUDStreamTreeBuilder.add(fr1.start, fr1.end, fr1);
                fr1.setRelativeExonStartPos(fr2.relativeExonStartPos + fr2.end - fr2.start);
                break;
            }
            case '-': {
                GeneSubRegion fr2;
                int j;
                int i2;
                List<GeneSubRegion> locatedRegions;
                GeneSubRegion fr1;
                int i3;
                SeqSegment exon = this.exons.get(this.exonNum - 1);
                if (this.codingEnd >= exon.start && this.codingEnd <= exon.end) {
                    this.codingStartRelativeSiteInSequence = exon.end - this.codingEnd;
                    this.codingStartSiteExonID = this.exonNum - 1;
                }
                if (this.codingStart >= exon.start && this.codingStart <= exon.end) {
                    this.codingEndSiteExonID = this.exonNum - 1;
                }
                accumIntronLen = 0;
                for (i3 = this.exonNum - 2; i3 >= 0; --i3) {
                    exon = this.exons.get(i3);
                    accumIntronLen += this.exons.get((int)(i3 + 1)).start - this.exons.get((int)i3).end;
                    if (this.codingEnd >= exon.start && this.codingEnd <= exon.end) {
                        this.codingStartRelativeSiteInSequence = this.exons.get((int)(this.exonNum - 1)).end - this.codingEnd - accumIntronLen;
                        this.codingStartSiteExonID = i3;
                    }
                    if (this.codingStart < exon.start || this.codingStart > exon.end) continue;
                    this.codingEndSiteExonID = i3;
                }
                for (i3 = 1; i3 < this.exonNum; ++i3) {
                    this.intronLength.add(this.exons.get((int)i3).start - this.exons.get((int)(i3 - 1)).end);
                }
                this.codingStartR = this.codingEnd;
                this.codingEndR = this.codingStart;
                relativeCodingStartPos = 0;
                relativeExonStartPos = 0;
                int base = 1;
                boolean toPrint = false;
                for (int i5 = this.exonNum - 1; i5 >= 0; --i5) {
                    fr1 = new GeneSubRegion(1, (short)(this.exonNum - i5), this.exons.get((int)i5).start + base, this.exons.get((int)i5).end);
                    if (toPrint) {
                        System.out.println(fr1.toString());
                    }
                    exonIntronUDStreamTreeBuilder.add(fr1.start, fr1.end, fr1);
                    hasUpdatedExonIntronUDStreamTreeBuilder = true;
                    fr1.setRelativeExonStartPos(relativeExonStartPos);
                    relativeExonStartPos += fr1.end - fr1.start + 1;
                }
                if (hasUpdatedExonIntronUDStreamTreeBuilder) {
                    this.exonIntronUDStreamTree = exonIntronUDStreamTreeBuilder.build();
                    hasUpdatedExonIntronUDStreamTreeBuilder = false;
                }
                if (!(locatedRegions = this.exonIntronUDStreamTree.getContains(this.codingStartR)).isEmpty()) {
                    this.codingStartSiteExonID = this.exonNum - locatedRegions.get((int)0).index;
                }
                if (!(locatedRegions = this.exonIntronUDStreamTree.getContains(this.codingEndR)).isEmpty()) {
                    this.codingEndSiteExonID = this.exonNum - locatedRegions.get((int)0).index;
                }
                if (this.codingStartSiteExonID >= 0) {
                    for (i2 = this.exonNum - 1; i2 >= 0; --i2) {
                        locatedRegions = this.exonIntronUDStreamTree.getContains(this.exons.get((int)i2).start + base, this.exons.get((int)i2).end);
                        if (locatedRegions.size() > 1) {
                            this.logger.error("Duplicated exon [" + this.exons.get((int)i2).start + "," + (this.exons.get((int)i2).end - base) + " in " + this.refID);
                        }
                        fr1 = locatedRegions.get(0);
                        relativeCodingStartPos = 0;
                        if (i2 > this.codingStartSiteExonID) {
                            for (j = this.exonNum - 1; j > i2; --j) {
                                relativeCodingStartPos += this.exons.get((int)j).end - this.exons.get((int)j).start;
                            }
                            relativeCodingStartPos += this.exons.get((int)this.codingStartSiteExonID).end - this.codingStartR;
                            relativeCodingStartPos = -relativeCodingStartPos;
                        } else {
                            for (j = i2 + 1; j <= this.codingStartSiteExonID; ++j) {
                                relativeCodingStartPos += this.exons.get((int)j).end - this.exons.get((int)j).start;
                            }
                            relativeCodingStartPos -= this.exons.get((int)this.codingStartSiteExonID).end - this.codingStartR;
                        }
                        fr1.setRelativeCodingStartPos(relativeCodingStartPos);
                    }
                }
                for (i2 = this.exonNum - 1; i2 > 0; --i2) {
                    fr1 = new GeneSubRegion(2, (short)(this.exonNum - i2), this.exons.get((int)(i2 - 1)).end + base, this.exons.get((int)i2).start);
                    if (toPrint) {
                        System.out.println(fr1.toString());
                    }
                    if (fr1.start > fr1.end) continue;
                    exonIntronUDStreamTreeBuilder.add(fr1.start, fr1.end, fr1);
                    hasUpdatedExonIntronUDStreamTreeBuilder = true;
                }
                if (hasUpdatedExonIntronUDStreamTreeBuilder) {
                    this.exonIntronUDStreamTree = exonIntronUDStreamTreeBuilder.build();
                    hasUpdatedExonIntronUDStreamTreeBuilder = false;
                }
                for (i2 = this.exonNum - 1; i2 > 0; --i2) {
                    locatedRegions = this.exonIntronUDStreamTree.getContains(this.exons.get((int)(i2 - 1)).end + base, this.exons.get((int)i2).start);
                    if (locatedRegions.size() > 1) {
                        this.logger.error("Duplicated inton [" + this.exons.get((int)(i2 - 1)).end + "," + (this.exons.get((int)i2).start - base) + " in " + this.refID);
                    }
                    if (locatedRegions.isEmpty()) continue;
                    fr1 = locatedRegions.get(0);
                    locatedRegions = this.exonIntronUDStreamTree.getContains(this.exons.get((int)(i2 - 1)).start + base, this.exons.get((int)(i2 - 1)).end);
                    fr2 = locatedRegions.get(0);
                    fr1.setRelativeCodingStartPos(fr2.relativeCodingStartPos);
                    fr1.setRelativeExonStartPos(fr2.relativeExonStartPos);
                }
                locatedRegions = this.exonIntronUDStreamTree.getContains(this.exons.get((int)(this.exons.size() - 1)).start + base, this.exons.get((int)(this.exons.size() - 1)).end);
                fr2 = locatedRegions.get(0);
                fr1 = new GeneSubRegion(0, -1, this.exons.get((int)(this.exons.size() - 1)).end + base, this.exons.get((int)(this.exons.size() - 1)).end + base + upstreamExt);
                exonIntronUDStreamTreeBuilder.add(fr1.start, fr1.end, fr1);
                fr1.setRelativeExonStartPos(fr2.relativeExonStartPos + fr2.end - fr2.start);
                locatedRegions = this.exonIntronUDStreamTree.getContains(this.exons.get((int)0).start + base, this.exons.get((int)0).end);
                fr2 = locatedRegions.get(0);
                fr1 = new GeneSubRegion(3, -1, this.exons.get((int)0).start - downstreamExt, this.exons.get((int)0).start);
                exonIntronUDStreamTreeBuilder.add(fr1.start, fr1.end, fr1);
                fr1.setRelativeCodingStartPos(fr2.relativeCodingStartPos);
                fr1.setRelativeExonStartPos(0);
                break;
            }
            default: {
                throw new Exception("Unknown strand at " + this.refID + "; and cannot make AccuExonLength!");
            }
        }
        this.exonIntronUDStreamTree = exonIntronUDStreamTreeBuilder.build();
        if (this.delSites != null) {
            effectiveSites = new List<Integer>();
            StringBuilder effectiveBase = new StringBuilder();
            for (i = 0; i < this.delSites.length; ++i) {
                if (this.delSites[i] <= this.codingStartRelativeSiteInSequence) continue;
                effectiveSites.add(this.delSites[i]);
                effectiveBase.append(this.delSeq.charAt(i));
            }
            if (effectiveSites.isEmpty()) {
                this.delSites = null;
                this.delSeq = null;
            } else if (this.delSites.length != effectiveSites.size()) {
                this.delSites = new int[effectiveSites.size()];
                for (i = 0; i < this.delSites.length; ++i) {
                    this.delSites[i] = (Integer)effectiveSites.get(i);
                }
                this.delSeq = effectiveBase.toString();
            }
        }
        if (this.insSites != null) {
            effectiveSites = new List();
            StringBuilder effectiveBase = new StringBuilder();
            for (i = 0; i < this.insSites.length; ++i) {
                if (this.strand == '+') {
                    if (this.insSites[i] <= this.codingStartRelativeSiteInSequence) continue;
                    effectiveSites.add(this.insSites[i]);
                    effectiveBase.append(this.insSeq.charAt(i));
                    continue;
                }
                if (this.insSites[i] <= this.codingStartRelativeSiteInSequence) continue;
                effectiveSites.add(this.insSites[i]);
                effectiveBase.append(this.insSeq.charAt(i));
            }
            if (effectiveSites.isEmpty()) {
                this.insSites = null;
                this.insSeq = null;
            } else if (this.insSites.length != effectiveSites.size()) {
                this.insSites = new int[effectiveSites.size()];
                for (i = 0; i < this.insSites.length; ++i) {
                    this.insSites[i] = (Integer)effectiveSites.get(i);
                }
                this.insSeq = effectiveBase.toString();
            }
        }
    }

    private String getReverseComplementalSquences(String str1) {
        if (str1 == null || str1.length() == 0) {
            return null;
        }
        int len = str1.length();
        StringBuilder complement = new StringBuilder();
        complement.setLength(len);
        block10: for (int i = --len; i >= 0; --i) {
            switch (str1.charAt(i)) {
                case 'A': {
                    complement.setCharAt(len - i, 'T');
                    continue block10;
                }
                case 'T': {
                    complement.setCharAt(len - i, 'A');
                    continue block10;
                }
                case 'G': {
                    complement.setCharAt(len - i, 'C');
                    continue block10;
                }
                case 'C': {
                    complement.setCharAt(len - i, 'G');
                    continue block10;
                }
                case 'R': {
                    complement.setCharAt(len - i, 'Y');
                    continue block10;
                }
                case 'Y': {
                    complement.setCharAt(len - i, 'R');
                    continue block10;
                }
                case '[': {
                    complement.setCharAt(len - i, ']');
                    continue block10;
                }
                case ']': {
                    complement.setCharAt(len - i, '[');
                    continue block10;
                }
                default: {
                    complement.setCharAt(len - i, str1.charAt(i));
                }
            }
        }
        return complement.toString();
    }

    public List<GeneFeature> findFeatureSV(String chr, Variant var, boolean isForwardStrandInput, int splicingDis, TIntSet selectedFeatureSet, boolean includeExonic, ProgressBar bar) {
        int oldStartPos = var.getPosition();
        String refOrg = var.alleleOfIndex(0).toString();
        String[] altAlleles = new String[var.numOfAlleles() - 1];
        for (int i = 0; i < altAlleles.length; ++i) {
            altAlleles[i] = var.alleleOfIndex(i + 1).toString();
        }
        if (this.strand == '0') {
            this.logger.warn("Unknown strand at " + this.refID + ":(" + this.exonNum + "Exons" + (this.multipleMapping ? "MultiMap)" : ")"));
        }
        byte exonicFeatureID = VarGeneFeatureType.EXONIC.index;
        if (isForwardStrandInput && this.strand == '-') {
            refOrg = this.getReverseComplementalSquences(refOrg);
            for (int i = 0; i < altAlleles.length; ++i) {
                altAlleles[i] = this.getReverseComplementalSquences(altAlleles[i]);
            }
        }
        boolean count = false;
        byte[] errorCode = new byte[]{0};
        boolean index = false;
        List<GeneFeature> gfList = new List<GeneFeature>();
        List<Integer> idsList = new List<Integer>();
        for (String allele : altAlleles) {
            List<GeneFeature> gfListTmp;
            int startPos = oldStartPos;
            int startAllele = 0;
            String ref = refOrg;
            int effectiveLen = ref.length();
            if (ref.length() > allele.length()) {
                int lengthDiff = ref.length() - allele.length();
                char[] result = new char[ref.length()];
                if (ref.startsWith(allele)) {
                    System.arraycopy(allele.toCharArray(), 0, result, 0, allele.length());
                    Arrays.fill(result, allele.length(), ref.length(), '-');
                    allele = new String(result);
                } else if (ref.endsWith(allele)) {
                    Arrays.fill(result, 0, lengthDiff, '-');
                    System.arraycopy(allele.toCharArray(), 0, result, lengthDiff, allele.length());
                    allele = new String(result);
                }
            } else if (ref.length() < allele.length()) {
                char[] result = allele.toCharArray();
                if (allele.startsWith(ref)) {
                    Arrays.fill(result, 0, ref.length(), '+');
                    allele = new String(result);
                } else if (allele.endsWith(ref)) {
                    Arrays.fill(result, allele.length() - ref.length(), allele.length(), '+');
                    allele = new String(result);
                }
            }
            if (ref.length() > 1 && ref.length() == allele.length() && !allele.startsWith("-") && !allele.endsWith("-")) {
                int endAllele;
                boolean isForwardStrand;
                int length = ref.length();
                boolean bl = isForwardStrand = this.strand == '+';
                while (startAllele < length && ref.charAt(startAllele) == allele.charAt(startAllele)) {
                    ++startAllele;
                    --effectiveLen;
                }
                startPos = isForwardStrand ? oldStartPos + startAllele : oldStartPos + (length - 1 - startAllele);
                for (endAllele = startAllele + 1; endAllele < length && ref.charAt(endAllele) != allele.charAt(endAllele); ++endAllele) {
                }
                ref = ref.substring(startAllele, endAllele);
                allele = allele.substring(startAllele, endAllele);
                startAllele = 0;
            }
            String origAltAllele = allele;
            int delLen = 0;
            if (allele.startsWith("-")) {
                delLen = allele.lastIndexOf(45);
                origAltAllele = allele.substring(delLen + 1);
                delLen = allele.length() - origAltAllele.length();
                startPos = oldStartPos;
            } else if (allele.endsWith("-")) {
                delLen = allele.indexOf(45);
                origAltAllele = allele.substring(0, delLen);
                delLen = allele.length() - origAltAllele.length();
                startPos = oldStartPos;
            }
            int extLen = 0;
            if (ref.length() > origAltAllele.length()) {
                extLen = ref.length() - origAltAllele.length();
            }
            if ((gfListTmp = this.findCrudeFeatureSV(startPos, startPos + extLen, splicingDis, ref, origAltAllele, selectedFeatureSet, includeExonic)) == null || gfListTmp.isEmpty()) continue;
            if (gfListTmp.size() > 1) {
                GeneFeature gf0;
                int size = gfListTmp.size();
                idsList.clear();
                for (int i = 0; i < size; ++i) {
                    GeneFeature gf02 = gfListTmp.get(i);
                    if (gf02.typeID == exonicFeatureID) {
                        idsList.add(i);
                        continue;
                    }
                    gfList.add(gf02);
                }
                size = idsList.size();
                if (size <= 0) continue;
                if (startPos < this.codingEnd && startPos + extLen >= this.codingEnd) {
                    gf0 = gfListTmp.get((Integer)idsList.get(size - 1));
                    this.calculateAminoAcidDeletionAtRightTail(gf0, ref, allele, delLen, startPos + extLen);
                } else if (startPos < this.codingStart && startPos + extLen >= this.codingStart) {
                    gf0 = gfListTmp.get((Integer)idsList.get(0));
                    this.calculateAminoAcidDeletionAtLeftTail(gf0, ref, allele, delLen, startPos);
                } else {
                    int delCodingLen = 0;
                    for (int i = 0; i < size; ++i) {
                        GeneFeature gf03 = gfListTmp.get((Integer)idsList.get(i));
                        delCodingLen += Math.abs(gf03.cutCodingLen);
                    }
                    gf0 = gfListTmp.get((Integer)idsList.get(0));
                    this.calculateAminoAcidDeletion(gf0, ref, allele, delCodingLen);
                }
                gfList.add(gf0);
                continue;
            }
            GeneFeature gf = gfListTmp.get(0);
            if (gf == null) continue;
            if (gf.typeID == exonicFeatureID) {
                short exonID = gf.subRegionID;
                errorCode[0] = 0;
                if (allele.startsWith("+") || allele.endsWith("+")) {
                    this.calculateAminoAcidInsertion(gf, ref, allele);
                } else if (allele.startsWith("-") || allele.endsWith("-")) {
                    this.calculateAminoAcidDeletion(gf, ref, allele, delLen);
                } else if (effectiveLen > 1 && this.seqSet.contains(Character.valueOf(allele.charAt(startAllele)))) {
                    this.calculateAminoAcidChangeMulti(gf, this.strand == '+', ref.substring(startAllele), allele.substring(startAllele), startPos, gf.pos2CondingEnd, errorCode);
                } else {
                    this.calculateAminoAcidChange(gf, ref.charAt(startAllele), allele.charAt(startAllele), startPos, gf.pos2CondingEnd, errorCode);
                }
                if (errorCode[0] > 0) {
                    if (bar != null) {
                        bar.pause();
                    }
                    switch (errorCode[0]) {
                        case 1: {
                            String info = "The RefmRNA " + this.refID + " has no sequence data for the variant at chr" + chr + ":" + oldStartPos;
                            this.logger.warn(info);
                            break;
                        }
                        case 2: {
                            String info = "The RefmRNA " + this.refID + " has no sequence data for the variant at chr" + chr + ":" + oldStartPos;
                            this.logger.warn(info);
                            break;
                        }
                        case 3: {
                            String info = "The reference allele " + ref + " of chr" + chr + ":" + oldStartPos + " in the sample data and database are not identical on " + this.refID + " of " + this.geneSymb;
                            break;
                        }
                        case 4: {
                            break;
                        }
                    }
                    if (bar != null) {
                        bar.resume();
                    }
                }
                if (selectedFeatureSet.isEmpty()) {
                    gfList.add(gf);
                } else if (selectedFeatureSet.contains(gf.typeID)) {
                    gfList.add(gf);
                }
                gf.sequencePos = ":exon" + gf.subRegionID + gf.sequencePos;
                continue;
            }
            if (selectedFeatureSet.isEmpty()) {
                gfList.add(gf);
                continue;
            }
            if (!selectedFeatureSet.contains(gf.typeID)) continue;
            gfList.add(gf);
        }
        if (gfList.isEmpty()) {
            return null;
        }
        return gfList;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<GeneFeature> findCrudeFeatureSV(int pos1, int pos2, int splicingDis, String ref, String alt, TIntSet selectedFeatureSet, boolean includeExonic) {
        int relativeCodingStartPos = -1;
        List<GeneFeature> geneFeatureList = new List<GeneFeature>();
        GeneFeature gf = null;
        int pos = 0;
        int cutLen = pos2 - pos1;
        if (cutLen < 0) {
            String info = "Reversed positions at structure variant in getVarFeature " + pos1 + " of transcript " + this.refID;
            this.logger.error(info);
        } else if (cutLen > 0) {
            ++cutLen;
        }
        try {
            List<GeneSubRegion> locatedRegions = this.exonIntronUDStreamTree.getOverlaps(pos1, pos2);
            int size = locatedRegions.size();
            for (int i = 0; i < size; ++i) {
                int offSet2;
                int offSet1;
                boolean cutDownstream = true;
                GeneSubRegion region = locatedRegions.get(i);
                int regionStart = region.start;
                int regionEnd = region.end;
                byte regionType = region.type;
                relativeCodingStartPos = region.relativeCodingStartPos;
                short regionIndex = region.index;
                if (pos1 >= regionStart && pos1 <= regionEnd) {
                    pos = pos1;
                } else if (pos2 >= regionStart && pos2 <= regionEnd) {
                    pos = pos2;
                    cutDownstream = false;
                } else {
                    offSet1 = regionEnd - regionStart + 1;
                    switch (regionType) {
                        case 2: {
                            StringBuilder sbIntron = new StringBuilder(":intron").append(regionIndex).append(":c.");
                            offSet2 = 0;
                            if (offSet1 < offSet2) {
                                if (relativeCodingStartPos < 0) {
                                    --relativeCodingStartPos;
                                }
                                sbIntron.append(relativeCodingStartPos).append('+').append(offSet1);
                            } else {
                                if (relativeCodingStartPos > 0) {
                                    ++relativeCodingStartPos;
                                }
                                sbIntron.append(relativeCodingStartPos).append('-').append(offSet2);
                            }
                            sbIntron.append(ref).append(">").append(alt);
                            gf = new GeneFeature(VarGeneFeatureType.INTRONIC.index, -1, offSet1, offSet2, this.exonNum, this.geneSymbIndex, this.geneIDIndex, this.refIDIndex, sbIntron.toString(), regionIndex);
                            geneFeatureList.add(gf);
                            break;
                        }
                        case 1: {
                            gf = new GeneFeature(VarGeneFeatureType.EXONIC.index, -1, offSet1, 0, this.exonNum, this.geneSymbIndex, this.geneIDIndex, this.refIDIndex, ":exon" + regionIndex + ":c." + (relativeCodingStartPos += offSet1 - 1) + ref + ">" + alt, regionIndex);
                            gf.cutCodingLen = offSet1;
                            geneFeatureList.add(gf);
                            break;
                        }
                        case 0: {
                            offSet1 = regionEnd - regionStart;
                            gf = new GeneFeature(VarGeneFeatureType.UPSTREAM.index, -1, offSet1, -999, this.exonNum, this.geneSymbIndex, this.geneIDIndex, this.refIDIndex, ":n." + offSet1 + ref + ">" + alt, regionIndex);
                            geneFeatureList.add(gf);
                            break;
                        }
                        case 3: {
                            offSet1 = regionEnd - regionStart;
                            gf = new GeneFeature(VarGeneFeatureType.DOWNSTREAM.index, -1, offSet1, -999, this.exonNum, this.geneSymbIndex, this.geneIDIndex, this.refIDIndex, ":n.*" + offSet1 + ref + ">" + alt, regionIndex);
                            geneFeatureList.add(gf);
                            break;
                        }
                    }
                    if (selectedFeatureSet.isEmpty()) continue;
                    int lastIndex = geneFeatureList.size() - 1;
                    gf = geneFeatureList.get(lastIndex);
                    if (includeExonic && VarGeneFeatureType.EXONIC.index == gf.typeID || selectedFeatureSet.contains(gf.typeID)) continue;
                    geneFeatureList.removeByIndex(lastIndex);
                    continue;
                }
                switch (this.strand) {
                    case '+': {
                        int shorterStart;
                        int offSet12;
                        int relativeExonPos;
                        switch (region.type) {
                            case 2: {
                                if (pos <= region.start + splicingDis) {
                                    if (relativeCodingStartPos < 0) {
                                        --relativeCodingStartPos;
                                    }
                                    offSet1 = pos - region.start + 1;
                                    offSet2 = region.end - pos;
                                    relativeExonPos = region.relativeExonStartPos;
                                    if (this.noCodingExon) {
                                        gf = new GeneFeature(VarGeneFeatureType.NC_RNA.index, VarGeneFeatureType.SPLICING.index, offSet1, offSet2, this.exonNum, this.geneSymbIndex, this.geneIDIndex, this.refIDIndex, ":exon" + (region.index + 1) + ":n." + relativeExonPos + "+" + (offSet1 - 1) + ref + ">" + alt + "(GTdonor)", region.index);
                                        geneFeatureList.add(gf);
                                        break;
                                    }
                                    gf = new GeneFeature(VarGeneFeatureType.SPLICING.index, -1, offSet1, offSet2, this.exonNum, this.geneSymbIndex, this.geneIDIndex, this.refIDIndex, ":exon" + (region.index + 1) + ":c." + relativeCodingStartPos + "+" + offSet1 + ref + ">" + alt + "(GTdonor)", region.index);
                                    geneFeatureList.add(gf);
                                    break;
                                }
                                if (pos <= region.end - splicingDis) {
                                    StringBuilder sb;
                                    int offSet11 = pos - region.start + 1;
                                    offSet12 = region.end - pos;
                                    if (this.noCodingExon) {
                                        relativeExonPos = region.relativeExonStartPos;
                                        offSet1 = pos - region.start;
                                        offSet2 = region.end - pos + 1;
                                        sb = new StringBuilder(":intron" + region.index + ":n.");
                                        if (offSet1 < offSet2) {
                                            if (relativeExonPos < 0) {
                                                --relativeExonPos;
                                            }
                                            sb.append(relativeExonPos);
                                            sb.append('+');
                                            sb.append(offSet1);
                                        } else {
                                            if (relativeExonPos > 0) {
                                                ++relativeExonPos;
                                            }
                                            sb.append(relativeExonPos);
                                            sb.append('-');
                                            sb.append(offSet2);
                                        }
                                        sb.append(ref).append(">").append(alt);
                                        gf = new GeneFeature(VarGeneFeatureType.NC_RNA.index, VarGeneFeatureType.INTRONIC.index, offSet11, offSet12, this.exonNum, this.geneSymbIndex, this.geneIDIndex, this.refIDIndex, sb.toString(), region.index);
                                        geneFeatureList.add(gf);
                                        break;
                                    }
                                    offSet1 = pos - region.start + 1;
                                    offSet2 = region.end - pos + 1;
                                    sb = new StringBuilder(":intron" + region.index + ":c.");
                                    if (offSet1 < offSet2) {
                                        if (relativeCodingStartPos < 0) {
                                            --relativeCodingStartPos;
                                        }
                                        sb.append(relativeCodingStartPos);
                                        sb.append('+');
                                        sb.append(offSet1);
                                    } else {
                                        if (relativeCodingStartPos > 0) {
                                            ++relativeCodingStartPos;
                                        }
                                        sb.append(relativeCodingStartPos);
                                        sb.append('-');
                                        sb.append(offSet2);
                                    }
                                    sb.append(ref).append(">").append(alt);
                                    gf = new GeneFeature(VarGeneFeatureType.INTRONIC.index, -1, offSet11, offSet12, this.exonNum, this.geneSymbIndex, this.geneIDIndex, this.refIDIndex, sb.toString(), region.index);
                                    geneFeatureList.add(gf);
                                    break;
                                }
                                offSet1 = pos - region.start + 1;
                                offSet2 = region.end - pos;
                                if (this.noCodingExon) {
                                    gf = new GeneFeature(VarGeneFeatureType.NC_RNA.index, VarGeneFeatureType.SPLICING.index, offSet1, offSet2, this.exonNum, this.geneSymbIndex, this.geneIDIndex, this.refIDIndex, ":exon" + region.index + ":n." + (region.relativeExonStartPos + 1) + "-" + (offSet2 + 1) + ref + ">" + alt + "(AGacceptor)", region.index);
                                    geneFeatureList.add(gf);
                                    break;
                                }
                                gf = new GeneFeature(VarGeneFeatureType.SPLICING.index, -1, offSet1, offSet2, this.exonNum, this.geneSymbIndex, this.geneIDIndex, this.refIDIndex, ":exon" + region.index + ":c." + relativeCodingStartPos + "-" + (offSet2 + 1) + ref + ">" + alt + "(AGacceptor)", region.index, relativeCodingStartPos);
                                geneFeatureList.add(gf);
                                break;
                            }
                            case 1: {
                                if (this.noCodingExon) {
                                    offSet1 = pos - region.start + 1;
                                    offSet2 = region.end - pos;
                                    int relativeExonStartPos = region.relativeExonStartPos + offSet1 - 1;
                                    gf = new GeneFeature(VarGeneFeatureType.NC_RNA.index, VarGeneFeatureType.EXONIC.index, offSet1, offSet2, this.exonNum, this.geneSymbIndex, this.geneIDIndex, this.refIDIndex, ":exon" + region.index + ":n." + relativeExonStartPos + ref + ">" + alt, region.index, relativeExonStartPos);
                                    geneFeatureList.add(gf);
                                    break;
                                }
                                if (pos <= this.codingStart) {
                                    offSet1 = pos - region.start + 1;
                                    offSet2 = region.end - pos;
                                    relativeCodingStartPos = region.relativeCodingStartPos + offSet1 - 1;
                                    gf = new GeneFeature(VarGeneFeatureType.FIVE_PRIME_UTR.index, -1, offSet1, offSet2, this.exonNum, this.geneSymbIndex, this.geneIDIndex, this.refIDIndex, ":exon" + region.index + ":c." + relativeCodingStartPos + ref + ">" + alt, region.index);
                                    geneFeatureList.add(gf);
                                    break;
                                }
                                if (pos <= this.codingEnd) {
                                    offSet1 = pos - region.start + 1;
                                    offSet2 = region.end - pos;
                                    relativeCodingStartPos = region.relativeCodingStartPos + offSet1 - 1;
                                    gf = new GeneFeature(VarGeneFeatureType.EXONIC.index, -1, offSet1, offSet2, this.exonNum, this.geneSymbIndex, this.geneIDIndex, this.refIDIndex, ":exon" + region.index + ":c." + relativeCodingStartPos + ref + ">" + alt, region.index, relativeCodingStartPos);
                                    geneFeatureList.add(gf);
                                    int shorterEnd = Math.min(region.end, this.codingEnd);
                                    shorterStart = Math.max(region.start, this.codingStart);
                                    if (cutLen <= 0) break;
                                    if (cutDownstream) {
                                        gf.cutCodingLen = Math.min(cutLen, shorterEnd - pos + 1);
                                        break;
                                    }
                                    gf.cutCodingLen = Math.min(cutLen, pos - shorterStart + 1);
                                    gf.cutCodingLen = -gf.cutCodingLen;
                                    break;
                                }
                                offSet1 = pos - region.start + 1;
                                offSet2 = region.end - pos;
                                relativeCodingStartPos = pos - this.codingEnd;
                                gf = new GeneFeature(VarGeneFeatureType.THREE_PRIME_UTR.index, -1, offSet1, offSet2, this.exonNum, this.geneSymbIndex, this.geneIDIndex, this.refIDIndex, ":exon" + region.index + ":c.*" + relativeCodingStartPos + ref + ">" + alt, region.index, relativeCodingStartPos);
                                geneFeatureList.add(gf);
                                break;
                            }
                            case 0: {
                                relativeCodingStartPos = pos - region.end;
                                gf = this.noCodingExon ? new GeneFeature(VarGeneFeatureType.NC_RNA.index, VarGeneFeatureType.UPSTREAM.index, -999, -999, this.exonNum, this.geneSymbIndex, this.geneIDIndex, this.refIDIndex, ":n." + relativeCodingStartPos + ref + ">" + alt, region.index, relativeCodingStartPos) : new GeneFeature(VarGeneFeatureType.UPSTREAM.index, -1, -999, -999, this.exonNum, this.geneSymbIndex, this.geneIDIndex, this.refIDIndex, ":n." + relativeCodingStartPos + ref + ">" + alt, region.index, relativeCodingStartPos);
                                geneFeatureList.add(gf);
                                break;
                            }
                            case 3: {
                                offSet1 = pos - region.start;
                                gf = this.noCodingExon ? new GeneFeature(VarGeneFeatureType.NC_RNA.index, VarGeneFeatureType.DOWNSTREAM.index, offSet1, -999, this.exonNum, this.geneSymbIndex, this.geneIDIndex, this.refIDIndex, ":n.*" + offSet1 + ref + ">" + alt, region.index) : new GeneFeature(VarGeneFeatureType.DOWNSTREAM.index, -1, offSet1, -999, this.exonNum, this.geneSymbIndex, this.geneIDIndex, this.refIDIndex, ":n.*" + offSet1 + ref + ">" + alt, region.index);
                                geneFeatureList.add(gf);
                                break;
                            }
                        }
                        break;
                    }
                    case '-': {
                        int shorterStart;
                        int offSet12;
                        int relativeExonPos;
                        switch (region.type) {
                            case 2: {
                                if (pos <= region.start + splicingDis) {
                                    relativeCodingStartPos = region.relativeCodingStartPos + 1;
                                    if (relativeCodingStartPos < 0) {
                                        --relativeCodingStartPos;
                                    }
                                    offSet1 = pos - region.start + 1;
                                    offSet2 = region.end - pos;
                                    relativeExonPos = region.relativeExonStartPos;
                                    if (this.noCodingExon) {
                                        gf = new GeneFeature(VarGeneFeatureType.NC_RNA.index, VarGeneFeatureType.SPLICING.index, offSet1, offSet2, this.exonNum, this.geneSymbIndex, this.geneIDIndex, this.refIDIndex, ":exon" + (region.index + 1) + ":n." + relativeExonPos + "-" + offSet1 + ref + ">" + alt + "(AGacceptor)", region.index);
                                        geneFeatureList.add(gf);
                                        break;
                                    }
                                    gf = new GeneFeature(VarGeneFeatureType.SPLICING.index, -1, offSet1, offSet2, this.exonNum, this.geneSymbIndex, this.geneIDIndex, this.refIDIndex, ":exon" + (region.index + 1) + ":c." + relativeCodingStartPos + "-" + offSet1 + ref + ">" + alt + "(AGacceptor)", region.index, relativeCodingStartPos);
                                    geneFeatureList.add(gf);
                                    break;
                                }
                                if (pos <= region.end - splicingDis) {
                                    StringBuilder sb;
                                    int offSet11 = pos - region.start + 1;
                                    offSet12 = region.end - pos;
                                    if (this.noCodingExon) {
                                        relativeExonPos = region.relativeExonStartPos;
                                        offSet1 = pos - region.start;
                                        offSet2 = region.end - pos + 1;
                                        sb = new StringBuilder(":intron" + region.index + ":n.");
                                        if (offSet1 < offSet2) {
                                            if (relativeExonPos < 0) {
                                                --relativeExonPos;
                                            }
                                            sb.append(relativeExonPos);
                                            sb.append('+');
                                            sb.append(offSet1);
                                        } else {
                                            if (relativeExonPos > 0) {
                                                ++relativeExonPos;
                                            }
                                            sb.append(relativeExonPos);
                                            sb.append('-');
                                            sb.append(offSet2);
                                        }
                                        sb.append(ref).append(">").append(alt);
                                        gf = new GeneFeature(VarGeneFeatureType.NC_RNA.index, VarGeneFeatureType.INTRONIC.index, offSet11, offSet12, this.exonNum, this.geneSymbIndex, this.geneIDIndex, this.refIDIndex, sb.toString(), region.index);
                                        geneFeatureList.add(gf);
                                        break;
                                    }
                                    if (relativeCodingStartPos < 0) {
                                        --relativeCodingStartPos;
                                    }
                                    offSet1 = pos - region.start + 1;
                                    offSet2 = region.end - pos + 1;
                                    sb = new StringBuilder(":intron" + region.index + ":c.");
                                    if (offSet1 < offSet2) {
                                        if (relativeCodingStartPos < 0) {
                                            --relativeCodingStartPos;
                                        }
                                        sb.append(++relativeCodingStartPos);
                                        sb.append('-');
                                        sb.append(offSet1);
                                    } else {
                                        sb.append(relativeCodingStartPos);
                                        sb.append('+');
                                        sb.append(offSet2);
                                    }
                                    sb.append(ref).append(">").append(alt);
                                    gf = new GeneFeature(VarGeneFeatureType.INTRONIC.index, -1, offSet11, offSet12, this.exonNum, this.geneSymbIndex, this.geneIDIndex, this.refIDIndex, sb.toString(), region.index);
                                    geneFeatureList.add(gf);
                                    break;
                                }
                                if (relativeCodingStartPos < 0) {
                                    --relativeCodingStartPos;
                                }
                                offSet1 = pos - region.start + 1;
                                offSet2 = region.end - pos;
                                if (this.noCodingExon) {
                                    gf = new GeneFeature(VarGeneFeatureType.NC_RNA.index, VarGeneFeatureType.SPLICING.index, offSet1, offSet2, this.exonNum, this.geneSymbIndex, this.geneIDIndex, this.refIDIndex, ":exon" + region.index + ":n." + region.relativeExonStartPos + "+" + (offSet2 + 1) + ref + ">" + alt + "(GTdonor)", region.index);
                                    geneFeatureList.add(gf);
                                    break;
                                }
                                gf = new GeneFeature(VarGeneFeatureType.SPLICING.index, -1, offSet1, offSet2, this.exonNum, this.geneSymbIndex, this.geneIDIndex, this.refIDIndex, ":exon" + region.index + ":c." + relativeCodingStartPos + "+" + (offSet2 + 1) + ref + ">" + alt + "(GTdonor)", region.index, relativeCodingStartPos);
                                geneFeatureList.add(gf);
                                break;
                            }
                            case 1: {
                                if (this.noCodingExon) {
                                    offSet1 = pos - region.start + 1;
                                    offSet2 = region.end - pos;
                                    int relativeExonStartPos = region.relativeExonStartPos + offSet1 - 1;
                                    gf = new GeneFeature(VarGeneFeatureType.NC_RNA.index, VarGeneFeatureType.EXONIC.index, offSet1, offSet2, this.exonNum, this.geneSymbIndex, this.geneIDIndex, this.refIDIndex, ":exon" + region.index + ":n." + relativeExonStartPos + ref + ">" + alt, region.index, relativeExonStartPos);
                                    geneFeatureList.add(gf);
                                    break;
                                }
                                if (pos <= this.codingEndR) {
                                    offSet1 = pos - region.start + 1;
                                    offSet2 = region.end - pos;
                                    relativeCodingStartPos = this.codingEndR - pos;
                                    gf = new GeneFeature(VarGeneFeatureType.THREE_PRIME_UTR.index, -1, offSet1, offSet2, this.exonNum, this.geneSymbIndex, this.geneIDIndex, this.refIDIndex, ":exon" + region.index + ":c.*" + relativeCodingStartPos + ref + ">" + alt, region.index, relativeCodingStartPos);
                                    geneFeatureList.add(gf);
                                    break;
                                }
                                if (pos <= this.codingStartR) {
                                    offSet1 = pos - region.start + 1;
                                    offSet2 = region.end - pos;
                                    relativeCodingStartPos = region.relativeCodingStartPos + offSet2;
                                    gf = new GeneFeature(VarGeneFeatureType.EXONIC.index, -1, offSet1, offSet2, this.exonNum, this.geneSymbIndex, this.geneIDIndex, this.refIDIndex, ":exon" + region.index + ":c." + relativeCodingStartPos + ref + ">" + alt, region.index, relativeCodingStartPos);
                                    geneFeatureList.add(gf);
                                    int shorterEnd = Math.min(region.end, this.codingEnd);
                                    shorterStart = Math.max(region.start, this.codingStart);
                                    if (cutLen <= 0) break;
                                    if (cutDownstream) {
                                        gf.cutCodingLen = Math.min(cutLen, shorterEnd - pos + 1);
                                        break;
                                    }
                                    gf.cutCodingLen = Math.min(cutLen, pos - shorterStart + 1);
                                    gf.cutCodingLen = -gf.cutCodingLen;
                                    break;
                                }
                                offSet1 = pos - region.start + 1;
                                offSet2 = region.end - pos;
                                relativeCodingStartPos = region.relativeCodingStartPos + offSet2 - 1;
                                gf = new GeneFeature(VarGeneFeatureType.FIVE_PRIME_UTR.index, -1, offSet1, offSet2, this.exonNum, this.geneSymbIndex, this.geneIDIndex, this.refIDIndex, ":exon" + region.index + ":c." + relativeCodingStartPos + ref + ">" + alt, region.index, relativeCodingStartPos);
                                geneFeatureList.add(gf);
                                break;
                            }
                            case 0: {
                                relativeCodingStartPos = pos - region.end;
                                gf = this.noCodingExon ? new GeneFeature(VarGeneFeatureType.NC_RNA.index, VarGeneFeatureType.UPSTREAM.index, -999, -999, this.exonNum, this.geneSymbIndex, this.geneIDIndex, this.refIDIndex, ":n." + relativeCodingStartPos + ref + ">" + alt, region.index, relativeCodingStartPos) : new GeneFeature(VarGeneFeatureType.UPSTREAM.index, -1, -999, -999, this.exonNum, this.geneSymbIndex, this.geneIDIndex, this.refIDIndex, ":n." + relativeCodingStartPos + ref + ">" + alt, region.index, relativeCodingStartPos);
                                geneFeatureList.add(gf);
                                break;
                            }
                            case 3: {
                                offSet1 = pos - region.start;
                                gf = this.noCodingExon ? new GeneFeature(VarGeneFeatureType.NC_RNA.index, VarGeneFeatureType.DOWNSTREAM.index, -999, -999, this.exonNum, this.geneSymbIndex, this.geneIDIndex, this.refIDIndex, ":n." + relativeCodingStartPos + ref + ">" + alt, region.index, relativeCodingStartPos) : new GeneFeature(VarGeneFeatureType.DOWNSTREAM.index, -1, offSet1, -999, this.exonNum, this.geneSymbIndex, this.geneIDIndex, this.refIDIndex, ":n.*" + offSet1 + ref + ">" + alt, region.index);
                                geneFeatureList.add(gf);
                                break;
                            }
                        }
                        break;
                    }
                }
                if (selectedFeatureSet.isEmpty()) continue;
                int lastIndex = geneFeatureList.size() - 1;
                gf = geneFeatureList.get(lastIndex);
                boolean isExonic = includeExonic && VarGeneFeatureType.EXONIC.index == gf.typeID;
                boolean isSelectedFeature = selectedFeatureSet.contains(gf.typeID);
                if (isExonic || isSelectedFeature) continue;
                geneFeatureList.removeByIndex(lastIndex);
            }
            return geneFeatureList;
        }
        catch (Exception e) {
            String info = e.getMessage() + " at structure variant in getVarFeature " + pos1 + " of transcript " + this.refID;
            this.logger.error(info);
        }
        return geneFeatureList;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<GeneFeature> findCrudeFeatureSV0(int pos1, int pos2, int splicingDis, String ref, String alt, TIntSet selectedFeatureSet, boolean includeExonic) {
        int relativeCodingStartPos = -1;
        List<GeneFeature> geneFeatureList = new List<GeneFeature>();
        GeneFeature gf = null;
        boolean cutDownstream = true;
        int cutLen = pos2 - pos1;
        if (cutLen < 0) {
            String info = "Reversed positions at structure variant in getVarFeature " + pos1 + " of transcript " + this.refID;
            this.logger.error(info);
        } else if (cutLen > 0) {
            ++cutLen;
        }
        try {
            List<GeneSubRegion> locatedRegions = this.exonIntronUDStreamTree.getOverlaps(pos1, pos2);
            int size = locatedRegions.size();
            for (int i = 0; i < size; ++i) {
                boolean isExonic;
                int offSet2;
                int offSet1;
                int pos;
                cutDownstream = true;
                GeneSubRegion region = locatedRegions.get(i);
                if (pos1 >= region.start && pos1 <= region.end) {
                    pos = pos1;
                } else if (pos2 >= region.start && pos2 <= region.end) {
                    pos = pos2;
                    cutDownstream = false;
                } else {
                    switch (region.type) {
                        case 2: {
                            relativeCodingStartPos = region.relativeCodingStartPos;
                            offSet1 = region.end - region.start + 1;
                            offSet2 = 0;
                            StringBuilder sb = new StringBuilder(":intron" + region.index + ":c.");
                            if (offSet1 < offSet2) {
                                if (relativeCodingStartPos < 0) {
                                    --relativeCodingStartPos;
                                }
                                sb.append(relativeCodingStartPos);
                                sb.append('+');
                                sb.append(offSet1);
                            } else {
                                if (relativeCodingStartPos > 0) {
                                    ++relativeCodingStartPos;
                                }
                                sb.append(relativeCodingStartPos);
                                sb.append('-');
                                sb.append(offSet2);
                            }
                            sb.append(ref).append(">").append(alt);
                            gf = new GeneFeature(VarGeneFeatureType.INTRONIC.index, -1, offSet1, offSet2, this.exonNum, this.geneSymbIndex, this.geneIDIndex, this.refIDIndex, sb.toString(), region.index);
                            geneFeatureList.add(gf);
                            break;
                        }
                        case 1: {
                            offSet1 = region.end - region.start + 1;
                            offSet2 = 0;
                            relativeCodingStartPos = region.relativeCodingStartPos + offSet1 - 1;
                            gf = new GeneFeature(VarGeneFeatureType.EXONIC.index, -1, offSet1, offSet2, this.exonNum, this.geneSymbIndex, this.geneIDIndex, this.refIDIndex, ":exon" + region.index + ":c." + relativeCodingStartPos + ref + ">" + alt, region.index);
                            geneFeatureList.add(gf);
                            gf.cutCodingLen = offSet1;
                            break;
                        }
                        case 0: {
                            offSet1 = region.end - region.start;
                            gf = new GeneFeature(VarGeneFeatureType.UPSTREAM.index, -1, offSet1, -999, this.exonNum, this.geneSymbIndex, this.geneIDIndex, this.refIDIndex, ":n." + offSet1 + ref + ">" + alt, region.index);
                            geneFeatureList.add(gf);
                            break;
                        }
                        case 3: {
                            offSet1 = region.end - region.start;
                            gf = new GeneFeature(VarGeneFeatureType.DOWNSTREAM.index, -1, offSet1, -999, this.exonNum, this.geneSymbIndex, this.geneIDIndex, this.refIDIndex, ":n.*" + offSet1 + ref + ">" + alt, region.index);
                            geneFeatureList.add(gf);
                            break;
                        }
                    }
                    if (selectedFeatureSet.isEmpty()) continue;
                    int lastIndex = geneFeatureList.size() - 1;
                    gf = geneFeatureList.get(lastIndex);
                    isExonic = includeExonic && VarGeneFeatureType.EXONIC.index == gf.typeID;
                    boolean isSelectedFeature = selectedFeatureSet.contains(gf.typeID);
                    if (isExonic || isSelectedFeature) continue;
                    geneFeatureList.removeByIndex(lastIndex);
                    continue;
                }
                switch (this.strand) {
                    case '+': {
                        int shorterStart;
                        int offSet12;
                        int relativeExonPos;
                        switch (region.type) {
                            case 2: {
                                if (pos <= region.start + splicingDis) {
                                    relativeCodingStartPos = region.relativeCodingStartPos;
                                    if (relativeCodingStartPos < 0) {
                                        --relativeCodingStartPos;
                                    }
                                    offSet1 = pos - region.start + 1;
                                    offSet2 = region.end - pos;
                                    relativeExonPos = region.relativeExonStartPos;
                                    if (this.noCodingExon) {
                                        gf = new GeneFeature(VarGeneFeatureType.NC_RNA.index, VarGeneFeatureType.SPLICING.index, offSet1, offSet2, this.exonNum, this.geneSymbIndex, this.geneIDIndex, this.refIDIndex, ":exon" + (region.index + 1) + ":n." + relativeExonPos + "+" + (offSet1 - 1) + ref + ">" + alt + "(GTdonor)", region.index);
                                        geneFeatureList.add(gf);
                                        break;
                                    }
                                    gf = new GeneFeature(VarGeneFeatureType.SPLICING.index, -1, offSet1, offSet2, this.exonNum, this.geneSymbIndex, this.geneIDIndex, this.refIDIndex, ":exon" + (region.index + 1) + ":c." + relativeCodingStartPos + "+" + offSet1 + ref + ">" + alt + "(GTdonor)", region.index);
                                    geneFeatureList.add(gf);
                                    break;
                                }
                                if (pos <= region.end - splicingDis) {
                                    StringBuilder sb;
                                    int offSet11 = pos - region.start + 1;
                                    offSet12 = region.end - pos;
                                    if (this.noCodingExon) {
                                        relativeExonPos = region.relativeExonStartPos;
                                        offSet1 = pos - region.start;
                                        offSet2 = region.end - pos + 1;
                                        sb = new StringBuilder(":intron" + region.index + ":n.");
                                        if (offSet1 < offSet2) {
                                            if (relativeExonPos < 0) {
                                                --relativeExonPos;
                                            }
                                            sb.append(relativeExonPos);
                                            sb.append('+');
                                            sb.append(offSet1);
                                        } else {
                                            if (relativeExonPos > 0) {
                                                ++relativeExonPos;
                                            }
                                            sb.append(relativeExonPos);
                                            sb.append('-');
                                            sb.append(offSet2);
                                        }
                                        sb.append(ref).append(">").append(alt);
                                        gf = new GeneFeature(VarGeneFeatureType.NC_RNA.index, VarGeneFeatureType.INTRONIC.index, offSet11, offSet12, this.exonNum, this.geneSymbIndex, this.geneIDIndex, this.refIDIndex, sb.toString(), region.index);
                                        geneFeatureList.add(gf);
                                        break;
                                    }
                                    relativeCodingStartPos = region.relativeCodingStartPos;
                                    offSet1 = pos - region.start + 1;
                                    offSet2 = region.end - pos + 1;
                                    sb = new StringBuilder(":intron" + region.index + ":c.");
                                    if (offSet1 < offSet2) {
                                        if (relativeCodingStartPos < 0) {
                                            --relativeCodingStartPos;
                                        }
                                        sb.append(relativeCodingStartPos);
                                        sb.append('+');
                                        sb.append(offSet1);
                                    } else {
                                        if (relativeCodingStartPos > 0) {
                                            ++relativeCodingStartPos;
                                        }
                                        sb.append(relativeCodingStartPos);
                                        sb.append('-');
                                        sb.append(offSet2);
                                    }
                                    sb.append(ref).append(">").append(alt);
                                    gf = new GeneFeature(VarGeneFeatureType.INTRONIC.index, -1, offSet11, offSet12, this.exonNum, this.geneSymbIndex, this.geneIDIndex, this.refIDIndex, sb.toString(), region.index);
                                    geneFeatureList.add(gf);
                                    break;
                                }
                                relativeCodingStartPos = region.relativeCodingStartPos;
                                offSet1 = pos - region.start + 1;
                                offSet2 = region.end - pos;
                                if (this.noCodingExon) {
                                    gf = new GeneFeature(VarGeneFeatureType.NC_RNA.index, VarGeneFeatureType.SPLICING.index, offSet1, offSet2, this.exonNum, this.geneSymbIndex, this.geneIDIndex, this.refIDIndex, ":exon" + region.index + ":n." + (region.relativeExonStartPos + 1) + "-" + (offSet2 + 1) + ref + ">" + alt + "(AGacceptor)", region.index);
                                    geneFeatureList.add(gf);
                                    break;
                                }
                                gf = new GeneFeature(VarGeneFeatureType.SPLICING.index, -1, offSet1, offSet2, this.exonNum, this.geneSymbIndex, this.geneIDIndex, this.refIDIndex, ":exon" + region.index + ":c." + relativeCodingStartPos + "-" + (offSet2 + 1) + ref + ">" + alt + "(AGacceptor)", region.index, relativeCodingStartPos);
                                geneFeatureList.add(gf);
                                break;
                            }
                            case 1: {
                                if (this.noCodingExon) {
                                    offSet1 = pos - region.start + 1;
                                    offSet2 = region.end - pos;
                                    int relativeExonStartPos = region.relativeExonStartPos + offSet1 - 1;
                                    gf = new GeneFeature(VarGeneFeatureType.NC_RNA.index, VarGeneFeatureType.EXONIC.index, offSet1, offSet2, this.exonNum, this.geneSymbIndex, this.geneIDIndex, this.refIDIndex, ":exon" + region.index + ":n." + relativeExonStartPos + ref + ">" + alt, region.index, relativeExonStartPos);
                                    geneFeatureList.add(gf);
                                    break;
                                }
                                if (pos <= this.codingStart) {
                                    offSet1 = pos - region.start + 1;
                                    offSet2 = region.end - pos;
                                    relativeCodingStartPos = region.relativeCodingStartPos + offSet1 - 1;
                                    gf = new GeneFeature(VarGeneFeatureType.FIVE_PRIME_UTR.index, -1, offSet1, offSet2, this.exonNum, this.geneSymbIndex, this.geneIDIndex, this.refIDIndex, ":exon" + region.index + ":c." + relativeCodingStartPos + ref + ">" + alt, region.index);
                                    geneFeatureList.add(gf);
                                    break;
                                }
                                if (pos <= this.codingEnd) {
                                    offSet1 = pos - region.start + 1;
                                    offSet2 = region.end - pos;
                                    relativeCodingStartPos = region.relativeCodingStartPos + offSet1 - 1;
                                    gf = new GeneFeature(VarGeneFeatureType.EXONIC.index, -1, offSet1, offSet2, this.exonNum, this.geneSymbIndex, this.geneIDIndex, this.refIDIndex, ":exon" + region.index + ":c." + relativeCodingStartPos + ref + ">" + alt, region.index, relativeCodingStartPos);
                                    geneFeatureList.add(gf);
                                    int shorterEnd = Math.min(region.end, this.codingEnd);
                                    shorterStart = Math.max(region.start, this.codingStart);
                                    if (cutLen <= 0) break;
                                    if (cutDownstream) {
                                        gf.cutCodingLen = Math.min(cutLen, shorterEnd - pos + 1);
                                        break;
                                    }
                                    gf.cutCodingLen = Math.min(cutLen, pos - shorterStart + 1);
                                    gf.cutCodingLen = -gf.cutCodingLen;
                                    break;
                                }
                                offSet1 = pos - region.start + 1;
                                offSet2 = region.end - pos;
                                relativeCodingStartPos = pos - this.codingEnd;
                                gf = new GeneFeature(VarGeneFeatureType.THREE_PRIME_UTR.index, -1, offSet1, offSet2, this.exonNum, this.geneSymbIndex, this.geneIDIndex, this.refIDIndex, ":exon" + region.index + ":c.*" + relativeCodingStartPos + ref + ">" + alt, region.index, relativeCodingStartPos);
                                geneFeatureList.add(gf);
                                break;
                            }
                            case 0: {
                                relativeCodingStartPos = pos - region.end;
                                gf = this.noCodingExon ? new GeneFeature(VarGeneFeatureType.NC_RNA.index, VarGeneFeatureType.UPSTREAM.index, -999, -999, this.exonNum, this.geneSymbIndex, this.geneIDIndex, this.refIDIndex, ":n." + relativeCodingStartPos + ref + ">" + alt, region.index, relativeCodingStartPos) : new GeneFeature(VarGeneFeatureType.UPSTREAM.index, -1, -999, -999, this.exonNum, this.geneSymbIndex, this.geneIDIndex, this.refIDIndex, ":n." + relativeCodingStartPos + ref + ">" + alt, region.index, relativeCodingStartPos);
                                geneFeatureList.add(gf);
                                break;
                            }
                            case 3: {
                                offSet1 = pos - region.start;
                                gf = this.noCodingExon ? new GeneFeature(VarGeneFeatureType.NC_RNA.index, VarGeneFeatureType.DOWNSTREAM.index, offSet1, -999, this.exonNum, this.geneSymbIndex, this.geneIDIndex, this.refIDIndex, ":n.*" + offSet1 + ref + ">" + alt, region.index) : new GeneFeature(VarGeneFeatureType.DOWNSTREAM.index, -1, offSet1, -999, this.exonNum, this.geneSymbIndex, this.geneIDIndex, this.refIDIndex, ":n.*" + offSet1 + ref + ">" + alt, region.index);
                                geneFeatureList.add(gf);
                                break;
                            }
                        }
                        break;
                    }
                    case '-': {
                        int shorterStart;
                        int offSet12;
                        int relativeExonPos;
                        switch (region.type) {
                            case 2: {
                                if (pos <= region.start + splicingDis) {
                                    relativeCodingStartPos = region.relativeCodingStartPos + 1;
                                    if (relativeCodingStartPos < 0) {
                                        --relativeCodingStartPos;
                                    }
                                    offSet1 = pos - region.start + 1;
                                    offSet2 = region.end - pos;
                                    relativeExonPos = region.relativeExonStartPos;
                                    if (this.noCodingExon) {
                                        gf = new GeneFeature(VarGeneFeatureType.NC_RNA.index, VarGeneFeatureType.SPLICING.index, offSet1, offSet2, this.exonNum, this.geneSymbIndex, this.geneIDIndex, this.refIDIndex, ":exon" + (region.index + 1) + ":n." + relativeExonPos + "-" + offSet1 + ref + ">" + alt + "(AGacceptor)", region.index);
                                        geneFeatureList.add(gf);
                                        break;
                                    }
                                    gf = new GeneFeature(VarGeneFeatureType.SPLICING.index, -1, offSet1, offSet2, this.exonNum, this.geneSymbIndex, this.geneIDIndex, this.refIDIndex, ":exon" + (region.index + 1) + ":c." + relativeCodingStartPos + "-" + offSet1 + ref + ">" + alt + "(AGacceptor)", region.index, relativeCodingStartPos);
                                    geneFeatureList.add(gf);
                                    break;
                                }
                                if (pos <= region.end - splicingDis) {
                                    StringBuilder sb;
                                    int offSet11 = pos - region.start + 1;
                                    offSet12 = region.end - pos;
                                    if (this.noCodingExon) {
                                        relativeExonPos = region.relativeExonStartPos;
                                        offSet1 = pos - region.start;
                                        offSet2 = region.end - pos + 1;
                                        sb = new StringBuilder(":intron" + region.index + ":n.");
                                        if (offSet1 < offSet2) {
                                            if (relativeExonPos < 0) {
                                                --relativeExonPos;
                                            }
                                            sb.append(relativeExonPos);
                                            sb.append('+');
                                            sb.append(offSet1);
                                        } else {
                                            if (relativeExonPos > 0) {
                                                ++relativeExonPos;
                                            }
                                            sb.append(relativeExonPos);
                                            sb.append('-');
                                            sb.append(offSet2);
                                        }
                                        sb.append(ref).append(">").append(alt);
                                        gf = new GeneFeature(VarGeneFeatureType.NC_RNA.index, VarGeneFeatureType.INTRONIC.index, offSet11, offSet12, this.exonNum, this.geneSymbIndex, this.geneIDIndex, this.refIDIndex, sb.toString(), region.index);
                                        geneFeatureList.add(gf);
                                        break;
                                    }
                                    relativeCodingStartPos = region.relativeCodingStartPos;
                                    if (relativeCodingStartPos < 0) {
                                        --relativeCodingStartPos;
                                    }
                                    offSet1 = pos - region.start + 1;
                                    offSet2 = region.end - pos + 1;
                                    sb = new StringBuilder(":intron" + region.index + ":c.");
                                    if (offSet1 < offSet2) {
                                        if (relativeCodingStartPos < 0) {
                                            --relativeCodingStartPos;
                                        }
                                        sb.append(++relativeCodingStartPos);
                                        sb.append('-');
                                        sb.append(offSet1);
                                    } else {
                                        sb.append(relativeCodingStartPos);
                                        sb.append('+');
                                        sb.append(offSet2);
                                    }
                                    sb.append(ref).append(">").append(alt);
                                    gf = new GeneFeature(VarGeneFeatureType.INTRONIC.index, -1, offSet11, offSet12, this.exonNum, this.geneSymbIndex, this.geneIDIndex, this.refIDIndex, sb.toString(), region.index);
                                    geneFeatureList.add(gf);
                                    break;
                                }
                                relativeCodingStartPos = region.relativeCodingStartPos;
                                if (relativeCodingStartPos < 0) {
                                    --relativeCodingStartPos;
                                }
                                offSet1 = pos - region.start + 1;
                                offSet2 = region.end - pos;
                                if (this.noCodingExon) {
                                    gf = new GeneFeature(VarGeneFeatureType.NC_RNA.index, VarGeneFeatureType.SPLICING.index, offSet1, offSet2, this.exonNum, this.geneSymbIndex, this.geneIDIndex, this.refIDIndex, ":exon" + region.index + ":n." + region.relativeExonStartPos + "+" + (offSet2 + 1) + ref + ">" + alt + "(GTdonor)", region.index);
                                    geneFeatureList.add(gf);
                                    break;
                                }
                                gf = new GeneFeature(VarGeneFeatureType.SPLICING.index, -1, offSet1, offSet2, this.exonNum, this.geneSymbIndex, this.geneIDIndex, this.refIDIndex, ":exon" + region.index + ":c." + relativeCodingStartPos + "+" + (offSet2 + 1) + ref + ">" + alt + "(GTdonor)", region.index, relativeCodingStartPos);
                                geneFeatureList.add(gf);
                                break;
                            }
                            case 1: {
                                if (this.noCodingExon) {
                                    offSet1 = pos - region.start + 1;
                                    offSet2 = region.end - pos;
                                    int relativeExonStartPos = region.relativeExonStartPos + offSet1 - 1;
                                    gf = new GeneFeature(VarGeneFeatureType.NC_RNA.index, VarGeneFeatureType.EXONIC.index, offSet1, offSet2, this.exonNum, this.geneSymbIndex, this.geneIDIndex, this.refIDIndex, ":exon" + region.index + ":n." + relativeExonStartPos + ref + ">" + alt, region.index, relativeExonStartPos);
                                    geneFeatureList.add(gf);
                                    break;
                                }
                                if (pos <= this.codingEndR) {
                                    offSet1 = pos - region.start + 1;
                                    offSet2 = region.end - pos;
                                    relativeCodingStartPos = this.codingEndR - pos;
                                    gf = new GeneFeature(VarGeneFeatureType.THREE_PRIME_UTR.index, -1, offSet1, offSet2, this.exonNum, this.geneSymbIndex, this.geneIDIndex, this.refIDIndex, ":exon" + region.index + ":c.*" + relativeCodingStartPos + ref + ">" + alt, region.index, relativeCodingStartPos);
                                    geneFeatureList.add(gf);
                                    break;
                                }
                                if (pos <= this.codingStartR) {
                                    offSet1 = pos - region.start + 1;
                                    offSet2 = region.end - pos;
                                    relativeCodingStartPos = region.relativeCodingStartPos + offSet2;
                                    gf = new GeneFeature(VarGeneFeatureType.EXONIC.index, -1, offSet1, offSet2, this.exonNum, this.geneSymbIndex, this.geneIDIndex, this.refIDIndex, ":exon" + region.index + ":c." + relativeCodingStartPos + ref + ">" + alt, region.index, relativeCodingStartPos);
                                    geneFeatureList.add(gf);
                                    int shorterEnd = Math.min(region.end, this.codingEnd);
                                    shorterStart = Math.max(region.start, this.codingStart);
                                    if (cutLen <= 0) break;
                                    if (cutDownstream) {
                                        gf.cutCodingLen = Math.min(cutLen, shorterEnd - pos + 1);
                                        break;
                                    }
                                    gf.cutCodingLen = Math.min(cutLen, pos - shorterStart + 1);
                                    gf.cutCodingLen = -gf.cutCodingLen;
                                    break;
                                }
                                offSet1 = pos - region.start + 1;
                                offSet2 = region.end - pos;
                                relativeCodingStartPos = region.relativeCodingStartPos + offSet2 - 1;
                                gf = new GeneFeature(VarGeneFeatureType.FIVE_PRIME_UTR.index, -1, offSet1, offSet2, this.exonNum, this.geneSymbIndex, this.geneIDIndex, this.refIDIndex, ":exon" + region.index + ":c." + relativeCodingStartPos + ref + ">" + alt, region.index, relativeCodingStartPos);
                                geneFeatureList.add(gf);
                                break;
                            }
                            case 0: {
                                relativeCodingStartPos = pos - region.end;
                                gf = this.noCodingExon ? new GeneFeature(VarGeneFeatureType.NC_RNA.index, VarGeneFeatureType.UPSTREAM.index, -999, -999, this.exonNum, this.geneSymbIndex, this.geneIDIndex, this.refIDIndex, ":n." + relativeCodingStartPos + ref + ">" + alt, region.index, relativeCodingStartPos) : new GeneFeature(VarGeneFeatureType.UPSTREAM.index, -1, -999, -999, this.exonNum, this.geneSymbIndex, this.geneIDIndex, this.refIDIndex, ":n." + relativeCodingStartPos + ref + ">" + alt, region.index, relativeCodingStartPos);
                                geneFeatureList.add(gf);
                                break;
                            }
                            case 3: {
                                offSet1 = pos - region.start;
                                gf = this.noCodingExon ? new GeneFeature(VarGeneFeatureType.NC_RNA.index, VarGeneFeatureType.DOWNSTREAM.index, -999, -999, this.exonNum, this.geneSymbIndex, this.geneIDIndex, this.refIDIndex, ":n." + relativeCodingStartPos + ref + ">" + alt, region.index, relativeCodingStartPos) : new GeneFeature(VarGeneFeatureType.DOWNSTREAM.index, -1, offSet1, -999, this.exonNum, this.geneSymbIndex, this.geneIDIndex, this.refIDIndex, ":n.*" + offSet1 + ref + ">" + alt, region.index);
                                geneFeatureList.add(gf);
                                break;
                            }
                        }
                        break;
                    }
                }
                if (selectedFeatureSet.isEmpty()) continue;
                int lastIndex = geneFeatureList.size() - 1;
                gf = geneFeatureList.get(lastIndex);
                isExonic = includeExonic && VarGeneFeatureType.EXONIC.index == gf.typeID;
                boolean isSelectedFeature = selectedFeatureSet.contains(gf.typeID);
                if (isExonic || isSelectedFeature) continue;
                geneFeatureList.removeByIndex(lastIndex);
            }
            return geneFeatureList;
        }
        catch (Exception e) {
            String info = e.getMessage() + " at structure variant in getVarFeature " + pos1 + " of transcript " + this.refID;
            this.logger.error(info);
        }
        return geneFeatureList;
    }

    public void calculateAminoAcidChange(GeneFeature gf, char ref, char alt, int absPos, int pos2CondingEnd, byte[] errorCode) {
        int shiftBpDel = 0;
        int relativeCodingStartPosIncDNA = gf.relativeCodingStartPos;
        int relativeCodingStartPosInRef = gf.relativeCodingStartPos;
        StringBuilder info = new StringBuilder(":c.");
        if (this.delSites != null) {
            shiftBpDel = Arrays.binarySearch(this.delSites, relativeCodingStartPosIncDNA + this.codingStartRelativeSiteInSequence);
            if (shiftBpDel < 0) {
                shiftBpDel = -shiftBpDel - 1;
            }
            relativeCodingStartPosIncDNA += shiftBpDel;
        }
        int shiftBpIns = 0;
        if (this.insSites != null) {
            shiftBpIns = Arrays.binarySearch(this.insSites, relativeCodingStartPosIncDNA + this.codingStartRelativeSiteInSequence);
            if (shiftBpIns < 0) {
                shiftBpIns = -shiftBpIns - 1;
            }
            relativeCodingStartPosIncDNA -= shiftBpIns;
        }
        int incodonIndex = relativeCodingStartPosIncDNA % 3;
        int curCodonStart = relativeCodingStartPosIncDNA - incodonIndex;
        if (incodonIndex < 0) {
            incodonIndex += 3;
        }
        info.append(relativeCodingStartPosIncDNA + 1);
        info.append(ref);
        info.append('>');
        info.append(alt);
        if (this.mRnaSequence == null) {
            errorCode[0] = 1;
            gf.sequencePos = info.toString();
            return;
        }
        curCodonStart += this.codingStartRelativeSiteInSequence;
        curCodonStart -= shiftBpDel;
        if ((curCodonStart += shiftBpIns) < 0) {
            gf.sequencePos = info.toString();
            return;
        }
        if ((curCodonStart += 3) > this.mRnaSequence.length()) {
            errorCode[0] = 2;
            gf.sequencePos = info.toString();
            return;
        }
        String codon = this.mRnaSequence.substring(curCodonStart - 3, curCodonStart).toUpperCase();
        if (codon.charAt(incodonIndex) != ref) {
            errorCode[0] = 3;
            gf.sequencePos = info.toString();
        } else {
            char refP = '?';
            char altP = '?';
            if (CodonTable.INSTANCE.codonMap.containsKey(codon) && (refP = (char)CodonTable.INSTANCE.codonMap.get(codon).charValue()) == '*' && pos2CondingEnd > 3) {
                errorCode[0] = 4;
                gf.sequencePos = info.toString();
                return;
            }
            info.append(':');
            info.append("p.");
            info.append(refP);
            int codonIndex = relativeCodingStartPosInRef / 3 + 1;
            StringBuilder sb = new StringBuilder(codon);
            sb.setCharAt(incodonIndex, alt);
            info.append(codonIndex);
            codon = sb.toString().toUpperCase();
            if (CodonTable.INSTANCE.codonMap.containsKey(codon)) {
                altP = CodonTable.INSTANCE.codonMap.get(codon).charValue();
                info.append(altP);
            } else {
                info.append('?');
            }
            if (altP == '?' || refP == '?') {
                gf.typeID = VarGeneFeatureType.EXONIC.index;
                gf.sequencePos = info.toString();
            } else if (refP == altP) {
                gf.typeID = VarGeneFeatureType.SYNONYMOUS.index;
                gf.sequencePos = info.toString();
            } else if (codonIndex == 1 && refP == 'M') {
                gf.typeID = VarGeneFeatureType.START_LOSS.index;
                gf.sequencePos = info.toString();
            } else if (refP != '*' && altP != '*') {
                gf.typeID = VarGeneFeatureType.MISSENSE.index;
                gf.sequencePos = info.toString();
            } else if (refP != '*') {
                gf.typeID = VarGeneFeatureType.STOP_GAINED.index;
                gf.sequencePos = info.toString();
            } else {
                gf.typeID = VarGeneFeatureType.STOP_LOSS.index;
                gf.sequencePos = info.toString();
            }
        }
    }

    public void calculateAminoAcidChangeMulti(GeneFeature gf, boolean isforward, String ref, String alt, int startPos, int pos2CondingEnd, byte[] errorCode) {
        int incodonStart;
        int shiftBpDel = 0;
        int relativeCodingStartPosIncDNA = gf.relativeCodingStartPos;
        int relativeCodingStartPosInRef = gf.relativeCodingStartPos;
        StringBuilder annot = new StringBuilder();
        StringBuilder info = new StringBuilder();
        if (this.delSites != null) {
            shiftBpDel = Arrays.binarySearch(this.delSites, relativeCodingStartPosIncDNA + this.codingStartRelativeSiteInSequence);
            if (shiftBpDel < 0) {
                shiftBpDel = -shiftBpDel - 1;
            }
            relativeCodingStartPosIncDNA += shiftBpDel;
        }
        int shiftBpIns = 0;
        if (this.insSites != null) {
            shiftBpIns = Arrays.binarySearch(this.insSites, relativeCodingStartPosIncDNA + this.codingStartRelativeSiteInSequence);
            if (shiftBpIns < 0) {
                shiftBpIns = -shiftBpIns - 1;
            }
            relativeCodingStartPosIncDNA -= shiftBpIns;
        }
        int curCodonStart = relativeCodingStartPosIncDNA - incodonStart;
        for (incodonStart = relativeCodingStartPosIncDNA % 3; incodonStart < 0; incodonStart += 3) {
        }
        annot.append(relativeCodingStartPosIncDNA + 1);
        if (this.mRnaSequence == null) {
            annot.append(ref);
            annot.append('>');
            annot.append(alt);
            errorCode[0] = 1;
            gf.sequencePos = annot.toString();
            return;
        }
        curCodonStart += this.codingStartRelativeSiteInSequence;
        curCodonStart -= shiftBpDel;
        if ((curCodonStart += shiftBpIns) < 0) {
            annot.append(ref);
            annot.append('>');
            annot.append(alt);
            gf.sequencePos = annot.toString();
            return;
        }
        StringBuilder sb = new StringBuilder();
        int accumlateSizeNum = 0;
        int totalLen = ref.length();
        int totalEnd = incodonStart + totalLen;
        int incodonEnd = Math.min(totalEnd, 3);
        int minID = 127;
        curCodonStart += 3;
        while (accumlateSizeNum < totalLen) {
            annot.append("c.");
            if (curCodonStart > this.mRnaSequence.length()) {
                errorCode[0] = 2;
                annot.append(ref);
                annot.append('>');
                annot.append(alt);
                annot.append(":exonic");
                minID = VarGeneFeatureType.EXONIC.index;
                annot.append('&');
                break;
            }
            String codon = this.mRnaSequence.substring(curCodonStart - 3, curCodonStart).toUpperCase();
            String changedSeq1 = codon.substring(incodonStart, incodonEnd);
            sb.delete(0, sb.length());
            for (int t = 0; t < incodonEnd - incodonStart; ++t) {
                if (ref.charAt(t + accumlateSizeNum) == '.') {
                    sb.append(changedSeq1.charAt(t));
                    continue;
                }
                sb.append(ref.charAt(t + accumlateSizeNum));
            }
            String tmpRef = sb.toString();
            sb.delete(0, sb.length());
            int len = alt.length();
            for (int t = 0; t < incodonEnd - incodonStart && t + accumlateSizeNum < len; ++t) {
                if (alt.charAt(t + accumlateSizeNum) == '.') {
                    sb.append(changedSeq1.charAt(t));
                    continue;
                }
                sb.append(alt.charAt(t + accumlateSizeNum));
            }
            String tmpAlt = sb.toString();
            annot.append(tmpRef);
            annot.append('>');
            annot.append(tmpAlt);
            if (!changedSeq1.equals(tmpRef)) {
                errorCode[0] = 3;
                gf.sequencePos = annot.toString();
                return;
            }
            char refP = '?';
            char altP = '?';
            if (CodonTable.INSTANCE.codonMap.containsKey(codon) && (refP = (char)CodonTable.INSTANCE.codonMap.get(codon).charValue()) == '*' && pos2CondingEnd > 3) {
                errorCode[0] = 4;
                gf.sequencePos = annot.toString();
                return;
            }
            annot.append(':');
            annot.append("p.");
            annot.append(refP);
            int codonIndex = relativeCodingStartPosInRef / 3 + 1;
            sb.delete(0, sb.length());
            sb.append(codon);
            for (int t = 0; t < tmpAlt.length(); ++t) {
                sb.setCharAt(incodonStart + t, tmpAlt.charAt(t));
            }
            annot.append(codonIndex);
            codon = sb.toString().toUpperCase();
            if (CodonTable.INSTANCE.codonMap.containsKey(codon)) {
                altP = CodonTable.INSTANCE.codonMap.get(codon).charValue();
                annot.append(altP);
            } else {
                annot.append('?');
            }
            annot.append(":");
            if (altP == '?' || refP == '?') {
                gf.typeID = VarGeneFeatureType.EXONIC.index;
                gf.sequencePos = info.toString();
            } else if (refP == altP) {
                annot.append("synonymous");
                minID = VarGeneFeatureType.SYNONYMOUS.index;
            } else if (codonIndex == 1 && refP == 'M') {
                annot.append("startloss");
                minID = VarGeneFeatureType.STOP_LOSS.index;
            } else if (refP != '*' && altP != '*') {
                annot.append("missense");
                minID = VarGeneFeatureType.MISSENSE.index;
            } else if (refP != '*') {
                annot.append("stopgain");
                minID = VarGeneFeatureType.STOP_GAINED.index;
            } else {
                annot.append("stoploss");
                minID = VarGeneFeatureType.STOP_LOSS.index;
            }
            curCodonStart += 3;
            accumlateSizeNum += incodonEnd - incodonStart;
            relativeCodingStartPosInRef += 3;
            incodonStart = 0;
            incodonEnd = totalLen - accumlateSizeNum;
            incodonEnd = Math.min(incodonEnd, 3);
            annot.append('&');
            info.append('&');
        }
        gf.typeID = (byte)minID;
        gf.sequencePos = gf.sequencePos + annot.substring(0, annot.length() - 1);
    }

    public int calculateAminoAcidIndex(int relativeCodingStartPosInRef) {
        int incodonIndex;
        int relativeCodingStartPosIncDNA = relativeCodingStartPosInRef;
        if (this.delSites != null) {
            int shiftBpDel = Arrays.binarySearch(this.delSites, relativeCodingStartPosIncDNA + this.codingStartRelativeSiteInSequence);
            if (shiftBpDel < 0) {
                shiftBpDel = -shiftBpDel - 1;
            }
            relativeCodingStartPosIncDNA += shiftBpDel;
        }
        if (this.insSites != null) {
            int shiftBpIns = Arrays.binarySearch(this.insSites, relativeCodingStartPosIncDNA + this.codingStartRelativeSiteInSequence);
            if (shiftBpIns < 0) {
                shiftBpIns = -shiftBpIns - 1;
            }
            relativeCodingStartPosIncDNA -= shiftBpIns;
        }
        if ((incodonIndex = relativeCodingStartPosIncDNA % 3) < 0) {
            incodonIndex += 3;
        }
        return incodonIndex;
    }

    public void calculateAminoAcidDeletion(GeneFeature gf, String ref, String alt, int delSeqLen) {
        int incLen;
        int shiftBpDel = 0;
        int relativeCodingStartPosIncDNA = gf.relativeCodingStartPos;
        if (this.delSites != null) {
            shiftBpDel = Arrays.binarySearch(this.delSites, relativeCodingStartPosIncDNA + this.codingStartRelativeSiteInSequence);
            if (shiftBpDel < 0) {
                shiftBpDel = -shiftBpDel - 1;
            }
            relativeCodingStartPosIncDNA += shiftBpDel;
        }
        int shiftBpIns = 0;
        if (this.insSites != null) {
            shiftBpIns = Arrays.binarySearch(this.insSites, relativeCodingStartPosIncDNA + this.codingStartRelativeSiteInSequence);
            if (shiftBpIns < 0) {
                shiftBpIns = -shiftBpIns - 1;
            }
            relativeCodingStartPosIncDNA -= shiftBpIns;
        }
        String delSeq = null;
        StringBuilder info = new StringBuilder(":c.");
        if (alt.endsWith("-")) {
            info.append(relativeCodingStartPosIncDNA += ref.length() - delSeqLen);
            if (delSeqLen > 1) {
                info.append("_").append(relativeCodingStartPosIncDNA + ref.length());
            }
            info.append("del");
            delSeq = ref.substring(ref.length() - delSeqLen);
            info.append(delSeq);
        } else if (alt.startsWith("-")) {
            info.append(relativeCodingStartPosIncDNA);
            if (delSeqLen > 1) {
                info.append("_").append(relativeCodingStartPosIncDNA + delSeqLen - 1);
            }
            info.append("del");
            delSeq = ref.substring(0, delSeqLen);
            info.append(delSeq);
        } else {
            info.append(relativeCodingStartPosIncDNA);
            if (delSeqLen > 1) {
                info.append("_").append(relativeCodingStartPosIncDNA + delSeqLen - 1);
            }
            info.append("del");
            info.append(alt);
        }
        if (delSeq == null) {
            return;
        }
        if (this.mRnaSequence == null) {
            gf.sequencePos = info.toString();
            return;
        }
        int incodonIndex = relativeCodingStartPosIncDNA % 3;
        int curCodonStart = relativeCodingStartPosIncDNA - incodonIndex;
        if (incodonIndex < 0) {
            incodonIndex += 3;
        }
        curCodonStart += this.codingStartRelativeSiteInSequence;
        curCodonStart -= shiftBpDel;
        if ((curCodonStart += shiftBpIns) < 0) {
            gf.sequencePos = info.toString();
            return;
        }
        List<String> orgCodons = new List<String>();
        List<String> shiftedCodons = new List<String>();
        curCodonStart += 3;
        for (incLen = 0; incLen < incodonIndex + delSeqLen && curCodonStart + incLen < this.mRnaSequence.length(); incLen += 3) {
            String codon = this.mRnaSequence.substring(curCodonStart - 3 + incLen, curCodonStart + incLen).toUpperCase();
            orgCodons.add(codon);
        }
        if (curCodonStart <= this.mRnaSequence.length()) {
            String shiftedCodon = this.mRnaSequence.substring(curCodonStart - 3, curCodonStart - 3 + incodonIndex);
            if (shiftedCodon.length() + delSeqLen < 3) {
                shiftedCodon = shiftedCodon + delSeq.toUpperCase();
            } else {
                incLen = 3 - shiftedCodon.length();
                shiftedCodon = shiftedCodon + delSeq.substring(0, incLen);
                shiftedCodons.add(shiftedCodon);
                incLen += 3;
                while (incLen < delSeqLen) {
                    shiftedCodons.add(delSeq.substring(incLen - 3, incLen));
                    incLen += 3;
                }
                shiftedCodon = delSeq.substring(incLen -= 3);
            }
            incLen = curCodonStart + incodonIndex - shiftedCodon.length();
            if (incLen < this.mRnaSequence.length()) {
                shiftedCodon = shiftedCodon + this.mRnaSequence.substring(curCodonStart - 3 + incodonIndex, incLen);
                shiftedCodons.add(shiftedCodon);
                if (delSeqLen % 3 != 0) {
                    incLen += 3;
                    while (incLen <= this.mRnaSequence.length()) {
                        shiftedCodon = this.mRnaSequence.substring(incLen - 3, incLen);
                        shiftedCodons.add(shiftedCodon);
                        incLen += 3;
                    }
                }
            }
        } else {
            gf.sequencePos = info.toString();
            return;
        }
        info.append(':');
        info.append("p.");
        int codonIndex = relativeCodingStartPosIncDNA / 3 + 1;
        info.append(codonIndex);
        for (String codon1 : orgCodons) {
            if (CodonTable.INSTANCE.codonMap.containsKey(codon1)) {
                Character refP = CodonTable.INSTANCE.codonMap.get(codon1);
                if (refP == null) {
                    this.logger.error("Unknown code for " + codon1);
                    refP = Character.valueOf('?');
                }
                info.append(refP);
                continue;
            }
            info.append('?');
        }
        info.append("del");
        boolean hasStopCodon = false;
        for (String codon1 : shiftedCodons) {
            if (CodonTable.INSTANCE.codonMap.containsKey(codon1)) {
                Character altP = CodonTable.INSTANCE.codonMap.get(codon1);
                if (altP == null) {
                    this.logger.error("Unknown code for " + codon1);
                    altP = Character.valueOf('?');
                    continue;
                }
                if (altP.charValue() == '*') {
                    info.append(altP);
                    hasStopCodon = true;
                    break;
                }
                info.append(altP);
                continue;
            }
            info.append('?');
        }
        gf.sequencePos = info.toString();
        gf.typeID = delSeqLen % 3 == 0 ? VarGeneFeatureType.NON_FRAME_SHIFT.index : VarGeneFeatureType.FRAME_SHIFT.index;
    }

    public void calculateAminoAcidDeletionAtRightTail(GeneFeature gf, String ref, String alt, int delSeqLen, int refGenomeEndPos) {
        int shiftBpDel = 0;
        int relativeCodingStartPosIncDNA = gf.relativeCodingStartPos;
        if (this.delSites != null) {
            shiftBpDel = Arrays.binarySearch(this.delSites, relativeCodingStartPosIncDNA + this.codingStartRelativeSiteInSequence);
            if (shiftBpDel < 0) {
                shiftBpDel = -shiftBpDel - 1;
            }
            relativeCodingStartPosIncDNA += shiftBpDel;
        }
        int shiftBpIns = 0;
        if (this.insSites != null) {
            shiftBpIns = Arrays.binarySearch(this.insSites, relativeCodingStartPosIncDNA + this.codingStartRelativeSiteInSequence);
            if (shiftBpIns < 0) {
                shiftBpIns = -shiftBpIns - 1;
            }
            relativeCodingStartPosIncDNA -= shiftBpIns;
        }
        int incodonIndex = relativeCodingStartPosIncDNA % 3;
        int curCodonStart = relativeCodingStartPosIncDNA - incodonIndex;
        if (incodonIndex < 0) {
            incodonIndex += 3;
        }
        StringBuilder info = new StringBuilder(":c.");
        if (alt.endsWith("-")) {
            int s = ref.length() - delSeqLen - 1;
            if (s >= 0) {
                info.append(ref.charAt(s));
            }
            info.append(relativeCodingStartPosIncDNA + (ref.length() - delSeqLen));
            info.append("del-");
            info.append(ref.substring(ref.length() - delSeqLen));
        } else {
            info.append(ref.charAt(0));
            info.append(relativeCodingStartPosIncDNA - (ref.length() - delSeqLen));
            info.append("del");
            info.append(ref, 0, delSeqLen);
            info.append("-");
        }
        if (this.mRnaSequence == null) {
            gf.sequencePos = info.toString();
            return;
        }
        curCodonStart += this.codingStartRelativeSiteInSequence;
        curCodonStart -= shiftBpDel;
        if ((curCodonStart += shiftBpIns) < 0) {
            gf.sequencePos = info.toString();
            return;
        }
        if ((curCodonStart += 3) > this.mRnaSequence.length()) {
            gf.sequencePos = info.toString();
            return;
        }
        String codon = this.mRnaSequence.substring(curCodonStart - 3, curCodonStart).toUpperCase();
        char refP = '?';
        int codonIndex = relativeCodingStartPosIncDNA / 3 + 1;
        if (CodonTable.INSTANCE.codonMap.containsKey(codon)) {
            refP = CodonTable.INSTANCE.codonMap.get(codon).charValue();
        }
        info.append(':');
        info.append("p.");
        info.append(refP);
        info.append(codonIndex);
        boolean hasStopLoss = false;
        char altP = '?';
        info.append("del");
        if (refP == '*' || refGenomeEndPos >= this.codingEnd) {
            hasStopLoss = true;
            info.append(altP);
            if (this.strand == '+') {
                info.append(":stoploss");
                gf.typeID = VarGeneFeatureType.STOP_LOSS.index;
            } else {
                info.append(":startloss");
                gf.typeID = VarGeneFeatureType.START_LOSS.index;
            }
        } else if (delSeqLen % 3 == 0) {
            info.append(":nonframeshift");
            gf.typeID = VarGeneFeatureType.NON_FRAME_SHIFT.index;
        } else {
            info.append(":frameshift");
            gf.typeID = VarGeneFeatureType.FRAME_SHIFT.index;
        }
        gf.sequencePos = info.toString();
    }

    public void calculateAminoAcidDeletionAtLeftTail(GeneFeature gf, String ref, String alt, int delSeqLen, int refGenomeEndPos) {
        int shiftBpDel = 0;
        int relativeCodingStartPosIncDNA = gf.relativeCodingStartPos;
        if (this.delSites != null) {
            shiftBpDel = Arrays.binarySearch(this.delSites, relativeCodingStartPosIncDNA + this.codingStartRelativeSiteInSequence);
            if (shiftBpDel < 0) {
                shiftBpDel = -shiftBpDel - 1;
            }
            relativeCodingStartPosIncDNA += shiftBpDel;
        }
        int shiftBpIns = 0;
        if (this.insSites != null) {
            shiftBpIns = Arrays.binarySearch(this.insSites, relativeCodingStartPosIncDNA + this.codingStartRelativeSiteInSequence);
            if (shiftBpIns < 0) {
                shiftBpIns = -shiftBpIns - 1;
            }
            relativeCodingStartPosIncDNA -= shiftBpIns;
        }
        int incodonIndex = relativeCodingStartPosIncDNA % 3;
        int curCodonStart = relativeCodingStartPosIncDNA - incodonIndex;
        if (incodonIndex < 0) {
            incodonIndex += 3;
        }
        StringBuilder info = new StringBuilder(":c.");
        if (alt.endsWith("-")) {
            int s = ref.length() - delSeqLen - 1;
            if (s >= 0) {
                info.append(ref.charAt(s));
            }
            info.append(relativeCodingStartPosIncDNA + (ref.length() - delSeqLen));
            info.append("del-");
            info.append(ref.substring(ref.length() - delSeqLen));
        } else {
            info.append(ref.charAt(0));
            info.append(relativeCodingStartPosIncDNA - (ref.length() - delSeqLen));
            info.append("del");
            info.append(ref.substring(0, delSeqLen));
            info.append("-");
        }
        if (this.mRnaSequence == null) {
            gf.sequencePos = info.toString();
            return;
        }
        curCodonStart += this.codingStartRelativeSiteInSequence;
        curCodonStart -= shiftBpDel;
        if ((curCodonStart += shiftBpIns) < 0) {
            gf.sequencePos = info.toString();
            return;
        }
        if ((curCodonStart += 3) > this.mRnaSequence.length()) {
            gf.sequencePos = info.toString();
            return;
        }
        String codon = this.mRnaSequence.substring(curCodonStart - 3, curCodonStart).toUpperCase();
        char refP = '?';
        int codonIndex = relativeCodingStartPosIncDNA / 3 + 1;
        if (CodonTable.INSTANCE.codonMap.containsKey(codon)) {
            refP = CodonTable.INSTANCE.codonMap.get(codon).charValue();
        }
        info.append(':');
        info.append("p.");
        info.append(refP);
        info.append(codonIndex);
        boolean hasStartLoss = false;
        char altP = '?';
        info.append("del");
        if (refP == 'M' || refGenomeEndPos < this.codingStart) {
            hasStartLoss = true;
            info.append(altP);
            if (this.strand == '+') {
                info.append(":startloss");
                gf.typeID = VarGeneFeatureType.START_LOSS.index;
            } else {
                info.append(":stoploss");
                gf.typeID = VarGeneFeatureType.STOP_LOSS.index;
            }
            gf.sequencePos = info.toString();
        } else {
            if (delSeqLen % 3 == 0) {
                info.append(":nonframeshift");
                gf.typeID = VarGeneFeatureType.NON_FRAME_SHIFT.index;
            } else {
                info.append(":frameshift");
                gf.typeID = VarGeneFeatureType.FRAME_SHIFT.index;
            }
            gf.sequencePos = info.toString();
        }
    }

    public void calculateAminoAcidInsertion(GeneFeature gf, String ref, String alt) {
        int inc;
        String instSeq;
        int shiftBpDel = 0;
        int relativeCodingStartPosIncDNA = gf.relativeCodingStartPos;
        if (this.delSites != null) {
            shiftBpDel = Arrays.binarySearch(this.delSites, relativeCodingStartPosIncDNA + this.codingStartRelativeSiteInSequence);
            if (shiftBpDel < 0) {
                shiftBpDel = -shiftBpDel - 1;
            }
            relativeCodingStartPosIncDNA += shiftBpDel;
        }
        int shiftBpIns = 0;
        if (this.insSites != null) {
            shiftBpIns = Arrays.binarySearch(this.insSites, relativeCodingStartPosIncDNA + this.codingStartRelativeSiteInSequence);
            if (shiftBpIns < 0) {
                shiftBpIns = -shiftBpIns - 1;
            }
            relativeCodingStartPosIncDNA -= shiftBpIns;
        }
        int insSeqLen = alt.length() - ref.length();
        StringBuilder info = new StringBuilder(":c.");
        if (alt.endsWith("+")) {
            info.append(relativeCodingStartPosIncDNA - 1);
            info.append('_');
            info.append(relativeCodingStartPosIncDNA);
            info.append("ins");
            instSeq = alt.substring(0, alt.length() - ref.length());
            info.append(instSeq);
        } else {
            info.append((relativeCodingStartPosIncDNA += ref.length()) - 1);
            info.append('_');
            info.append(relativeCodingStartPosIncDNA);
            info.append("ins");
            instSeq = alt.substring(ref.length());
            info.append(instSeq);
        }
        if (this.mRnaSequence == null) {
            gf.sequencePos = info.toString();
            return;
        }
        int incodonIndex = relativeCodingStartPosIncDNA % 3;
        int curCodonStart = relativeCodingStartPosIncDNA - incodonIndex;
        if (incodonIndex < 0) {
            incodonIndex += 3;
        }
        curCodonStart += this.codingStartRelativeSiteInSequence;
        curCodonStart -= shiftBpDel;
        if ((curCodonStart += shiftBpIns) < 0) {
            gf.sequencePos = info.toString();
            return;
        }
        List<String> shiftedCodons = new List<String>();
        if ((curCodonStart += 3) > this.mRnaSequence.length()) {
            gf.sequencePos = info.toString();
            return;
        }
        String orgCodon = this.mRnaSequence.substring(curCodonStart - 3, curCodonStart);
        String shiftedCodon = this.mRnaSequence.substring(curCodonStart - 3, curCodonStart - 3 + incodonIndex);
        if (shiftedCodon.length() + instSeq.length() < 3) {
            shiftedCodon = shiftedCodon + instSeq;
        } else {
            inc = 3 - shiftedCodon.length();
            shiftedCodon = shiftedCodon + instSeq.substring(0, inc);
            shiftedCodons.add(shiftedCodon);
            inc += 3;
            while (inc < insSeqLen) {
                shiftedCodons.add(instSeq.substring(inc - 3, inc));
                inc += 3;
            }
            shiftedCodon = instSeq.substring(inc -= 3);
        }
        inc = curCodonStart + incodonIndex - shiftedCodon.length();
        if (inc < this.mRnaSequence.length()) {
            shiftedCodon = shiftedCodon + this.mRnaSequence.substring(curCodonStart - 3 + incodonIndex, inc);
            shiftedCodons.add(shiftedCodon);
            if (insSeqLen % 3 != 0) {
                inc += 3;
                while (inc <= this.mRnaSequence.length()) {
                    shiftedCodon = this.mRnaSequence.substring(inc - 3, inc);
                    shiftedCodons.add(shiftedCodon);
                    inc += 3;
                }
            }
        }
        Character refP = Character.valueOf('?');
        info.append(':');
        info.append("p.");
        int codonIndex = relativeCodingStartPosIncDNA / 3 + 1;
        info.append(codonIndex);
        if (CodonTable.INSTANCE.codonMap.containsKey(orgCodon)) {
            refP = CodonTable.INSTANCE.codonMap.get(orgCodon);
            if (refP == null) {
                this.logger.error("Unknown code for " + orgCodon);
                refP = Character.valueOf('?');
            }
            info.append(refP);
        } else {
            info.append('?');
        }
        info.append("ins");
        boolean hasStopCodon = false;
        for (String codon1 : shiftedCodons) {
            if (CodonTable.INSTANCE.codonMap.containsKey(codon1)) {
                Character altP = CodonTable.INSTANCE.codonMap.get(codon1);
                if (altP == null) {
                    this.logger.error("Unknown code for " + codon1);
                    altP = Character.valueOf('?');
                    continue;
                }
                if (altP.charValue() == '*') {
                    info.append(altP);
                    hasStopCodon = true;
                    break;
                }
                info.append(altP);
                continue;
            }
            info.append('?');
        }
        gf.sequencePos = info.toString();
        gf.typeID = insSeqLen % 3 == 0 ? VarGeneFeatureType.NON_FRAME_SHIFT.index : VarGeneFeatureType.FRAME_SHIFT.index;
    }
}

