/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.annotation;

import cern.colt.list.DoubleArrayList;
import cern.jet.stat.Descriptive;
import edu.sysu.pmglab.analysis.CalcRegionSet;
import edu.sysu.pmglab.analysis.GenomeRegion;
import edu.sysu.pmglab.annotation.VarGeneFeatureType;
import edu.sysu.pmglab.annotation.database.gene.IGeneFeature;
import edu.sysu.pmglab.bytecode.ByteStream;
import edu.sysu.pmglab.bytecode.Bytes;
import edu.sysu.pmglab.bytecode.BytesSplitter;
import edu.sysu.pmglab.ccf.CCFReader;
import edu.sysu.pmglab.ccf.CCFTable;
import edu.sysu.pmglab.ccf.record.IRecord;
import edu.sysu.pmglab.ccf.type.FieldType;
import edu.sysu.pmglab.container.indexable.IndexableSet;
import edu.sysu.pmglab.container.indexable.LinkedSet;
import edu.sysu.pmglab.container.list.FloatList;
import edu.sysu.pmglab.container.list.IntList;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.container.list.LongList;
import edu.sysu.pmglab.container.rangelist.VarInt64RangeList;
import edu.sysu.pmglab.executor.Context;
import edu.sysu.pmglab.executor.ITask;
import edu.sysu.pmglab.executor.Status;
import edu.sysu.pmglab.executor.ThreadQueue;
import edu.sysu.pmglab.gtb.GTBManager;
import edu.sysu.pmglab.gtb.GTBReader;
import edu.sysu.pmglab.gtb.GTBReaderOption;
import edu.sysu.pmglab.gtb.genome.Variant;
import edu.sysu.pmglab.gtb.genome.coordinate.Chromosome;
import edu.sysu.pmglab.io.FileUtils;
import edu.sysu.pmglab.io.file.LiveFile;
import edu.sysu.pmglab.io.text.TextRecord;
import edu.sysu.pmglab.io.text.reader.CustomSeparator;
import edu.sysu.pmglab.io.text.reader.IHeaderParser;
import edu.sysu.pmglab.io.text.reader.TextReader;
import edu.sysu.pmglab.kgga.command.SetupApplication;
import edu.sysu.pmglab.kgga.command.setting.GeneSetAssocSetting;
import edu.sysu.pmglab.kgga.command.setting.InteractionSetting;
import edu.sysu.pmglab.kgga.io.GlobalPedIndividuals;
import edu.sysu.pmglab.stat.DynamicScanWindows;
import gnu.trove.iterator.TLongIterator;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.TObjectFloatMap;
import gnu.trove.map.hash.THashMap;
import gnu.trove.set.TIntSet;
import gnu.trove.set.hash.TIntHashSet;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetSocketAddress;
import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.function.BiConsumer;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import org.rosuda.REngine.REXPMismatchException;
import org.rosuda.REngine.REngineException;
import org.rosuda.REngine.Rserve.RConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Var2RegionMapper {
    private final Logger logger = LoggerFactory.getLogger("Mapping variants to genes");
    List<GenomeRegion> baseRegions;
    List<CalcRegionSet> calcRegionSetList;
    Map<String, GenomeRegion> labelRegionMap;
    TIntSet responseGeneFeature;
    Set<Integer> explanatoryGeneFeature;
    IndexableSet<String> geneSymbolMap;
    HashMap<String, List<GenomeRegion>> separateRegionMap = new HashMap();
    HashMap<String, List<CalcRegionSet>> separateRegionSetMap = new HashMap();

    public void setResponseGeneFeature(TIntSet responseGeneFeature) {
        this.responseGeneFeature = responseGeneFeature;
    }

    public void setGeneSymbolMap(IndexableSet<String> geneSymbolMap) {
        this.geneSymbolMap = geneSymbolMap;
    }

    public void setExplanatoryGeneFeature(Set<Integer> explanatoryGeneFeature) {
        this.explanatoryGeneFeature = explanatoryGeneFeature;
    }

    public void cleanAllGeneRegions() {
        if (this.baseRegions != null) {
            this.baseRegions.clear();
            this.labelRegionMap.clear();
        }
    }

    public List<GenomeRegion> getBaseRegions() {
        return this.baseRegions;
    }

    public void setBaseRegions(List<GenomeRegion> baseRegions) {
        this.baseRegions = baseRegions;
    }

    public Set<Integer> getExplanatoryGeneFeature() {
        return this.explanatoryGeneFeature;
    }

    public void standardizeVariantScoresWithThread(int threadNum) {
        DoubleArrayList scores = new DoubleArrayList();
        float max = Float.MIN_VALUE;
        float min = Float.MAX_VALUE;
        for (GenomeRegion gr : this.baseRegions) {
            for (float score : gr.getMutMaxScoreCase()) {
                if (Float.isNaN(score)) continue;
                if (min > score) {
                    min = score;
                } else if (max < score) {
                    max = score;
                }
                scores.add(score);
            }
        }
        scores.quickSort();
        ThreadQueue threadPool = new ThreadQueue(threadNum);
        for (GenomeRegion gr : this.baseRegions) {
            VariantScoreStandardizeThread variantScoreStandardizeThread = new VariantScoreStandardizeThread(scores);
            variantScoreStandardizeThread.setGeneRegion(gr);
            threadPool.addTask(variantScoreStandardizeThread);
        }
        threadPool.close();
        this.logger.info("Scores of genes are standardized!");
    }

    public void newStandardizeVariantScoresWithThread(int threadNum) {
        HashSet<Float> uniqueScoresSet = new HashSet<Float>();
        for (GenomeRegion genomeRegion : this.baseRegions) {
            float score;
            int i;
            FloatList mutCountScore = genomeRegion.getMutUniqueScoreCase();
            FloatList controlCountScore = genomeRegion.getMutUniqueScoreControl();
            int size = mutCountScore.size();
            for (i = 0; i < size; ++i) {
                score = mutCountScore.get(i);
                if (Float.isNaN(score)) continue;
                uniqueScoresSet.add(Float.valueOf(score));
            }
            size = controlCountScore.size();
            for (i = 0; i < size; ++i) {
                score = controlCountScore.get(i);
                if (Float.isNaN(score)) continue;
                uniqueScoresSet.add(Float.valueOf(score));
            }
        }
        DoubleArrayList scores = new DoubleArrayList();
        for (Float aFloat : uniqueScoresSet) {
            scores.add(aFloat.floatValue());
        }
        scores.quickSort();
        ThreadQueue threadQueue = new ThreadQueue(threadNum);
        for (GenomeRegion gr : this.baseRegions) {
            VariantScoreStandardizeThread variantScoreStandardizeThread = new VariantScoreStandardizeThread(scores);
            variantScoreStandardizeThread.setGeneRegion(gr);
            threadQueue.addTask(variantScoreStandardizeThread);
        }
        threadQueue.close();
        this.logger.info("Scores of genes are standardized!");
    }

    public void newStandardizeVariantScoresWithThread0(int threadNum) {
        DoubleArrayList scores = new DoubleArrayList();
        float max = Float.MIN_VALUE;
        float min = Float.MAX_VALUE;
        for (GenomeRegion gr : this.baseRegions) {
            float[] mutCountScore = gr.getMutMaxScoreCase();
            float[] controlCountScore = gr.getMutMaxScoreControl();
            for (float score : mutCountScore) {
                if (Float.isNaN(score)) continue;
                if (min > score) {
                    min = score;
                } else if (max < score) {
                    max = score;
                }
                scores.add(score);
            }
            for (float score : controlCountScore) {
                if (Float.isNaN(score)) continue;
                if (min > score) {
                    min = score;
                } else if (max < score) {
                    max = score;
                }
                scores.add(score);
            }
        }
        scores.quickSort();
        ThreadQueue threadPool = new ThreadQueue(threadNum);
        for (GenomeRegion gr : this.baseRegions) {
            VariantScoreStandardizeThread variantScoreStandardizeThread = new VariantScoreStandardizeThread(scores);
            variantScoreStandardizeThread.setGeneRegion(gr);
            threadPool.addTask(variantScoreStandardizeThread);
        }
        threadPool.close();
        this.logger.info("Scores of genes are standardized!");
    }

    public void standardizeVariantScoresWithThread(int threadNum, String[] fieldNames) throws Exception {
        DoubleArrayList scores = new DoubleArrayList();
        float max = Float.MIN_VALUE;
        float min = Float.MAX_VALUE;
        for (GenomeRegion gr : this.baseRegions) {
            for (String field : fieldNames) {
                FloatList mutCountScore = GenomeRegion.getFloatListValue(gr, field);
                int size = mutCountScore.size() / 2;
                for (int i = 0; i < size; ++i) {
                    float score = mutCountScore.get(i + i + 1);
                    if (Float.isNaN(score)) continue;
                    if (min > score) {
                        min = score;
                    } else if (max < score) {
                        max = score;
                    }
                    scores.add(score);
                }
            }
        }
        scores.quickSort();
        ThreadQueue threadPool = new ThreadQueue(threadNum);
        for (GenomeRegion gr : this.baseRegions) {
            for (String field : fieldNames) {
                FloatList floatList = GenomeRegion.getFloatListValue(gr, field);
                VariantScoreFloatListStandardizeThread variantScoreStandardizeThread = new VariantScoreFloatListStandardizeThread(scores);
                variantScoreStandardizeThread.setGeneRegion(gr, floatList, field);
                threadPool.addTask(variantScoreStandardizeThread);
            }
        }
        threadPool.close();
        this.logger.info("Scores of genes are standardized!");
    }

    public void standardizeRegionFeatureScores() {
        int j;
        List<double[]> scoreList = new List<double[]>();
        for (GenomeRegion gr : this.baseRegions) {
            scoreList.add(gr.getRegionScores());
        }
        int colNum = ((double[])scoreList.get(0)).length;
        DoubleArrayList[] cols = new DoubleArrayList[colNum];
        for (int j2 = 0; j2 < colNum; ++j2) {
            cols[j2] = new DoubleArrayList();
        }
        for (double[] originalRegion : scoreList) {
            for (j = 0; j < originalRegion.length; ++j) {
                if (Double.isNaN(originalRegion[j])) {
                    originalRegion[j] = 0.0;
                }
                cols[j].add(originalRegion[j]);
            }
        }
        double[] means = new double[cols.length];
        double[] sds = new double[cols.length];
        for (j = 0; j < cols.length; ++j) {
            means[j] = Descriptive.mean(cols[j]);
            sds[j] = Descriptive.sampleVariance(cols[j], means[j]);
            sds[j] = Math.sqrt(sds[j]);
            cols[j] = null;
        }
        for (GenomeRegion gr : this.baseRegions) {
            for (int j3 = 0; j3 < cols.length; ++j3) {
                gr.standardizeFeatureScore(j3, means[j3], sds[j3]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void imputeRegionalMissingScores(InetSocketAddress address) throws REngineException, REXPMismatchException, IOException {
        int rowNum = this.baseRegions.size();
        int colNum = this.baseRegions.get(0).getRegionScores().length;
        try (RConnection rcon = null;){
            int j;
            rcon = new RConnection(address.getHostName(), address.getPort());
            double[] countsMatrix = new double[rowNum * colNum];
            for (j = 0; j < rowNum; ++j) {
                double[] v = this.baseRegions.get(j).getRegionScores();
                System.arraycopy(v, 0, countsMatrix, j * v.length, v.length);
            }
            rcon.eval("library(missForest)");
            rcon.eval("library(doParallel)");
            rcon.eval("library(rngtools)");
            rcon.eval("num_cores <- " + colNum);
            rcon.eval("registerDoParallel(num_cores)");
            rcon.assign("valMat", countsMatrix);
            rcon.eval("valMat<-matrix(valMat, nrow=" + rowNum + ", ncol=" + colNum + ", byrow = TRUE)");
            rcon.eval("tmpD <- missForest(valMat, maxiter = 4,\n                                      ntree = 25,\n                                      parallelize = 'forests',\n                                      nodesize = c(20, 40),\n                                      maxnodes = 50)$ximp");
            countsMatrix = rcon.eval("t(tmpD)").asDoubles();
            for (j = 0; j < rowNum; ++j) {
                double[] newMatrix = new double[colNum];
                System.arraycopy(countsMatrix, j * colNum, newMatrix, 0, colNum);
                this.baseRegions.get(j).setRegionScores(newMatrix);
            }
        }
    }

    public void imputeRegionalMissingScores0(InetSocketAddress address) throws REngineException, REXPMismatchException {
        int rowNum = this.baseRegions.size();
        int colNum = this.baseRegions.get(0).getRegionScores().length;
        RConnection rcon = new RConnection(address.getHostName(), address.getPort());
        int matrixRow = 100000;
        int lastRow = 0;
        rcon.eval("library(missForest)");
        rcon.eval("library(doParallel)");
        rcon.eval("library(rngtools)");
        double[] countsMatrix = new double[matrixRow * colNum];
        for (int j = 0; j < rowNum; ++j) {
            double[] newMatrix;
            int i;
            double[] countsMatrixAfterImput;
            double[] v;
            int circleIndex = j % matrixRow;
            if ((circleIndex != 0 || j == 0) && j < rowNum - 1) {
                v = this.baseRegions.get(j).getRegionScores();
                System.arraycopy(v, 0, countsMatrix, circleIndex * v.length, v.length);
                continue;
            }
            if (lastRow == 0) {
                rcon.assign("valMat", countsMatrix);
                rcon.eval("valMat<-matrix(valMat, nrow=" + matrixRow + ", ncol=" + colNum + ", byrow = TRUE)");
                rcon.eval("num_cores <- " + (colNum - 1));
                rcon.eval("registerDoParallel(num_cores)");
                rcon.eval("tmp <- missForest(valMat, maxiter = 4,\n                                          ntree = 25,\n                                          parallelize = 'forests',\n                                          mtry = floor(sqrt(ncol(valMat))),\n                                          nodesize = c(20, 40),\n                                          maxnodes = 50)$ximp");
                countsMatrixAfterImput = rcon.eval("t(tmp)").asDoubles();
                for (i = (j / matrixRow - 1) * matrixRow; i < j; ++i) {
                    newMatrix = new double[colNum];
                    System.arraycopy(countsMatrixAfterImput, i % matrixRow * colNum, newMatrix, 0, colNum);
                    this.baseRegions.get(i).setRegionScores(newMatrix);
                }
                if (rowNum - j < matrixRow) {
                    lastRow = rowNum - j;
                    countsMatrix = new double[lastRow * colNum];
                } else {
                    countsMatrix = new double[matrixRow * colNum];
                }
                v = this.baseRegions.get(j).getRegionScores();
                System.arraycopy(v, 0, countsMatrix, j % matrixRow * v.length, v.length);
                continue;
            }
            v = this.baseRegions.get(j).getRegionScores();
            System.arraycopy(v, 0, countsMatrix, circleIndex * v.length, v.length);
            rcon.assign("valMat", countsMatrix);
            rcon.eval("valMat<-matrix(valMat, nrow=" + lastRow + ", ncol=" + colNum + ", byrow = TRUE)");
            rcon.eval("num_cores <- " + (colNum - 1));
            rcon.eval("registerDoParallel(num_cores)");
            rcon.eval("tmp <- missForest(valMat, maxiter = 4,\n                                          ntree = 25,\n                                          parallelize = 'forests',\n                                          mtry = floor(sqrt(ncol(valMat))),\n                                          nodesize = c(20, 40),\n                                          maxnodes = 50)$ximp");
            countsMatrixAfterImput = rcon.eval("t(tmp)").asDoubles();
            for (i = 0; i < lastRow; ++i) {
                newMatrix = new double[colNum];
                System.arraycopy(countsMatrixAfterImput, i * colNum, newMatrix, 0, colNum);
                this.baseRegions.get(rowNum - (lastRow - i)).setRegionScores(newMatrix);
            }
        }
    }

    public List<byte[][]> sampleGenotypesGenes(File varAnnotFile, IndexableSet<String> susceptibleGenes, int threadNum, int maxQTLPerGene) throws IOException {
        GTBManager manager = new GTBManager(varAnnotFile);
        File geneAnnotationFile = FileUtils.getSubFile(varAnnotFile.getParentFile().getParentFile(), "/AssignVar2GeneTask/genes.annot.hg38.ccf");
        Map<String, GenomeRegion> geneRegionMap = this.readAssignedVarPointersOfGenes(geneAnnotationFile);
        List<GenomeRegion> geneRegions = new List<GenomeRegion>(geneRegionMap.values());
        geneRegions.sort(Comparator.comparingLong(GenomeRegion::getStartPointer).thenComparingLong(GenomeRegion::getEndPointer));
        LongList pointersAnnotFile = new LongList();
        int geneNum = geneRegions.size();
        String[] necessaryFields = new String[]{"SOURCE@FILE_ID", "SOURCE@FILE_POINTER"};
        LinkedSet<String> neededFields = new LinkedSet<String>(necessaryFields);
        ThreadQueue threadqueue = new ThreadQueue(threadNum);
        GTBReader annotReader = new GTBReader((GTBReaderOption)new GTBReaderOption(manager, false, false).addFields(neededFields));
        THashMap<String, GTBReader> gtyReaders = new THashMap<String, GTBReader>();
        THashMap<String, IntList> gtyIndividualIDs = new THashMap<String, IntList>();
        List<byte[][]> genotypeCodes = new List<byte[][]>();
        int subjectNum = GlobalPedIndividuals.size();
        for (int i = 0; i < geneNum; ++i) {
            long pointer;
            GenomeRegion gene = geneRegions.get(i);
            String name = this.geneSymbolMap.valueOf(Integer.parseInt(gene.getLabel()));
            if (!susceptibleGenes.contains(name)) continue;
            if (name.equals("MIR137HG") || name.equals("SOX2-OT")) {
                boolean bl = false;
            }
            VarInt64RangeList pb = gene.getOutcomeVarPointers();
            pointersAnnotFile.clear();
            if (pb == null) continue;
            TLongIterator pbIters = pb.iterator();
            while (pbIters.hasNext()) {
                pointer = pbIters.next();
                pointersAnnotFile.add(pointer);
            }
            if (pointersAnnotFile.isEmpty()) continue;
            pointersAnnotFile.sort();
            int size = pointersAnnotFile.size();
            IntList indexes = new IntList();
            for (int m = 0; m < size; ++m) {
                indexes.add(m);
            }
            if (size > maxQTLPerGene) {
                indexes.shuffle(size);
                size = maxQTLPerGene;
            }
            byte[][] genotypes = new byte[size][subjectNum];
            int j = 0;
            while (j < size) {
                IntList subjectIDs;
                int m = indexes.fastGet(j);
                annotReader.seek(pointersAnnotFile.get(m));
                Variant annotVariant = annotReader.read();
                String fileId = (String)annotVariant.getProperty("SOURCE@FILE_ID");
                pointer = (Long)annotVariant.getProperty("SOURCE@FILE_POINTER");
                GTBReader gtyReader = (GTBReader)gtyReaders.get(fileId);
                if (gtyReader == null) {
                    gtyReader = new GTBReader(fileId);
                    gtyReaders.put(fileId, gtyReader);
                    subjectIDs = GlobalPedIndividuals.size() > 0 ? GlobalPedIndividuals.getIndividuals().getUIDs().findIndicesIn(gtyReader.getIndividuals()) : null;
                    gtyIndividualIDs.put(fileId, subjectIDs);
                } else {
                    subjectIDs = (IntList)gtyIndividualIDs.get(fileId);
                }
                gtyReader.seek(pointer);
                Variant gtyVariant = gtyReader.read();
                IntList finalSubjectIDs = subjectIDs;
                int finalJ = j++;
                threadqueue.addTask((status, context) -> {
                    annotVariant.setGenotypes(gtyVariant.getGenotypes().subGenotypes(finalSubjectIDs).toBiallelic(gtyVariant.indexOfAllele(annotVariant.alleleOfIndex(0)), gtyVariant.indexOfAllele(annotVariant.alleleOfIndex(1)), -1));
                    int[][] codes = annotVariant.getGenotypes().getGenotypeCodes();
                    gtyVariant.setGenotypes(null);
                    annotVariant.setGenotypes(null);
                    for (int t = 0; t < codes[0].length; ++t) {
                        genotypes[finalJ][t] = (byte)(codes[0][t] + codes[1][t]);
                    }
                });
            }
            threadqueue.await();
            genotypeCodes.add(genotypes);
        }
        threadqueue.close();
        geneRegions.clear();
        return genotypeCodes;
    }

    public List<byte[][]> sampleGenotypesGenes(File varAnnotFile, IndexableSet<String> susceptibleGenes, int threadNum, int maxQTLPerGene, IndexableSet<String> collectedEQTLGenes, IndexableSet<String> noneQTLGenes) throws IOException {
        int i;
        GTBManager manager = new GTBManager(varAnnotFile);
        File geneAnnotationFile = FileUtils.getSubFile(varAnnotFile.getParentFile().getParentFile(), "/AssignVar2GeneTask/genes.annot.hg38.ccf");
        Map<String, GenomeRegion> geneRegionMap = this.readAssignedVarPointersOfGenes(geneAnnotationFile);
        List<GenomeRegion> geneRegions = new List<GenomeRegion>(geneRegionMap.values());
        geneRegions.sort(Comparator.comparingLong(GenomeRegion::getStartPointer).thenComparingLong(GenomeRegion::getEndPointer));
        LongList pointersAnnotFile = new LongList();
        int geneNum = geneRegions.size();
        String[] necessaryFields = new String[]{"SOURCE@FILE_ID", "SOURCE@FILE_POINTER"};
        LinkedSet<String> neededFields = new LinkedSet<String>(necessaryFields);
        ThreadQueue threadqueue = new ThreadQueue(threadNum);
        GTBReader annotReader = new GTBReader((GTBReaderOption)new GTBReaderOption(manager, false, false).addFields(neededFields));
        THashMap<String, GTBReader> gtyReaders = new THashMap<String, GTBReader>();
        THashMap<String, IntList> gtyIndividualIDs = new THashMap<String, IntList>();
        List<byte[][]> genotypeCodes = new List<byte[][]>();
        int subjectNum = GlobalPedIndividuals.size();
        IntList subjectIndexes = new IntList();
        for (i = 0; i < subjectNum; ++i) {
            subjectIndexes.add(i);
        }
        subjectNum = subjectIndexes.size();
        for (i = 0; i < geneNum; ++i) {
            long pointer;
            GenomeRegion gene = geneRegions.get(i);
            String name = this.geneSymbolMap.valueOf(Integer.parseInt(gene.getLabel()));
            if (!susceptibleGenes.contains(name)) {
                noneQTLGenes.add(name);
                continue;
            }
            if (name.equals("MIR137HG") || name.equals("SOX2-OT")) {
                boolean bl = false;
            }
            VarInt64RangeList pb = gene.getOutcomeVarPointers();
            pointersAnnotFile.clear();
            if (pb == null) continue;
            TLongIterator pbIters = pb.iterator();
            while (pbIters.hasNext()) {
                pointer = pbIters.next();
                pointersAnnotFile.add(pointer);
            }
            if (pointersAnnotFile.isEmpty()) continue;
            pointersAnnotFile.sort();
            int size = pointersAnnotFile.size();
            IntList indexes = new IntList();
            for (int m = 0; m < size; ++m) {
                indexes.add(m);
            }
            if (size > maxQTLPerGene) {
                indexes.shuffle(size);
                size = maxQTLPerGene;
            }
            byte[][] genotypes = new byte[size][subjectNum];
            int j = 0;
            while (j < size) {
                IntList subjectIDs;
                int m = indexes.fastGet(j);
                annotReader.seek(pointersAnnotFile.get(m));
                Variant annotVariant = annotReader.read();
                String fileId = (String)annotVariant.getProperty("SOURCE@FILE_ID");
                pointer = (Long)annotVariant.getProperty("SOURCE@FILE_POINTER");
                GTBReader gtyReader = (GTBReader)gtyReaders.get(fileId);
                if (gtyReader == null) {
                    gtyReader = new GTBReader(fileId);
                    gtyReaders.put(fileId, gtyReader);
                    subjectIDs = GlobalPedIndividuals.size() > 0 ? GlobalPedIndividuals.getIndividuals().getUIDs().findIndicesIn(gtyReader.getIndividuals()) : null;
                    gtyIndividualIDs.put(fileId, subjectIDs);
                } else {
                    subjectIDs = (IntList)gtyIndividualIDs.get(fileId);
                }
                gtyReader.seek(pointer);
                Variant gtyVariant = gtyReader.read();
                IntList finalSubjectIDs = subjectIDs;
                int finalSubjectNum = subjectNum;
                int finalJ = j++;
                threadqueue.addTask((status, context) -> {
                    annotVariant.setGenotypes(gtyVariant.getGenotypes().subGenotypes(finalSubjectIDs).toBiallelic(gtyVariant.indexOfAllele(annotVariant.alleleOfIndex(0)), gtyVariant.indexOfAllele(annotVariant.alleleOfIndex(1)), -1));
                    int[][] codes = annotVariant.getGenotypes().getGenotypeCodes();
                    gtyVariant.setGenotypes(null);
                    annotVariant.setGenotypes(null);
                    for (int t = 0; t < finalSubjectNum; ++t) {
                        genotypes[finalJ][t] = (byte)(codes[0][subjectIndexes.fastGet(t)] + codes[1][subjectIndexes.fastGet(t)]);
                    }
                });
            }
            threadqueue.await();
            genotypeCodes.add(genotypes);
            collectedEQTLGenes.add(name);
        }
        threadqueue.close();
        geneRegions.clear();
        return genotypeCodes;
    }

    public void assignVars2GenesWithPredictors(String adjustedACMeta, String caseACMeta, File varAnnotFile, String mutationSubjectCaseField, String mutationCountCaseField, String mutationSubjectControlField, String mutationCountControlField, String mutationScoreCountField, List<String> addedValueFields, IndexableSet<String> geneSymbMap, Map<Integer, Map<Integer, int[]>> geneSubRegionLength, boolean uniqeSubjectInARegion, int threadNum, double freqRatio, String[] freqFieldNames) throws IOException {
        GTBManager manager = new GTBManager(varAnnotFile);
        File geneAnnotationFile = FileUtils.getSubFile(varAnnotFile.getParentFile().getParentFile(), "/AssignVar2GeneTask/genes.annot.hg38.ccf");
        Map<String, GenomeRegion> geneRegionMap = this.readAssignedVarPointersOfGenes(geneAnnotationFile);
        List<GenomeRegion> geneRegions = new List<GenomeRegion>(geneRegionMap.values());
        geneRegions.sort(Comparator.comparingLong(GenomeRegion::getStartPointer).thenComparingLong(GenomeRegion::getEndPointer));
        LongList pointersAnnotFile = new LongList();
        int geneNum = geneRegions.size();
        String[] necessaryFields = new String[]{"GTYSUM@RefHomGtyNum_CASE", "GTYSUM@HetGtyNum_CASE", "GTYSUM@AltHomGtyNum_CASE", "GTYSUM@RefHomGtyNum_CONTROL", "GTYSUM@HetGtyNum_CONTROL", "GTYSUM@AltHomGtyNum_CONTROL", "GTYSUM@COUNT_ALT_CASE", "GTYSUM@COUNT_ALT_CONTROL"};
        LinkedSet<String> neededFields = new LinkedSet<String>(necessaryFields);
        boolean hasAdjCase = false;
        if (manager.containsField("GTYSUM@ADJ_ALT_CASE")) {
            hasAdjCase = true;
            ((AbstractCollection)neededFields).add("GTYSUM@ADJ_ALT_CASE");
            ((AbstractCollection)neededFields).add("GTYSUM@ADJ_FREQ");
        }
        boolean hasControlSample = manager.containsField("GTYSUM@RefHomGtyNum_CONTROL");
        ((AbstractCollection)neededFields).add(mutationSubjectCaseField);
        ((AbstractCollection)neededFields).add(mutationSubjectControlField);
        ((AbstractCollection)neededFields).add(mutationScoreCountField);
        neededFields.addAll((String[])freqFieldNames);
        neededFields.addAll(addedValueFields);
        GTBReader annotReader = new GTBReader((GTBReaderOption)new GTBReaderOption(manager, false, false).addFields(neededFields));
        List<Variant> variantsCaseHigh = new List<Variant>();
        List<Variant> variantsControlHigh = new List<Variant>();
        boolean isIntArray = manager.getField(mutationSubjectCaseField).type() == FieldType.int32List;
        this.baseRegions = new List();
        float scale = 1000.0f;
        final ThreadQueue threadqueue = new ThreadQueue(threadNum);
        double controlFreq = 0.0;
        for (int i = 0; i < geneNum; ++i) {
            GenomeRegion gene = geneRegions.get(i);
            VarInt64RangeList pb = gene.getOutcomeVarPointers();
            pointersAnnotFile.clear();
            if (pb == null) continue;
            TLongIterator pbIters = pb.iterator();
            while (pbIters.hasNext()) {
                long pointer = pbIters.next();
                pointersAnnotFile.add(pointer);
            }
            if (pointersAnnotFile.isEmpty()) continue;
            pointersAnnotFile.sort();
            int size = pointersAnnotFile.size();
            variantsCaseHigh.clear();
            variantsControlHigh.clear();
            for (int m = 0; m < size; ++m) {
                annotReader.seek(pointersAnnotFile.get(m));
                Variant annotVariant = annotReader.read();
                int AACase = (Integer)annotVariant.getProperty("GTYSUM@RefHomGtyNum_CASE");
                int AaCase = (Integer)annotVariant.getProperty("GTYSUM@HetGtyNum_CASE");
                int aaCase = (Integer)annotVariant.getProperty("GTYSUM@AltHomGtyNum_CASE");
                double caseFreq = AACase + AaCase + aaCase;
                aaCase = (Integer)annotVariant.getProperty("GTYSUM@COUNT_ALT_CASE");
                caseFreq = (double)aaCase / caseFreq;
                if (hasControlSample) {
                    int AAControl = (Integer)annotVariant.getProperty("GTYSUM@RefHomGtyNum_CONTROL");
                    int AaControl = (Integer)annotVariant.getProperty("GTYSUM@HetGtyNum_CONTROL");
                    int aaControl = (Integer)annotVariant.getProperty("GTYSUM@AltHomGtyNum_CONTROL");
                    controlFreq = AAControl + AaControl + aaControl;
                    aaControl = (Integer)annotVariant.getProperty("GTYSUM@COUNT_ALT_CONTROL");
                    controlFreq = (double)aaControl / controlFreq;
                }
                if (Double.isNaN(freqRatio)) {
                    variantsCaseHigh.add(annotVariant);
                    continue;
                }
                if (caseFreq >= freqRatio * controlFreq) {
                    variantsCaseHigh.add(annotVariant);
                    continue;
                }
                if (!(controlFreq >= freqRatio * caseFreq)) continue;
                variantsControlHigh.add(annotVariant);
            }
            if (variantsCaseHigh.isEmpty()) continue;
            if (!variantsControlHigh.isEmpty()) {
                variantsCaseHigh.addAll(variantsControlHigh);
            }
            CollectGeneVariantsThread collectGeneVariantsThread = new CollectGeneVariantsThread(addedValueFields, mutationSubjectCaseField, uniqeSubjectInARegion, isIntArray, mutationCountCaseField, mutationScoreCountField, mutationSubjectControlField, mutationCountControlField, freqFieldNames, hasAdjCase, adjustedACMeta){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void fireTaskComplete() {
                    if (this.newGeneRegion != null && Var2RegionMapper.this.baseRegions != null) {
                        ThreadQueue threadQueue = threadqueue;
                        synchronized (threadQueue) {
                            Var2RegionMapper.this.baseRegions.add(this.newGeneRegion);
                        }
                    }
                }
            };
            collectGeneVariantsThread.setGene(variantsCaseHigh, gene);
            threadqueue.addTask(collectGeneVariantsThread);
        }
        threadqueue.close();
        geneRegions.clear();
        int geneSize = this.baseRegions.size();
        addedValueFields.add("RegionLength");
        this.labelRegionMap = new THashMap<String, GenomeRegion>(geneSize);
        List<GenomeRegion> allRegionsTmp = new List<GenomeRegion>(geneSize);
        for (int i = 0; i < geneSize; ++i) {
            int[] length;
            GenomeRegion gr = this.baseRegions.get(i);
            String regionLabel = gr.getLabel() + "#" + gr.getType();
            if (this.labelRegionMap.containsKey(regionLabel)) continue;
            double[] featureScores = gr.getRegionScores();
            double[] featureScores1 = new double[featureScores.length + 1];
            System.arraycopy(featureScores, 0, featureScores1, 0, featureScores.length);
            Map<Integer, int[]> typeLength = geneSubRegionLength.get(Integer.parseInt(gr.getLabel()));
            featureScores1[featureScores.length] = typeLength == null ? 0.0 : ((length = typeLength.get(gr.getType())) == null ? 0.0 : (double)((float)length[0] / scale));
            gr.setRegionScores(featureScores1);
            allRegionsTmp.add(gr);
            this.labelRegionMap.put(regionLabel, gr);
        }
        this.baseRegions.clear();
        this.baseRegions.addAll(allRegionsTmp);
        allRegionsTmp.clear();
    }

    public void assignVars2GenesWithPredictors(File varAnnotFile, String mutationSubjectCaseField, String mutationCountField, String mutationScoreCountField, List<String> addedValueFields, IndexableSet<String> geneSymbMap, Map<Integer, Map<Integer, int[]>> geneSubRegionLength, boolean uniqeSubjectInARegion, int threadNum) throws IOException {
        GTBManager manager = new GTBManager(varAnnotFile);
        File geneAnnotationFile = FileUtils.getSubFile(varAnnotFile.getParentFile().getParentFile(), "/AssignVar2GeneTask/genes.annot.hg38.ccf");
        Map<String, GenomeRegion> geneRegionMap = this.readAssignedVarPointersOfGenes(geneAnnotationFile);
        List<GenomeRegion> geneRegions = new List<GenomeRegion>(geneRegionMap.values());
        geneRegions.sort(Comparator.comparingLong(GenomeRegion::getStartPointer).thenComparingLong(GenomeRegion::getEndPointer));
        LongList pointersAnnotFile = new LongList();
        int geneNum = geneRegions.size();
        GTBReader annotReader = new GTBReader(new GTBReaderOption(manager, false, true));
        double scoreVal = Double.NaN;
        List<Variant> variantsTmp = new List<Variant>();
        boolean isIntArray = manager.getField(mutationSubjectCaseField).type() == FieldType.int32List;
        Object alleleNumsScoreDep = null;
        int maxPos = Integer.MIN_VALUE;
        int minPos = Integer.MAX_VALUE;
        this.baseRegions = new List();
        float scale = 1000.0f;
        final ThreadQueue threadqueue = new ThreadQueue(threadNum);
        for (int i = 0; i < geneNum; ++i) {
            GenomeRegion gene = geneRegions.get(i);
            VarInt64RangeList pb = gene.getOutcomeVarPointers();
            pointersAnnotFile.clear();
            if (pb == null) continue;
            TLongIterator pbIters = pb.iterator();
            while (pbIters.hasNext()) {
                long pointer = pbIters.next();
                pointersAnnotFile.add(pointer);
            }
            if (pointersAnnotFile.isEmpty()) continue;
            pointersAnnotFile.sort();
            int size = pointersAnnotFile.size();
            variantsTmp.clear();
            for (int m = 0; m < size; ++m) {
                annotReader.seek(pointersAnnotFile.get(m));
                Variant annotVariant = annotReader.read();
                variantsTmp.add(annotVariant);
            }
            if (variantsTmp.isEmpty()) continue;
            CollectGeneVariantsThread collectGeneVariantsThread = new CollectGeneVariantsThread(addedValueFields, mutationSubjectCaseField, uniqeSubjectInARegion, isIntArray, mutationCountField, mutationScoreCountField){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void fireTaskComplete() {
                    if (this.newGeneRegion != null && Var2RegionMapper.this.baseRegions != null) {
                        ThreadQueue threadQueue = threadqueue;
                        synchronized (threadQueue) {
                            Var2RegionMapper.this.baseRegions.add(this.newGeneRegion);
                        }
                    }
                }
            };
            collectGeneVariantsThread.setGene(variantsTmp, gene);
            threadqueue.addTask(collectGeneVariantsThread);
        }
        threadqueue.close();
        geneRegions.clear();
        int geneSize = this.baseRegions.size();
        addedValueFields.add("RegionLength");
        this.labelRegionMap = new THashMap<String, GenomeRegion>(geneSize);
        List<GenomeRegion> allRegionsTmp = new List<GenomeRegion>(geneSize);
        for (int i = 0; i < geneSize; ++i) {
            int[] length;
            GenomeRegion gr = this.baseRegions.get(i);
            String regionLabel = gr.getLabel() + "#" + gr.getType();
            if (this.labelRegionMap.containsKey(regionLabel)) continue;
            double[] featureScores = gr.getRegionScores();
            double[] featureScores1 = new double[featureScores.length + 1];
            System.arraycopy(featureScores, 0, featureScores1, 0, featureScores.length);
            Map<Integer, int[]> typeLength = geneSubRegionLength.get(Integer.parseInt(gr.getLabel()));
            featureScores1[featureScores.length] = typeLength == null ? 0.0 : ((length = typeLength.get(gr.getType())) == null ? 0.0 : (double)((float)length[0] / scale));
            gr.setRegionScores(featureScores1);
            allRegionsTmp.add(gr);
            this.labelRegionMap.put(regionLabel, gr);
        }
        this.baseRegions.clear();
        this.baseRegions.addAll(allRegionsTmp);
        allRegionsTmp.clear();
    }

    public void generateCalcGeneRegionSet() {
        if (this.baseRegions == null || this.baseRegions.isEmpty()) {
            return;
        }
        this.calcRegionSetList = new List();
        for (GenomeRegion gr : this.baseRegions) {
            CalcRegionSet calcRegionSet = new CalcRegionSet();
            calcRegionSet.addRegion(gr);
            calcRegionSet.preComputeAllMutScores();
            this.calcRegionSetList.add(calcRegionSet);
        }
    }

    public List<CalcRegionSet> generateCalcGeneRegionSet(List<GenomeRegion> baseRegions) throws IOException {
        if (baseRegions == null || baseRegions.isEmpty()) {
            return null;
        }
        List<CalcRegionSet> calcRegionSetList = new List<CalcRegionSet>();
        for (GenomeRegion gr : baseRegions) {
            CalcRegionSet calcRegionSet = new CalcRegionSet();
            calcRegionSet.addRegion(gr);
            calcRegionSet.preComputeAllMutScores();
            calcRegionSetList.add(calcRegionSet);
        }
        return calcRegionSetList;
    }

    public List<CalcRegionSet> getCalcRegionSetList() {
        return this.calcRegionSetList;
    }

    public void generateCalcGeneRegionSet(GeneSetAssocSetting geneSetAssocSetting, IndexableSet<String> geneSymbolMap) throws IOException {
        this.generateCalcGeneRegionSet(geneSetAssocSetting.getPath(), geneSetAssocSetting.getThreshold(), geneSymbolMap, geneSetAssocSetting.getIdIndex(), geneSetAssocSetting.getUrlIndex(), geneSetAssocSetting.getGeneStartIndex());
    }

    public void generateCalcGeneRegionSet(InteractionSetting interactionSetting, IndexableSet<String> geneSymbolMap) throws IOException {
        this.generateCalcGeneRegionSet(interactionSetting.getInteractionUnitFile(), interactionSetting.getScoreFilterThreshold(), geneSymbolMap, -1, -1, 0);
    }

    private void generateCalcGeneRegionSet(LiveFile diepFile, double scoreFilterThreshold, IndexableSet<String> geneSymbolMap, int idIndex, int urlIndex, int geneStartIndex) throws IOException {
        boolean hasHead = false;
        String sep = "\t";
        String regex = "^-?\\d*\\.?\\d+$";
        this.baseRegions.sort(Comparator.comparing(t -> (String)geneSymbolMap.valueOf(Integer.parseInt(t.getLabel()))));
        HashMap<String, IntList> nameIndexMap = new HashMap<String, IntList>();
        List<CalcRegionSet> calcRegionSets = new List<CalcRegionSet>();
        boolean geneContainInBaseRegions = true;
        for (int i = 0; i < this.baseRegions.size(); ++i) {
            GenomeRegion gr = this.baseRegions.get(i);
            nameIndexMap.computeIfAbsent(geneSymbolMap.valueOf(Integer.parseInt(gr.getLabel())), k -> new IntList()).add(i);
        }
        try {
            String line;
            BufferedReader reader;
            String filePath = diepFile.getPath();
            if (diepFile.getPath().endsWith(".gz") || diepFile.getPath().endsWith(".bgz")) {
                FileInputStream fileInputStream = new FileInputStream(filePath);
                GZIPInputStream gzipInputStream = new GZIPInputStream(fileInputStream);
                reader = new BufferedReader(new InputStreamReader(gzipInputStream));
            } else {
                FileReader fileReader = new FileReader(filePath);
                reader = new BufferedReader(fileReader);
            }
            if (hasHead) {
                line = reader.readLine();
                String[] stringArray = line.split(sep);
            }
            int geneEndIndex = -1;
            while ((line = reader.readLine()) != null) {
                int size;
                geneContainInBaseRegions = true;
                String[] columns = line.split(sep);
                if (Pattern.matches(regex, columns[(size = columns.length) - 1])) {
                    float score = Float.parseFloat(columns[size - 1]);
                    if ((double)score < scoreFilterThreshold) continue;
                    geneEndIndex = size - 1;
                } else {
                    geneEndIndex = size;
                }
                List<IntList> allIndexes = new List<IntList>();
                for (int i = geneStartIndex; i < geneEndIndex; ++i) {
                    String geneName = columns[i];
                    if (!nameIndexMap.containsKey(geneName)) {
                        geneContainInBaseRegions = false;
                        break;
                    }
                    IntList indexes = (IntList)nameIndexMap.get(geneName);
                    if (indexes == null) continue;
                    allIndexes.add(indexes);
                }
                if (allIndexes.size() < 2) continue;
                List<int[]> combinations = Var2RegionMapper.listAllCombinations(allIndexes);
                for (int[] combination : combinations) {
                    CalcRegionSet set = idIndex >= 0 && urlIndex >= 0 ? new CalcRegionSet(columns[idIndex], columns[urlIndex]) : new CalcRegionSet();
                    for (int j : combination) {
                        set.addRegion(this.baseRegions.get(j));
                    }
                    set.preComputeAllMutScores();
                    calcRegionSets.add(set);
                }
            }
            reader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.baseRegions.clear();
        this.calcRegionSetList = calcRegionSets;
        SetupApplication.GlobalLogger.info("{} interaction units are loaded from {} for analysis.", (Object)this.calcRegionSetList.size(), (Object)diepFile.getPath());
    }

    private void generateCombinations(List<List<Integer>> allIndexes, int depth, List<GenomeRegion> current, List<List<GenomeRegion>> result) {
        if (depth == allIndexes.size()) {
            result.add(new List<GenomeRegion>(current));
            return;
        }
        for (int num : allIndexes.get(depth)) {
            current.add(this.baseRegions.get(num));
            this.generateCombinations(allIndexes, depth + 1, current, result);
            current.remove(current.size() - 1);
        }
    }

    public static List<int[]> listAllCombinations(List<IntList> groups2) {
        int groupIndex;
        if (groups2 == null || groups2.isEmpty()) {
            return null;
        }
        int[] indices = new int[groups2.size()];
        int totalGroups = groups2.size();
        List<int[]> allCombinations = new List<int[]>();
        block0: do {
            int[] combination = new int[totalGroups];
            for (int i = 0; i < totalGroups; ++i) {
                combination[i] = groups2.get(i).get(indices[i]);
            }
            allCombinations.add(combination);
            for (groupIndex = totalGroups - 1; groupIndex >= 0; --groupIndex) {
                int n = groupIndex;
                indices[n] = indices[n] + 1;
                if (indices[groupIndex] < groups2.get(groupIndex).size()) continue block0;
                indices[groupIndex] = 0;
            }
        } while (groupIndex >= 0);
        return allCombinations;
    }

    public static void main(String[] args) throws IOException {
        String path = "/Volumes/SSD/Data/resource/diep/TAB_NOHEAD_DiffColumns.txt";
        LiveFile diepFile = LiveFile.of(new File(path));
        boolean hasHead = false;
        String sep = "\t";
        String regex = "^-?\\d*\\.?\\d+$";
        float scoreFilterThreshold = 0.1f;
        LinkedSet geneSymbolMap = new LinkedSet();
        List<Test> testList = new List<Test>();
        testList.add(new Test("A1BG"));
        testList.add(new Test("A2M"));
        testList.add(new Test("RET"));
        testList.add(new Test("ACTA2"));
        testList.add(new Test("ACTN1"));
        testList.add(new Test("AKT1"));
        testList.add(new Test("AKT1"));
        ((Test)testList.get(0)).setType("Type1");
        ((Test)testList.get(1)).setType("Type1");
        ((Test)testList.get(2)).setType("Type2");
        ((Test)testList.get(3)).setType("Type1");
        ((Test)testList.get(4)).setType("Type2");
        ((Test)testList.get(5)).setType("Type1");
        ((Test)testList.get(6)).setType("Type2");
        testList.sort(Comparator.comparing(t -> t.name));
        HashMap<String, List> nameIndexMap = new HashMap<String, List>();
        for (int i = 0; i < testList.size(); ++i) {
            Test test2 = (Test)testList.get(i);
            nameIndexMap.computeIfAbsent(test2.name, k -> new List()).add(i);
        }
        try (BufferedReader reader = new BufferedReader(new FileReader(path));){
            String line;
            if (hasHead) {
                line = reader.readLine();
                String[] stringArray = line.split(sep);
            }
            while ((line = reader.readLine()) != null) {
                float score;
                int size;
                String[] columns = line.split(sep);
                if (!Pattern.matches(regex, columns[(size = columns.length) - 1]) || (score = Float.parseFloat(columns[size - 1])) < scoreFilterThreshold) continue;
                for (int i = 0; i < size - 1; ++i) {
                    String geneName = columns[i];
                    if (!nameIndexMap.containsKey(geneName)) continue;
                    List indexes = (List)nameIndexMap.get(geneName);
                    Iterator iterator2 = indexes.iterator();
                    while (iterator2.hasNext()) {
                        int index = (Integer)iterator2.next();
                        System.out.println(((Test)testList.get((int)index)).name + "__" + ((Test)testList.get((int)index)).Type);
                    }
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public IndexableSet<String> generateCalcGeneRegionSet0(InteractionSetting interactionSetting, IndexableSet<String> geneSymbolMap) throws IOException {
        TextRecord record;
        LinkedSet<String> newGeneSymbolMap = new LinkedSet<String>();
        LiveFile diepFile = interactionSetting.getInteractionUnitFile();
        TextReader reader = TextReader.setInput(diepFile).setHeaderParser((values2, separator, header) -> {
            List<Bytes> firstLine = separator.accept(values2);
            IHeaderParser.FIRST_LINE.parse(values2, separator, header);
            return true;
        }).setSeparator(new CustomSeparator(new BiConsumer<Bytes, List<Bytes>>(){
            byte separator = (byte)-1;

            @Override
            public void accept(Bytes byteCode, List<Bytes> byteCodes) {
                if (this.separator == -1) {
                    if (byteCode.indexOf((byte)9) != -1) {
                        this.separator = (byte)9;
                    } else if (byteCode.indexOf((byte)32) != -1) {
                        this.separator = (byte)32;
                    } else if (byteCode.indexOf((byte)44) != -1) {
                        this.separator = (byte)44;
                    }
                }
                byteCode.splitTo(this.separator, byteCodes);
            }
        })).instance();
        List tmpRegions = new List();
        List<CalcRegionSet> calcRegionSets = new List<CalcRegionSet>();
        this.baseRegions.sort((region1, region2) -> {
            int label1 = Integer.parseInt(region1.getLabel());
            int label2 = Integer.parseInt(region2.getLabel());
            String gene1 = (String)geneSymbolMap.valueOf(label1);
            String gene2 = (String)geneSymbolMap.valueOf(label2);
            return gene1.compareTo(gene2);
        });
        int geneIndex = 0;
        GenomeRegion currentGene = this.baseRegions.get(geneIndex);
        String currentGeneName = geneSymbolMap.valueOf(Integer.parseInt(currentGene.getLabel()));
        double scoreFilterThreshold = interactionSetting.getScoreFilterThreshold();
        while ((record = reader.read()) != null) {
            GenomeRegion gene2;
            float score = Float.parseFloat(record.get("Digene_Score").toString());
            if ((double)score < scoreFilterThreshold) continue;
            String aGeneName = record.get("GeneA").toString();
            String bGeneName = record.get("GeneB").toString();
            if (currentGeneName == null) continue;
            while (geneIndex < this.baseRegions.size() && aGeneName.compareTo(currentGeneName) > 0) {
                if (++geneIndex >= this.baseRegions.size()) continue;
                currentGene = this.baseRegions.get(geneIndex);
                currentGeneName = geneSymbolMap.valueOf(Integer.parseInt(currentGene.getLabel()));
            }
            if (aGeneName.compareTo(currentGeneName) > 0 || !aGeneName.equals(currentGeneName)) continue;
            GenomeRegion gene1 = this.baseRegions.get(geneIndex);
            String bGeneLabel = String.valueOf(geneSymbolMap.indexOf(bGeneName));
            if (bGeneLabel.equals("-1") || (gene2 = this.findGeneByLabel(this.baseRegions, bGeneLabel, geneSymbolMap)) == null) continue;
            CalcRegionSet calcRegionSet = new CalcRegionSet();
            calcRegionSet.addRegion(gene1);
            calcRegionSet.addRegion(gene2);
            calcRegionSets.add(calcRegionSet);
            String geneName = calcRegionSet.getAllRegionNameFull(geneSymbolMap);
            ((AbstractCollection)newGeneSymbolMap).add(geneName);
        }
        newGeneSymbolMap.addAll(geneSymbolMap);
        this.baseRegions.clear();
        this.baseRegions.addAll(tmpRegions);
        this.calcRegionSetList = calcRegionSets;
        tmpRegions.clear();
        return newGeneSymbolMap;
    }

    private GenomeRegion findGeneByLabel(List<GenomeRegion> genes, String geneLabel, IndexableSet<String> geneSymbolMap) {
        int left = 0;
        int right = genes.size() - 1;
        while (left <= right) {
            int mid = left + (right - left) / 2;
            int compare = 0;
            try {
                compare = geneSymbolMap.valueOf(Integer.parseInt(genes.get(mid).getLabel())).compareTo(geneSymbolMap.valueOf(Integer.parseInt(geneLabel)));
            }
            catch (Exception e) {
                System.out.println(mid + "__" + geneLabel);
            }
            if (compare == 0) {
                return genes.get(mid);
            }
            if (compare < 0) {
                left = mid + 1;
                continue;
            }
            right = mid - 1;
        }
        return null;
    }

    public void assignVars2GenesWithThreadPool(String adjustedACMeta, String caseACMeta, File varAnnotFile, String mutationSubjectField, String mutationCountField, String mutationScoreCountField, String mutationSubjectControlField, String mutationCountControlField, List<String> addedValueFields, final IndexableSet<String> geneSymbMap, final Map<Integer, Map<Integer, int[]>> geneSubRegionLength, boolean uniqeSubjectInARegion, int threadNum, boolean scanBySizeORLength, float pValueInRegion) throws IOException, REngineException, REXPMismatchException {
        CollectGeneVariantsThread collectGeneVariantsThread;
        boolean needScan;
        Variant annotVariant;
        int size;
        TLongIterator pbIters;
        VarInt64RangeList pb;
        GenomeRegion gene;
        int i;
        GTBManager manager = new GTBManager(varAnnotFile);
        File geneAnnotationFile = FileUtils.getSubFile(varAnnotFile.getParentFile().getParentFile(), "/AssignVar2GeneTask/genes.annot.hg38.ccf");
        Map<String, GenomeRegion> geneRegionMap = this.readAssignedVarPointersOfGenes(geneAnnotationFile);
        List<GenomeRegion> geneRegions = new List<GenomeRegion>(geneRegionMap.values());
        geneRegions.sort(Comparator.comparingLong(GenomeRegion::getStartPointer).thenComparingLong(GenomeRegion::getEndPointer));
        LongList pointersAnnotFile = new LongList();
        int geneNum = geneRegions.size();
        String[] necessaryFields = new String[]{"GTYSUM@RefHomGtyNum_CASE", "GTYSUM@HetGtyNum_CASE", "GTYSUM@AltHomGtyNum_CASE", "GTYSUM@RefHomGtyNum_CONTROL", "GTYSUM@HetGtyNum_CONTROL", "GTYSUM@AltHomGtyNum_CONTROL", "GTYSUM@COUNT_ALT_CASE", "GTYSUM@COUNT_ALT_CONTROL"};
        LinkedSet<String> neededFields = new LinkedSet<String>(necessaryFields);
        ((AbstractCollection)neededFields).add(mutationSubjectField);
        ((AbstractCollection)neededFields).add(mutationSubjectControlField);
        ((AbstractCollection)neededFields).add(mutationScoreCountField);
        ((AbstractCollection)neededFields).add(adjustedACMeta);
        neededFields.addAll(addedValueFields);
        GTBReader annotReader = new GTBReader((GTBReaderOption)new GTBReaderOption(manager, false, false).addFields(neededFields));
        List<Variant> variantsTmp = new List<Variant>();
        boolean isIntArray = manager.getField(mutationSubjectField).type() == FieldType.int32List;
        this.baseRegions = new List();
        float scale = 1000.0f;
        DynamicScanWindows dynamicScanWindows = DynamicScanWindows.getInstance();
        dynamicScanWindows.setMeta(caseACMeta, adjustedACMeta);
        dynamicScanWindows.setFDRCutoff(pValueInRegion);
        final ThreadQueue geneThreadqueue = new ThreadQueue(threadNum);
        final LinkedBlockingQueue genomeRegionQueue = new LinkedBlockingQueue();
        this.logger.info("Assigning variants to genes...");
        for (i = 0; i < geneNum; ++i) {
            gene = geneRegions.get(i);
            pb = gene.getOutcomeVarPointers();
            pointersAnnotFile.clear();
            if (pb == null) continue;
            pbIters = pb.iterator();
            while (pbIters.hasNext()) {
                long pointer = pbIters.next();
                pointersAnnotFile.add(pointer);
            }
            if (pointersAnnotFile.isEmpty()) continue;
            pointersAnnotFile.sort();
            size = pointersAnnotFile.size();
            variantsTmp.clear();
            for (int m = 0; m < size; ++m) {
                annotReader.seek(pointersAnnotFile.get(m));
                annotVariant = annotReader.read();
                variantsTmp.add(annotVariant);
            }
            if (variantsTmp.isEmpty()) continue;
            needScan = scanBySizeORLength ? dynamicScanWindows.judgeBySize(variantsTmp) : dynamicScanWindows.judgeByLength(variantsTmp);
            needScan = false;
            if (!needScan) continue;
            DynamicScanWindows.DynamicScanThread dynamicScanThread = new DynamicScanWindows.DynamicScanThread(){

                @Override
                public void fireTaskComplete() {
                    if (this.scanSignificant()) {
                        genomeRegionQueue.addAll(this.getResultRegions());
                        this.changeGeneSubRegionLength(geneSubRegionLength, geneSymbMap);
                    }
                }
            };
            dynamicScanThread.setTask(variantsTmp, gene, scanBySizeORLength);
            geneThreadqueue.addTask(dynamicScanThread);
        }
        geneThreadqueue.await();
        while (!genomeRegionQueue.isEmpty()) {
            GenomeRegion genomeRegion = (GenomeRegion)genomeRegionQueue.poll();
            collectGeneVariantsThread = new CollectGeneVariantsThread(addedValueFields, mutationSubjectField, uniqeSubjectInARegion, isIntArray, mutationCountField, mutationScoreCountField, true, adjustedACMeta){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void fireTaskComplete() {
                    if (this.newGeneRegion != null && Var2RegionMapper.this.baseRegions != null) {
                        ThreadQueue threadQueue = geneThreadqueue;
                        synchronized (threadQueue) {
                            Var2RegionMapper.this.baseRegions.add(this.newGeneRegion);
                        }
                    }
                }
            };
            collectGeneVariantsThread.setGene(genomeRegion.getVariants(), genomeRegion);
            collectGeneVariantsThread.setMutationCountControlField(mutationCountControlField);
            collectGeneVariantsThread.setMutationControlSubjectField(mutationSubjectControlField);
            geneThreadqueue.addTask(collectGeneVariantsThread);
        }
        geneThreadqueue.await();
        for (i = 0; i < geneNum; ++i) {
            gene = geneRegions.get(i);
            pb = gene.getOutcomeVarPointers();
            pointersAnnotFile.clear();
            if (pb == null) continue;
            pbIters = pb.iterator();
            while (pbIters.hasNext()) {
                long pointer = pbIters.next();
                pointersAnnotFile.add(pointer);
            }
            if (pointersAnnotFile.isEmpty()) continue;
            pointersAnnotFile.sort();
            size = pointersAnnotFile.size();
            variantsTmp.clear();
            for (int m = 0; m < size; ++m) {
                annotReader.seek(pointersAnnotFile.get(m));
                annotVariant = annotReader.read();
                variantsTmp.add(annotVariant);
            }
            if (variantsTmp.isEmpty()) continue;
            needScan = scanBySizeORLength ? dynamicScanWindows.judgeBySize(variantsTmp) : dynamicScanWindows.judgeByLength(variantsTmp);
            needScan = false;
            if (needScan) continue;
            collectGeneVariantsThread = new CollectGeneVariantsThread(addedValueFields, mutationSubjectField, uniqeSubjectInARegion, isIntArray, mutationCountField, mutationScoreCountField, true, adjustedACMeta){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void fireTaskComplete() {
                    if (this.newGeneRegion != null && Var2RegionMapper.this.baseRegions != null) {
                        ThreadQueue threadQueue = geneThreadqueue;
                        synchronized (threadQueue) {
                            Var2RegionMapper.this.baseRegions.add(this.newGeneRegion);
                        }
                    }
                }
            };
            collectGeneVariantsThread.setGene(variantsTmp, gene);
            geneThreadqueue.addTask(collectGeneVariantsThread);
        }
        geneThreadqueue.close();
        int geneSize = this.baseRegions.size();
        String chooseOne = "VariantsDensity";
        addedValueFields.add(chooseOne);
        this.labelRegionMap = new THashMap<String, GenomeRegion>(geneSize);
        List<GenomeRegion> allRegionsTmp = new List<GenomeRegion>(geneSize);
        double variantDensity = 0.0;
        double tmpLength = 0.0;
        for (int i2 = 0; i2 < geneSize; ++i2) {
            int typeLengthSize;
            GenomeRegion gr = this.baseRegions.get(i2);
            String regionLabel = gr.getLabel() + "#" + gr.getType();
            if (this.labelRegionMap.containsKey(regionLabel)) continue;
            double[] featureScores = gr.getRegionScores();
            double[] featureScores1 = new double[featureScores.length + 1];
            System.arraycopy(featureScores, 0, featureScores1, 0, featureScores.length);
            Map<Integer, int[]> typeLength = geneSubRegionLength.get(Integer.parseInt(gr.getLabel()));
            int n = typeLengthSize = typeLength == null ? 0 : typeLength.size();
            if (typeLength == null) {
                featureScores1[featureScores.length] = 0.0;
            } else {
                int[] length = typeLength.get(gr.getType());
                if (length == null) {
                    featureScores1[featureScores.length] = 0.0;
                } else {
                    tmpLength = (float)length[0] / scale == 1.0f ? (double)((float)(gr.getEnd() - gr.getStart() + 1) / scale) : (double)((float)length[0] / scale);
                    variantDensity = (double)gr.getMutCountScoreListRef().size() / 2.0 / tmpLength;
                    switch (chooseOne) {
                        case "RegionLength": {
                            featureScores1[featureScores.length] = tmpLength;
                            break;
                        }
                        case "VariantsDensity": {
                            featureScores1[featureScores.length] = variantDensity;
                            break;
                        }
                        default: {
                            throw new IllegalStateException("Unexpected value: " + chooseOne);
                        }
                    }
                }
            }
            gr.setRegionScores(featureScores1);
            allRegionsTmp.add(gr);
            this.labelRegionMap.put(regionLabel, gr);
        }
        this.baseRegions.clear();
        this.baseRegions.addAll(allRegionsTmp);
        allRegionsTmp.clear();
    }

    public void assignVars2GenesWithThreadPool0(Context context, File varAnnotFile, String mutationSubjectField, String mutationCountField, String mutationScoreCountField, List<String> addedValueFields, final IndexableSet<String> geneSymbMap, final Map<Integer, Map<Integer, int[]>> geneSubRegionLength, boolean uniqeSubjectInARegion, int threadNum, boolean scanBySizeORLength, float pValueInRegion) throws IOException, REngineException, REXPMismatchException {
        CollectGeneVariantsThread collectGeneVariantsThread;
        GTBManager manager = new GTBManager(varAnnotFile);
        File geneAnnotationFile = FileUtils.getSubFile(varAnnotFile.getParentFile().getParentFile(), "/AssignVar2GeneTask/genes.annot.hg38.ccf");
        Map<String, GenomeRegion> geneRegionMap = this.readAssignedVarPointersOfGenes(geneAnnotationFile);
        List<GenomeRegion> geneRegions = new List<GenomeRegion>(geneRegionMap.values());
        geneRegions.sort(Comparator.comparingLong(GenomeRegion::getStartPointer).thenComparingLong(GenomeRegion::getEndPointer));
        LongList pointersAnnotFile = new LongList();
        int geneNum = geneRegions.size();
        GTBReader annotReader = new GTBReader(new GTBReaderOption(manager, false, true));
        List<Variant> variantsTmp = new List<Variant>();
        boolean isIntArray = manager.getField(mutationSubjectField).type() == FieldType.int32List;
        this.baseRegions = new List();
        float scale = 1000.0f;
        boolean useAdjustedAC = false;
        String adjustedACMeta = null;
        String caseACMeta = (String)context.cast("CaseMutationCount");
        if (context.cast("AdjustedAC") != null) {
            useAdjustedAC = true;
            adjustedACMeta = (String)context.cast("AdjustedAC");
        }
        DynamicScanWindows dynamicScanWindows = DynamicScanWindows.getInstance();
        dynamicScanWindows.setMeta(caseACMeta, adjustedACMeta);
        dynamicScanWindows.setFDRCutoff(pValueInRegion);
        ThreadQueue scanThreadqueue = new ThreadQueue(threadNum / 2);
        final ThreadQueue geneThreadqueue = new ThreadQueue(threadNum / 2);
        final LinkedBlockingQueue genomeRegionQueue = new LinkedBlockingQueue();
        this.logger.info("Assigning variants to genes...");
        for (int i = 0; i < geneNum; ++i) {
            GenomeRegion gene = geneRegions.get(i);
            VarInt64RangeList pb = gene.getOutcomeVarPointers();
            pointersAnnotFile.clear();
            if (pb == null) continue;
            TLongIterator pbIters = pb.iterator();
            while (pbIters.hasNext()) {
                long pointer = pbIters.next();
                pointersAnnotFile.add(pointer);
            }
            if (pointersAnnotFile.isEmpty()) continue;
            pointersAnnotFile.sort();
            int size = pointersAnnotFile.size();
            variantsTmp.clear();
            for (int m = 0; m < size; ++m) {
                annotReader.seek(pointersAnnotFile.get(m));
                Variant annotVariant = annotReader.read();
                variantsTmp.add(annotVariant);
            }
            if (variantsTmp.isEmpty()) continue;
            boolean needScan = scanBySizeORLength ? dynamicScanWindows.judgeBySize(variantsTmp) : dynamicScanWindows.judgeByLength(variantsTmp);
            if (needScan) {
                DynamicScanWindows.DynamicScanThread dynamicScanThread = new DynamicScanWindows.DynamicScanThread(){

                    @Override
                    public void fireTaskComplete() {
                        if (this.scanSignificant()) {
                            genomeRegionQueue.addAll(this.getResultRegions());
                            this.changeGeneSubRegionLength(geneSubRegionLength, geneSymbMap);
                        }
                    }
                };
                dynamicScanThread.setTask(variantsTmp, gene, scanBySizeORLength);
                scanThreadqueue.addTask(dynamicScanThread);
                continue;
            }
            collectGeneVariantsThread = new CollectGeneVariantsThread(addedValueFields, mutationSubjectField, uniqeSubjectInARegion, isIntArray, mutationCountField, mutationScoreCountField, useAdjustedAC, adjustedACMeta){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void fireTaskComplete() {
                    if (this.newGeneRegion != null && Var2RegionMapper.this.baseRegions != null) {
                        ThreadQueue threadQueue = geneThreadqueue;
                        synchronized (threadQueue) {
                            Var2RegionMapper.this.baseRegions.add(this.newGeneRegion);
                        }
                    }
                }
            };
            collectGeneVariantsThread.setGene(variantsTmp, gene);
            geneThreadqueue.addTask(collectGeneVariantsThread);
        }
        while (!genomeRegionQueue.isEmpty()) {
            GenomeRegion genomeRegion = (GenomeRegion)genomeRegionQueue.poll();
            collectGeneVariantsThread = new CollectGeneVariantsThread(addedValueFields, mutationSubjectField, uniqeSubjectInARegion, isIntArray, mutationCountField, mutationScoreCountField, useAdjustedAC, adjustedACMeta){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void fireTaskComplete() {
                    if (this.newGeneRegion != null && Var2RegionMapper.this.baseRegions != null) {
                        ThreadQueue threadQueue = geneThreadqueue;
                        synchronized (threadQueue) {
                            Var2RegionMapper.this.baseRegions.add(this.newGeneRegion);
                        }
                    }
                }
            };
            collectGeneVariantsThread.setGene(genomeRegion.getVariants(), genomeRegion);
            geneThreadqueue.addTask(collectGeneVariantsThread);
        }
        scanThreadqueue.close();
        geneThreadqueue.close();
        int geneSize = this.baseRegions.size();
        String chooseOne = "VariantsDensity";
        addedValueFields.add(chooseOne);
        this.labelRegionMap = new THashMap<String, GenomeRegion>(geneSize);
        List<GenomeRegion> allRegionsTmp = new List<GenomeRegion>(geneSize);
        double variantDensity = 0.0;
        double tmpLength = 0.0;
        for (int i = 0; i < geneSize; ++i) {
            int typeLengthSize;
            GenomeRegion gr = this.baseRegions.get(i);
            String regionLabel = gr.getLabel() + "#" + gr.getType();
            if (this.labelRegionMap.containsKey(regionLabel)) continue;
            double[] featureScores = gr.getRegionScores();
            double[] featureScores1 = new double[featureScores.length + 1];
            System.arraycopy(featureScores, 0, featureScores1, 0, featureScores.length);
            Map<Integer, int[]> typeLength = geneSubRegionLength.get(Integer.parseInt(gr.getLabel()));
            int n = typeLengthSize = typeLength == null ? 0 : typeLength.size();
            if (typeLength == null) {
                featureScores1[featureScores.length] = 0.0;
            } else {
                int[] length = typeLength.get(gr.getType());
                if (length == null) {
                    featureScores1[featureScores.length] = 0.0;
                } else {
                    tmpLength = (float)length[0] / scale == 1.0f ? (double)((float)(gr.getEnd() - gr.getStart() + 1) / scale) : (double)((float)length[0] / scale);
                    variantDensity = (double)gr.getMutCountScoreListRef().size() / 2.0 / tmpLength;
                    switch (chooseOne) {
                        case "RegionLength": {
                            featureScores1[featureScores.length] = tmpLength;
                            break;
                        }
                        case "VariantsDensity": {
                            featureScores1[featureScores.length] = variantDensity == 0.0 ? 0.0 : Math.log(variantDensity);
                        }
                    }
                }
            }
            gr.setRegionScores(featureScores1);
            allRegionsTmp.add(gr);
            this.labelRegionMap.put(regionLabel, gr);
        }
        this.baseRegions.clear();
        this.baseRegions.addAll(allRegionsTmp);
        allRegionsTmp.clear();
    }

    public void assignVars2GenesWithPredictors(Context context, File varAnnotFile, String mutationSubjectField, String mutationCountField, String mutationScoreCountField, List<String> addedValueFields, IndexableSet<String> geneSymbMap, Map<Integer, Map<Integer, int[]>> geneSubRegionLength, boolean uniqeSubjectInARegion, int threadNum, boolean scanBySizeORLength, float pValueInRegion) throws IOException, REngineException, REXPMismatchException {
        GTBManager manager = new GTBManager(varAnnotFile);
        File geneAnnotationFile = FileUtils.getSubFile(varAnnotFile.getParentFile().getParentFile(), "/AssignVar2GeneTask/genes.annot.hg38.ccf");
        Map<String, GenomeRegion> geneRegionMap = this.readAssignedVarPointersOfGenes(geneAnnotationFile);
        List<GenomeRegion> geneRegions = new List<GenomeRegion>(geneRegionMap.values());
        geneRegions.sort(Comparator.comparingLong(GenomeRegion::getStartPointer).thenComparingLong(GenomeRegion::getEndPointer));
        LongList pointersAnnotFile = new LongList();
        int geneNum = geneRegions.size();
        GTBReader annotReader = new GTBReader(new GTBReaderOption(manager, false, true));
        double scoreVal = Double.NaN;
        List<Variant> variantsTmp = new List<Variant>();
        boolean isIntArray = manager.getField(mutationSubjectField).type() == FieldType.int32List;
        Object alleleNumsScoreDep = null;
        int maxPos = Integer.MIN_VALUE;
        int minPos = Integer.MAX_VALUE;
        this.baseRegions = new List();
        float scale = 1000.0f;
        boolean useAdjustedAC = false;
        String adjustedACMeta = null;
        String caseACMeta = (String)context.cast("CaseMutationCount");
        if (context.cast("AdjustedAC") != null) {
            useAdjustedAC = true;
            adjustedACMeta = (String)context.cast("AdjustedAC");
        }
        DynamicScanWindows dynamicScanWindows = DynamicScanWindows.getInstance();
        dynamicScanWindows.setFDRCutoff(pValueInRegion);
        dynamicScanWindows.setMeta(caseACMeta, adjustedACMeta);
        final ThreadQueue threadqueue = new ThreadQueue(threadNum);
        this.logger.info("Assigning variants to genes...");
        for (int i = 0; i < geneNum; ++i) {
            CollectGeneVariantsThread collectGeneVariantsThread;
            GenomeRegion gene = geneRegions.get(i);
            VarInt64RangeList pb = gene.getOutcomeVarPointers();
            pointersAnnotFile.clear();
            if (pb == null) continue;
            TLongIterator pbIters = pb.iterator();
            while (pbIters.hasNext()) {
                long pointer = pbIters.next();
                pointersAnnotFile.add(pointer);
            }
            if (pointersAnnotFile.isEmpty()) continue;
            pointersAnnotFile.sort();
            int size = pointersAnnotFile.size();
            variantsTmp.clear();
            for (int m = 0; m < size; ++m) {
                annotReader.seek(pointersAnnotFile.get(m));
                Variant annotVariant = annotReader.read();
                variantsTmp.add(annotVariant);
            }
            if (variantsTmp.isEmpty()) continue;
            boolean needScan = scanBySizeORLength ? dynamicScanWindows.judgeBySize(variantsTmp) : dynamicScanWindows.judgeByLength(variantsTmp);
            if (needScan) {
                dynamicScanWindows.setTask(variantsTmp, gene);
                if (scanBySizeORLength) {
                    dynamicScanWindows.executeWithVarSize();
                } else {
                    dynamicScanWindows.executeWithRegionLength();
                }
                dynamicScanWindows.changeGeneSubRegionLength(geneSubRegionLength, geneSymbMap);
                if (!dynamicScanWindows.scanSignificant()) continue;
                List<GenomeRegion> scanRegions = dynamicScanWindows.getResultRegions();
                for (GenomeRegion genomeRegion : scanRegions) {
                    collectGeneVariantsThread = new CollectGeneVariantsThread(addedValueFields, mutationSubjectField, uniqeSubjectInARegion, isIntArray, mutationCountField, mutationScoreCountField, useAdjustedAC, adjustedACMeta){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void fireTaskComplete() {
                            if (this.newGeneRegion != null && Var2RegionMapper.this.baseRegions != null) {
                                ThreadQueue threadQueue = threadqueue;
                                synchronized (threadQueue) {
                                    Var2RegionMapper.this.baseRegions.add(this.newGeneRegion);
                                }
                            }
                        }
                    };
                    collectGeneVariantsThread.setGene(genomeRegion.getVariants(), genomeRegion);
                    threadqueue.addTask(collectGeneVariantsThread);
                }
            } else {
                collectGeneVariantsThread = new CollectGeneVariantsThread(addedValueFields, mutationSubjectField, uniqeSubjectInARegion, isIntArray, mutationCountField, mutationScoreCountField, useAdjustedAC, adjustedACMeta){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void fireTaskComplete() {
                        if (this.newGeneRegion != null && Var2RegionMapper.this.baseRegions != null) {
                            ThreadQueue threadQueue = threadqueue;
                            synchronized (threadQueue) {
                                Var2RegionMapper.this.baseRegions.add(this.newGeneRegion);
                            }
                        }
                    }
                };
                collectGeneVariantsThread.setGene(variantsTmp, gene);
                threadqueue.addTask(collectGeneVariantsThread);
            }
            if (i % 10000 != 0 || i <= 0) continue;
            this.logger.info("Dynamic Scan Window Index: " + i + ", effective Region size: " + this.baseRegions.size() + ", All region size: " + geneNum);
        }
        threadqueue.close();
        geneRegions.clear();
        int geneSize = this.baseRegions.size();
        String chooseOne = "VariantsDensity";
        addedValueFields.add(chooseOne);
        this.labelRegionMap = new THashMap<String, GenomeRegion>(geneSize);
        List<GenomeRegion> allRegionsTmp = new List<GenomeRegion>(geneSize);
        double variantDensity = 0.0;
        double tmpLength = 0.0;
        for (int i = 0; i < geneSize; ++i) {
            int typeLengthSize;
            GenomeRegion gr = this.baseRegions.get(i);
            String regionLabel = gr.getLabel() + "#" + gr.getType();
            if (this.labelRegionMap.containsKey(regionLabel)) continue;
            double[] featureScores = gr.getRegionScores();
            double[] featureScores1 = new double[featureScores.length + 1];
            System.arraycopy(featureScores, 0, featureScores1, 0, featureScores.length);
            Map<Integer, int[]> typeLength = geneSubRegionLength.get(Integer.parseInt(gr.getLabel()));
            int n = typeLengthSize = typeLength == null ? 0 : typeLength.size();
            if (typeLength == null) {
                featureScores1[featureScores.length] = 0.0;
            } else {
                int[] length = typeLength.get(gr.getType());
                if (length == null) {
                    featureScores1[featureScores.length] = 0.0;
                } else {
                    tmpLength = (float)length[0] / scale == 1.0f ? (double)((float)(gr.getEnd() - gr.getStart() + 1) / scale) : (double)((float)length[0] / scale);
                    variantDensity = (double)gr.getMutCountScoreListRef().size() / 2.0 / tmpLength;
                    switch (chooseOne) {
                        case "RegionLength": {
                            featureScores1[featureScores.length] = tmpLength;
                            break;
                        }
                        case "VariantsDensity": {
                            featureScores1[featureScores.length] = variantDensity;
                        }
                    }
                }
            }
            gr.setRegionScores(featureScores1);
            allRegionsTmp.add(gr);
            this.labelRegionMap.put(regionLabel, gr);
        }
        this.baseRegions.clear();
        this.baseRegions.addAll(allRegionsTmp);
        allRegionsTmp.clear();
    }

    public HashMap<String, List<GenomeRegion>> getSeparateRegionMap() {
        return this.separateRegionMap;
    }

    public HashMap<String, List<CalcRegionSet>> getSeparateRegionSetMap() {
        return this.separateRegionSetMap;
    }

    public void separateRegionSets() {
        this.logger.info("Separating Regions...");
        String[] typeArray = new String[]{"CodingExon", "UTR5", "UTR3", "UpStream", "DownStream", "OtherRegions", "Intron"};
        DynamicScanWindows dynamicScanWindows = DynamicScanWindows.getInstance();
        boolean needScan = dynamicScanWindows.isUseScan();
        for (GenomeRegion gr : this.baseRegions) {
            String key;
            int typeIndex;
            int regionType = gr.getType();
            int n = typeIndex = needScan ? regionType % dynamicScanWindows.getScale() : regionType;
            if (typeIndex >= 6) {
                typeIndex = 6;
            }
            if (!this.separateRegionSetMap.containsKey(key = typeArray[typeIndex])) {
                this.separateRegionSetMap.put(key, new List());
            }
            this.separateRegionSetMap.put(key, new List());
            CalcRegionSet calcRegionSet = new CalcRegionSet();
            calcRegionSet.addRegion(gr);
            this.separateRegionSetMap.get(key).add(calcRegionSet);
        }
        this.baseRegions.clear();
    }

    public void separateRegions() {
        this.logger.info("Separating Regions...");
        String[] typeArray = new String[]{"CodingExon", "UTR5", "UTR3", "UpStream", "DownStream", "OtherRegions", "Intron"};
        DynamicScanWindows dynamicScanWindows = DynamicScanWindows.getInstance();
        boolean needScan = dynamicScanWindows.isUseScan();
        for (GenomeRegion gr : this.baseRegions) {
            String key;
            int typeIndex;
            int regionType = gr.getType();
            int n = typeIndex = needScan ? regionType % dynamicScanWindows.getScale() : regionType;
            if (typeIndex >= 6) {
                typeIndex = 6;
            }
            if (!this.separateRegionMap.containsKey(key = typeArray[typeIndex])) {
                this.separateRegionMap.put(key, new List());
            }
            this.separateRegionMap.get(key).add(gr);
        }
        this.baseRegions.clear();
    }

    public void appendPredictor(File geneVarAnnotFile, List<String> varFeatureNames, String name, List<String> selectedFreqFields) throws IOException {
        varFeatureNames.add(name);
        String[] freqScoreFieldInGeneFile = selectedFreqFields.toArray((T1[])new String[0]);
        CCFReader reader = new CCFReader(new CCFTable(geneVarAnnotFile));
        int inc = 0;
        try {
            IRecord record;
            while ((record = reader.read()) != null) {
                double[] featureScores;
                String symbol = record.get("Basic@SymbolID") + "#" + record.get("Basic@GeneSubRegionTypeID");
                GenomeRegion gr = this.labelRegionMap.get(symbol);
                if (gr == null || (featureScores = gr.getRegionScores()) == null) continue;
                double[] featureScores1 = new double[featureScores.length + 1];
                Arrays.fill(featureScores1, 0.0);
                System.arraycopy(featureScores, 0, featureScores1, 0, featureScores.length);
                ++inc;
                float avgFreq = 0.0f;
                for (String s : freqScoreFieldInGeneFile) {
                    float freq = ((Float)record.get(s)).floatValue();
                    if (Float.isNaN(freq)) continue;
                    avgFreq += freq;
                }
                featureScores1[featureScores.length] = avgFreq /= (float)freqScoreFieldInGeneFile.length;
                gr.setRegionScores(featureScores1);
            }
            reader.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            String info = e.getMessage() + " when loading gene feature file ";
            this.logger.error(info);
        }
        this.logger.info("{} gene regions are assigned frequency scores", (Object)inc);
    }

    public void appendInteraction(List<String> varFeatureNames, String interAct1, String interAct2) throws Exception {
        int index1 = -1;
        int index2 = -1;
        int size = varFeatureNames.size();
        for (int i = 0; i < size; ++i) {
            if (varFeatureNames.get(i).equals(interAct1)) {
                index1 = i;
            } else if (varFeatureNames.get(i).equals(interAct2)) {
                index2 = i;
            }
            if (index1 >= 0 && index2 >= 0) break;
        }
        if (index1 < 0 || index2 < 0) {
            if (index1 < 0) {
                throw new Exception("Unknown name " + interAct1 + " for the interaction!");
            }
            throw new Exception("Unknown name " + interAct2 + " for the interaction!");
        }
        varFeatureNames.add(interAct1 + "_" + interAct2);
        for (Map.Entry<String, GenomeRegion> entry : this.labelRegionMap.entrySet()) {
            double[] featureScores;
            GenomeRegion gr = entry.getValue();
            if (gr == null || (featureScores = gr.getRegionScores()) == null || featureScores.length < size) continue;
            double[] featureScores1 = new double[featureScores.length + 1];
            Arrays.fill(featureScores1, 0.0);
            System.arraycopy(featureScores, 0, featureScores1, 0, featureScores.length);
            featureScores1[featureScores.length] = featureScores[index1] * featureScores[index2];
            gr.setRegionScores(featureScores1);
        }
    }

    public Map<String, GenomeRegion> readAssignedVarPointersOfGenes(File geneVarAnnotFile) throws IOException {
        CCFReader reader = new CCFReader(geneVarAnnotFile);
        THashMap<String, GenomeRegion> chromGeneRegions = new THashMap<String, GenomeRegion>();
        try {
            IRecord record;
            while ((record = reader.read()) != null) {
                long pointer;
                int symbolID = (Integer)record.get("Basic@SymbolID");
                int regionTypeID = (Integer)record.get("Basic@GeneSubRegionTypeID");
                Chromosome chomID = (Chromosome)record.get("Basic@Chromosome");
                int startPos = (Integer)record.get("Basic@Start");
                int endPos = (Integer)record.get("Basic@End");
                GenomeRegion gr = new GenomeRegion(String.valueOf(symbolID));
                gr.setType(regionTypeID);
                gr.setCoordinate(chomID, startPos, endPos);
                VarInt64RangeList pointers = (VarInt64RangeList)record.get("Basic@OutcomeVarPointers");
                gr.setOutcomeVarPointers(pointers);
                VarInt64RangeList pb = gr.getOutcomeVarPointers();
                long startP = Long.MAX_VALUE;
                long endP = Long.MIN_VALUE;
                TLongIterator pbIters = pb.iterator();
                while (pbIters.hasNext()) {
                    pointer = pbIters.next();
                    if (startP > pointer) {
                        startP = pointer;
                    }
                    if (endP >= pointer) continue;
                    endP = pointer;
                }
                pointers = (VarInt64RangeList)record.get("Basic@ExplainVarPointers");
                gr.setExplainVarPointers(pointers);
                pb = gr.getExplainVarPointers();
                if (pb != null) {
                    pbIters = pb.iterator();
                    while (pbIters.hasNext()) {
                        pointer = pbIters.next();
                        if (startP > pointer) {
                            startP = pointer;
                        }
                        if (endP >= pointer) continue;
                        endP = pointer;
                    }
                }
                gr.setStartPointer(startP);
                gr.setEndPointer(endP);
                String label = symbolID + "#" + regionTypeID;
                chromGeneRegions.put(label, gr);
            }
            reader.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            String info = e.getMessage() + " when loading gene feature file.";
            this.logger.error(info);
        }
        return chromGeneRegions;
    }

    public boolean appendRefFreqScore2GeneRegions(File geneFreqScoreFile, String[] scoreFieldNames, String[] freqFieldNames, int caseNum) throws IOException {
        CCFReader reader = new CCFReader(new CCFTable(geneFreqScoreFile));
        int count = 0;
        int nonMissing = 0;
        try {
            IRecord record;
            int[] valNum = null;
            float[] avgScores = null;
            float[] avgFreqs = null;
            while ((record = reader.read()) != null) {
                int j;
                int geneID = (Integer)record.get("Basic@SymbolID");
                int regionID = (Integer)record.get("Basic@GeneSubRegionTypeID");
                String label = geneID + "#" + regionID;
                GenomeRegion gr = this.labelRegionMap.get(label);
                if (gr == null) continue;
                avgScores = null;
                avgFreqs = null;
                for (String scoreFieldName : scoreFieldNames) {
                    if (scoreFieldName == null) {
                        avgScores = new float[1];
                        Arrays.fill(avgScores, 1.0f);
                        valNum = new int[1];
                        Arrays.fill(valNum, 1);
                        continue;
                    }
                    float[] scoreArray = (float[])record.get(scoreFieldName);
                    if (avgScores == null) {
                        avgScores = new float[scoreArray.length];
                        Arrays.fill(avgScores, 0.0f);
                        valNum = new int[scoreArray.length];
                        Arrays.fill(valNum, 0);
                    }
                    for (j = 0; j < scoreArray.length; ++j) {
                        if (Float.isNaN(scoreArray[j])) continue;
                        int n = j;
                        valNum[n] = valNum[n] + 1;
                        int n2 = j;
                        avgScores[n2] = avgScores[n2] + scoreArray[j];
                        ++nonMissing;
                    }
                }
                for (int j2 = 0; j2 < avgScores.length; ++j2) {
                    assert (valNum != null);
                    if (valNum[j2] > 0) {
                        int n = j2;
                        avgScores[n] = avgScores[n] / (float)valNum[j2];
                        continue;
                    }
                    avgScores[j2] = Float.NaN;
                }
                for (String freqFieldName : freqFieldNames) {
                    float[] freqArray = (float[])record.get(freqFieldName);
                    if (avgFreqs == null) {
                        avgFreqs = new float[freqArray.length];
                        Arrays.fill(avgFreqs, 0.0f);
                        valNum = new int[freqArray.length];
                        Arrays.fill(valNum, 0);
                    }
                    j = 0;
                    while (j < freqArray.length) {
                        if (!Float.isNaN(freqArray[j])) {
                            int n = j;
                            avgFreqs[n] = avgFreqs[n] + freqArray[j];
                        }
                        int n = j++;
                        valNum[n] = valNum[n] + 1;
                    }
                }
                for (int j3 = 0; j3 < ((float[])Objects.requireNonNull(avgFreqs)).length; ++j3) {
                    if (valNum[j3] >= 0) {
                        int n = j3;
                        avgFreqs[n] = avgFreqs[n] / (float)valNum[j3];
                        continue;
                    }
                    avgFreqs[j3] = Float.NaN;
                }
                FloatList refFreqScoreArray = new FloatList();
                for (int i = 0; i < avgFreqs.length; ++i) {
                    refFreqScoreArray.add(avgFreqs[i] * (float)caseNum * 2.0f);
                    refFreqScoreArray.add(avgScores[i % avgScores.length]);
                }
                gr.setMutCountScoreListRef(refFreqScoreArray);
                gr.calcMidMutScoreControl();
                ++count;
            }
            reader.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            String info = e.getMessage() + " when loading gene feature file.";
            this.logger.error(info);
        }
        this.logger.info("{} gene regions are assigned frequency scores", (Object)count);
        return nonMissing != 0;
    }

    public void appendRefFreqScore2GeneRegions(File geneFreqScoreFile, String scoreFieldName, String[] freqFieldNames, int caseNum) throws IOException {
        CCFReader reader = new CCFReader(new CCFTable(geneFreqScoreFile));
        int count = 0;
        boolean nonMissing = false;
        try {
            IRecord record;
            float[] avgFreqs = null;
            FloatList scoreArray = null;
            int[] valNum = null;
            while ((record = reader.read()) != null) {
                int geneID = (Integer)record.get("Basic@SymbolID");
                int regionID = (Integer)record.get("Basic@GeneSubRegionTypeID");
                String label = geneID + "#" + regionID;
                GenomeRegion gr = this.labelRegionMap.get(label);
                if (gr == null) continue;
                avgFreqs = null;
                if (scoreFieldName != null) {
                    scoreArray = (FloatList)record.get(scoreFieldName);
                }
                for (String freqFieldName : freqFieldNames) {
                    FloatList freqArray = (FloatList)record.get(freqFieldName);
                    if (avgFreqs == null) {
                        avgFreqs = new float[freqArray.size()];
                        Arrays.fill(avgFreqs, 0.0f);
                        valNum = new int[freqArray.size()];
                        Arrays.fill(valNum, 0);
                    }
                    int j = 0;
                    while (j < avgFreqs.length) {
                        if (!Float.isNaN(freqArray.fastGet(j))) {
                            int n = j;
                            avgFreqs[n] = avgFreqs[n] + freqArray.fastGet(j);
                        }
                        int n = j++;
                        valNum[n] = valNum[n] + 1;
                    }
                }
                for (int j = 0; j < ((float[])Objects.requireNonNull(avgFreqs)).length; ++j) {
                    if (valNum[j] >= 0) {
                        int n = j;
                        avgFreqs[n] = avgFreqs[n] / (float)valNum[j];
                        continue;
                    }
                    avgFreqs[j] = Float.NaN;
                }
                FloatList refFreqScoreArray = new FloatList();
                if (scoreFieldName != null) {
                    for (int i = 0; i < avgFreqs.length; ++i) {
                        refFreqScoreArray.add(avgFreqs[i] * (float)caseNum * 2.0f);
                        refFreqScoreArray.add(scoreArray.fastGet(i));
                    }
                } else {
                    for (float avgFreq : avgFreqs) {
                        refFreqScoreArray.add(avgFreq * (float)caseNum * 2.0f);
                        refFreqScoreArray.add(1.0f);
                    }
                }
                gr.setMutCountScoreListRef(refFreqScoreArray);
                ++count;
            }
            reader.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            String info = e.getMessage() + " when loading gene feature file.";
            this.logger.error(info);
        }
        this.logger.info("{} gene regions are assigned frequency scores", (Object)count);
    }

    private void addVar2RegionalPredictorScores(List<Variant> regionVariants, GenomeRegion gr, List<String> addedValueFields) {
        double[] accumulatedFeatureScores = new double[addedValueFields.size()];
        Arrays.fill(accumulatedFeatureScores, Double.NaN);
        int[] accumulatedFeatureScoreCounts = new int[addedValueFields.size()];
        Arrays.fill(accumulatedFeatureScoreCounts, 0);
        int size = addedValueFields.size();
        for (int i = 0; i < size; ++i) {
            for (Variant var : regionVariants) {
                float scoreVal;
                if (var.getProperty(addedValueFields.get(i)) instanceof Number) {
                    scoreVal = ((Number)var.getProperty(addedValueFields.get(i))).floatValue();
                } else {
                    if (!(var.getProperty(addedValueFields.get(i)) instanceof Bytes)) continue;
                    Bytes scoreS = (Bytes)var.getProperty(addedValueFields.get(i));
                    scoreVal = scoreS.toFloat();
                }
                if (Float.isNaN(scoreVal)) continue;
                if (Double.isNaN(accumulatedFeatureScores[i])) {
                    accumulatedFeatureScores[i] = scoreVal;
                } else {
                    int n = i;
                    accumulatedFeatureScores[n] = accumulatedFeatureScores[n] + (double)scoreVal;
                }
                int n = i;
                accumulatedFeatureScoreCounts[n] = accumulatedFeatureScoreCounts[n] + 1;
            }
        }
        gr.setRegionScores(accumulatedFeatureScores);
        gr.setFeatureScoreCounts(accumulatedFeatureScoreCounts);
    }

    private void addVar2RegionalPredictorScores(Variant var, GenomeRegion gr, List<String> addedValueFields) {
        int[] featureScoreCounts;
        double[] featureScores = gr.getRegionScores();
        if (featureScores == null) {
            featureScores = new double[addedValueFields.size()];
            featureScoreCounts = new int[addedValueFields.size()];
            Arrays.fill(featureScores, Double.NaN);
            Arrays.fill(featureScoreCounts, 0);
            gr.setRegionScores(featureScores);
            gr.setFeatureScoreCounts(featureScoreCounts);
        } else {
            featureScoreCounts = gr.getFeatureScoreCounts();
        }
        int size = addedValueFields.size();
        for (int i = 0; i < size; ++i) {
            float scoreVal;
            if (var.getProperty(addedValueFields.get(i)) instanceof Number) {
                scoreVal = ((Number)var.getProperty(addedValueFields.get(i))).floatValue();
            } else {
                if (!(var.getProperty(addedValueFields.get(i)) instanceof Bytes)) continue;
                Bytes scoreS = (Bytes)var.getProperty(addedValueFields.get(i));
                scoreVal = scoreS.toFloat();
            }
            if (Float.isNaN(scoreVal)) continue;
            if (Double.isNaN(featureScores[i])) {
                featureScores[i] = scoreVal;
            } else {
                int n = i;
                featureScores[n] = featureScores[n] + (double)scoreVal;
            }
            int n = i;
            featureScoreCounts[n] = featureScoreCounts[n] + 1;
        }
    }

    private void extractAllGeneFeatures(Variant var, TIntObjectMap<TIntSet> geneVarIDMap, boolean needSubIntron, int dependentSubIntron) {
        Object feature = null;
        List geneFeatureAnnots = new List();
        geneFeatureAnnots.addAll(IGeneFeature.instancesOf((List)var.getProperty("GeneFeature@RefGene")));
        geneFeatureAnnots.addAll(IGeneFeature.instancesOf((List)var.getProperty("GeneFeature@GENCODE")));
        geneFeatureAnnots.addAll(IGeneFeature.instancesOf((List)var.getProperty("GeneFeature@KnownGene")));
        for (IGeneFeature item : geneFeatureAnnots) {
            int geneSymbIndex = item.getGeneSymbolID();
            byte featureID = item.getTypeID();
            if (featureID == VarGeneFeatureType.INTRONIC.getFeatureID() && needSubIntron && item.getSubRegionID() > dependentSubIntron) continue;
            TIntSet varType = geneVarIDMap.putIfAbsent(geneSymbIndex, new TIntHashSet());
            varType.add(featureID);
        }
    }

    private void collectRegionGeneInfor(List<Variant> regionVariants, GenomeRegion gr) {
        HashSet<String> geneSymbls = new HashSet<String>();
        ByteStream geneFeatureAnnots = new ByteStream();
        BytesSplitter splitter = new BytesSplitter(59);
        byte[] naCode = new byte[]{46};
        for (Variant var : regionVariants) {
            geneFeatureAnnots.clear();
            Bytes geneFeatureAnnot = (Bytes)var.getProperty("RefGene");
            if (geneFeatureAnnot != null && !geneFeatureAnnot.valueEquals(naCode)) {
                geneFeatureAnnots.write(geneFeatureAnnot);
                geneFeatureAnnots.write(59);
            }
            if ((geneFeatureAnnot = (Bytes)var.getProperty("GENCODE")) != null && !geneFeatureAnnot.valueEquals(naCode)) {
                geneFeatureAnnots.write(geneFeatureAnnot);
                geneFeatureAnnots.write(59);
            }
            if ((geneFeatureAnnot = (Bytes)var.getProperty("KnownGene")) != null && !geneFeatureAnnot.valueEquals(naCode)) {
                geneFeatureAnnots.write(geneFeatureAnnot);
                geneFeatureAnnots.write(59);
            }
            if (geneFeatureAnnots.length() == 0) continue;
            splitter.init(geneFeatureAnnots.toBytes());
            while (splitter.hasNext()) {
                Bytes item = splitter.next();
                int index = item.indexOf((byte)58);
                if (index <= 0) continue;
                Bytes geneSymb = item.subBytes(0, index);
                geneSymbls.add(geneSymb.toString());
            }
        }
        if (!geneSymbls.isEmpty()) {
            // empty if block
        }
    }

    public void removeDuplicateRegionSet() {
        this.logger.info("Sorting regions.");
        GenomeRegionComparator comparator = new GenomeRegionComparator();
        this.baseRegions.sort(comparator);
        List<String> tmpArray = new List<String>();
        this.logger.info("Removing duplicate regions.");
        for (int i = 0; i < this.baseRegions.size(); ++i) {
            GenomeRegion r2;
            GenomeRegion r1 = this.baseRegions.get(i);
            for (int j = i + 1; j < this.baseRegions.size() && comparator.compare(r1, r2 = this.baseRegions.get(j)) == 0; ++j) {
                if (!Arrays.equals(r1.getRegionScores(), r2.getRegionScores())) continue;
                tmpArray.add(r2.getLabel());
                this.baseRegions.remove(r2);
            }
            if (tmpArray.size() <= 0) continue;
            List<String> symbolArray = new List<String>();
            symbolArray.addAll(tmpArray);
            r1.setSameRegionsLabel(symbolArray);
            tmpArray.clear();
        }
    }

    private static class GenomeRegionComparator
    implements Comparator<GenomeRegion> {
        boolean useScan = DynamicScanWindows.getInstance().isUseScan();
        int scale = DynamicScanWindows.getInstance().getScale();

        private GenomeRegionComparator() {
        }

        @Override
        public int compare(GenomeRegion g1, GenomeRegion g2) {
            int chromosomeComparison = Integer.compare(g1.getChromID().getIndex(), g2.getChromID().getIndex());
            if (chromosomeComparison != 0) {
                return chromosomeComparison;
            }
            int startComparison = Integer.compare(g1.getStart(), g2.getStart());
            if (startComparison != 0) {
                return startComparison;
            }
            if (this.useScan) {
                return Integer.compare(g1.getType() % this.scale, g2.getType() % this.scale);
            }
            return Integer.compare(g1.getType(), g2.getType());
        }
    }

    private static class Test {
        String name;
        String Type;

        public Test(String name) {
            this.name = name;
        }

        public void setType(String type) {
            this.Type = type;
        }
    }

    private class CollectGeneVariantsThread
    implements ITask {
        List<Variant> variantList;
        List<String> addedValueFields;
        String mutationCaseSubjectField;
        GenomeRegion gene;
        boolean uniqueSubjectInARRegion;
        boolean isIntArray;
        String mutationCountCaseField;
        String mutationScoreCountField;
        GenomeRegion newGeneRegion;
        String[] freqFieldNames;
        boolean useAdjustedAC = false;
        String adjustedACMeta;
        String mutationControlSubjectField;
        String mutationCountControlField;

        public void setMutationCountControlField(String mutationCountControlField) {
            this.mutationCountControlField = mutationCountControlField;
        }

        public void setMutationControlSubjectField(String mutationControlSubjectField) {
            this.mutationControlSubjectField = mutationControlSubjectField;
        }

        public CollectGeneVariantsThread(List<String> addedValueFields, String mutationCaseSubjectField, boolean uniqueSubjectInARRegion, boolean isIntArray, String mutationCountCaseField, String mutationScoreCountField, boolean useAdjustedAC, String adjustedACMeta) {
            this.addedValueFields = addedValueFields;
            this.mutationCaseSubjectField = mutationCaseSubjectField;
            this.uniqueSubjectInARRegion = uniqueSubjectInARRegion;
            this.isIntArray = isIntArray;
            this.mutationCountCaseField = mutationCountCaseField;
            this.mutationScoreCountField = mutationScoreCountField;
            this.useAdjustedAC = useAdjustedAC;
            this.adjustedACMeta = adjustedACMeta;
        }

        public CollectGeneVariantsThread(List<String> addedValueFields, String mutationCaseSubjectField, boolean uniqueSubjectInARRegion, boolean isIntArray, String mutationCountCaseField, String mutationScoreCountField) {
            this.addedValueFields = addedValueFields;
            this.mutationCaseSubjectField = mutationCaseSubjectField;
            this.uniqueSubjectInARRegion = uniqueSubjectInARRegion;
            this.isIntArray = isIntArray;
            this.mutationCountCaseField = mutationCountCaseField;
            this.mutationScoreCountField = mutationScoreCountField;
        }

        public CollectGeneVariantsThread(List<String> addedValueFields, String mutationCaseSubjectField, boolean uniqueSubjectInARRegion, boolean isIntArray, String mutationCountCaseField, String mutationScoreCountField, String mutationControlSubjectField, String mutationCountControlField, String[] freqFieldNames, boolean useAdjustedAC, String adjustedACMeta) {
            this.addedValueFields = addedValueFields;
            this.mutationCaseSubjectField = mutationCaseSubjectField;
            this.uniqueSubjectInARRegion = uniqueSubjectInARRegion;
            this.isIntArray = isIntArray;
            this.mutationCountCaseField = mutationCountCaseField;
            this.mutationScoreCountField = mutationScoreCountField;
            this.mutationControlSubjectField = mutationControlSubjectField;
            this.mutationCountControlField = mutationCountControlField;
            this.freqFieldNames = freqFieldNames;
            this.useAdjustedAC = useAdjustedAC;
            this.adjustedACMeta = adjustedACMeta;
        }

        public void setGene(List<Variant> variantCaseHigh, GenomeRegion gene) {
            this.variantList = new List();
            this.variantList.addAll(variantCaseHigh);
            this.gene = gene;
        }

        protected void fireTaskComplete() {
        }

        @Override
        public void execute(Status status, Context context) throws Error {
            int maxPos = Integer.MIN_VALUE;
            int minPos = Integer.MAX_VALUE;
            this.newGeneRegion = new GenomeRegion(this.gene.getLabel());
            this.newGeneRegion.setType(this.gene.getType());
            this.newGeneRegion.setChromID(this.gene.getChromID());
            String[] mutatedSubjectsCase = null;
            String[] mutatedSubjectsControl = null;
            IntList mutatedSubjectsInt = null;
            IntList mutatedSubjectsControlInt = null;
            double scoreVal = Double.NaN;
            boolean noScoreWeight = this.mutationScoreCountField == null;
            FloatList refFreqScoreArray = new FloatList();
            for (Variant var : this.variantList) {
                Float scoreS;
                Var2RegionMapper.this.addVar2RegionalPredictorScores(var, this.newGeneRegion, (List<String>)this.addedValueFields);
                if (this.isIntArray) {
                    int k;
                    if (this.mutationCaseSubjectField != null) {
                        mutatedSubjectsInt = (IntList)var.getProperty(this.mutationCaseSubjectField);
                        mutatedSubjectsCase = new String[mutatedSubjectsInt.size()];
                        for (k = 0; k < mutatedSubjectsCase.length; ++k) {
                            mutatedSubjectsCase[k] = String.valueOf(mutatedSubjectsInt.get(k));
                        }
                    }
                    if (this.mutationControlSubjectField != null) {
                        mutatedSubjectsControlInt = (IntList)var.getProperty(this.mutationControlSubjectField);
                        mutatedSubjectsControl = new String[mutatedSubjectsControlInt.size()];
                        for (k = 0; k < mutatedSubjectsControl.length; ++k) {
                            mutatedSubjectsControl[k] = String.valueOf(mutatedSubjectsControlInt.get(k));
                        }
                    }
                } else {
                    mutatedSubjectsCase = (String[])var.getProperty(this.mutationCaseSubjectField);
                    mutatedSubjectsControl = (String[])var.getProperty(this.mutationControlSubjectField);
                }
                scoreVal = noScoreWeight ? 1.0 : ((scoreS = (Float)var.getProperty(this.mutationScoreCountField)) == null ? Double.NaN : (double)scoreS.floatValue());
                if (var.getPosition() > maxPos) {
                    maxPos = var.getPosition();
                }
                if (var.getPosition() < minPos) {
                    minPos = var.getPosition();
                }
                if (this.useAdjustedAC) {
                    float adjustedAC = ((Float)var.getProperty(this.adjustedACMeta)).floatValue();
                    if (Float.isNaN(adjustedAC)) {
                        adjustedAC = 0.0f;
                    }
                    refFreqScoreArray.add(adjustedAC);
                    refFreqScoreArray.add((float)scoreVal);
                } else {
                    float avgFreq = 0.0f;
                    for (String freqFieldName : this.freqFieldNames) {
                        float freq = ((Float)var.getProperty(freqFieldName)).floatValue();
                        if (Float.isNaN(freq)) continue;
                        avgFreq += freq;
                    }
                    this.newGeneRegion.addRefFreqScore(avgFreq /= (float)this.freqFieldNames.length, (float)scoreVal);
                }
                if (this.uniqueSubjectInARRegion) {
                    this.newGeneRegion.addCaseSubjectIDMutMaxScore(mutatedSubjectsCase, (float)scoreVal);
                    this.newGeneRegion.addControlSubjectIDMutMaxScore(mutatedSubjectsControl, (float)scoreVal);
                }
                if (!this.useAdjustedAC || this.uniqueSubjectInARRegion) continue;
                this.newGeneRegion.addCaseSubjectIDMutSumScore(mutatedSubjectsCase, (float)scoreVal);
                this.newGeneRegion.addControlSubjectIDMutSumScore(mutatedSubjectsControl, (float)scoreVal);
            }
            this.variantList = null;
            if (this.newGeneRegion.getCaseIDMutMaxScoreMap() == null) {
                this.newGeneRegion = null;
            } else {
                this.newGeneRegion.setStart(minPos);
                this.newGeneRegion.setEnd(maxPos);
                this.newGeneRegion.calcMidMutScoreCase();
                if (this.useAdjustedAC) {
                    this.newGeneRegion.setMutCountScoreListRef(refFreqScoreArray);
                    this.newGeneRegion.calcMidScoreRef();
                } else {
                    this.newGeneRegion.calcMidScoreRef();
                }
                double[] featureScores = this.newGeneRegion.getRegionScores();
                if (featureScores != null) {
                    int[] featureScoreCounts = this.newGeneRegion.getFeatureScoreCounts();
                    for (int j = 0; j < featureScoreCounts.length; ++j) {
                        featureScores[j] = featureScoreCounts[j] == 0 ? Double.NaN : featureScores[j] / (double)featureScoreCounts[j];
                    }
                }
            }
            this.fireTaskComplete();
        }
    }

    private static class VariantScoreFloatListStandardizeThread
    implements ITask {
        GenomeRegion gr;
        DoubleArrayList scores;
        double scoreSize;
        FloatList mutCountScore;
        int size;
        String field;

        public VariantScoreFloatListStandardizeThread(DoubleArrayList scores) {
            this.scores = scores;
            this.scoreSize = scores.size();
        }

        public void setGeneRegion(GenomeRegion gr, FloatList mutCountScore, String field) {
            this.gr = gr;
            this.mutCountScore = mutCountScore;
            this.size = mutCountScore.size() / 2;
            this.field = field;
        }

        @Override
        public void execute(Status status, Context context) throws Exception, Error {
            for (int i = 0; i < this.size; ++i) {
                float score = this.mutCountScore.get(i + i + 1);
                if (Float.isNaN(score)) continue;
                int index = this.scores.binarySearch(score);
                if (index < 0) {
                    index = -index - 1;
                }
                while (this.scores.getQuick(index) == (double)score) {
                    if (--index >= 0) continue;
                    index = 0;
                    break;
                }
                score = (float)((double)index / this.scoreSize);
                this.mutCountScore.set(i + i + 1, score);
            }
            GenomeRegion.setFieldValue(this.gr, this.field, this.mutCountScore);
        }
    }

    private static class VariantScoreStandardizeThread
    implements ITask {
        GenomeRegion gr;
        DoubleArrayList globalScores;
        double globalScoreSize;

        public VariantScoreStandardizeThread(DoubleArrayList globalScores) {
            this.globalScores = globalScores;
            this.globalScoreSize = globalScores.size();
        }

        public void setGeneRegion(GenomeRegion gr) {
            this.gr = gr;
        }

        @Override
        public void execute(Status status, Context context) throws Exception, Error {
            FloatList mutCountScoreListRef;
            TObjectFloatMap<String> controlMutCountScoresMap;
            int index;
            float score;
            int i;
            TObjectFloatMap<String> mutCountScoresMap = this.gr.getCaseIDMutMaxScoreMap();
            if (mutCountScoresMap != null) {
                mutCountScoresMap.forEachEntry((key, value) -> {
                    if (!Float.isNaN(value)) {
                        int index1 = this.globalScores.binarySearch(value);
                        if (index1 < 0) {
                            index1 = -index1 - 1;
                        }
                        while (this.globalScores.getQuick(index1) == (double)value) {
                            if (--index1 >= 0) continue;
                            index1 = 0;
                            break;
                        }
                        float score1 = (float)((double)index1 / this.globalScoreSize);
                        mutCountScoresMap.put((String)key, score1);
                    }
                    return true;
                });
                FloatList uniqueScores = this.gr.getMutUniqueScoreCase();
                if (uniqueScores != null) {
                    int size = uniqueScores.size();
                    for (i = 0; i < size; ++i) {
                        score = uniqueScores.get(i);
                        if (Float.isNaN(score)) continue;
                        index = this.globalScores.binarySearch(score);
                        if (index < 0) {
                            index = -index - 1;
                        }
                        while (this.globalScores.getQuick(index) == (double)score) {
                            if (--index >= 0) continue;
                            index = 0;
                            break;
                        }
                        score = (float)((double)index / this.globalScoreSize);
                        uniqueScores.set(i, score);
                    }
                    this.gr.calcMidMutScoreCase();
                }
            }
            if ((controlMutCountScoresMap = this.gr.getControlIDMutMaxScoreMap()) != null) {
                controlMutCountScoresMap.forEachEntry((key, value) -> {
                    if (!Float.isNaN(value)) {
                        int index2 = this.globalScores.binarySearch(value);
                        if (index2 < 0) {
                            index2 = -index2 - 1;
                        }
                        while (this.globalScores.getQuick(index2) == (double)value) {
                            if (--index2 >= 0) continue;
                            index2 = 0;
                            break;
                        }
                        float score2 = (float)((double)index2 / this.globalScoreSize);
                        controlMutCountScoresMap.put((String)key, score2);
                    }
                    return true;
                });
                FloatList uniqueScores = this.gr.getMutUniqueScoreControl();
                if (uniqueScores != null) {
                    int size = uniqueScores.size();
                    for (int i2 = 0; i2 < size; ++i2) {
                        score = uniqueScores.get(i2);
                        if (Float.isNaN(score)) continue;
                        index = this.globalScores.binarySearch(score);
                        if (index < 0) {
                            index = -index - 1;
                        }
                        while (this.globalScores.getQuick(index) == (double)score) {
                            if (--index >= 0) continue;
                            index = 0;
                            break;
                        }
                        score = (float)((double)index / this.globalScoreSize);
                        uniqueScores.set(i2, score);
                    }
                    this.gr.calcMidMutScoreControl();
                }
            }
            if ((mutCountScoreListRef = this.gr.getMutCountScoreListRef()) != null) {
                for (i = 0; i < mutCountScoreListRef.size() / 2; ++i) {
                    score = mutCountScoreListRef.get(i + i + 1);
                    if (Float.isNaN(score)) continue;
                    index = this.globalScores.binarySearch(score);
                    if (index < 0) {
                        index = -index - 1;
                    }
                    while (this.globalScores.getQuick(index) == (double)score) {
                        if (--index >= 0) continue;
                        index = 0;
                        break;
                    }
                    score = (float)((double)index / this.globalScoreSize);
                    mutCountScoreListRef.set(i + i + 1, score);
                }
                this.gr.calcMidScoreRef();
            }
        }
    }
}

