/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.annotation;

import edu.sysu.pmglab.utils.Assert;
import gnu.trove.map.hash.THashMap;
import java.util.Map;

public enum VarGeneFeatureType {
    FRAME_SHIFT(0, "frameshift"),
    NON_FRAME_SHIFT(1, "nonframeshift"),
    START_LOSS(2, "startloss"),
    STOP_LOSS(3, "stoploss"),
    STOP_GAINED(4, "stopgain"),
    SPLICING(5, "splicing"),
    MISSENSE(6, "missense"),
    SYNONYMOUS(7, "synonymous"),
    EXONIC(8, "exonic"),
    FIVE_PRIME_UTR(9, "5UTR", "5'UTR", "5_UTR"),
    THREE_PRIME_UTR(10, "3UTR", "3'UTR", "3_UTR"),
    INTRONIC(11, "intronic"),
    UPSTREAM(12, "upstream"),
    DOWNSTREAM(13, "downstream"),
    NC_RNA(14, "ncRNA"),
    INTERGENIC(15, "intergenic"),
    MONOMORPHIC(16, "monomorphic"),
    UNKNOWN(17, "unknown", "un_known");

    public final byte index;
    private final String msg;

    private VarGeneFeatureType(byte code, String ... names) {
        Assert.that(names != null && names.length >= 1);
        this.index = code;
        this.msg = names[0];
        TypeDict.putName(this.toString(), this);
        for (String name : names) {
            TypeDict.putName(name, this);
        }
        TypeDict.putIndex(this.index, this);
    }

    public String getFeatureName() {
        return this.msg;
    }

    public byte getFeatureID() {
        return this.index;
    }

    public static String getFeatureName(int id) {
        return TypeDict.getByIndex(id).getFeatureName();
    }

    public static byte getFeatureID(String name) {
        return TypeDict.get(name).getFeatureID();
    }

    public static byte[] getExonicIDs() {
        return new byte[]{VarGeneFeatureType.FRAME_SHIFT.index, VarGeneFeatureType.MISSENSE.index, VarGeneFeatureType.NON_FRAME_SHIFT.index, VarGeneFeatureType.START_LOSS.index, VarGeneFeatureType.STOP_GAINED.index, VarGeneFeatureType.STOP_LOSS.index, VarGeneFeatureType.SYNONYMOUS.index};
    }

    public static int getTotalFeatureNum() {
        return VarGeneFeatureType.UNKNOWN.index + 1;
    }

    public String getName() {
        return this.msg;
    }

    static class TypeDict {
        static final Map<String, VarGeneFeatureType> dicts = new THashMap<String, VarGeneFeatureType>();
        static final Map<Integer, VarGeneFeatureType> indexDicts = new THashMap<Integer, VarGeneFeatureType>();

        TypeDict() {
        }

        public static VarGeneFeatureType get(String name) {
            return dicts.get(name);
        }

        public static VarGeneFeatureType getByIndex(int index) {
            return indexDicts.get(index);
        }

        public static void putName(String name, VarGeneFeatureType type) {
            dicts.put(name, type);
        }

        public static void putIndex(int index, VarGeneFeatureType type) {
            indexDicts.put(index, type);
        }
    }
}

