/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.annotation.database;

import edu.sysu.pmglab.RuntimeProperty;
import edu.sysu.pmglab.annotation.database.DatabaseDescription;
import edu.sysu.pmglab.annotation.database.IntervalDatabaseDescription;
import edu.sysu.pmglab.ccf.CCFTable;
import edu.sysu.pmglab.ccf.LiteTable;
import edu.sysu.pmglab.ccf.ReaderOption;
import edu.sysu.pmglab.ccf.field.FieldGroupMeta;
import edu.sysu.pmglab.ccf.field.FieldMeta;
import edu.sysu.pmglab.ccf.field.IFieldCollection;
import edu.sysu.pmglab.ccf.indexer.intvalue.CCFIntIndexer;
import edu.sysu.pmglab.ccf.meta.ICCFMeta;
import edu.sysu.pmglab.ccf.record.IRecord;
import edu.sysu.pmglab.ccf.toolkit.Indexer;
import edu.sysu.pmglab.ccf.toolkit.annotator.Database;
import edu.sysu.pmglab.ccf.toolkit.annotator.GTBDatabase;
import edu.sysu.pmglab.ccf.toolkit.annotator.IntervalDatabase;
import edu.sysu.pmglab.ccf.toolkit.listener.InputListener;
import edu.sysu.pmglab.ccf.type.FieldType;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.gtb.GTBManager;
import edu.sysu.pmglab.gtb.GTBReaderOption;
import edu.sysu.pmglab.gtb.genome.Variant;
import edu.sysu.pmglab.gtb.genome.coordinate.Chromosome;
import edu.sysu.pmglab.gtb.toolkit.GTBIndexer;
import edu.sysu.pmglab.gtb.toolkit.annotator.Conservation;
import edu.sysu.pmglab.gtb.toolkit.annotator.DBNSFP_RankScore;
import edu.sysu.pmglab.gtb.toolkit.annotator.EpiMap;
import edu.sysu.pmglab.gtb.toolkit.annotator.FAVOR;
import edu.sysu.pmglab.gtb.toolkit.annotator.GNOMAD;
import edu.sysu.pmglab.gtb.toolkit.annotator.PEXT;
import edu.sysu.pmglab.gtb.toolkit.annotator.RegBase;
import edu.sysu.pmglab.io.file.Channel;
import edu.sysu.pmglab.io.file.LiveFile;
import edu.sysu.pmglab.text.Utility;
import edu.sysu.pmglab.utils.Downloader;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public class DataBaseFactory {
    private DataBaseFactory() {
    }

    public static Database<?, Variant> instanceOf(DatabaseDescription databaseDescription) throws Exception {
        GTBDatabase database;
        LiveFile pathToDatabase;
        String databaseName;
        LiveFile path = databaseDescription.getPath();
        Set<String> specifiedFieldNames = databaseDescription.getFields() == null ? null : databaseDescription.getFields();
        switch (databaseName = databaseDescription.getName().toLowerCase()) {
            case "gnomad": {
                if (path == null) {
                    pathToDatabase = Channel.get(databaseName, "/gnomad/gnomad.joint.v4.1.sites.hg38.gtb");
                    if (pathToDatabase == null) {
                        throw new RuntimeException("Could not find gnomad database! Please set the path by -vad gnomad path=/path/to/gtb/file \n");
                    }
                } else {
                    pathToDatabase = databaseDescription.getPath();
                }
                GTBReaderOption readerOption = DataBaseFactory.getReadOptions(pathToDatabase, specifiedFieldNames);
                database = new GNOMAD(readerOption);
                break;
            }
            case "dbnsfp": {
                if (path == null) {
                    pathToDatabase = Channel.get(databaseName, "/dbnsfp/dbNSFP4.8a_variant.gtb");
                    pathToDatabase = Channel.get(databaseName, "/dbnsfp/dbNSFP5.0a_variant.hg38.gtb");
                    if (pathToDatabase == null) {
                        throw new RuntimeException("Could not find dbnsfp database! Please set the path by -vad dbnsfp path=/path/to/gtb/file \n");
                    }
                } else {
                    pathToDatabase = databaseDescription.getPath();
                }
                GTBReaderOption readerOption = DataBaseFactory.getReadOptions(pathToDatabase, specifiedFieldNames);
                database = new DBNSFP_RankScore(readerOption);
                break;
            }
            case "conservation": {
                if (path == null) {
                    pathToDatabase = Channel.get(databaseName, "/conservation/VarNoteDB_ES_Conservation_Aggregation.hg38.gtb");
                    if (pathToDatabase == null) {
                        throw new RuntimeException("Could not find conservation database! Please set the path by -vad conservation path=/path/to/gtb/file \n");
                    }
                } else {
                    pathToDatabase = databaseDescription.getPath();
                }
                GTBReaderOption readerOption = DataBaseFactory.getReadOptions(pathToDatabase, specifiedFieldNames);
                database = new Conservation(readerOption);
                break;
            }
            case "cadd": {
                if (path == null) {
                    pathToDatabase = Channel.get(databaseName, "/cadd/CADD_v1.7.hg38.gtb");
                    if (pathToDatabase == null) {
                        throw new RuntimeException("Could not find cadd database! Please set the path by -vad cadd path=/path/to/gtb/file \n");
                    }
                } else {
                    pathToDatabase = databaseDescription.getPath();
                }
                GTBReaderOption readerOption = DataBaseFactory.getReadOptions(pathToDatabase, specifiedFieldNames);
                database = new GTBDatabase(readerOption);
                break;
            }
            case "favor": {
                if (path == null) {
                    pathToDatabase = Channel.get(databaseName, "/favor/FAVOR.ALL.hg38.gtb");
                    if (pathToDatabase == null) {
                        throw new RuntimeException("Could not find favor database! Please set the path by -vad favor path=/path/to/gtb/file \n");
                    }
                } else {
                    pathToDatabase = databaseDescription.getPath();
                }
                GTBReaderOption readerOption = DataBaseFactory.getReadOptions(pathToDatabase, specifiedFieldNames);
                database = new FAVOR(readerOption, specifiedFieldNames == null ? null : readerOption.subsetFields(specifiedFieldNames), readerOption.getGTBManager().getMeta());
                DataBaseFactory.checkFieldNames(database, specifiedFieldNames);
                break;
            }
            case "regbase": {
                if (path == null) {
                    pathToDatabase = Channel.get(databaseName, "/regbase/FAVOR.ALL.hg38.gtb");
                    if (pathToDatabase == null) {
                        throw new RuntimeException("Could not find regbase database! Please set the path by -vad regbase path=/path/to/gtb/file \n");
                    }
                } else {
                    pathToDatabase = databaseDescription.getPath();
                }
                GTBReaderOption readerOption = DataBaseFactory.getReadOptions(pathToDatabase, specifiedFieldNames);
                database = new RegBase(readerOption, specifiedFieldNames == null ? null : readerOption.subsetFields(specifiedFieldNames), readerOption.getGTBManager().getMeta());
                DataBaseFactory.checkFieldNames(database, specifiedFieldNames);
                break;
            }
            case "pext": {
                if (path == null) {
                    pathToDatabase = Channel.get(databaseName, "/pext/pext.hg38.gtb");
                    if (pathToDatabase == null) {
                        throw new RuntimeException("Could not find pext database! Please set the path by -vad pext path=/path/to/gtb/file \n");
                    }
                } else {
                    pathToDatabase = databaseDescription.getPath();
                }
                GTBReaderOption readerOption = DataBaseFactory.getReadOptions(pathToDatabase, specifiedFieldNames);
                database = new PEXT(readerOption);
                break;
            }
            case "clinvar": {
                if (path == null) {
                    pathToDatabase = Channel.get(databaseName, "/clinvar/clinvar.hg38.gtb");
                    if (pathToDatabase == null) {
                        throw new RuntimeException("Could not find clinvar database! Please set the path by -vad clinvar path=/path/to/gtb/file \n");
                    }
                } else {
                    pathToDatabase = databaseDescription.getPath();
                }
                GTBReaderOption readerOption = DataBaseFactory.getReadOptions(pathToDatabase, specifiedFieldNames);
                database = new GTBDatabase(readerOption);
                break;
            }
            default: {
                pathToDatabase = databaseDescription.getPath();
                GTBReaderOption readerOption = DataBaseFactory.getReadOptions(pathToDatabase, specifiedFieldNames);
                database = new GTBDatabase(readerOption);
            }
        }
        databaseDescription.setPath(pathToDatabase);
        return database;
    }

    public static Database<?, Variant> instanceOfBED(IntervalDatabaseDescription databaseDescription) throws Exception {
        LiveFile userSpecifiedPath = databaseDescription.getPath();
        final Set<String> specifiedFieldNames = databaseDescription.getFields() == null ? null : databaseDescription.getFields();
        String databaseName = databaseDescription.getName().toLowerCase();
        IntervalDatabase database = null;
        if (databaseName.startsWith("eipmap")) {
            if (databaseDescription.isGib()) {
                database = new EpiMap(databaseDescription.getPath());
            } else {
                LiveFile pathToDatabase = Channel.get("eipmap", "/eipmap/" + databaseDescription.getName() + ".gib");
                if (pathToDatabase == null) {
                    String localResourcePathName = RuntimeProperty.getClassPath(DataBaseFactory.class).getPath();
                    localResourcePathName = localResourcePathName.contains("out/production") ? "./resources" : localResourcePathName + "/resources";
                    File gibPath = new File(localResourcePathName + "/eipmap/" + databaseDescription.getName() + ".gib");
                    if (!gibPath.exists()) {
                        String name = "impute_" + databaseDescription.getGeoID() + "_" + databaseDescription.getMarkerID();
                        LiveFile remoteFile = LiveFile.of("https://epigenome.wustl.edu/epimap/data/imputed/" + name + ".bigWig");
                        File bigWigLocalFile = RuntimeProperty.createFile(remoteFile.getName());
                        Downloader downloader = new Downloader(remoteFile, bigWigLocalFile);
                        if (!bigWigLocalFile.exists() || downloader.compareTime() != 0) {
                            downloader.download();
                        }
                        gibPath.getParentFile().mkdirs();
                        EpiMap.buildFrom(bigWigLocalFile).setOutput(gibPath).build(4);
                    }
                    pathToDatabase = LiveFile.of(gibPath);
                }
                database = new EpiMap(pathToDatabase);
            }
        } else {
            if (userSpecifiedPath == null || userSpecifiedPath.length() == 0L) {
                throw new RuntimeException("Please set the userSpecifiedPath of --region-annotation-database if you do not specify EipMap!\n");
            }
            LiveFile pathToDatabase = databaseDescription.getPath();
            final CCFTable table = new CCFTable(pathToDatabase);
            if (table.containsField(null, "CHROM") && table.containsField(null, "POS_START") && table.containsField(null, "POS_END")) {
                CCFIntIndexer<Object> indexer = (Boolean)table.getOption("INDEXER") != false ? new CCFIntIndexer((LiteTable)table.getOption("INDEXER")) : Indexer.setInput(table, "CHROM", "POS_START").getTagFrom(record -> (Chromosome)record.get("CHROM"), FieldType.chromosome).getIntValueFrom(record -> (Integer)record.get("POS_START")).setListener(new InputListener("Indexed", "records")).build(2);
                database = new IntervalDatabase(new ReaderOption(table, new String[0]), indexer){
                    final IFieldCollection fields;
                    {
                        super(x0, x1);
                        this.fields = table.subsetFields(specifiedFieldNames).asUnmodifiable();
                    }

                    @Override
                    public IFieldCollection getAllFields() {
                        return this.fields;
                    }

                    @Override
                    public ICCFMeta getMeta() {
                        return table.getMeta();
                    }

                    @Override
                    public boolean annotate(List<IRecord> resources, long pointer, Variant variant) {
                        return super.annotate(resources, pointer, variant);
                    }
                };
                DataBaseFactory.checkFieldNames(database, specifiedFieldNames);
                return database;
            }
            throw new Exception("The database " + databaseName + " is not available!");
        }
        return database;
    }

    private static GTBReaderOption getReadOptions(LiveFile pathToDatabase, Set<String> specifiedFieldNames) throws IOException {
        GTBReaderOption readerOption;
        GTBManager manager = new GTBManager(pathToDatabase);
        if (manager.getIndexer() == null) {
            System.out.println(pathToDatabase + " has no index!");
            GTBIndexer.setInput(manager, new String[0]).save(4);
        }
        if (specifiedFieldNames != null) {
            HashSet<String> allFieldNameSet = new HashSet<String>();
            Iterable<String> allFieldNames = manager.getAllFieldNames();
            for (String field : allFieldNames) {
                allFieldNameSet.add(field);
            }
            HashSet<String> allFieldGroupSet = new HashSet<String>();
            Iterable<String> allFieldGroups = manager.getAllFieldGroupNames();
            for (String field : allFieldGroups) {
                allFieldGroupSet.add(field);
            }
            readerOption = (GTBReaderOption)new GTBReaderOption(manager, false, false).addFields(manager.subsetFields(specifiedFieldNames));
            for (String fieldName : specifiedFieldNames) {
                if (fieldName.contains("@")) {
                    FieldMeta field = manager.getField(fieldName);
                    if (field != null) {
                        readerOption.addFields((IFieldCollection)field);
                        continue;
                    }
                    try {
                        ArrayList<String> similarFields = new ArrayList<String>(Utility.top3Matches(allFieldNameSet, fieldName));
                        throw new Exception("Unavailable field '" + fieldName + "' in resource database " + pathToDatabase.getName() + "\nThe available similar fields are : " + similarFields);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                FieldGroupMeta fieldGroup = manager.getFieldGroup(fieldName);
                if (fieldGroup != null) {
                    readerOption.addFields(fieldGroup);
                    continue;
                }
                try {
                    ArrayList<String> similarFields = new ArrayList<String>(Utility.top3Matches(allFieldGroupSet, fieldName));
                    throw new Exception("Unavailable field group name'" + fieldName + "' in resource database " + pathToDatabase.getName() + "\nThe available similar field groups are : " + similarFields);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        } else {
            readerOption = new GTBReaderOption(manager, false, true);
        }
        return readerOption;
    }

    private static void checkFieldNames(Database<?, Variant> database, Set<String> specifiedFields) throws Exception {
        if (specifiedFields == null || specifiedFields.isEmpty()) {
            return;
        }
        if (database.getAllFields().numOfFields() < specifiedFields.size()) {
            List<String> unavailableFields = new List<String>();
            HashSet<String> allFieldNameSet = new HashSet<String>();
            IFieldCollection fieldMetas = database.getAllFields();
            for (FieldMeta name : fieldMetas) {
                allFieldNameSet.add(name.fullName());
            }
            ArrayList<String> similarFields = new ArrayList<String>();
            for (String name : specifiedFields) {
                if (fieldMetas.containsField(name)) continue;
                unavailableFields.add(name);
                similarFields.addAll(Utility.top3Matches(allFieldNameSet, name));
            }
            throw new Exception("The specified fields " + unavailableFields + " for database [" + database.getDatabaseName() + "] are unavailable!\nThe available similar fields are : " + similarFields);
        }
    }
}

