/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.annotation.database;

import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.io.file.LiveFile;
import java.util.HashSet;
import java.util.Set;

public class DatabaseDescription {
    String name;
    LiveFile path;
    final Set<String> fields;

    public String getName() {
        return this.name;
    }

    public LiveFile getPath() {
        return this.path;
    }

    public void setPath(LiveFile path) {
        this.path = path;
    }

    public Set<String> getFields() {
        return this.fields;
    }

    public DatabaseDescription(String name, LiveFile path, String[] fields) {
        this.name = name;
        this.path = path;
        if (fields != null && fields.length > 0) {
            this.fields = new HashSet<String>();
            for (String field : fields) {
                if (field.trim().isEmpty()) continue;
                this.fields.add(field.trim());
            }
        } else {
            this.fields = null;
        }
    }

    public DatabaseDescription(String name, String[] fields) {
        this.name = name;
        this.path = null;
        if (fields != null && fields.length > 0) {
            this.fields = new HashSet<String>();
            for (String field : fields) {
                if (field.trim().isEmpty()) continue;
                this.fields.add(field.trim());
            }
        } else {
            this.fields = null;
        }
    }

    public DatabaseDescription(String name) {
        this.name = name;
        this.path = null;
        this.fields = null;
    }

    public String toString() {
        return "DatabaseDescription{name='" + this.name + '\'' + ", path='" + (this.path == null ? "." : this.path.getPath()) + '\'' + (this.fields == null ? "" : ", fields=" + List.wrap(this.fields).toString(",")) + '}';
    }
}

