/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.annotation.database;

import edu.sysu.pmglab.annotation.SeqSegment;
import edu.sysu.pmglab.annotation.Transcript;
import edu.sysu.pmglab.annotation.VarGeneFeatureType;
import edu.sysu.pmglab.annotation.database.DatabaseDescription;
import edu.sysu.pmglab.annotation.database.GeneFeatureDatabases;
import edu.sysu.pmglab.ccf.meta.CCFMetaItem;
import edu.sysu.pmglab.ccf.toolkit.listener.AnnotationListener;
import edu.sysu.pmglab.ccf.type.FieldType;
import edu.sysu.pmglab.container.indexable.IndexableSet;
import edu.sysu.pmglab.container.intervaltree.inttree.IntIntervalTree;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.container.rangelist.VarInt32RangeList;
import edu.sysu.pmglab.gtb.GTBManager;
import edu.sysu.pmglab.gtb.GTBReaderOption;
import edu.sysu.pmglab.gtb.genome.Variant;
import edu.sysu.pmglab.gtb.genome.coordinate.Chromosome;
import edu.sysu.pmglab.gtb.genome.coordinate.PositionType;
import edu.sysu.pmglab.gtb.genome.coordinate.Strand;
import edu.sysu.pmglab.gtb.toolkit.GTBAnnotator;
import edu.sysu.pmglab.io.file.Channel;
import edu.sysu.pmglab.io.file.LiveFile;
import edu.sysu.pmglab.io.text.TextRecord;
import edu.sysu.pmglab.io.text.reader.IHeaderParser;
import edu.sysu.pmglab.io.text.reader.Separator;
import edu.sysu.pmglab.io.text.reader.TextReader;
import edu.sysu.pmglab.kgga.command.SetupApplication;
import edu.sysu.pmglab.kgga.command.pipeline.AnnotationOptions;
import edu.sysu.pmglab.kgga.command.setting.GlobalAnnotationGenomeVersion;
import edu.sysu.pmglab.utils.Downloader;
import gnu.trove.iterator.TIntIterator;
import gnu.trove.map.hash.THashMap;
import gnu.trove.set.TIntSet;
import gnu.trove.set.hash.TIntHashSet;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;

public enum GeneFeatureDBUtility {
    INSTANCE;


    public void fillPathWithDefaultDatabases(List<DatabaseDescription> defaultDatabases) throws IOException {
        if (defaultDatabases == null) {
            SetupApplication.GlobalLogger.info("No default databases found.");
            return;
        }
        for (DatabaseDescription databaseDescription : defaultDatabases) {
            Downloader downloader;
            String url;
            File resourcePath;
            LiveFile databaseSourceFile;
            String localPath;
            String standDatabaseName;
            if ("RefGene".equalsIgnoreCase(databaseDescription.getName())) {
                standDatabaseName = "RefGene";
                if (databaseDescription.getPath() == null) {
                    localPath = "gene/refGene_" + (Object)((Object)GlobalAnnotationGenomeVersion.refGenomeVersion) + "_kggseq_v2.txt.gz";
                    databaseSourceFile = Channel.get(standDatabaseName, localPath);
                    if (databaseSourceFile == null || databaseSourceFile.getPath().startsWith("http")) {
                        resourcePath = new File("./resources/" + localPath);
                        url = "https://idc.biosino.org/pmglab/resource/kgg/kgga/resources/" + localPath;
                        downloader = new Downloader(LiveFile.of(url), resourcePath);
                        downloader.setThreads(4);
                        if (downloader.compareTime() != 0) {
                            downloader.download();
                        }
                        databaseSourceFile = LiveFile.of(resourcePath.getPath());
                    }
                } else {
                    databaseSourceFile = databaseDescription.getPath();
                }
            } else if ("GENCODE".equalsIgnoreCase(databaseDescription.getName())) {
                standDatabaseName = "GENCODE";
                if (databaseDescription.getPath() == null) {
                    localPath = "gene/GEncode_" + (Object)((Object)GlobalAnnotationGenomeVersion.refGenomeVersion) + "_kggseq_v2.txt.gz";
                    databaseSourceFile = Channel.get(standDatabaseName, localPath);
                    if (databaseSourceFile == null || databaseSourceFile.getPath().startsWith("http")) {
                        resourcePath = new File("./resources/" + localPath);
                        url = "https://idc.biosino.org/pmglab/resource/kgg/kgga/resources/" + localPath;
                        System.out.println(url);
                        downloader = new Downloader(LiveFile.of(url), resourcePath);
                        downloader.setThreads(4);
                        if (downloader.compareTime() != 0) {
                            downloader.download();
                        }
                        databaseSourceFile = LiveFile.of(resourcePath.getPath());
                    }
                } else {
                    databaseSourceFile = databaseDescription.getPath();
                }
            } else if ("KnownGene".equalsIgnoreCase(databaseDescription.getName())) {
                standDatabaseName = "KnownGene";
                if (databaseDescription.getPath() == null) {
                    localPath = "gene/knownGene_" + (Object)((Object)GlobalAnnotationGenomeVersion.refGenomeVersion) + "_kggseq_v2.txt.gz";
                    databaseSourceFile = Channel.get(standDatabaseName, localPath);
                    if (databaseSourceFile == null || databaseSourceFile.getPath().startsWith("http")) {
                        resourcePath = new File("./resources/" + localPath);
                        url = "https://idc.biosino.org/pmglab/resource/kgg/kgga/resources/" + localPath;
                        downloader = new Downloader(LiveFile.of(url), resourcePath);
                        downloader.setThreads(4);
                        if (downloader.compareTime() != 0) {
                            downloader.download();
                        }
                        databaseSourceFile = LiveFile.of(resourcePath.getPath());
                    }
                } else {
                    databaseSourceFile = databaseDescription.getPath();
                }
            } else {
                if (databaseDescription.getPath() == null) {
                    SetupApplication.GlobalLogger.error("unsupported reference model gene database: {}, refGene/GEncode/knownGene expected. ", (Object)databaseDescription);
                    return;
                }
                databaseSourceFile = databaseDescription.getPath();
                standDatabaseName = databaseDescription.getName();
            }
            databaseDescription.name = standDatabaseName;
            databaseDescription.path = LiveFile.of(databaseSourceFile.getPath());
        }
    }

    public void getUnifiedIDs(List<DatabaseDescription> defaultDatabases, IndexableSet<String> geneSymbMap, IndexableSet<String> geneIDMap, IndexableSet<String> transcriptIDMap, TIntSet canonicalTranscriptIDSet) throws IOException {
        THashMap<String, String> canonicalTranscriptGeneMap = new THashMap<String, String>();
        File localGeneDBFile = new File(defaultDatabases.get((int)0).path.getPath());
        String parentPath = localGeneDBFile.getParent();
        File canonicalTranscriptFile = new File(parentPath + "/CanonicalTranscript.txt.gz");
        if (canonicalTranscriptFile.exists()) {
            TextRecord canonicalRecords;
            TextReader canonicalTranscriptReader = TextReader.setInput(canonicalTranscriptFile).setHeaderParser(IHeaderParser.NO_HEADER_LINE).setSeparator(Separator.COMMA).instance();
            int dot = 46;
            while ((canonicalRecords = canonicalTranscriptReader.read()) != null) {
                int index = canonicalRecords.get(1).toString().lastIndexOf(dot);
                String transcriptID = index >= 0 ? canonicalRecords.get(1).toString().substring(0, index) : canonicalRecords.get(1).toString();
                canonicalTranscriptGeneMap.put(canonicalRecords.get(0).toString(), transcriptID);
            }
            canonicalTranscriptReader.close();
        }
        THashMap<String, String> canonicalTranscriptGeneMapSup = new THashMap<String, String>();
        HashSet<String> geneSetWithCanonicalTranscript = new HashSet<String>();
        int geneFeatureDatabasesNum = defaultDatabases.size();
        for (DatabaseDescription defaultDatabase : defaultDatabases) {
            LiveFile file = defaultDatabase.path;
            this.loadIDs(file, geneSymbMap, geneIDMap, transcriptIDMap, canonicalTranscriptIDSet, canonicalTranscriptGeneMap, canonicalTranscriptGeneMapSup, geneSetWithCanonicalTranscript);
        }
        for (Map.Entry entry : canonicalTranscriptGeneMapSup.entrySet()) {
            int index = transcriptIDMap.indexOf((String)entry.getValue());
            if (index < 0) continue;
            canonicalTranscriptIDSet.add(index);
        }
        canonicalTranscriptGeneMapSup.clear();
    }

    public Map<String, int[]> getGeneCodingLengthPoints(List<DatabaseDescription> defaultDatabases, boolean onlyCodingRegions, int splicingDis) throws IOException {
        int geneFeatureDatabasesNum = defaultDatabases.size();
        THashMap<String, List<SeqSegment>> geneExonRegions = new THashMap<String, List<SeqSegment>>();
        for (int i = 0; i < geneFeatureDatabasesNum; ++i) {
            LiveFile file = defaultDatabases.get((int)i).path;
            GeneFeatureDBUtility.loadGeneCodingRegions(file, geneExonRegions, splicingDis, onlyCodingRegions);
        }
        return this.calculateGeneCodingRegionLengthPoints(geneExonRegions);
    }

    public void annotateTo(File inputFile, File outputFilePath, IndexableSet<String> geneSymbMap, IndexableSet<String> geneIDMap, IndexableSet<String> transcriptIDMap, TIntSet canonicalTranscriptIDSet, AnnotationOptions annotationOptions, int threadNum) throws IOException {
        byte unknownID = VarGeneFeatureType.UNKNOWN.index;
        int varGeneFeatureTypeNum = unknownID + 1;
        AtomicInteger[] variantsCounters = new AtomicInteger[unknownID + 1];
        for (int ii = 0; ii < varGeneFeatureTypeNum; ++ii) {
            variantsCounters[ii] = new AtomicInteger(0);
        }
        TIntHashSet selectedFeatureSet = new TIntHashSet();
        VarInt32RangeList featureIDDs = annotationOptions.geneFeatureIn;
        TIntIterator ids = featureIDDs.iterator();
        while (ids.hasNext()) {
            selectedFeatureSet.add(ids.next());
        }
        Set<String> excludedGenes = annotationOptions.geneExcluded;
        Set<String> retainedGenes = annotationOptions.geneRetained;
        boolean willFilter = !selectedFeatureSet.isEmpty() || !excludedGenes.isEmpty() || !retainedGenes.isEmpty();
        GeneFeatureDatabases geneFeatureDatabases = new GeneFeatureDatabases(selectedFeatureSet, excludedGenes, retainedGenes, variantsCounters);
        geneFeatureDatabases.setDises(annotationOptions.upstreamDis, annotationOptions.downstreamDis, annotationOptions.splicingDis);
        geneFeatureDatabases.setIndexes(geneSymbMap, geneIDMap, transcriptIDMap, canonicalTranscriptIDSet);
        geneFeatureDatabases.loadDefaultDatabases(annotationOptions.geneDatabase);
        GTBManager inputFileManager = new GTBManager(inputFile);
        long totalVarNum = inputFileManager.numOfVariants();
        GTBAnnotator annotator = GTBAnnotator.setInput(new GTBReaderOption(inputFileManager)).setOutput(outputFilePath).addMeta(inputFileManager.getMeta()).addOption(new CCFMetaItem("$GeneSymbolIDMap", FieldType.stringIndexableSet, geneSymbMap)).addOption(new CCFMetaItem("$GeneIDMap", FieldType.stringIndexableSet, geneIDMap)).addOption(new CCFMetaItem("$TranscriptIDMap", FieldType.stringIndexableSet, transcriptIDMap)).addOption(new CCFMetaItem("$CanonicalTranscriptIDSet", FieldType.int32Set, canonicalTranscriptIDSet)).addDatabase(geneFeatureDatabases).setListener(new AnnotationListener<Variant>());
        if (willFilter) {
            annotator.submit(threadNum);
            GTBManager manger = new GTBManager(outputFilePath);
            long retainedVarNum = manger.numOfVariants();
            SetupApplication.GlobalLogger.info("{} out of {} variants retained after filtering according to gene features.", (Object)retainedVarNum, (Object)totalVarNum);
        } else {
            annotator.append(threadNum);
            SetupApplication.GlobalLogger.info("{} variants are annotated with gene features.", (Object)totalVarNum);
        }
        StringBuilder info = new StringBuilder();
        info.append("Gene feature summary of variants:\n");
        double totalVarNumD = 0.0;
        for (AtomicInteger variantsCounter : variantsCounters) {
            totalVarNumD += (double)variantsCounter.get();
        }
        for (int j = 0; j < variantsCounters.length; ++j) {
            if (variantsCounters[j].get() <= 0) continue;
            info.append(" ").append(j).append(".").append(VarGeneFeatureType.getFeatureName(j)).append(": ").append(variantsCounters[j]).append(" (").append(String.format("%.3f", (double)variantsCounters[j].get() / totalVarNumD * 100.0)).append("%)\n");
        }
        SetupApplication.GlobalLogger.info(info.toString());
    }

    public Map<String, int[]> calculateGeneCodingRegionLengthPoints(Map<String, List<SeqSegment>> geneExonRegions) {
        THashMap<String, int[]> geneExonLength = new THashMap<String, int[]>();
        for (Map.Entry<String, List<SeqSegment>> entry : geneExonRegions.entrySet()) {
            int i;
            List<SeqSegment> seqSegments = entry.getValue();
            IntIntervalTree.Builder<SeqSegment> intervalTreeBuilder = new IntIntervalTree.Builder<SeqSegment>();
            int size = seqSegments.size();
            int[] boundaries = new int[size * 2];
            for (i = 0; i < size; ++i) {
                boundaries[i * 2] = seqSegments.get((int)i).start;
                boundaries[i * 2 + 1] = seqSegments.get((int)i).end;
                if (boundaries[i * 2] >= boundaries[i * 2 + 1]) continue;
                intervalTreeBuilder.add(boundaries[i * 2], boundaries[i * 2 + 1], seqSegments.get(i));
            }
            IntIntervalTree intervalTree = intervalTreeBuilder.build();
            Arrays.sort(boundaries);
            int len = 0;
            for (i = 1; i < boundaries.length; ++i) {
                if (!intervalTree.contains(boundaries[i - 1], boundaries[i])) continue;
                len += boundaries[i] - boundaries[i - 1];
            }
            geneExonLength.put(entry.getKey(), new int[]{len, boundaries[0], boundaries[boundaries.length - 1]});
        }
        return geneExonLength;
    }

    public static Map<Chromosome, IntIntervalTree<Transcript>> loadRefGeneSeqs(String datbaseName, LiveFile databaseSourceFile, IndexableSet<String> geneSymbMap, IndexableSet<String> geneIDMap, IndexableSet<String> transcriptIDMap, int upstreamDis, int downstreamDis) throws IOException {
        THashMap<Chromosome, IntIntervalTree<Transcript>> chromTranscriptTreeMap = null;
        THashMap chromTranscriptTreeBuilder = new THashMap();
        Separator separator = Separator.TAB;
        TextReader reader = TextReader.setInput(databaseSourceFile).setHeaderParser(IHeaderParser.NO_HEADER_LINE).setSeparator(separator).instance();
        PositionType positionType = PositionType.ZERO_BASED;
        int indexmRNAName = 1;
        int indexChom = 2;
        int indexStrand = 3;
        int indexTxStart = 4;
        int indexTxEnd = 5;
        int indexCdsStart = 6;
        int indexCdsEnd = 7;
        int indexExonCount = 8;
        int indexExonStarts = 9;
        int indexExonEnds = 10;
        int indexName2 = 12;
        int indexSeq = 16;
        int indexDelSite = 17;
        int indexInsSite = 18;
        int effectiveRNANum = 0;
        try {
            TextRecord recordMap;
            String delSite = null;
            String insSite = null;
            while ((recordMap = reader.read()) != null) {
                int i;
                int index;
                String geneID;
                String geneSymbol = recordMap.get(indexName2).toString();
                if (geneSymbol.endsWith("decay")) continue;
                String comp1 = recordMap.get(13).toString();
                String comp2 = recordMap.get(14).toString();
                if (comp1.equals("incmpl") || comp2.equals("incmpl")) continue;
                String[] infors = geneSymbol.split(";");
                if (infors.length > 1) {
                    geneSymbol = infors[1];
                    geneID = infors[0];
                } else {
                    geneSymbol = infors[0];
                    geneID = null;
                }
                Chromosome chromosome = Chromosome.get(recordMap.get(indexChom).toString());
                String accession = recordMap.get(indexmRNAName).toString();
                Strand strand = Strand.get(recordMap.get(indexStrand).toString());
                int txStart = recordMap.get(indexTxStart).toInt();
                int txEnd = recordMap.get(indexTxEnd).toInt();
                int codingStart = recordMap.get(indexCdsStart).toInt();
                int codingEnd = recordMap.get(indexCdsEnd).toInt();
                String exonStarts = recordMap.get(indexExonStarts).toString();
                String exonEnds = recordMap.get(indexExonEnds).toString();
                String sequence2 = recordMap.get(indexSeq).toString();
                accession = accession + "@" + txStart;
                List<SeqSegment> exonRegions = new List<SeqSegment>();
                String[] exonStartArray = exonStarts.split(",");
                String[] exonEndArray = exonEnds.split(",");
                for (int i2 = 0; i2 < exonStartArray.length; ++i2) {
                    exonRegions.add(new SeqSegment(Integer.parseInt(exonStartArray[i2]), Integer.parseInt(exonEndArray[i2])));
                }
                if (!chromTranscriptTreeBuilder.containsKey(chromosome)) {
                    chromTranscriptTreeBuilder.put(chromosome, new IntIntervalTree.Builder());
                }
                int transcriptIDIndex = transcriptIDMap.indexOf(accession);
                Transcript mrna = new Transcript(accession, transcriptIDIndex, strand.toString().charAt(0), txStart, txEnd, codingStart, codingEnd, exonRegions);
                if (strand.isReverse()) {
                    ((IntIntervalTree.Builder)chromTranscriptTreeBuilder.get(chromosome)).add(mrna.start - downstreamDis, mrna.end + upstreamDis, mrna);
                } else {
                    ((IntIntervalTree.Builder)chromTranscriptTreeBuilder.get(chromosome)).add(mrna.start - upstreamDis, mrna.end + downstreamDis, mrna);
                }
                mrna.setmRnaSequence(sequence2.toUpperCase());
                if (delSite != null && !".".equals(delSite)) {
                    index = delSite.indexOf(":");
                    String[] delSites = delSite.substring(0, index).split(",");
                    int[] delSitesInt = new int[delSites.length];
                    for (i = 0; i < delSitesInt.length; ++i) {
                        delSitesInt[i] = Integer.parseInt(delSites[i]);
                    }
                    mrna.setDelSites(delSitesInt);
                    mrna.setDelSeq(delSite.substring(index + 1));
                }
                if (insSite != null && !".".equals(insSite)) {
                    index = insSite.indexOf(":");
                    String[] insSites = insSite.substring(0, index).split(",");
                    int[] insSitesInt = new int[insSites.length];
                    for (i = 0; i < insSitesInt.length; ++i) {
                        insSitesInt[i] = Integer.parseInt(insSites[i]);
                    }
                    mrna.setInsSites(insSitesInt);
                    mrna.setInsSeq(insSite.substring(index + 1));
                }
                mrna.generateIntervalTree(upstreamDis, downstreamDis);
                mrna.setGeneSymb(geneSymbol);
                int geneSymbolIndex = geneSymbMap.indexOf(geneSymbol);
                mrna.setGeneSymbIndex(geneSymbolIndex);
                if (geneID != null) {
                    int geneIDIndex = geneIDMap.indexOf(geneID);
                    mrna.setGeneIDIndex(geneIDIndex);
                }
                ++effectiveRNANum;
            }
            reader.close();
            chromTranscriptTreeMap = new THashMap<Chromosome, IntIntervalTree<Transcript>>();
            for (Chromosome chromosome : chromTranscriptTreeBuilder.keySet()) {
                chromTranscriptTreeMap.put(chromosome, ((IntIntervalTree.Builder)chromTranscriptTreeBuilder.get(chromosome)).build());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            String info = e.getMessage() + " when loading gene feature file ";
            SetupApplication.GlobalLogger.error(info);
        }
        SetupApplication.GlobalLogger.info("{} transcripts of genes have been read in the dataset {} from {}", effectiveRNANum, datbaseName, databaseSourceFile);
        return chromTranscriptTreeMap;
    }

    public Map<String, Map<Integer, int[]>> getGeneNonCodingLengthPoints(List<DatabaseDescription> defaultDatabases, IndexableSet<String> transcriptIDMap, TIntSet canonicalTranscriptIDSet, int splicingDis, int upstreamDis, int downstreamDis) throws IOException {
        int geneFeatureDatabasesNum = defaultDatabases.size();
        THashMap<String, Transcript> geneTranscript = new THashMap<String, Transcript>();
        boolean onlyCodingRegions = false;
        for (int i = 0; i < geneFeatureDatabasesNum; ++i) {
            LiveFile file = defaultDatabases.get((int)i).path;
            this.loadGeneSingleTranscriptCodingRegions(file, geneTranscript, splicingDis, onlyCodingRegions, transcriptIDMap, canonicalTranscriptIDSet);
        }
        return this.calculateGeneNonCodingRegionLengthPoints(geneTranscript, upstreamDis, downstreamDis);
    }

    public Map<String, Map<Integer, int[]>> calculateGeneNonCodingRegionLengthPoints(Map<String, Transcript> geneTranscript, int upstreamDis, int downstreamDis) {
        THashMap<String, Map<Integer, int[]>> geneNonCodingRegionLength = new THashMap<String, Map<Integer, int[]>>();
        for (Map.Entry<String, Transcript> entry : geneTranscript.entrySet()) {
            int i;
            int exonLen;
            int i2;
            Transcript transcript = entry.getValue();
            List<SeqSegment> seqSegments = transcript.getExons();
            int size = seqSegments.size();
            int codingStart = transcript.getCodingStart();
            int codingEnd = transcript.getCodingEnd();
            THashMap<Integer, int[]> regionLen = new THashMap<Integer, int[]>();
            if (size == 1) {
                if (transcript.getStrand() == '+') {
                    if (codingStart < codingEnd) {
                        regionLen.put(1, new int[]{transcript.getCodingStart() - transcript.start, transcript.start, transcript.getCodingStart()});
                        regionLen.put(2, new int[]{transcript.getEnd() - transcript.getCodingEnd(), transcript.getCodingEnd(), transcript.getEnd()});
                    } else {
                        regionLen.put(0, new int[]{seqSegments.get((int)0).end - seqSegments.get((int)0).start, seqSegments.get((int)0).start, seqSegments.get((int)0).end});
                    }
                    regionLen.put(3, new int[]{upstreamDis, transcript.getStart() - upstreamDis, transcript.start});
                    regionLen.put(4, new int[]{downstreamDis, transcript.getEnd(), transcript.getEnd() + downstreamDis});
                } else if (transcript.getStrand() == '-') {
                    if (codingStart < codingEnd) {
                        regionLen.put(2, new int[]{transcript.getCodingStart() - transcript.start, transcript.start, transcript.getCodingStart()});
                        regionLen.put(1, new int[]{transcript.getEnd() - transcript.getCodingEnd(), transcript.getCodingEnd(), transcript.getEnd()});
                    } else {
                        regionLen.put(0, new int[]{seqSegments.get((int)0).end - seqSegments.get((int)0).start, seqSegments.get((int)0).start, seqSegments.get((int)0).end});
                    }
                    regionLen.put(4, new int[]{downstreamDis, transcript.getStart() - downstreamDis, transcript.getStart()});
                    regionLen.put(3, new int[]{upstreamDis, transcript.getEnd(), transcript.getEnd() + upstreamDis});
                }
                regionLen.put(11, new int[]{-1, Integer.MAX_VALUE, Integer.MAX_VALUE});
                geneNonCodingRegionLength.put(entry.getKey(), regionLen);
                continue;
            }
            int utr5Len = 0;
            int utr3Len = 0;
            if (transcript.getStrand() == '+') {
                if (codingStart < codingEnd) {
                    for (i2 = 0; i2 < size; ++i2) {
                        if (seqSegments.get((int)i2).end <= codingStart) {
                            utr5Len += seqSegments.get((int)i2).end - seqSegments.get((int)i2).start;
                            continue;
                        }
                        if (seqSegments.get((int)i2).start >= codingStart) break;
                        utr5Len += codingStart - seqSegments.get((int)i2).start;
                    }
                    regionLen.put(1, new int[]{utr5Len, transcript.start, transcript.getCodingStart()});
                    for (i2 = size - 1; i2 >= 0; --i2) {
                        if (seqSegments.get((int)i2).start >= codingEnd) {
                            utr3Len += seqSegments.get((int)i2).end - seqSegments.get((int)i2).start;
                            continue;
                        }
                        if (seqSegments.get((int)i2).end <= codingEnd) break;
                        utr3Len += seqSegments.get((int)i2).end - codingEnd;
                    }
                    regionLen.put(2, new int[]{utr3Len, transcript.getCodingEnd(), transcript.getEnd()});
                } else {
                    exonLen = 0;
                    for (i = 0; i < size; ++i) {
                        exonLen += seqSegments.get((int)i).end - seqSegments.get((int)i).start;
                    }
                    regionLen.put(0, new int[]{exonLen, transcript.getStart(), transcript.getEnd()});
                }
                regionLen.put(3, new int[]{upstreamDis, transcript.getStart() - upstreamDis, transcript.start});
                regionLen.put(4, new int[]{downstreamDis, transcript.getEnd(), transcript.getEnd() + downstreamDis});
                for (i2 = 1; i2 < size; ++i2) {
                    regionLen.put(i2 + 10, new int[]{seqSegments.get((int)i2).start - seqSegments.get((int)(i2 - 1)).end, seqSegments.get((int)i2).start, seqSegments.get((int)(i2 - 1)).end});
                }
            } else if (transcript.getStrand() == '-') {
                if (codingStart < codingEnd) {
                    for (i2 = size - 1; i2 >= 0; --i2) {
                        if (seqSegments.get((int)i2).start >= codingEnd) {
                            utr5Len += seqSegments.get((int)i2).end - seqSegments.get((int)i2).start;
                            continue;
                        }
                        if (seqSegments.get((int)i2).end <= codingEnd) break;
                        utr5Len += seqSegments.get((int)i2).end - codingEnd;
                    }
                    regionLen.put(1, new int[]{utr5Len, transcript.getCodingEnd(), transcript.getEnd()});
                    for (i2 = 0; i2 < size; ++i2) {
                        if (seqSegments.get((int)i2).end <= codingStart) {
                            utr3Len += seqSegments.get((int)i2).end - seqSegments.get((int)i2).start;
                            continue;
                        }
                        if (seqSegments.get((int)i2).start >= codingStart) break;
                        utr3Len += codingStart - seqSegments.get((int)i2).start;
                    }
                    regionLen.put(2, new int[]{utr3Len, transcript.start, transcript.getCodingStart()});
                } else {
                    exonLen = 0;
                    for (i = 0; i < size; ++i) {
                        exonLen += seqSegments.get((int)i).end - seqSegments.get((int)i).start;
                    }
                    regionLen.put(0, new int[]{exonLen, transcript.getStart(), transcript.getEnd()});
                }
                regionLen.put(4, new int[]{downstreamDis, transcript.getStart() - downstreamDis, transcript.getStart()});
                regionLen.put(3, new int[]{upstreamDis, transcript.getEnd(), transcript.getEnd() + upstreamDis});
                for (i2 = size - 2; i2 >= 0; --i2) {
                    regionLen.put(size - 2 - i2 + 11, new int[]{seqSegments.get((int)(i2 + 1)).start - seqSegments.get((int)i2).end, seqSegments.get((int)(i2 + 1)).start, seqSegments.get((int)i2).end});
                }
            }
            geneNonCodingRegionLength.put(entry.getKey(), regionLen);
        }
        return geneNonCodingRegionLength;
    }

    public static void loadGeneCodingRegions(LiveFile databaseSourceFile, Map<String, List<SeqSegment>> geneExonRegions, int splicingLen, boolean onlyCodingRegions) throws IOException {
        TextRecord recordMap;
        TextReader reader = TextReader.setInput(databaseSourceFile).setHeaderParser(IHeaderParser.NO_HEADER_LINE).instance();
        int indexName2 = 12;
        int indexExonStarts = 9;
        int indexExonEnds = 10;
        int indexCdsStart = 6;
        int indexCdsEnd = 7;
        while ((recordMap = reader.read()) != null) {
            String geneID;
            String geneSymbol = recordMap.get(indexName2).toString();
            if (geneSymbol.endsWith("decay")) continue;
            String comp1 = recordMap.get(13).toString();
            String comp2 = recordMap.get(14).toString();
            if (comp1.equals("incmpl") || comp2.equals("incmpl")) continue;
            String[] infors = geneSymbol.split(";");
            if (infors.length > 1) {
                geneSymbol = infors[1];
                geneID = infors[0];
            } else {
                geneSymbol = infors[0];
                geneID = null;
            }
            String exonStarts = recordMap.get(indexExonStarts).toString();
            String exonEnds = recordMap.get(indexExonEnds).toString();
            int codingStart = recordMap.get(indexCdsStart).toInt();
            int codingEnd = recordMap.get(indexCdsEnd).toInt();
            if (codingStart >= codingEnd) continue;
            List exonRegions = geneExonRegions.computeIfAbsent(geneSymbol, k -> new List());
            String[] exonStartArray = exonStarts.split(",");
            String[] exonEndArray = exonEnds.split(",");
            for (int i = 0; i < exonStartArray.length; ++i) {
                int realStart = Integer.parseInt(exonStartArray[i]);
                int realEnd = Integer.parseInt(exonEndArray[i]);
                if (onlyCodingRegions && codingStart > realStart) {
                    realStart = codingStart;
                }
                if (codingStart < realEnd) {
                    realEnd += splicingLen;
                }
                if (onlyCodingRegions && codingEnd < realEnd) {
                    realEnd = codingEnd;
                }
                if (codingEnd > realStart) {
                    realStart -= splicingLen;
                }
                if (realStart >= realEnd) continue;
                exonRegions.add(new SeqSegment(realStart, realEnd));
            }
        }
        reader.close();
    }

    public void loadGeneSingleTranscriptCodingRegions(LiveFile databaseSourceFile, Map<String, Transcript> geneTranscriptMap, int splicingLen, boolean onlyCodingRegions, IndexableSet<String> transcriptIDSet, TIntSet canonicalTranscriptIDSet) throws IOException {
        TextRecord recordMap;
        TextReader reader = TextReader.setInput(databaseSourceFile).setHeaderParser(IHeaderParser.NO_HEADER_LINE).instance();
        int indexmRNAName = 1;
        int indexName2 = 12;
        int indexExonStarts = 9;
        int indexExonEnds = 10;
        int indexCdsStart = 6;
        int indexCdsEnd = 7;
        int indexStrand = 3;
        int indexTxStart = 4;
        int indexTxEnd = 5;
        while ((recordMap = reader.read()) != null) {
            List<SeqSegment> exonRegions;
            String geneID;
            String geneSymbol = recordMap.get(indexName2).toString();
            if (geneSymbol.endsWith("decay") || geneTranscriptMap.containsKey(geneSymbol)) continue;
            String[] infors = geneSymbol.split(";");
            if (infors.length > 1) {
                geneSymbol = infors[1];
                geneID = infors[0];
            } else {
                geneSymbol = infors[0];
                geneID = null;
            }
            String accession = recordMap.get(indexmRNAName).toString();
            int txStart = recordMap.get(indexTxStart).toInt();
            accession = accession + "@" + txStart;
            int index = transcriptIDSet.indexOf(accession);
            if (!canonicalTranscriptIDSet.contains(index)) continue;
            Strand strand = Strand.get(recordMap.get(indexStrand).toString());
            String exonStarts = recordMap.get(indexExonStarts).toString();
            String exonEnds = recordMap.get(indexExonEnds).toString();
            int txEnd = recordMap.get(indexTxEnd).toInt();
            int codingStart = recordMap.get(indexCdsStart).toInt();
            int codingEnd = recordMap.get(indexCdsEnd).toInt();
            Transcript transcript = geneTranscriptMap.get(geneSymbol);
            if (transcript == null) {
                exonRegions = new List();
                transcript = new Transcript(accession, -1, strand.toString().charAt(0), txStart, txEnd, codingStart, codingEnd, exonRegions);
                geneTranscriptMap.put(geneSymbol, transcript);
            }
            exonRegions = transcript.getExons();
            String[] exonStartArray = exonStarts.split(",");
            String[] exonEndArray = exonEnds.split(",");
            for (int i = 0; i < exonStartArray.length; ++i) {
                int realStart = Integer.parseInt(exonStartArray[i]);
                int realEnd = Integer.parseInt(exonEndArray[i]);
                if (onlyCodingRegions && codingStart > realStart) {
                    realStart = codingStart;
                }
                if (codingStart < realEnd) {
                    realEnd += splicingLen;
                }
                if (onlyCodingRegions && codingEnd < realEnd) {
                    realEnd = codingEnd;
                }
                if (codingEnd > realStart) {
                    realStart -= splicingLen;
                }
                if (realStart >= realEnd) continue;
                exonRegions.add(new SeqSegment(realStart, realEnd));
            }
        }
        reader.close();
    }

    public void loadIDs(LiveFile databaseSourceFile, IndexableSet<String> geneSymbMap, IndexableSet<String> geneIDMap, IndexableSet<String> transcriptIDMap, TIntSet canonicalTranscriptIDSet, Map<String, String> canonicalTranscriptGeneMap, Map<String, String> canonicalTranscriptGeneMapSup, Set<String> geneSetWithCanonicalTranscript) throws IOException {
        Separator separator = Separator.TAB;
        TextReader reader = TextReader.setInput(databaseSourceFile).setHeaderParser(IHeaderParser.NO_HEADER_LINE).setSeparator(separator).instance();
        PositionType positionType = PositionType.ZERO_BASED;
        int indexmRNAName = 1;
        int indexChom = 2;
        int indexStrand = 3;
        int indexTxStart = 4;
        int indexTxEnd = 5;
        int indexCdsStart = 6;
        int indexCdsEnd = 7;
        int indexExonCount = 8;
        int indexExonStarts = 9;
        int indexExonEnds = 10;
        int indexName2 = 12;
        int indexSeq = 16;
        int indexDelSite = 17;
        int indexInsSite = 18;
        try {
            TextRecord recordMap;
            while ((recordMap = reader.read()) != null) {
                String geneID;
                String geneSymbol = recordMap.get(indexName2).toString();
                if (geneSymbol.endsWith("decay")) continue;
                String comp1 = recordMap.get(13).toString();
                String comp2 = recordMap.get(14).toString();
                if (comp1.equals("incmpl") || comp2.equals("incmpl")) continue;
                String[] infors = geneSymbol.split(";");
                if (infors.length > 1) {
                    geneSymbol = infors[1];
                    geneID = infors[0];
                    geneIDMap.add(geneID);
                } else {
                    geneSymbol = infors[0];
                    geneID = null;
                }
                String accession = recordMap.get(indexmRNAName).toString();
                int txStart = recordMap.get(indexTxStart).toInt();
                String accessionStartPos = accession + "@" + txStart;
                transcriptIDMap.add(accessionStartPos);
                if (!geneSymbMap.contains(geneSymbol)) {
                    geneSymbMap.add(geneSymbol);
                }
                if (geneSetWithCanonicalTranscript.contains(geneSymbol)) continue;
                String canonicalTranscript = canonicalTranscriptGeneMap.get(geneSymbol);
                if (canonicalTranscript != null) {
                    int index = accession.indexOf(".");
                    if (index >= 0) {
                        accession = accession.substring(0, index);
                    }
                    if (canonicalTranscript.equals(accession)) {
                        canonicalTranscriptIDSet.add(transcriptIDMap.indexOf(accessionStartPos));
                        canonicalTranscriptGeneMapSup.remove(geneSymbol);
                        geneSetWithCanonicalTranscript.add(geneSymbol);
                        continue;
                    }
                    if (canonicalTranscriptGeneMapSup.containsKey(geneSymbol)) continue;
                    canonicalTranscriptGeneMapSup.put(geneSymbol, accessionStartPos);
                    continue;
                }
                canonicalTranscriptIDSet.add(transcriptIDMap.indexOf(accessionStartPos));
                geneSetWithCanonicalTranscript.add(geneSymbol);
            }
            reader.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            String info = e.getMessage() + " when loading gene feature file ";
            SetupApplication.GlobalLogger.error(info);
        }
    }
}

