/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.annotation.database;

import edu.sysu.pmglab.annotation.GeneFeature;
import edu.sysu.pmglab.annotation.Transcript;
import edu.sysu.pmglab.annotation.VarGeneFeatureType;
import edu.sysu.pmglab.annotation.database.DatabaseDescription;
import edu.sysu.pmglab.annotation.database.GeneFeatureDBUtility;
import edu.sysu.pmglab.bytecode.Bytes;
import edu.sysu.pmglab.ccf.field.FieldGroupMeta;
import edu.sysu.pmglab.ccf.field.IFieldCollection;
import edu.sysu.pmglab.ccf.meta.ICCFMeta;
import edu.sysu.pmglab.ccf.toolkit.annotator.Database;
import edu.sysu.pmglab.ccf.type.FieldType;
import edu.sysu.pmglab.container.indexable.IndexableSet;
import edu.sysu.pmglab.container.intervaltree.inttree.IntIntervalTree;
import edu.sysu.pmglab.container.list.IntList;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.container.list.ShortList;
import edu.sysu.pmglab.gtb.genome.Variant;
import edu.sysu.pmglab.gtb.genome.coordinate.Chromosome;
import edu.sysu.pmglab.io.file.LiveFile;
import edu.sysu.pmglab.kgga.command.SetupApplication;
import gnu.trove.set.TIntSet;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;

public class GeneFeatureDatabases
extends Database<GeneFeature, Variant> {
    int upstreamDis = 1000;
    int downstreamDis = 1000;
    int splicingDis = 2;
    IndexableSet<String> geneSymbMap;
    IndexableSet<String> geneIDMap;
    IndexableSet<String> transcriptIDMap;
    TIntSet canonicalTranscriptIDSet;
    final FieldGroupMeta FIELDS = new FieldGroupMeta("GeneFeature").addField("MarkFeatureGene", FieldType.varInt32).addField("MarkGeneFeature", FieldType.varInt32).addField("HitGenes", FieldType.int32List).addField("HitGeneRegionTypes", FieldType.int16List).addField("HitGeneFeatures", FieldType.int16List);
    List<String> databaseNames;
    List<Map<Chromosome, IntIntervalTree<Transcript>>> chromTranscriptTreeMaps;
    final TIntSet selectedFeatureSet;
    Set<String> excludedGenes;
    Set<String> geneRetained;
    AtomicInteger[] variantsCounters;

    public GeneFeatureDatabases(TIntSet selectedFeatureSet, Set<String> excludedGenes, Set<String> geneRetained, AtomicInteger[] variantsCounters) {
        this.selectedFeatureSet = selectedFeatureSet;
        this.excludedGenes = excludedGenes;
        this.geneRetained = geneRetained;
        this.variantsCounters = variantsCounters;
        this.databaseNames = new List(1);
        this.chromTranscriptTreeMaps = new List(1);
    }

    public void setDises(int upstreamDis, int downstreamDis, int splicingDis) {
        this.upstreamDis = upstreamDis;
        this.downstreamDis = downstreamDis;
        this.splicingDis = splicingDis;
    }

    public void setIndexes(IndexableSet<String> geneSymbMap, IndexableSet<String> geneIDMap, IndexableSet<String> transcriptIDMap, TIntSet canonicalTranscriptIDSet) {
        this.geneSymbMap = geneSymbMap;
        this.geneIDMap = geneIDMap;
        this.transcriptIDMap = transcriptIDMap;
        this.canonicalTranscriptIDSet = canonicalTranscriptIDSet;
    }

    public GeneFeatureDatabases add(String databaseName, Map<Chromosome, IntIntervalTree<Transcript>> chromTranscriptTreeMap) {
        this.FIELDS.addField("GeneFeature", databaseName, FieldType.bytecodeList);
        this.databaseNames.add(databaseName);
        this.chromTranscriptTreeMaps.add(chromTranscriptTreeMap);
        return this;
    }

    public void loadDefaultDatabases(List<DatabaseDescription> defaultDatabases) throws IOException {
        if (defaultDatabases == null) {
            SetupApplication.GlobalLogger.info("No default databases found.");
            return;
        }
        for (DatabaseDescription databaseDescription : defaultDatabases) {
            String standDatabaseName = databaseDescription.name;
            if (standDatabaseName == null || standDatabaseName.trim().isEmpty()) {
                standDatabaseName = "customized";
            }
            LiveFile databaseSourceFile = databaseDescription.getPath();
            Map<Chromosome, IntIntervalTree<Transcript>> transcriptTreeMap = GeneFeatureDBUtility.loadRefGeneSeqs(standDatabaseName, databaseSourceFile, this.geneSymbMap, this.geneIDMap, this.transcriptIDMap, this.upstreamDis, this.downstreamDis);
            this.add(standDatabaseName, transcriptTreeMap);
        }
    }

    @Override
    public ICCFMeta getMeta() {
        return super.getMeta();
    }

    @Override
    public GeneFeatureReader instance() throws IOException {
        return new GeneFeatureReader(this);
    }

    @Override
    public boolean annotate(List<GeneFeature> resources, long pointer, Variant target) {
        return super.annotate(resources, pointer, target);
    }

    @Override
    public IFieldCollection getAllFields() {
        return this.FIELDS;
    }

    static class GeneFeatureReader
    extends Database.Reader<GeneFeature, Variant, GeneFeatureDatabases> {
        String[] databaseNames;
        int geneFeatureDatabasesNum;
        int splicingDis;
        TIntSet selectedFeatureSet;
        Set<String> excludedGenes;
        Set<String> retainedGenes;
        TIntSet canonicalTranscriptIDSet;
        AtomicInteger[] variantsCounters;
        Map<Chromosome, IntIntervalTree<Transcript>>[] chromTranscriptTreeMaps;
        boolean containIntergenic;
        boolean includeExonic = false;
        final boolean needExcludeGenes;
        final boolean needRetainGenes;
        final IntList hitGeneIDs = new IntList();
        final ShortList hitGeneRegionIDs = new ShortList();
        final ShortList hitGeneFeatureIDs = new ShortList();
        final Set<Integer> addedGeneID = new HashSet<Integer>();
        List<Bytes>[] featureCaches;

        public GeneFeatureReader(GeneFeatureDatabases database) {
            super(database);
            this.geneFeatureDatabasesNum = database.databaseNames.size();
            this.databaseNames = database.databaseNames.toArray((T1[])new String[0]);
            this.excludedGenes = database.excludedGenes;
            this.retainedGenes = database.geneRetained;
            this.selectedFeatureSet = database.selectedFeatureSet;
            this.splicingDis = database.splicingDis;
            this.variantsCounters = database.variantsCounters;
            this.chromTranscriptTreeMaps = database.chromTranscriptTreeMaps.toArray((T1[])new Map[0]);
            this.canonicalTranscriptIDSet = database.canonicalTranscriptIDSet;
            this.featureCaches = new List[this.geneFeatureDatabasesNum];
            for (int i = 0; i < this.geneFeatureDatabasesNum; ++i) {
                this.featureCaches[i] = new List();
            }
            this.containIntergenic = this.selectedFeatureSet.isEmpty();
            if (!this.selectedFeatureSet.isEmpty()) {
                byte[] detailedExonFeatures;
                this.containIntergenic = this.selectedFeatureSet.contains(VarGeneFeatureType.INTERGENIC.index);
                for (byte detailedExonFeature : detailedExonFeatures = VarGeneFeatureType.getExonicIDs()) {
                    if (!this.selectedFeatureSet.contains(detailedExonFeature)) continue;
                    this.includeExonic = true;
                    break;
                }
            }
            this.needExcludeGenes = this.excludedGenes != null && !this.excludedGenes.isEmpty();
            this.needRetainGenes = this.retainedGenes != null && !this.retainedGenes.isEmpty();
        }

        @Override
        public List<GeneFeature> find(long pointer, Variant variant) {
            List<GeneFeature> featureListAll = new List<GeneFeature>();
            int pos = variant.getPosition();
            int extLen = 0;
            int refAlleleLen = variant.alleleOfIndex(0).length();
            int sizeA = variant.numOfAlleles();
            for (int i = 1; i < sizeA; ++i) {
                int len = Math.abs(variant.alleleOfIndex(i).length() - refAlleleLen);
                if (extLen >= len) continue;
                extLen = len;
            }
            for (int i = 0; i < this.geneFeatureDatabasesNum; ++i) {
                List<Transcript> transcriptOverlap;
                IntIntervalTree<Transcript> chromosomeIntervalTree = this.chromTranscriptTreeMaps[i].get(variant.getChromosome());
                if (chromosomeIntervalTree == null || (transcriptOverlap = chromosomeIntervalTree.getOverlaps(pos, pos + extLen)).isEmpty()) continue;
                for (Transcript transcript : transcriptOverlap) {
                    List<GeneFeature> gfs;
                    if (this.needExcludeGenes && this.excludedGenes.contains(transcript.getGeneSymb()) || this.needRetainGenes && !this.retainedGenes.contains(transcript.getGeneSymb()) || (gfs = transcript.findFeatureSV(variant.getChromosome().getName(), variant, true, this.splicingDis, this.selectedFeatureSet, this.includeExonic, null)) == null) continue;
                    for (GeneFeature gf : gfs) {
                        gf.dbID = (short)i;
                    }
                    featureListAll.addAll(gfs);
                }
            }
            return featureListAll;
        }

        private short convertFeatureType2RegionType(byte featureTypeID, byte featureTypeID2, int regionID) {
            int typeID = 0;
            if (featureTypeID > 8) {
                block0 : switch (featureTypeID) {
                    case 9: {
                        typeID = 1;
                        break;
                    }
                    case 10: {
                        typeID = 2;
                        break;
                    }
                    case 11: {
                        typeID = (short)(10 + regionID);
                        break;
                    }
                    case 12: {
                        typeID = 3;
                        break;
                    }
                    case 13: {
                        typeID = 4;
                        break;
                    }
                    case 14: {
                        if (featureTypeID2 <= 8) break;
                        switch (featureTypeID2) {
                            case 11: {
                                typeID = (short)(10 + regionID);
                                break block0;
                            }
                            case 12: {
                                typeID = 3;
                                break block0;
                            }
                            case 13: {
                                typeID = 4;
                                break block0;
                            }
                        }
                        throw new IllegalStateException("Unexpected value: " + featureTypeID2);
                    }
                }
            }
            return (short)typeID;
        }

        @Override
        public boolean annotate(long pointer, Variant variant) throws IOException {
            List<GeneFeature> featureListAll = this.find(pointer, variant);
            if (featureListAll == null) {
                featureListAll = List.EMPTY();
            }
            if (!featureListAll.isEmpty()) {
                int i;
                featureListAll.sort(GeneFeature::compareTo);
                byte smallestFeatureID = featureListAll.get(0).getTypeID();
                this.variantsCounters[smallestFeatureID].getAndIncrement();
                variant.setProperty("GeneFeature@MarkFeatureGene", featureListAll.get(0).getGeneSymbolID());
                variant.setProperty("GeneFeature@MarkGeneFeature", smallestFeatureID);
                this.hitGeneIDs.clear();
                this.hitGeneRegionIDs.clear();
                this.hitGeneFeatureIDs.clear();
                int size = featureListAll.size();
                this.addedGeneID.clear();
                for (i = 0; i < this.geneFeatureDatabasesNum; ++i) {
                    this.featureCaches[i].clear();
                }
                for (i = 0; i < size; ++i) {
                    GeneFeature geneFeature = featureListAll.get(i);
                    if (!this.addedGeneID.contains(geneFeature.getGeneSymbolID())) {
                        if (geneFeature.getTypeID() > VarGeneFeatureType.EXONIC.index) {
                            if (this.canonicalTranscriptIDSet.contains(geneFeature.getTranscriptID())) {
                                this.hitGeneIDs.add(geneFeature.getGeneSymbolID());
                                this.hitGeneFeatureIDs.add(geneFeature.getTypeID());
                                short convertedID = this.convertFeatureType2RegionType(geneFeature.getTypeID(), geneFeature.getSecondTypeID(), geneFeature.getSubRegionID());
                                this.hitGeneRegionIDs.add(convertedID);
                                this.addedGeneID.add(geneFeature.getGeneSymbolID());
                            }
                        } else {
                            this.hitGeneIDs.add(geneFeature.getGeneSymbolID());
                            this.hitGeneFeatureIDs.add(geneFeature.getTypeID());
                            this.hitGeneRegionIDs.add(this.convertFeatureType2RegionType(geneFeature.getTypeID(), geneFeature.getSecondTypeID(), geneFeature.getSubRegionID()));
                            this.addedGeneID.add(geneFeature.getGeneSymbolID());
                        }
                    }
                    this.featureCaches[geneFeature.dbID].addAll((Bytes[])geneFeature.encode());
                }
                for (i = 0; i < this.geneFeatureDatabasesNum; ++i) {
                    if (this.featureCaches[i].isEmpty()) {
                        variant.setProperty("GeneFeature@" + this.databaseNames[i], List.EMPTY());
                        continue;
                    }
                    variant.setProperty("GeneFeature@" + this.databaseNames[i], this.featureCaches[i]);
                }
                variant.setProperty("GeneFeature@HitGenes", this.hitGeneIDs);
                variant.setProperty("GeneFeature@HitGeneRegionTypes", this.hitGeneRegionIDs);
                variant.setProperty("GeneFeature@HitGeneFeatures", this.hitGeneFeatureIDs);
                return true;
            }
            if (this.containIntergenic) {
                byte smallestFeatureID = VarGeneFeatureType.INTERGENIC.index;
                variant.setProperty("GeneFeature@MarkFeatureGene", -1);
                variant.setProperty("GeneFeature@MarkGeneFeature", smallestFeatureID);
                variant.setProperty("GeneFeature@HitGenes", new IntList());
                variant.setProperty("GeneFeature@HitGeneRegionTypes", new ShortList());
                variant.setProperty("GeneFeature@HitGeneFeatures", new ShortList());
                for (int i = 0; i < this.geneFeatureDatabasesNum; ++i) {
                    variant.setProperty("GeneFeature@" + this.databaseNames[i], List.EMPTY());
                }
                this.variantsCounters[smallestFeatureID].getAndIncrement();
                return true;
            }
            return false;
        }

        @Override
        public void close() throws IOException {
            super.close();
        }
    }
}

