/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.annotation.database;

import edu.sysu.pmglab.ccf.CCFTable;
import edu.sysu.pmglab.io.file.LiveFile;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

public class IntervalDatabaseDescription {
    final String name;
    final LiveFile path;
    final String geoID;
    final String markerID;
    final boolean isGib;
    final Set<String> fields;

    public String getName() {
        return this.name;
    }

    public LiveFile getPath() {
        return this.path;
    }

    public Set<String> getFields() {
        return this.fields;
    }

    public IntervalDatabaseDescription(String name, LiveFile path, String geoID, String markerID, String field) {
        this.path = path;
        this.geoID = geoID;
        this.markerID = markerID;
        if (name.toLowerCase().startsWith("eipmap")) {
            String subName = name.substring(6);
            if (path == null) {
                this.isGib = false;
                this.name = subName.isEmpty() ? "EipMapDatabase_" + geoID + "_" + markerID : name;
            } else {
                boolean isGib1;
                try {
                    CCFTable table = new CCFTable(path);
                    isGib1 = true;
                }
                catch (IOException e) {
                    isGib1 = false;
                }
                this.isGib = isGib1;
                this.name = name;
            }
        } else {
            this.name = name;
            this.isGib = false;
        }
        if (field != null && !field.isEmpty()) {
            String[] fields = field.split(",");
            this.fields = new HashSet<String>();
            for (String field0 : fields) {
                if (field0.trim().isEmpty()) continue;
                this.fields.add(field0.trim());
            }
        } else {
            this.fields = null;
        }
    }

    public String getGeoID() {
        return this.geoID;
    }

    public String getMarkerID() {
        return this.markerID;
    }

    public boolean isGib() {
        return this.isGib;
    }

    public String toString() {
        return "DatabaseDescription{name='" + this.name + '\'' + ", path='" + this.path + '\'' + '}';
    }
}

