/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.annotation.database;

import edu.sysu.pmglab.annotation.database.IntervalDatabaseDescription;
import edu.sysu.pmglab.commandParser.converter.IDynamicConverter;
import edu.sysu.pmglab.commandParser.exception.ParameterException;
import edu.sysu.pmglab.io.file.LiveFile;
import java.io.IOException;
import java.util.Map;

public enum IntervalDatabaseDescriptionConverter implements IDynamicConverter<IntervalDatabaseDescription>
{
    INSTANCE;


    @Override
    public IntervalDatabaseDescription convert(String s, Map<String, String> map) {
        String name = map.get("name");
        if (name.toLowerCase().startsWith("eipmap")) {
            if (map.get("path").isEmpty()) {
                return new IntervalDatabaseDescription(name, null, map.get("subID"), map.get("marker"), null);
            }
            if (!map.get("subID").isEmpty() || !map.get("marker").isEmpty()) {
                throw new ParameterException("You have specified the path of the interval database " + name + ". Please do not specify the 'subID' or 'marker'.");
            }
            try {
                return new IntervalDatabaseDescription(name, LiveFile.of(map.get("path")), null, null, null);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            return new IntervalDatabaseDescription(name, LiveFile.of(map.get("path")), null, null, map.get("field"));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

