/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.annotation.database.gene;

import edu.sysu.pmglab.annotation.VarGeneFeatureType;
import edu.sysu.pmglab.bytecode.ByteStream;
import edu.sysu.pmglab.bytecode.Bytes;
import edu.sysu.pmglab.container.indexable.IndexableSet;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.utils.Assert;

public interface IGeneFeature {
    public int getGeneSymbolID();

    public int getGeneID();

    public int getTranscriptID();

    public String getSequencePos();

    public short getExonNum();

    public short getSubRegionID();

    public byte getTypeID();

    public byte getSecondTypeID();

    public Bytes toDetail(IndexableSet<String> var1, IndexableSet<String> var2, IndexableSet<String> var3);

    public List<Bytes> encode();

    public static IGeneFeature instanceOf(final List<Bytes> codes) {
        Assert.that(codes.size() % 8 == 0);
        return new IGeneFeature(){
            int geneSymbolID = -1;
            int geneID = -1;
            int transcriptID = -1;
            String sequencePos = null;
            short exonNum = (short)-1;
            short subRegionID = (short)-1;
            byte typeID = (byte)-1;
            byte secondTypeID = (byte)-1;

            @Override
            public int getGeneSymbolID() {
                if (this.geneSymbolID == -1) {
                    this.geneSymbolID = ((Bytes)codes.fastGet(0)).decodeVarInt32();
                }
                return this.geneSymbolID;
            }

            @Override
            public int getGeneID() {
                if (this.geneID == -1) {
                    this.geneID = ((Bytes)codes.fastGet(1)).decodeVarInt32();
                }
                return this.geneID;
            }

            @Override
            public int getTranscriptID() {
                if (this.transcriptID == -1) {
                    this.transcriptID = ((Bytes)codes.fastGet(2)).decodeVarInt32();
                }
                return this.transcriptID;
            }

            @Override
            public String getSequencePos() {
                if (this.sequencePos == null) {
                    this.sequencePos = ((Bytes)codes.fastGet(3)).toString();
                }
                return this.sequencePos;
            }

            @Override
            public short getExonNum() {
                if (this.exonNum == -1) {
                    this.exonNum = ((Bytes)codes.fastGet(4)).decodeShort();
                }
                return this.exonNum;
            }

            @Override
            public short getSubRegionID() {
                if (this.subRegionID == -1) {
                    this.subRegionID = ((Bytes)codes.fastGet(5)).decodeShort();
                }
                return this.subRegionID;
            }

            @Override
            public byte getTypeID() {
                if (this.typeID == -1) {
                    this.typeID = ((Bytes)codes.fastGet(6)).decodeByte();
                }
                return this.typeID;
            }

            @Override
            public byte getSecondTypeID() {
                if (this.secondTypeID == -1) {
                    this.secondTypeID = ((Bytes)codes.fastGet(7)).decodeByte();
                }
                return this.secondTypeID;
            }

            @Override
            public List<Bytes> encode() {
                return codes;
            }

            @Override
            public Bytes toDetail(IndexableSet<String> geneSymbMap, IndexableSet<String> geneIDMap, IndexableSet<String> transcriptIDMap) {
                ByteStream sb = new ByteStream();
                sb.writeChar(geneSymbMap.valueOf(this.getGeneSymbolID()));
                sb.write(58);
                if (this.getGeneID() >= 0) {
                    sb.writeChar(geneIDMap.valueOf(this.getGeneID()));
                    sb.write(58);
                }
                sb.writeChar(transcriptIDMap.valueOf(this.getTranscriptID()));
                sb.writeChar(this.getSequencePos());
                sb.write(58);
                sb.writeChar(this.getExonNum());
                sb.writeChar("Exons:");
                sb.writeChar(VarGeneFeatureType.getFeatureName(this.getTypeID()));
                return sb.toBytes();
            }
        };
    }

    public static List<IGeneFeature> instancesOf(List<Bytes> codes) {
        if (codes == null || codes.isEmpty()) {
            return new List<IGeneFeature>(0);
        }
        int size = codes.size();
        Assert.that(size % 8 == 0);
        List<IGeneFeature> returns = new List<IGeneFeature>(size / 8);
        for (int i = 0; i < size / 8; ++i) {
            returns.add(IGeneFeature.instanceOf((List<Bytes>)codes.subList(8 * i, 8 * i + 8)));
        }
        return returns;
    }
}

