/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.annotation.database.gene;

import edu.sysu.pmglab.bytecode.ByteStream;
import edu.sysu.pmglab.bytecode.Bytes;
import edu.sysu.pmglab.bytecode.BytesSplitter;
import edu.sysu.pmglab.container.list.IntList;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.container.list.LongList;
import edu.sysu.pmglab.gtb.genome.coordinate.Chromosome;
import edu.sysu.pmglab.io.file.LiveFile;
import edu.sysu.pmglab.io.reader.ReaderStream;
import edu.sysu.pmglab.io.writer.WriterStream;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;

public class KggFileSeqFiller {
    private Chromosome currContig;
    private boolean finish = false;
    private Chromosome nextChr = null;
    private final ByteStream cache = new ByteStream();
    private final LongList contigSize = new LongList();
    static BytesSplitter tabSplitter = new BytesSplitter(9);
    static byte[] unassigned = "unassigned_transcript".getBytes();
    String seqPath;
    String kggFile;
    String resFile;

    public void submit() throws IOException {
        byte seq;
        int j;
        ByteStream cache = new ByteStream();
        ByteStream seqCache = new ByteStream();
        ReaderStream seqReader = LiveFile.of(this.seqPath).openAsText();
        ReaderStream kggReader = LiveFile.of(this.kggFile).openAsText();
        WriterStream kggWriter = new WriterStream(new File(this.resFile), WriterStream.Option.GZIP);
        this.collectOneContig(seqReader, seqCache);
        ByteStream exonSeq = new ByteStream();
        HashMap<Chromosome, List<Bytes>> unmatchedKGGRecords = new HashMap<Chromosome, List<Bytes>>();
        int index = 0;
        boolean inverseStrand = false;
        Chromosome currChromosome = null;
        Chromosome chromosome = this.currContig;
        int codingStart = -1;
        int codingEnd = -1;
        IntList exonStart = null;
        IntList exonEnd = null;
        while (kggReader.readline(cache) != -1) {
            byte seq2;
            int j2;
            int tmpEnd;
            int tmpPos;
            int i;
            ++index;
            Bytes line = cache.toBytes();
            tabSplitter.init(line);
            int colCount = 0;
            boolean invalid = false;
            while (tabSplitter.hasNext()) {
                Bytes item = tabSplitter.next();
                switch (colCount++) {
                    case 1: {
                        if (!item.startsWith(unassigned)) break;
                        invalid = true;
                        break;
                    }
                    case 2: {
                        String contigName = item.toString();
                        currChromosome = Chromosome.get(contigName);
                        if (currChromosome.equals(Chromosome.UNKNOWN)) {
                            currChromosome = Chromosome.get(contigName);
                        }
                        if (currChromosome.equals(chromosome)) break;
                        List<Bytes> unmatchedRecordsInContig = (List<Bytes>)unmatchedKGGRecords.get(currChromosome);
                        if (unmatchedRecordsInContig == null) {
                            unmatchedRecordsInContig = new List<Bytes>();
                            unmatchedKGGRecords.put(currChromosome, unmatchedRecordsInContig);
                        }
                        unmatchedRecordsInContig.add(cache.toBytes().detach());
                        invalid = true;
                        break;
                    }
                    case 3: {
                        inverseStrand = item.toString().equals("-");
                        break;
                    }
                    case 6: {
                        codingStart = item.toInt();
                        break;
                    }
                    case 7: {
                        codingEnd = item.toInt();
                        break;
                    }
                    case 9: {
                        exonStart = KggFileSeqFiller.parse(item);
                        break;
                    }
                    case 10: {
                        exonEnd = KggFileSeqFiller.parse(item);
                        break;
                    }
                }
                if (!invalid) continue;
                break;
            }
            if (invalid) {
                cache.clear();
                exonSeq.clear();
                continue;
            }
            int exonSize = exonEnd.size();
            if (inverseStrand) {
                boolean utr3Appender = exonStart.fastGet(0) > codingStart;
                for (i = exonSize - 1; i >= 0; --i) {
                    tmpPos = exonEnd.fastGet(i);
                    tmpEnd = exonStart.fastGet(i);
                    for (j2 = tmpPos - 1; j2 >= tmpEnd; --j2) {
                        seq2 = seqCache.toBytes().byteAt(j2);
                        switch (seq2) {
                            case 65: 
                            case 97: {
                                seq2 = 84;
                                break;
                            }
                            case 67: 
                            case 99: {
                                seq2 = 71;
                                break;
                            }
                            case 71: 
                            case 103: {
                                seq2 = 67;
                                break;
                            }
                            case 84: 
                            case 116: {
                                seq2 = 65;
                            }
                        }
                        exonSeq.write(seq2);
                    }
                    if (i != 0 || !utr3Appender) continue;
                    int firstStart = exonStart.fastGet(0);
                    for (j = 0; j < 3; ++j) {
                        seq = seqCache.toBytes().byteAt(firstStart + j);
                        switch (seq) {
                            case 65: 
                            case 97: {
                                seq = 84;
                                break;
                            }
                            case 67: 
                            case 99: {
                                seq = 71;
                                break;
                            }
                            case 71: 
                            case 103: {
                                seq = 67;
                                break;
                            }
                            case 84: 
                            case 116: {
                                seq = 65;
                            }
                        }
                        exonSeq.write(seq);
                    }
                }
            } else {
                boolean utr5Appender = exonEnd.fastGet(exonSize - 1) < codingEnd;
                for (i = 0; i < exonSize; ++i) {
                    tmpPos = exonStart.fastGet(i);
                    tmpEnd = exonEnd.fastGet(i);
                    for (j2 = tmpPos; j2 < tmpEnd; ++j2) {
                        seq2 = seqCache.toBytes().byteAt(j2);
                        exonSeq.write(seq2);
                    }
                    if (i != exonSize - 1 || !utr5Appender) continue;
                    for (j2 = 0; j2 < 3; ++j2) {
                        exonSeq.write(seqCache.toBytes().byteAt(tmpEnd + j2));
                    }
                }
            }
            cache.write(exonSeq.toBytes());
            cache.write(9);
            cache.write((byte)46);
            cache.write(9);
            cache.write((byte)46);
            cache.write((byte)10);
            kggWriter.write(cache.toBytes());
            cache.clear();
            exonSeq.clear();
        }
        cache.clear();
        while (this.collectOneContig(seqReader, seqCache)) {
            chromosome = this.currContig;
            List unmatchedRecords = (List)unmatchedKGGRecords.get(chromosome);
            if (unmatchedRecords == null || unmatchedRecords.isEmpty()) {
                seqCache.clear();
                continue;
            }
            for (Bytes line : unmatchedRecords) {
                int tmpEnd;
                int tmpPos;
                int i;
                tabSplitter.init(line);
                int count1 = 0;
                while (tabSplitter.hasNext()) {
                    Bytes item = tabSplitter.next();
                    switch (count1++) {
                        case 3: {
                            inverseStrand = item.toString().equals("-");
                            break;
                        }
                        case 6: {
                            codingStart = item.toInt();
                            break;
                        }
                        case 7: {
                            codingEnd = item.toInt();
                            break;
                        }
                        case 9: {
                            exonStart = KggFileSeqFiller.parse(item);
                            break;
                        }
                        case 10: {
                            exonEnd = KggFileSeqFiller.parse(item);
                            break;
                        }
                    }
                }
                int exonSize = exonEnd.size();
                if (inverseStrand) {
                    boolean utr3Appender = exonStart.fastGet(0) > codingStart;
                    for (i = exonSize - 1; i >= 0; --i) {
                        tmpPos = exonEnd.fastGet(i);
                        tmpEnd = exonStart.fastGet(i);
                        for (j = tmpPos - 1; j >= tmpEnd; --j) {
                            seq = seqCache.toBytes().byteAt(j);
                            switch (seq) {
                                case 65: 
                                case 97: {
                                    seq = 84;
                                    break;
                                }
                                case 67: 
                                case 99: {
                                    seq = 71;
                                    break;
                                }
                                case 71: 
                                case 103: {
                                    seq = 67;
                                    break;
                                }
                                case 84: 
                                case 116: {
                                    seq = 65;
                                }
                            }
                            exonSeq.write(seq);
                        }
                        if (i == 0 && !utr3Appender) continue;
                    }
                } else {
                    boolean utr5Appender = exonEnd.fastGet(exonSize - 1) < codingEnd;
                    for (i = 0; i < exonSize; ++i) {
                        tmpPos = exonStart.fastGet(i);
                        tmpEnd = exonEnd.fastGet(i);
                        for (j = tmpPos; j < tmpEnd; ++j) {
                            seq = seqCache.toBytes().byteAt(j);
                            exonSeq.write(seq);
                        }
                        if (i != exonSize - 1 || !utr5Appender) continue;
                        for (j = 0; j < 3; ++j) {
                            exonSeq.write(seqCache.toBytes().byteAt(tmpEnd + j));
                        }
                    }
                }
                cache.write(line);
                cache.write(exonSeq.toBytes());
                cache.write(9);
                cache.write((byte)46);
                cache.write(9);
                cache.write((byte)46);
                cache.write((byte)10);
                kggWriter.write(cache.toBytes());
                exonSeq.clear();
                cache.clear();
            }
        }
        seqReader.close();
        kggReader.close();
        kggWriter.close();
    }

    boolean collectOneContig(ReaderStream fs, ByteStream seqCache) throws IOException {
        if (this.finish) {
            return false;
        }
        if (this.nextChr != null) {
            this.currContig = this.nextChr;
            this.nextChr = null;
        }
        seqCache.clear();
        long size = 0L;
        boolean res = false;
        while (fs.readline(this.cache) != -1) {
            Bytes line = this.cache.toBytes();
            if (line.startsWith((byte)35)) {
                this.cache.clear();
                continue;
            }
            if (line.length() == 0) {
                this.cache.clear();
                continue;
            }
            if (line.byteAt(0) == 62) {
                Bytes headLine = line.detach();
                Iterator<Bytes> iterator2 = headLine.split((byte)32).next().split((byte)62);
                iterator2.next();
                Bytes contig = iterator2.next().detach();
                Chromosome chromosome = Chromosome.get(contig.toString());
                if (chromosome == Chromosome.UNKNOWN) {
                    chromosome = Chromosome.get(contig.toString());
                }
                if (this.currContig == null) {
                    this.currContig = chromosome;
                    this.cache.clear();
                    continue;
                }
                this.nextChr = chromosome;
                this.cache.clear();
                break;
            }
            size += (long)line.length();
            seqCache.write(line.detach());
            this.cache.clear();
            res = true;
        }
        if (!res) {
            this.finish = true;
            this.currContig = this.nextChr;
            this.nextChr = null;
        }
        if (this.nextChr == null && this.finish) {
            return false;
        }
        this.contigSize.add(size);
        return res;
    }

    static IntList parse(Bytes encodeIntList) {
        IntList res = new IntList();
        Iterator<Bytes> iterator2 = encodeIntList.split((byte)44);
        while (iterator2.hasNext()) {
            Bytes item = iterator2.next().trim();
            if (item.length() == 0) continue;
            res.add(item.toInt());
        }
        return res;
    }

    public KggFileSeqFiller setSeqPath(String seqPath) {
        this.seqPath = seqPath;
        return this;
    }

    public KggFileSeqFiller setKggFile(String kggFile) {
        this.kggFile = kggFile;
        return this;
    }

    public KggFileSeqFiller setResFile(String resFile) {
        this.resFile = resFile;
        return this;
    }
}

