/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.annotation.database.gene;

import edu.sysu.pmglab.annotation.database.gene.KggFileSeqFiller;
import edu.sysu.pmglab.annotation.database.gene.KnownGeneFileParser;
import edu.sysu.pmglab.annotation.database.gene.RefSeq2KggSeqGeneProducer;
import edu.sysu.pmglab.io.FileUtils;
import java.io.File;
import java.io.IOException;
import java.util.UUID;

public class KnownGene2KggSeqGeneProducer
extends RefSeq2KggSeqGeneProducer {
    protected File extraGeneFile;
    protected File inputKnownGeneFile;

    @Override
    public void submit(String outputFilePath) throws IOException {
        this.check();
        String tmpKggFile = FileUtils.getSubFile(this.outputDir.toString(), UUID.randomUUID() + ".txt");
        KnownGeneFileParser refSeqGTFParser = new KnownGeneFileParser().setKnownGeneFile(this.inputKnownGeneFile).setExtraGeneFile(this.extraGeneFile).setStoredContigName(storedContigName).setOutputPath(tmpKggFile);
        refSeqGTFParser.submit();
        if (this.inputFNAFile != null) {
            String resFile = FileUtils.getSubFile(this.outputDir.toString(), outputFilePath);
            new KggFileSeqFiller().setKggFile(tmpKggFile).setSeqPath(this.inputFNAFile.toString()).setResFile(resFile).submit();
            FileUtils.delete(tmpKggFile);
        } else {
            String resFile = FileUtils.getSubFile(this.outputDir.toString(), outputFilePath);
            new File(tmpKggFile).renameTo(new File(resFile));
        }
    }

    @Override
    protected void check() {
        if (this.extraGeneFile == null) {
            throw new UnsupportedOperationException("KnownGene gene map file isn't assigned");
        }
        if (this.inputKnownGeneFile == null) {
            throw new UnsupportedOperationException("KnownGene file isn't assigned");
        }
        if (this.outputDir == null) {
            throw new UnsupportedOperationException("Output directory isn't assigned");
        }
        if (this.inputFNAFile == null) {
            throw new UnsupportedOperationException("Input sequence file(.fna) isn't assigned");
        }
    }

    public KnownGene2KggSeqGeneProducer setInputKnownGeneFile(Object inputKnownGeneFile) {
        this.inputKnownGeneFile = new File(inputKnownGeneFile.toString());
        return this;
    }

    public KnownGene2KggSeqGeneProducer setExtraGeneFile(Object extraGeneFile) {
        this.extraGeneFile = new File(extraGeneFile.toString());
        return this;
    }

    @Override
    public KnownGene2KggSeqGeneProducer setOutputDir(Object outputDir) {
        super.setOutputDir(outputDir);
        return this;
    }

    @Override
    public KnownGene2KggSeqGeneProducer setInputGTFFile(Object inputGTFFile) {
        super.setInputGTFFile(inputGTFFile);
        return this;
    }

    @Override
    public KnownGene2KggSeqGeneProducer setInputFNAFile(Object inputFNAFile) {
        super.setInputFNAFile(inputFNAFile);
        return this;
    }

    public static void main(String[] args) throws IOException {
        new KnownGene2KggSeqGeneProducer().setInputKnownGeneFile("/Users/wenjiepeng/Desktop/SDFA3.0/annotation/annotation/resource/genome/knownGene/knownGene.txt").setOutputDir("/Users/wenjiepeng/Desktop/SDFA3.0/annotation/annotation/resource/genome").setInputFNAFile("/Users/wenjiepeng/Desktop/SDFA3.0/annotation/annotation/resource/genome/refGene/GRCh38_latest_genomic.fna.gz").setExtraGeneFile("/Users/wenjiepeng/Desktop/SDFA3.0/annotation/annotation/resource/genome/knownGene/mart_export-3.txt").submit("knownGene_hg38_kggseq_v2.txt.gz");
    }
}

