/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.annotation.database.gene;

import edu.sysu.pmglab.annotation.database.gene.RefSeqGTFParser;
import edu.sysu.pmglab.bytecode.ASCIIUtility;
import edu.sysu.pmglab.bytecode.ByteStream;
import edu.sysu.pmglab.bytecode.Bytes;
import edu.sysu.pmglab.bytecode.BytesSplitter;
import edu.sysu.pmglab.gtb.genome.coordinate.Chromosome;
import edu.sysu.pmglab.io.file.LiveFile;
import edu.sysu.pmglab.io.reader.ReaderStream;
import edu.sysu.pmglab.io.writer.WriterStream;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;

public class KnownGeneFileParser {
    File outputPath;
    String knownGeneFile;
    String extraGeneFile;
    HashSet<Chromosome> storedContigName;
    static BytesSplitter tabSplitter = new BytesSplitter(9);
    static BytesSplitter semicolonSplitter = new BytesSplitter(59);
    static BytesSplitter colonSplitter = new BytesSplitter(58);

    public void submit() throws IOException {
        File tmp = this.outputPath;
        ByteStream cache = new ByteStream();
        HashMap<Bytes, KnownGeneTransfer> transcriptMap = new HashMap<Bytes, KnownGeneTransfer>();
        ReaderStream readerStream = LiveFile.of(this.extraGeneFile).openAsText();
        while (readerStream.readline(cache) != -1) {
            Bytes line = cache.toBytes();
            if (line.byteAt(0) != 35) {
                KnownGeneTransfer.register(cache.toBytes(), transcriptMap);
            }
            cache.clear();
        }
        boolean dropSize = false;
        readerStream.close();
        cache.clear();
        ByteStream writerCache = new ByteStream();
        readerStream = LiveFile.of(this.knownGeneFile).openAsText();
        KnownGeneTransfer knownGeneTransfer = null;
        WriterStream writerStream = new WriterStream(tmp, WriterStream.Option.DEFAULT);
        while (readerStream.readline(cache) != -1) {
            Bytes line = cache.toBytes();
            if (line.byteAt(0) != 35) {
                tabSplitter.init(line);
                int cloCount = 0;
                boolean invalid = false;
                while (tabSplitter.hasNext()) {
                    Bytes item = tabSplitter.next();
                    switch (cloCount++) {
                        case 0: {
                            knownGeneTransfer = transcriptMap.get(item);
                            boolean bl = invalid = knownGeneTransfer == null;
                            if (invalid) break;
                            writerCache.write(ASCIIUtility.toASCII(knownGeneTransfer.idOfHGNC));
                            writerCache.write(9);
                            writerCache.write(item.detach());
                            writerCache.write(9);
                            break;
                        }
                        case 1: {
                            Chromosome chromosome = Chromosome.get(item.toString());
                            boolean bl = invalid = !this.storedContigName.contains(chromosome);
                            if (invalid) break;
                            writerCache.write(item.detach());
                            writerCache.write(9);
                            break;
                        }
                        default: {
                            writerCache.write(item.detach());
                            writerCache.write(9);
                        }
                    }
                    if (!invalid) continue;
                    break;
                }
                if (invalid || knownGeneTransfer == null) {
                    writerCache.clear();
                    cache.clear();
                    continue;
                }
                writerCache.write((byte)48);
                writerCache.write(9);
                writerCache.write(knownGeneTransfer.getGeneName());
                writerCache.write(9);
                writerCache.write(RefSeqGTFParser.UNKNOWN_FLAG);
                writerCache.write(9);
                writerCache.write(RefSeqGTFParser.UNKNOWN_FLAG);
                writerCache.write(9);
                writerCache.write((byte)46);
                writerCache.write((byte)44);
                writerCache.write(9);
                writerCache.write((byte)10);
                writerStream.write(writerCache.toBytes());
            }
            cache.clear();
            writerCache.clear();
        }
        readerStream.close();
        writerStream.close();
    }

    public KnownGeneFileParser setOutputPath(Object outputPath) {
        this.outputPath = new File(outputPath.toString());
        return this;
    }

    public KnownGeneFileParser setKnownGeneFile(Object knownGeneFile) {
        this.knownGeneFile = knownGeneFile.toString();
        return this;
    }

    public KnownGeneFileParser setStoredContigName(HashSet<Chromosome> storedContigName) {
        this.storedContigName = storedContigName;
        return this;
    }

    public String getKnownGeneFile() {
        return this.knownGeneFile;
    }

    public String getExtraGeneFile() {
        return this.extraGeneFile;
    }

    public KnownGeneFileParser setExtraGeneFile(Object extraGeneFile) {
        this.extraGeneFile = extraGeneFile.toString();
        return this;
    }

    public static void main(String[] args) throws IOException {
        Chromosome.get("chrMT").addAlias("NC_012920.1", "MT", "chrM");
        HashSet<Chromosome> chromosomes = new HashSet<Chromosome>(Chromosome.values());
        new KnownGeneFileParser().setExtraGeneFile("/Users/wenjiepeng/Desktop/SDFA3.0/annotation/annotation/resource/genome/knownGene/mart_export-3.txt").setKnownGeneFile("/Users/wenjiepeng/Desktop/SDFA3.0/annotation/annotation/resource/genome/knownGene/knownGene.txt").setOutputPath("/Users/wenjiepeng/Desktop/SDFA3.0/annotation/annotation/resource/genome/knownGene").setStoredContigName(chromosomes).submit();
    }

    private static class KnownGeneTransfer {
        int idOfHGNC = -1;
        Bytes geneNameOfHGNC;
        Bytes geneNameOfUCSC;

        private KnownGeneTransfer() {
        }

        public static void register(Bytes line, HashMap<Bytes, KnownGeneTransfer> transcriptMap) {
            KnownGeneTransfer knownGeneTransfer = new KnownGeneTransfer();
            tabSplitter.init(line);
            Bytes nameOfRNA = null;
            Bytes versionOfRNA = null;
            int colCount = 0;
            while (tabSplitter.hasNext()) {
                Bytes item = tabSplitter.next();
                switch (colCount++) {
                    case 0: {
                        knownGeneTransfer.geneNameOfUCSC = item.detach();
                        break;
                    }
                    case 2: {
                        nameOfRNA = item.detach();
                        break;
                    }
                    case 3: {
                        versionOfRNA = item.detach();
                        break;
                    }
                    case 4: {
                        if (item.length() == 0) break;
                        knownGeneTransfer.geneNameOfHGNC = item.detach();
                        Bytes last = null;
                        while (tabSplitter.hasNext()) {
                            last = tabSplitter.next();
                        }
                        if (last == null) break;
                        colonSplitter.init(last);
                        colonSplitter.next();
                        knownGeneTransfer.idOfHGNC = colonSplitter.next().detach().toInt();
                    }
                }
            }
            if (nameOfRNA != null && versionOfRNA != null) {
                transcriptMap.put(nameOfRNA, knownGeneTransfer);
                transcriptMap.put(versionOfRNA, knownGeneTransfer);
            }
        }

        public Bytes getGeneName() {
            return this.geneNameOfHGNC == null ? this.geneNameOfUCSC : new Bytes(this.geneNameOfUCSC.toString() + ";" + this.geneNameOfHGNC.toString());
        }

        public int getIdOfHGNC() {
            return this.idOfHGNC;
        }
    }
}

