/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.annotation.database.gene;

import edu.sysu.pmglab.annotation.database.gene.KggFileSeqFiller;
import edu.sysu.pmglab.annotation.database.gene.RefSeqGTFParser;
import edu.sysu.pmglab.gtb.genome.coordinate.Chromosome;
import edu.sysu.pmglab.io.FileUtils;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.UUID;

public class RefSeq2KggSeqGeneProducer {
    protected File outputDir;
    protected File inputGTFFile;
    protected File inputFNAFile;
    protected static HashSet<Chromosome> storedContigName;

    public RefSeq2KggSeqGeneProducer() {
        Chromosome.get("chrMT").addAlias("NC_012920.1", "MT", "chrM");
        storedContigName = new HashSet<Chromosome>(Chromosome.values());
    }

    public void submit(String outputFileName) throws IOException {
        this.check();
        String tmpKggFile = FileUtils.getSubFile(this.outputDir.toString(), UUID.randomUUID() + ".txt");
        RefSeqGTFParser refSeqGTFParser = new RefSeqGTFParser().setGtfFile(this.inputGTFFile).setStoredContigName(storedContigName).setOutputKggFile(tmpKggFile);
        refSeqGTFParser.submit();
        if (this.inputFNAFile != null) {
            String resFile = FileUtils.getSubFile(this.outputDir.toString(), outputFileName);
            new KggFileSeqFiller().setKggFile(tmpKggFile).setSeqPath(this.inputFNAFile.toString()).setResFile(resFile).submit();
            FileUtils.delete(tmpKggFile);
        } else {
            String resFile = FileUtils.getSubFile(this.outputDir.toString(), outputFileName);
            new File(tmpKggFile).renameTo(new File(resFile));
        }
    }

    public RefSeq2KggSeqGeneProducer setOutputDir(Object outputDir) {
        this.outputDir = new File(outputDir.toString());
        return this;
    }

    public RefSeq2KggSeqGeneProducer setInputGTFFile(Object inputGTFFile) {
        this.inputGTFFile = new File(inputGTFFile.toString());
        return this;
    }

    public RefSeq2KggSeqGeneProducer setInputFNAFile(Object inputFNAFile) {
        this.inputFNAFile = new File(inputFNAFile.toString());
        return this;
    }

    protected void check() {
        if (this.inputGTFFile == null) {
            throw new UnsupportedOperationException("No gtf file is passed.");
        }
        if (this.outputDir == null) {
            throw new UnsupportedOperationException("Output directory file is not assigned.");
        }
    }

    public static void addStoredContig(String ... contigNames) {
        for (String contigName : contigNames) {
            Chromosome.get(contigName);
        }
        storedContigName.addAll(Chromosome.values());
    }

    public static void clearAllStoredContigs() {
        storedContigName.clear();
    }

    public static void main(String[] args) throws IOException {
        new RefSeq2KggSeqGeneProducer().setInputGTFFile("/Users/wenjiepeng/Desktop/SDFA3.0/annotation/annotation/resource/genome/refGene/GRCh38_latest_genomic.gtf.gz").setOutputDir("/Users/wenjiepeng/Desktop/SDFA3.0/annotation/annotation/resource/genome").setInputFNAFile("/Users/wenjiepeng/Desktop/SDFA3.0/annotation/annotation/resource/genome/refGene/GRCh38_latest_genomic.fna.gz").submit("refGene_hg38_kggseq_v2.txt.gz");
    }
}

