/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.annotation.database.gene;

import edu.sysu.pmglab.bytecode.ASCIIUtility;
import edu.sysu.pmglab.bytecode.ByteStream;
import edu.sysu.pmglab.bytecode.Bytes;
import edu.sysu.pmglab.bytecode.BytesSplitter;
import edu.sysu.pmglab.container.indexable.IndexableSet;
import edu.sysu.pmglab.container.indexable.LinkedSet;
import edu.sysu.pmglab.container.list.IntList;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.gtb.genome.coordinate.Chromosome;
import edu.sysu.pmglab.io.file.LiveFile;
import edu.sysu.pmglab.io.reader.ReaderStream;
import edu.sysu.pmglab.io.writer.WriterStream;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;

public class RefSeqGTFParser {
    String gtfFile;
    File outputKggFile;
    HashSet<Chromosome> storedContigName;
    static BytesSplitter tabSplit = new BytesSplitter(9);
    static BytesSplitter colonSplit = new BytesSplitter(58);
    static BytesSplitter semicolonSplit = new BytesSplitter(59);
    static BytesSplitter blankSplit = new BytesSplitter(32);
    public static Bytes CMPL_FLAG = new Bytes("cmpl");
    public static Bytes UNKNOWN_FLAG = new Bytes("unk");
    public static Bytes INCMPL_FLAG = new Bytes("incmpl");
    public static byte[] HGNC_BYTES = "HGNC".getBytes();
    static IndexableSet<Bytes> indexableTypeSet = new LinkedSet<Bytes>(new Bytes[]{new Bytes("gene"), new Bytes("transcript"), new Bytes("start_codon"), new Bytes("CDS"), new Bytes("exon"), new Bytes("stop_codon")});

    public void submit() throws IOException {
        Bytes line;
        ByteStream cache = new ByteStream();
        ByteStream outputCache = new ByteStream();
        LiveFile liveFile = LiveFile.of(this.gtfFile);
        ReaderStream readerStream = liveFile.openAsText();
        WriterStream writerStream = new WriterStream(new File(this.outputKggFile.toString()), WriterStream.Option.DEFAULT);
        int count = 0;
        Bytes transcriptName = null;
        while (readerStream.readline(cache) != -1 && (line = cache.toBytes()).byteAt(0) == 35) {
            cache.clear();
        }
        int indexOfHGNC = -1;
        KggSeqTranscriptRecord record = new KggSeqTranscriptRecord();
        List<KggSeqTranscriptRecord> list = new List<KggSeqTranscriptRecord>();
        boolean startGene = true;
        boolean startRNA = true;
        boolean firstRNAInGene = true;
        Bytes hgncBytes = null;
        do {
            hgncBytes = null;
            Bytes line2 = cache.toBytes();
            if (line2.byteAt(0) == 35) {
                cache.clear();
                continue;
            }
            List<Bytes> split = new List<Bytes>();
            Iterator<Bytes> iterator2 = line2.split((byte)9);
            while (iterator2.hasNext()) {
                split.add(iterator2.next().detach());
            }
            Bytes type = ((Bytes)split.fastGet(2)).detach();
            int index = indexableTypeSet.indexOf(type);
            switch (index) {
                case 0: {
                    int indexOfContig;
                    if (!startGene && !record.exonStartPos.isEmpty()) {
                        list.add(record);
                        record = record.retainContigAndGene();
                    }
                    startGene = false;
                    firstRNAInGene = true;
                    Bytes contigName = ((Bytes)split.fastGet(0)).detach();
                    String contigStringName = contigName.toString();
                    Chromosome chromosome = Chromosome.get(contigStringName);
                    if (!chromosome.equals(Chromosome.UNKNOWN)) {
                        indexOfContig = chromosome.getIndex();
                        contigName = new Bytes(chromosome.getName());
                    } else {
                        chromosome = Chromosome.get(contigStringName);
                        indexOfContig = chromosome.getIndex();
                        contigName = new Bytes(chromosome.getName());
                    }
                    Bytes info = (Bytes)split.get(8);
                    blankSplit.init(info);
                    blankSplit.next();
                    Bytes geneNameAtrr = blankSplit.next();
                    Iterator<Bytes> attrSplit = geneNameAtrr.split((byte)34);
                    attrSplit.next();
                    Bytes geneName = attrSplit.next().detach();
                    record.setContigName(contigName).setGeneName(geneName).indexOfContig(indexOfContig);
                    break;
                }
                case 1: {
                    Bytes idOfRNAHGNC;
                    if (!startRNA && !firstRNAInGene) {
                        list.add(record);
                        record = record.retainContigAndGene();
                    }
                    startRNA = false;
                    firstRNAInGene = false;
                    int pos = ((Bytes)split.fastGet(3)).toInt();
                    int end = ((Bytes)split.fastGet(4)).toInt();
                    byte strand = ((Bytes)split.fastGet(6)).startsWith((byte)43) ? (byte)0 : 1;
                    blankSplit.init((Bytes)split.fastGet(8));
                    int infoCount = 0;
                    block16: while (blankSplit.hasNext()) {
                        Bytes item = blankSplit.next();
                        switch (infoCount++) {
                            case 3: {
                                int indexOfVersion;
                                semicolonSplit.init(item);
                                Iterator<Bytes> iterator1 = semicolonSplit.next().split((byte)34);
                                iterator1.next();
                                transcriptName = iterator1.next().detach();
                                if (transcriptName == null || (indexOfVersion = transcriptName.indexOf((byte)46)) == -1) continue block16;
                                transcriptName = transcriptName.subBytes(0, indexOfVersion).detach();
                                break;
                            }
                            default: {
                                if (!item.startsWith(HGNC_BYTES)) continue block16;
                                hgncBytes = item.detach();
                            }
                        }
                    }
                    if (transcriptName == null) break;
                    try {
                        if (hgncBytes == null) {
                            idOfRNAHGNC = new Bytes("-1");
                        } else {
                            colonSplit.init(hgncBytes);
                            colonSplit.next();
                            colonSplit.next();
                            idOfRNAHGNC = colonSplit.next().split((byte)34).next().detach();
                        }
                        record.setPos(pos).setEnd(end).setTranscriptName(transcriptName).setIdOfHGNC(idOfRNAHGNC.toInt()).setStrand(strand);
                    }
                    catch (Exception e) {
                        System.out.println(count);
                        System.out.println(cache.toBytes());
                        colonSplit.init(hgncBytes);
                        colonSplit.next();
                        colonSplit.next();
                        idOfRNAHGNC = colonSplit.next().split((byte)34).next().detach();
                        record.setPos(pos).setEnd(end).setTranscriptName(transcriptName).setIdOfHGNC(idOfRNAHGNC.toInt());
                    }
                    break;
                }
                case 2: {
                    record.startCodon(true);
                    break;
                }
                case 3: {
                    record.setCodingPos(((Bytes)split.fastGet(3)).toInt());
                    record.setCodingEnd(((Bytes)split.fastGet(4)).toInt());
                    break;
                }
                case 4: {
                    int exonStart = ((Bytes)split.fastGet(3)).toInt();
                    int exonEnd = ((Bytes)split.fastGet(4)).toInt();
                    record.addExon(exonStart, exonEnd);
                    break;
                }
                case 5: {
                    int stopCodonStart = ((Bytes)split.fastGet(3)).toInt();
                    int stopCodonEnd = ((Bytes)split.fastGet(4)).toInt();
                    record.updateCodingEnd(stopCodonStart);
                    record.updateCodingEnd(stopCodonEnd);
                    record.endCodon(true);
                    break;
                }
            }
            ++count;
            cache.clear();
        } while (readerStream.readline(cache) != -1);
        list.sort(KggSeqTranscriptRecord::compareTo);
        for (int i = 0; i < list.size(); ++i) {
            KggSeqTranscriptRecord tmp = (KggSeqTranscriptRecord)list.fastGet(i);
            Chromosome chromosome = Chromosome.get(tmp.contigName.toString());
            if (!this.storedContigName.contains(chromosome)) continue;
            ((KggSeqTranscriptRecord)list.fastGet(i)).writeToCache(outputCache);
            writerStream.write(outputCache.toBytes());
            outputCache.clear();
        }
        readerStream.close();
        writerStream.close();
    }

    public RefSeqGTFParser setGtfFile(Object gtfFile) {
        this.gtfFile = gtfFile.toString();
        return this;
    }

    public RefSeqGTFParser setOutputKggFile(Object outputKggFile) {
        this.outputKggFile = new File(outputKggFile.toString());
        return this;
    }

    public File getOutputKggFile() {
        return this.outputKggFile;
    }

    public static void setIndexableTypeSet(IndexableSet<Bytes> indexableTypeSet) {
        RefSeqGTFParser.indexableTypeSet = indexableTypeSet;
    }

    public RefSeqGTFParser setStoredContigName(HashSet<Chromosome> storedContigName) {
        this.storedContigName = storedContigName;
        return this;
    }

    static class KggSeqTranscriptRecord
    implements Comparable<KggSeqTranscriptRecord> {
        int indexOfContig;
        int idOfHGNC;
        Bytes transcriptName;
        Bytes contigName;
        byte strand;
        int pos;
        int end;
        int codingPos = Integer.MAX_VALUE;
        int codingEnd = Integer.MIN_VALUE;
        int exonSize;
        IntList exonStartPos = new IntList();
        IntList exonEndPos = new IntList();
        Bytes geneName;
        boolean startCodon = false;
        boolean endCodon = false;

        public KggSeqTranscriptRecord setIdOfHGNC(int idOfHGNC) {
            this.idOfHGNC = idOfHGNC;
            return this;
        }

        public KggSeqTranscriptRecord setTranscriptName(Bytes transcriptName) {
            this.transcriptName = transcriptName;
            return this;
        }

        public KggSeqTranscriptRecord setContigName(Bytes contigName) {
            this.contigName = contigName;
            return this;
        }

        public KggSeqTranscriptRecord setStrand(byte strand) {
            this.strand = strand;
            return this;
        }

        public KggSeqTranscriptRecord setPos(int pos) {
            this.pos = pos;
            return this;
        }

        public KggSeqTranscriptRecord setEnd(int end) {
            this.end = end;
            return this;
        }

        public KggSeqTranscriptRecord setCodingPos(int codingPos) {
            this.codingPos = Math.min(codingPos, this.codingPos);
            return this;
        }

        public KggSeqTranscriptRecord updateCodingEnd(int coding) {
            this.codingPos = Math.min(coding, this.codingPos);
            this.codingEnd = Math.max(this.codingEnd, coding);
            return this;
        }

        public KggSeqTranscriptRecord setCodingEnd(int codingEnd) {
            this.codingEnd = Math.max(codingEnd, this.codingEnd);
            return this;
        }

        public KggSeqTranscriptRecord setExonSize(int exonSize) {
            this.exonSize = exonSize;
            return this;
        }

        public KggSeqTranscriptRecord setGeneName(Bytes geneName) {
            this.geneName = geneName;
            return this;
        }

        public void addExon(int start, int end) {
            this.exonStartPos.add(start - 1);
            this.exonEndPos.add(end);
        }

        public void writeToCache(ByteStream cache) {
            cache.write(ASCIIUtility.toASCII(this.idOfHGNC));
            cache.write(9);
            cache.write(this.transcriptName);
            cache.write(9);
            cache.write(this.contigName);
            cache.write(9);
            cache.write(this.strand == 0 ? (byte)43 : 45);
            cache.write(9);
            cache.write(ASCIIUtility.toASCII(this.pos - 1));
            cache.write(9);
            cache.write(ASCIIUtility.toASCII(this.end));
            cache.write(9);
            cache.write(ASCIIUtility.toASCII(this.codingPos == Integer.MAX_VALUE ? this.end : this.codingPos - 1));
            cache.write(9);
            cache.write(ASCIIUtility.toASCII(this.codingEnd == Integer.MIN_VALUE ? this.end : this.codingEnd));
            cache.write(9);
            cache.write(ASCIIUtility.toASCII(this.exonStartPos.size()));
            cache.write(9);
            this.exonStartPos.sort();
            this.writeMultiInt(cache, this.exonStartPos);
            cache.write(9);
            this.exonEndPos.sort();
            this.writeMultiInt(cache, this.exonEndPos);
            cache.write(9);
            cache.write((byte)48);
            cache.write(9);
            cache.write(this.geneName);
            cache.write(9);
            cache.write(this.codingPos == Integer.MAX_VALUE ? UNKNOWN_FLAG : (this.startCodon ? CMPL_FLAG : INCMPL_FLAG));
            cache.write(9);
            cache.write(this.codingEnd == Integer.MIN_VALUE ? UNKNOWN_FLAG : (this.endCodon ? CMPL_FLAG : INCMPL_FLAG));
            cache.write(9);
            this.writeMultiInt(cache, this.exonStartPos.size());
            cache.write(9);
            cache.write((byte)10);
        }

        void writeMultiInt(ByteStream cache, IntList list) {
            if (list.isEmpty()) {
                throw new UnsupportedOperationException("No exons.");
            }
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                cache.write(ASCIIUtility.toASCII(list.fastGet(i)));
                cache.write((byte)44);
            }
        }

        void writeMultiInt(ByteStream cache, int size) {
            for (int i = 0; i < size; ++i) {
                cache.write((byte)46);
                cache.write((byte)44);
            }
        }

        public void clear() {
            this.codingPos = Integer.MAX_VALUE;
            this.codingEnd = Integer.MIN_VALUE;
            this.exonStartPos.clear();
            this.exonEndPos.clear();
        }

        public KggSeqTranscriptRecord retainContigAndGene() {
            return new KggSeqTranscriptRecord().indexOfContig(this.indexOfContig).setContigName(this.contigName).setGeneName(this.geneName);
        }

        public KggSeqTranscriptRecord indexOfContig(int indexOfContig) {
            this.indexOfContig = indexOfContig;
            return this;
        }

        @Override
        public int compareTo(KggSeqTranscriptRecord o) {
            int status = Integer.compare(this.indexOfContig, o.indexOfContig);
            if (status == 0 && (status = Integer.compare(this.pos, o.pos)) == 0 && (status = Integer.compare(this.end, o.end)) == 0) {
                status = Integer.compare(this.exonStartPos.fastGet(0), o.exonStartPos.fastGet(0));
            }
            return status;
        }

        public KggSeqTranscriptRecord startCodon(boolean startCodon) {
            this.startCodon = startCodon;
            return this;
        }

        public KggSeqTranscriptRecord endCodon(boolean endCodon) {
            this.endCodon = endCodon;
            return this;
        }
    }
}

