/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.bytecode;

import edu.sysu.pmglab.container.array.EmptyArray;
import edu.sysu.pmglab.gtb.genome.genotype.Genotype;
import edu.sysu.pmglab.gtb.genome.genotype.GenotypeCodingException;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.DecimalFormat;

public class ASCIIUtility {
    static final long[] INT_SIZE_TABLE = new long[]{9L, 99L, 999L, 9999L, 99999L, 999999L, 9999999L, 99999999L, 999999999L, 9999999999L, 99999999999L, 999999999999L, 9999999999999L, 99999999999999L, 999999999999999L, 9999999999999999L, 99999999999999999L, 999999999999999999L, Long.MAX_VALUE};
    private static final ThreadLocal<DecimalFormat> REGULAR_DECIMAL_FORMATTERS = ThreadLocal.withInitial(() -> new DecimalFormat("#.####"));
    private static final ThreadLocal<DecimalFormat> SCIENTIFIC_DECIMAL_FORMATTERS = ThreadLocal.withInitial(() -> new DecimalFormat("#.###E0"));
    private static final long MAX_VALUE_DIV_10 = 0xCCCCCCCCCCCCCCCL;
    private static final long MAX_VALUE_MOD_10 = 7L;
    private static final long MIN_VALUE_DIV_10 = -922337203685477580L;
    private static final long MIN_VALUE_MOD_10 = 8L;
    private static final int MAX_LONG_LENGTH = 19;
    private static final int MIN_LONG_LENGTH = 20;
    private static final byte[] DigitTens = new byte[]{48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 49, 49, 49, 49, 49, 49, 49, 49, 49, 49, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 52, 52, 52, 52, 52, 52, 52, 52, 52, 52, 53, 53, 53, 53, 53, 53, 53, 53, 53, 53, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 55, 55, 55, 55, 55, 55, 55, 55, 55, 55, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57};
    private static final byte[] DigitOnes = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57};
    private static final byte[] INT_TO_ASCII = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57};

    private ASCIIUtility() {
        throw new UnsupportedOperationException("Cannot instantiate utility class");
    }

    public static DecimalFormat getDecimalFormatter(double value) {
        if (Math.abs(value) < 1.0E-4 || Math.abs(value) > 10000.0) {
            return SCIENTIFIC_DECIMAL_FORMATTERS.get();
        }
        return REGULAR_DECIMAL_FORMATTERS.get();
    }

    public static boolean toBoolean(byte[] bytes) {
        return ASCIIUtility.toBoolean(bytes, 0, bytes.length);
    }

    public static boolean toBoolean(byte[] bytes, int offset, int length) {
        if (length == 0) {
            return false;
        }
        if (length == 1) {
            byte b = bytes[offset];
            if (b == 70 || b == 102 || b == 48 || b == 78 || b == 110) {
                return false;
            }
            if (b == 84 || b == 116 || b == 49 || b == 89 || b == 121) {
                return true;
            }
        } else if (length == 4) {
            if (!(bytes[offset] != 116 && bytes[offset] != 84 || bytes[offset + 1] != 114 && bytes[offset + 1] != 82 || bytes[offset + 2] != 117 && bytes[offset + 2] != 85 || bytes[offset + 3] != 101 && bytes[offset + 3] != 69)) {
                return true;
            }
        } else if (!(length != 5 || bytes[offset] != 102 && bytes[offset] != 70 || bytes[offset + 1] != 97 && bytes[offset + 1] != 65 || bytes[offset + 2] != 108 && bytes[offset + 2] != 76 || bytes[offset + 3] != 115 && bytes[offset + 3] != 83 || bytes[offset + 4] != 101 && bytes[offset + 4] != 69)) {
            return false;
        }
        throw new NumberFormatException("Failed to convert '" + new String(bytes, offset, length) + "' to a boolean value");
    }

    public static byte toByte(byte[] bytes) {
        return ASCIIUtility.toByte(bytes, 0, bytes.length);
    }

    public static byte toByte(byte[] bytes, int offset, int length) {
        byte returns;
        long value = ASCIIUtility.toLong(bytes, offset, length);
        if (value != (long)(returns = (byte)value)) {
            throw new NumberFormatException("Failed to convert '" + new String(bytes, offset, length) + "' to a byte value: value overflow");
        }
        return returns;
    }

    public static short toShort(byte[] bytes) {
        return ASCIIUtility.toShort(bytes, 0, bytes.length);
    }

    public static short toShort(byte[] bytes, int offset, int length) {
        short returns;
        long value = ASCIIUtility.toLong(bytes, offset, length);
        if (value != (long)(returns = (short)value)) {
            throw new NumberFormatException("Failed to convert '" + new String(bytes, offset, length) + "' to a short value: value overflow");
        }
        return returns;
    }

    public static int toInt(byte[] bytes) {
        return ASCIIUtility.toInt(bytes, 0, bytes.length);
    }

    public static int toInt(byte[] bytes, int offset, int length) {
        int returns;
        long value = ASCIIUtility.toLong(bytes, offset, length);
        if (value != (long)(returns = (int)value)) {
            throw new NumberFormatException("Failed to convert '" + new String(bytes, offset, length) + "' to a integer value: value overflow");
        }
        return returns;
    }

    public static long toLong(byte[] bytes) {
        return ASCIIUtility.toLong(bytes, 0, bytes.length);
    }

    public static long toLong(byte[] bytes, int offset, int length) {
        if (length == 0) {
            return 0L;
        }
        if (length == 1) {
            byte c = bytes[offset];
            if (c >= 48 && c <= 57) {
                return c & 0xF;
            }
            if (c == 43 || c == 45 || c == 46 || c == 42) {
                return 0L;
            }
            throw new NumberFormatException("Failed to convert '" + new String(bytes, offset, length) + "' to a integer value: invalid character");
        }
        if (length > 20) {
            throw new NumberFormatException("Failed to convert '" + new String(bytes, offset, length) + "' to a integer value: overflow");
        }
        long value = 0L;
        int start = offset;
        int end = offset + length;
        boolean negative = false;
        if (bytes[start] == 45) {
            negative = true;
            ++start;
        } else if (bytes[start] == 43) {
            ++start;
        }
        if (length < 19) {
            for (int i = start; i < end; ++i) {
                byte c = bytes[i];
                if (c < 48 || c > 57) {
                    throw new NumberFormatException("Failed to convert '" + new String(bytes, offset, length) + "' to a integer value: invalid character");
                }
                value = value * 10L + (long)(c & 0xF);
            }
            return negative ? -value : value;
        }
        if (length == 19 && !negative) {
            for (int i = start; i < end; ++i) {
                byte c = bytes[i];
                if (c >= 48 && c <= 57) {
                    if (value > 0xCCCCCCCCCCCCCCCL || value == 0xCCCCCCCCCCCCCCCL && (long)(c & 0xF) > 7L) {
                        throw new NumberFormatException("Failed to convert '" + new String(bytes, offset, length) + "' to a integer value: overflow");
                    }
                } else {
                    throw new NumberFormatException("Failed to convert '" + new String(bytes, offset, length) + "' to a integer value: invalid character");
                }
                value = value * 10L + (long)(c & 0xF);
            }
            return value;
        }
        if (length == 20 && negative) {
            for (int i = start; i < end; ++i) {
                byte c = bytes[i];
                if (c >= 48 && c <= 57) {
                    if (value < -922337203685477580L || value == -922337203685477580L && (long)(c & 0xF) > 8L) {
                        throw new NumberFormatException("Failed to convert '" + new String(bytes, offset, length) + "' to a integer value: overflow");
                    }
                } else {
                    throw new NumberFormatException("Failed to convert '" + new String(bytes, offset, length) + "' to a integer value: invalid character");
                }
                value = value * 10L - (long)(c & 0xF);
            }
            return value;
        }
        throw new NumberFormatException("Failed to convert '" + new String(bytes, offset, length) + "' to a integer value: invalid length");
    }

    public static float toFloat(byte[] bytes) {
        return ASCIIUtility.toFloat(bytes, 0, bytes.length);
    }

    public static double toDouble(byte[] bytes) {
        return ASCIIUtility.toDouble(bytes, 0, bytes.length);
    }

    public static float toFloat(byte[] bytes, int offset, int length) {
        return (float)ASCIIUtility.toDouble(bytes, offset, length);
    }

    public static double toDouble(byte[] bytes, int offset, int length) {
        if (length == 0) {
            return Double.NaN;
        }
        if (length == 1) {
            byte c = bytes[offset];
            if (c >= 48 && c <= 57) {
                return c & 0xF;
            }
            if (c == 43 || c == 45 || c == 46 || c == 42 || c == 100 || c == 68 || c == 102 || c == 70) {
                return Double.NaN;
            }
            throw new NumberFormatException("Failed to convert '" + new String(bytes, offset, length) + "' to a integer value: invalid character");
        }
        if (length == 2) {
            if (!(bytes[offset] != 110 && bytes[offset] != 78 || bytes[offset + 1] != 97 && bytes[offset + 1] != 65)) {
                return Double.NaN;
            }
        } else if (length == 3) {
            if (!(bytes[offset] != 110 && bytes[offset] != 78 || bytes[offset + 1] != 97 && bytes[offset + 1] != 65 || bytes[offset + 2] != 110 && bytes[offset + 2] != 78)) {
                return Double.NaN;
            }
            if (!(bytes[offset] != 105 && bytes[offset] != 73 || bytes[offset + 1] != 110 && bytes[offset + 1] != 78 || bytes[offset + 2] != 102 && bytes[offset + 2] != 70)) {
                return Double.POSITIVE_INFINITY;
            }
        } else if (length == 4) {
            if (!(bytes[offset] != 45 || bytes[offset + 1] != 105 && bytes[offset + 1] != 73 || bytes[offset + 2] != 110 && bytes[offset + 2] != 78 || bytes[offset + 3] != 102 && bytes[offset + 3] != 70)) {
                return Double.NEGATIVE_INFINITY;
            }
        } else if (length == 8) {
            if (!(bytes[offset] != 73 && bytes[offset] != 105 || bytes[offset + 1] != 78 && bytes[offset + 1] != 110 || bytes[offset + 2] != 70 && bytes[offset + 2] != 102 || bytes[offset + 3] != 73 && bytes[offset + 3] != 105 || bytes[offset + 4] != 78 && bytes[offset + 4] != 110 || bytes[offset + 5] != 73 && bytes[offset + 5] != 105 || bytes[offset + 6] != 84 && bytes[offset + 6] != 116 || bytes[offset + 7] != 89 && bytes[offset + 7] != 121)) {
                return Double.POSITIVE_INFINITY;
            }
        } else if (!(length != 9 || bytes[offset] != 45 || bytes[offset + 1] != 73 && bytes[offset + 1] != 105 || bytes[offset + 2] != 78 && bytes[offset + 2] != 110 || bytes[offset + 3] != 70 && bytes[offset + 3] != 102 || bytes[offset + 4] != 73 && bytes[offset + 4] != 105 || bytes[offset + 5] != 78 && bytes[offset + 5] != 110 || bytes[offset + 6] != 73 && bytes[offset + 6] != 105 || bytes[offset + 7] != 84 && bytes[offset + 7] != 116 || bytes[offset + 8] != 89 && bytes[offset + 8] != 121)) {
            return Double.NEGATIVE_INFINITY;
        }
        int start = offset;
        int end = offset + length;
        boolean negative = false;
        if (bytes[start] == 45) {
            negative = true;
            ++start;
        } else if (bytes[start] == 43) {
            ++start;
        }
        double value = 0.0;
        boolean hasDot = false;
        double decimalPlace = 0.1;
        while (start < end) {
            byte c = bytes[start];
            if (c == 46) {
                if (hasDot) {
                    throw new NumberFormatException("Invalid format: multiple dots");
                }
                hasDot = true;
            } else if (c >= 48 && c <= 57) {
                if (hasDot) {
                    value += (double)(c & 0xF) * decimalPlace;
                    decimalPlace /= 10.0;
                } else {
                    value = value * 10.0 + (double)(c & 0xF);
                }
            } else {
                if (c == 101 || c == 69) {
                    try {
                        return Double.parseDouble(new String(bytes, offset, length));
                    }
                    catch (NumberFormatException e) {
                        throw new NumberFormatException("Failed to convert '" + new String(bytes, offset, length) + "' to a double value: invalid character");
                    }
                }
                throw new NumberFormatException("Failed to convert '" + new String(bytes, offset, length) + "' to a double value: invalid character");
            }
            ++start;
        }
        return negative ? -value : value;
    }

    public static BigInteger toBigInteger(byte[] bytes, int offset, int length) {
        return new BigInteger(new String(bytes, offset, length));
    }

    public static Genotype toDiploidGenotype(byte[] bytes, int offset, int length) {
        if (length == 0) {
            return Genotype.MISSING;
        }
        if (length == 1) {
            byte b = bytes[offset];
            if (b == 46) {
                return Genotype.MISSING;
            }
            if (b >= 48 && b <= 57) {
                int code = b & 0xF;
                return Genotype.of(code, code);
            }
        } else if (length == 2) {
            byte b1 = bytes[offset];
            byte b2 = bytes[offset + 1];
            if (b1 >= 48 && b1 <= 57 && b2 >= 48 && b2 <= 57) {
                int code = (b1 & 0xF) * 10 + (b2 & 0xF);
                return Genotype.of(code, code);
            }
        } else if (length == 3) {
            byte b1 = bytes[offset];
            byte b2 = bytes[offset + 1];
            byte b3 = bytes[offset + 2];
            if (b2 == 124 || b2 == 47) {
                int left = -2;
                int right = -2;
                if (b1 == 46) {
                    left = -1;
                } else if (b1 >= 48 && b1 <= 57) {
                    left = b1 & 0xF;
                }
                if (b3 == 46) {
                    right = -1;
                } else if (b3 >= 48 && b3 <= 57) {
                    right = b3 & 0xF;
                }
                if (left != -2 && right != -2) {
                    return Genotype.of(left, right);
                }
            } else if (b1 >= 48 && b1 <= 57 && b2 >= 48 && b2 <= 57 && b3 >= 48 && b3 <= 57) {
                int code = (b1 & 0xF) * 100 + (b2 & 0xF) * 10 + (b3 & 0xF);
                return Genotype.of(code, code);
            }
        } else if (length == 4) {
            byte b1 = bytes[offset];
            byte b2 = bytes[offset + 1];
            byte b3 = bytes[offset + 2];
            byte b4 = bytes[offset + 3];
            if (b2 == 124 || b2 == 47) {
                int left = -2;
                int right = -2;
                if (b1 == 46) {
                    left = -1;
                } else if (b1 >= 48 && b1 <= 57) {
                    left = b1 & 0xF;
                }
                if (b3 >= 48 && b3 <= 57 && b4 >= 48 && b4 <= 57) {
                    right = (b3 & 0xF) * 10 + (b4 & 0xF);
                }
                if (left != -2 && right != -2) {
                    return Genotype.of(left, right);
                }
            } else if (b3 == 124 || b3 == 47) {
                int left = -2;
                int right = -2;
                if (b1 >= 48 && b1 <= 57 && b2 >= 48 && b2 <= 57) {
                    left = (b1 & 0xF) * 10 + (b2 & 0xF);
                }
                if (b4 == 46) {
                    right = -1;
                } else if (b4 >= 48 && b4 <= 57) {
                    right = b4 & 0xF;
                }
                if (left != -2 && right != -2) {
                    return Genotype.of(left, right);
                }
            } else if (b1 >= 48 && b1 <= 57 && b2 >= 48 && b2 <= 57 && b3 >= 48 && b3 <= 57 && b4 >= 48 && b4 <= 57) {
                int code = (b1 & 0xF) * 1000 + (b2 & 0xF) * 100 + (b3 & 0xF) * 10 + (b4 & 0xF);
                return Genotype.of(code, code);
            }
        } else if (length == 5) {
            byte b1 = bytes[offset];
            byte b2 = bytes[offset + 1];
            byte b3 = bytes[offset + 2];
            byte b4 = bytes[offset + 3];
            byte b5 = bytes[offset + 4];
            if (b2 == 124 || b2 == 47) {
                int left = -2;
                int right = -2;
                if (b1 == 46) {
                    left = -1;
                } else if (b1 >= 48 && b1 <= 57) {
                    left = b1 & 0xF;
                }
                if (b3 >= 48 && b3 <= 57 && b4 >= 48 && b4 <= 57 && b5 >= 48 && b5 <= 57) {
                    right = (b3 & 0xF) * 100 + (b4 & 0xF) * 10 + (b5 & 0xF);
                }
                if (left != -2 && right != -2) {
                    return Genotype.of(left, right);
                }
            } else if (b3 == 124 || b3 == 47) {
                int left = -2;
                int right = -2;
                if (b1 >= 48 && b1 <= 57 && b2 >= 48 && b2 <= 57) {
                    left = (b1 & 0xF) * 10 + (b2 & 0xF);
                }
                if (b4 >= 48 && b4 <= 57 && b5 >= 48 && b5 <= 57) {
                    right = (b4 & 0xF) * 10 + (b5 & 0xF);
                }
                if (left != -2 && right != -2) {
                    return Genotype.of(left, right);
                }
            } else if (b4 == 124 || b4 == 47) {
                int left = -2;
                int right = -2;
                if (b1 >= 48 && b1 <= 57 && b2 >= 48 && b2 <= 57 && b3 >= 48 && b3 <= 57) {
                    left = (b1 & 0xF) * 100 + (b2 & 0xF) * 10 + (b3 & 0xF);
                }
                if (b5 == 46) {
                    right = -1;
                } else if (b5 >= 48 && b5 <= 57) {
                    right = b5 & 0xF;
                }
                if (left != -2 && right != -2) {
                    return Genotype.of(left, right);
                }
            }
        } else {
            for (int i = 1; i < length - 1; ++i) {
                if (bytes[offset + i] != 124 && bytes[offset + i] != 47) continue;
                return Genotype.of(ASCIIUtility.toHaploidGenotype(bytes, offset, i), ASCIIUtility.toHaploidGenotype(bytes, offset + i + 1, length - i - 1));
            }
            int c = ASCIIUtility.toHaploidGenotype(bytes, offset, length);
            return Genotype.of(c, c);
        }
        throw new GenotypeCodingException("Unable to convert " + new String(bytes, offset, length) + " as a genotype object");
    }

    public static int toHaploidGenotype(byte[] bytes, int offset, int length) {
        if (length == 1) {
            byte b = bytes[offset];
            if (b == 46) {
                return -1;
            }
            if (b >= 48 && b <= 57) {
                return b & 0xF;
            }
        } else if (length == 2) {
            byte b1 = bytes[offset];
            byte b2 = bytes[offset + 1];
            if (b1 >= 48 && b1 <= 57 && b2 >= 48 && b2 <= 57) {
                return (b1 & 0xF) * 10 + (b2 & 0xF);
            }
        } else if (length == 3) {
            byte b1 = bytes[offset];
            byte b2 = bytes[offset + 1];
            byte b3 = bytes[offset + 2];
            if (b1 >= 48 && b1 <= 57 && b2 >= 48 && b2 <= 57 && b3 >= 48 && b3 <= 57) {
                return (b1 & 0xF) * 100 + (b2 & 0xF) * 10 + (b3 & 0xF);
            }
        } else if (length == 4) {
            byte b1 = bytes[offset];
            byte b2 = bytes[offset + 1];
            byte b3 = bytes[offset + 2];
            byte b4 = bytes[offset + 3];
            if (b1 >= 48 && b1 <= 57 && b2 >= 48 && b2 <= 57 && b3 >= 48 && b3 <= 57 && b4 >= 48 && b4 <= 57) {
                int code = (b1 & 0xF) * 1000 + (b2 & 0xF) * 100 + (b3 & 0xF) * 10 + (b4 & 0xF);
                if (code >= 4095) {
                    throw new GenotypeCodingException("Invalid genotype: index of allele exceed the maximum SWI coding limit of 4094 (<= 4094)");
                }
                return code;
            }
        } else {
            throw new GenotypeCodingException("Invalid genotype: index of allele exceed the maximum SWI coding limit of 4094 (<= 4094)");
        }
        throw new GenotypeCodingException("Unable to convert " + new String(bytes, offset, length) + " as a genotype object");
    }

    public static byte[] toASCII(double value) {
        if (value == Double.POSITIVE_INFINITY) {
            return new byte[]{73, 110, 102, 105, 110, 105, 116, 121};
        }
        if (value == Double.NEGATIVE_INFINITY) {
            return new byte[]{45, 73, 110, 102, 105, 110, 105, 116, 121};
        }
        if (Double.isNaN(value)) {
            return new byte[]{78, 97, 78};
        }
        long longValue = (long)value;
        if ((double)longValue == value) {
            return ASCIIUtility.toASCII(longValue);
        }
        if (Math.abs(value) < 1.0E-4 || Math.abs(value) > 10000.0) {
            return ASCIIUtility.toASCII(SCIENTIFIC_DECIMAL_FORMATTERS.get().format(value), StandardCharsets.US_ASCII);
        }
        return ASCIIUtility.toASCII(REGULAR_DECIMAL_FORMATTERS.get().format(value), StandardCharsets.US_ASCII);
    }

    public static int toASCII(double value, byte[] cache, int off) {
        if (value == Double.POSITIVE_INFINITY) {
            cache[off] = 73;
            cache[off + 1] = 110;
            cache[off + 2] = 102;
            cache[off + 3] = 105;
            cache[off + 4] = 110;
            cache[off + 5] = 105;
            cache[off + 6] = 116;
            cache[off + 7] = 121;
            return 8;
        }
        if (value == Double.NEGATIVE_INFINITY) {
            cache[off] = 45;
            cache[off + 1] = 73;
            cache[off + 2] = 110;
            cache[off + 3] = 102;
            cache[off + 4] = 105;
            cache[off + 5] = 110;
            cache[off + 6] = 105;
            cache[off + 7] = 116;
            cache[off + 8] = 121;
            return 9;
        }
        if (Double.isNaN(value)) {
            cache[off] = 78;
            cache[off + 1] = 97;
            cache[off + 2] = 78;
            return 3;
        }
        long longValue = (long)value;
        if ((double)longValue == value) {
            return ASCIIUtility.toASCII(longValue, cache, off);
        }
        if (Math.abs(value) < 1.0E-4 || Math.abs(value) > 10000.0) {
            return ASCIIUtility.toASCII(SCIENTIFIC_DECIMAL_FORMATTERS.get().format(value), StandardCharsets.US_ASCII, cache, off);
        }
        return ASCIIUtility.toASCII(REGULAR_DECIMAL_FORMATTERS.get().format(value), StandardCharsets.US_ASCII, cache, off);
    }

    public static byte[] toASCII(int value) {
        int r;
        int q;
        if (value >= 0 && value <= 9) {
            return new byte[]{INT_TO_ASCII[value]};
        }
        if (value == Integer.MIN_VALUE) {
            return new byte[]{45, 50, 49, 52, 55, 52, 56, 51, 54, 52, 56};
        }
        if (value == Integer.MAX_VALUE) {
            return new byte[]{50, 49, 52, 55, 52, 56, 51, 54, 52, 55};
        }
        byte[] cache = new byte[ASCIIUtility.decimalStringLength(value)];
        int i = value;
        int charPos = cache.length;
        int sign = 0;
        if (i < 0) {
            sign = 45;
            i = -i;
        }
        while (i >= 65536) {
            q = i / 100;
            r = i - ((q << 6) + (q << 5) + (q << 2));
            i = q;
            cache[--charPos] = DigitOnes[r];
            cache[--charPos] = DigitTens[r];
        }
        do {
            q = i * 52429 >>> 19;
            r = i - ((q << 3) + (q << 1));
            cache[--charPos] = INT_TO_ASCII[r];
        } while ((i = q) != 0);
        if (sign != 0) {
            cache[--charPos] = sign;
        }
        return cache;
    }

    public static byte[] toASCII(long value) {
        int q2;
        int r;
        if (value >= 0L && value <= 9L) {
            return new byte[]{INT_TO_ASCII[(int)value]};
        }
        if (value == Long.MIN_VALUE) {
            return new byte[]{45, 57, 50, 50, 51, 51, 55, 50, 48, 51, 54, 56, 53, 52, 55, 55, 53, 56, 48, 56};
        }
        if (value == Long.MAX_VALUE) {
            return new byte[]{57, 50, 50, 51, 51, 55, 50, 48, 51, 54, 56, 53, 52, 55, 55, 53, 56, 48, 55};
        }
        byte[] cache = new byte[ASCIIUtility.decimalStringLength(value)];
        int index = cache.length;
        long i = value;
        int charPos = index;
        int sign = 0;
        if (i < 0L) {
            sign = 45;
            i = -i;
        }
        while (i > Integer.MAX_VALUE) {
            long q = i / 100L;
            r = (int)(i - ((q << 6) + (q << 5) + (q << 2)));
            i = q;
            cache[--charPos] = DigitOnes[r];
            cache[--charPos] = DigitTens[r];
        }
        int i2 = (int)i;
        while (i2 >= 65536) {
            q2 = i2 / 100;
            r = i2 - ((q2 << 6) + (q2 << 5) + (q2 << 2));
            i2 = q2;
            cache[--charPos] = DigitOnes[r];
            cache[--charPos] = DigitTens[r];
        }
        do {
            q2 = i2 * 52429 >>> 19;
            r = i2 - ((q2 << 3) + (q2 << 1));
            cache[--charPos] = INT_TO_ASCII[r];
        } while ((i2 = q2) != 0);
        if (sign != 0) {
            cache[--charPos] = sign;
        }
        return cache;
    }

    public static int toASCII(int value, byte[] cache, int off) {
        int r;
        int q;
        if (value >= 0 && value <= 9) {
            cache[off] = INT_TO_ASCII[value];
            return 1;
        }
        if (value == Integer.MIN_VALUE) {
            cache[off++] = 45;
            cache[off++] = 50;
            cache[off++] = 49;
            cache[off++] = 52;
            cache[off++] = 55;
            cache[off++] = 52;
            cache[off++] = 56;
            cache[off++] = 51;
            cache[off++] = 54;
            cache[off++] = 52;
            cache[off++] = 56;
            return 11;
        }
        if (value == Integer.MAX_VALUE) {
            cache[off++] = 50;
            cache[off++] = 49;
            cache[off++] = 52;
            cache[off++] = 55;
            cache[off++] = 52;
            cache[off++] = 56;
            cache[off++] = 51;
            cache[off++] = 54;
            cache[off++] = 52;
            cache[off++] = 55;
            return 10;
        }
        int reqLength = ASCIIUtility.decimalStringLength(value);
        int i = value;
        int charPos = reqLength;
        int sign = 0;
        if (i < 0) {
            sign = 45;
            i = -i;
        }
        while (i >= 65536) {
            q = i / 100;
            r = i - ((q << 6) + (q << 5) + (q << 2));
            i = q;
            cache[off + --charPos] = DigitOnes[r];
            cache[off + --charPos] = DigitTens[r];
        }
        do {
            q = i * 52429 >>> 19;
            r = i - ((q << 3) + (q << 1));
            cache[off + --charPos] = INT_TO_ASCII[r];
        } while ((i = q) != 0);
        if (sign != 0) {
            cache[off + --charPos] = sign;
        }
        return reqLength;
    }

    public static int toASCII(long value, byte[] cache, int off) {
        int q2;
        int r;
        if (value >= 0L && value <= 9L) {
            cache[off] = INT_TO_ASCII[(int)value];
            return 1;
        }
        if (value == Long.MIN_VALUE) {
            cache[off++] = 45;
            cache[off++] = 57;
            cache[off++] = 50;
            cache[off++] = 50;
            cache[off++] = 51;
            cache[off++] = 51;
            cache[off++] = 55;
            cache[off++] = 50;
            cache[off++] = 48;
            cache[off++] = 51;
            cache[off++] = 54;
            cache[off++] = 56;
            cache[off++] = 53;
            cache[off++] = 52;
            cache[off++] = 55;
            cache[off++] = 55;
            cache[off++] = 53;
            cache[off++] = 56;
            cache[off++] = 48;
            cache[off++] = 56;
            return 20;
        }
        if (value == Long.MAX_VALUE) {
            cache[off++] = 57;
            cache[off++] = 50;
            cache[off++] = 50;
            cache[off++] = 51;
            cache[off++] = 51;
            cache[off++] = 55;
            cache[off++] = 50;
            cache[off++] = 48;
            cache[off++] = 51;
            cache[off++] = 54;
            cache[off++] = 56;
            cache[off++] = 53;
            cache[off++] = 52;
            cache[off++] = 55;
            cache[off++] = 55;
            cache[off++] = 53;
            cache[off++] = 56;
            cache[off++] = 48;
            cache[off++] = 55;
            return 19;
        }
        int reqLength = ASCIIUtility.decimalStringLength(value);
        long i = value;
        int charPos = reqLength;
        int sign = 0;
        if (i < 0L) {
            sign = 45;
            i = -i;
        }
        while (i > Integer.MAX_VALUE) {
            long q = i / 100L;
            r = (int)(i - ((q << 6) + (q << 5) + (q << 2)));
            i = q;
            cache[off + --charPos] = DigitOnes[r];
            cache[off + --charPos] = DigitTens[r];
        }
        int i2 = (int)i;
        while (i2 >= 65536) {
            q2 = i2 / 100;
            r = i2 - ((q2 << 6) + (q2 << 5) + (q2 << 2));
            i2 = q2;
            cache[off + --charPos] = DigitOnes[r];
            cache[off + --charPos] = DigitTens[r];
        }
        do {
            q2 = i2 * 52429 >>> 19;
            r = i2 - ((q2 << 3) + (q2 << 1));
            cache[off + --charPos] = INT_TO_ASCII[r];
        } while ((i2 = q2) != 0);
        if (sign != 0) {
            cache[off + --charPos] = sign;
        }
        return reqLength;
    }

    public static byte[] toASCII(String string, Charset charset) {
        int srcLen = string.length();
        if (srcLen == 0) {
            return EmptyArray.BYTE;
        }
        byte[] result = new byte[srcLen];
        for (int i = 0; i < srcLen; ++i) {
            if (string.charAt(i) > '\u007f') {
                return string.getBytes(charset);
            }
            result[i] = (byte)string.charAt(i);
        }
        return result;
    }

    public static int toASCII(String string, Charset charset, byte[] cache, int off) {
        int markOff = off;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c > '\u007f') {
                byte[] bs = string.getBytes(charset);
                System.arraycopy(bs, 0, cache, markOff, bs.length);
                return bs.length;
            }
            cache[off++] = (byte)c;
        }
        return off - markOff;
    }

    static int decimalStringLength(long intValue) {
        if (intValue == 0L) {
            return 1;
        }
        if (intValue == Long.MIN_VALUE) {
            return 20;
        }
        if (intValue < 0L) {
            intValue = -intValue;
            int i = 0;
            while (true) {
                if (intValue <= INT_SIZE_TABLE[i]) {
                    return i + 2;
                }
                ++i;
            }
        }
        int i = 0;
        while (intValue > INT_SIZE_TABLE[i]) {
            ++i;
        }
        return i + 1;
    }
}

