/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.bytecode;

import edu.sysu.pmglab.bytecode.ASCIIUtility;
import edu.sysu.pmglab.bytecode.Bytes;
import edu.sysu.pmglab.bytecode.VarIntCodec;
import edu.sysu.pmglab.container.array.EmptyArray;
import edu.sysu.pmglab.utils.Assert;
import edu.sysu.pmglab.utils.ValueUtils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.DecimalFormat;

public final class ByteStream {
    public static final ByteStream EMPTY = new ByteStream(0, false);
    private static final ThreadLocal<ByteStream> POOL = ThreadLocal.withInitial(() -> new ByteStream(8192));
    private final boolean extensible;
    private byte[] bytes;
    private int offset;
    private int rp = 0;
    private int wp = 0;

    public ByteStream() {
        this(0, true);
    }

    public ByteStream(boolean extensible) {
        this(0, extensible);
    }

    public ByteStream(int initsize) {
        this(initsize, true);
    }

    public ByteStream(int initsize, boolean extensible) {
        this.bytes = initsize == 0 ? EmptyArray.BYTE : new byte[initsize];
        this.extensible = extensible;
    }

    public ByteStream(byte[] bytes, int off, int len) {
        this(bytes, off, len, true);
    }

    public ByteStream(byte[] bytes, int off, int len, boolean extensible) {
        Assert.checkByteArrayBounds(bytes, off, len);
        this.bytes = bytes;
        this.offset = off;
        this.wp = len;
        this.rp = 0;
        this.extensible = extensible;
    }

    public static ByteStream getThreadInstance() {
        return POOL.get().clear();
    }

    public byte[] bytes() {
        return this.bytes;
    }

    public int offset() {
        return this.offset;
    }

    public int start() {
        return this.offset;
    }

    public int length() {
        return this.wp;
    }

    public int end() {
        return this.offset + this.wp;
    }

    public int rRemaining() {
        int off = this.wp - this.rp;
        if (off >= 0) {
            return off;
        }
        this.rp = this.wp;
        return 0;
    }

    public int wRemaining() {
        return this.bytes.length - this.wp - this.offset;
    }

    public int rTell() {
        return this.rp;
    }

    public int wTell() {
        return this.wp;
    }

    public int capacity() {
        return this.bytes.length;
    }

    public void rSeek(int pos) {
        this.rp = pos < 0 ? 0 : (pos > this.wp ? this.wp : pos);
    }

    public void rSkip(int numOfBytes) {
        if (numOfBytes <= 0) {
            return;
        }
        this.rSeek(this.rp + numOfBytes);
    }

    public void wSkip(int numOfBytes) {
        if (numOfBytes <= 0) {
            return;
        }
        this.wRequire(numOfBytes);
        this.wp += numOfBytes;
    }

    public void wSeek(int pos) {
        if (pos <= 0) {
            this.wp = 0;
        } else {
            this.wRequire(pos - this.wp);
            this.wp = pos;
        }
        if (this.rp > this.wp) {
            this.rp = this.wp;
        }
    }

    public Bytes toBytes() {
        return new Bytes(this.bytes, this.offset, this.wp, false, false);
    }

    public Bytes toBytes(boolean detach) {
        if (detach && this.wp == 0) {
            return Bytes.EMPTY;
        }
        return new Bytes(this.bytes, this.offset, this.wp, detach, false);
    }

    public Bytes toBytes(Bytes wrapper) {
        if (wrapper == null) {
            return this.toBytes();
        }
        return this.toBytes(wrapper, false);
    }

    public Bytes toBytes(Bytes wrapper, boolean detach) {
        if (wrapper == null) {
            return this.toBytes(detach);
        }
        return wrapper.reset(this.bytes, this.offset, this.wp, detach);
    }

    public int read() {
        if (this.rp >= this.wp) {
            this.rp = this.wp;
            return -1;
        }
        return this.bytes[this.offset + this.rp++] & 0xFF;
    }

    public int read(byte[] dst) {
        return this.read(dst, 0, dst.length);
    }

    public int read(byte[] dst, int off, int len) {
        if (len == 0) {
            return 0;
        }
        if (len < 0) {
            throw new IllegalArgumentException(String.valueOf(len));
        }
        int byteToWrite = Math.min(len, this.rRemaining());
        if (byteToWrite == 0) {
            return -1;
        }
        System.arraycopy(this.bytes, this.offset + this.rp, dst, off, byteToWrite);
        this.rp += byteToWrite;
        return byteToWrite;
    }

    public byte[] read(int n) {
        if (n == 0) {
            return EmptyArray.BYTE;
        }
        if (n < 0) {
            throw new IllegalArgumentException(String.valueOf(n));
        }
        int byteToWrite = Math.min(n, this.rRemaining());
        if (byteToWrite == 0) {
            return EmptyArray.BYTE;
        }
        byte[] out = new byte[byteToWrite];
        System.arraycopy(this.bytes, this.offset + this.rp, out, 0, byteToWrite);
        this.rp += byteToWrite;
        return out;
    }

    public boolean readUntil(ByteStream output, byte until, boolean containsUntil) {
        if (this.rRemaining() == 0) {
            return false;
        }
        int j = -1;
        for (int i = this.rp; i < this.wp; ++i) {
            if (this.bytes[this.offset + i] != until) continue;
            j = i;
            break;
        }
        if (j == -1) {
            output.write(this.bytes, this.offset + this.rp, this.wp - this.rp);
            this.rp = this.wp;
            return false;
        }
        if (containsUntil) {
            output.write(this.bytes, this.offset + this.rp, j - this.rp + 1);
        } else {
            output.write(this.bytes, this.offset + this.rp, j - this.rp);
        }
        this.rp = j + 1;
        return true;
    }

    public int find(byte until) {
        for (int i = this.rp; i < this.wp; ++i) {
            if (this.bytes[this.offset + i] != until) continue;
            return i - this.rp;
        }
        return -1;
    }

    public int getVarInt32() {
        long value = this.getVarInt64();
        if (value >= Integer.MIN_VALUE && value <= Integer.MAX_VALUE) {
            return (int)value;
        }
        throw new NumberFormatException("Failed to convert '" + this + "' to a varInt32 value: value overflow");
    }

    public long getVarInt64() {
        this.rRequire(1);
        int len = VarIntCodec.getDecodedLength(this.bytes[this.offset + this.rp]);
        this.rRequire(len);
        long value = VarIntCodec.decode0(this.bytes, this.offset + this.rp, len);
        this.rp += len;
        return value;
    }

    public boolean getBoolean() {
        this.rRequire(1);
        int byteValue = this.read();
        if (byteValue == 0) {
            return false;
        }
        if (byteValue == 1) {
            return true;
        }
        throw new NumberFormatException("Failed to convert '" + byteValue + "' to a boolean value");
    }

    public byte getByte() {
        this.rRequire(1);
        return this.bytes[this.offset + this.rp++];
    }

    public short getShort() {
        this.rRequire(2);
        try {
            short s = (short)(this.bytes[this.offset + this.rp] & 0xFF | (this.bytes[this.offset + this.rp + 1] & 0xFF) << 8);
            return s;
        }
        finally {
            this.rp += 2;
        }
    }

    public int getInt() {
        this.rRequire(4);
        try {
            int n = this.bytes[this.offset + this.rp] & 0xFF | (this.bytes[this.offset + this.rp + 1] & 0xFF) << 8 | (this.bytes[this.offset + this.rp + 2] & 0xFF) << 16 | (this.bytes[this.offset + this.rp + 3] & 0xFF) << 24;
            return n;
        }
        finally {
            this.rp += 4;
        }
    }

    public long getLong() {
        this.rRequire(8);
        try {
            long l = (long)this.bytes[this.offset + this.rp] & 0xFFL | ((long)this.bytes[this.offset + this.rp + 1] & 0xFFL) << 8 | ((long)this.bytes[this.offset + this.rp + 2] & 0xFFL) << 16 | ((long)this.bytes[this.offset + this.rp + 3] & 0xFFL) << 24 | ((long)this.bytes[this.offset + this.rp + 4] & 0xFFL) << 32 | ((long)this.bytes[this.offset + this.rp + 5] & 0xFFL) << 40 | ((long)this.bytes[this.offset + this.rp + 6] & 0xFFL) << 48 | ((long)this.bytes[this.offset + this.rp + 7] & 0xFFL) << 56;
            return l;
        }
        finally {
            this.rp += 8;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLong(int len) {
        if (len < 0) {
            throw new IllegalArgumentException(String.valueOf(len));
        }
        if (len == 0) {
            return 0L;
        }
        this.rRequire(len);
        boolean negative = ((this.bytes[this.offset + this.rp + len - 1] & 0xFF) >> 7 & 1) == 1;
        long value = 0L;
        for (int i = 0; i < len - 1; ++i) {
            value |= ((long)this.bytes[this.offset + this.rp + i] & 0xFFL) << (i << 3);
        }
        value |= ((long)this.bytes[this.offset + this.rp + len - 1] & 0x7FL) << (len - 1 << 3);
        if (negative) {
            value = (value ^ 0xFFFFFFFFFFFFFFFFL) + 1L;
        }
        try {
            long l = value;
            return l;
        }
        finally {
            this.rp += len;
        }
    }

    public float getHalfFloat() {
        short shortBits = this.getShort();
        int mant = shortBits & 0x3FF;
        int exp = shortBits & 0x7C00;
        if (exp == 31744) {
            exp = 261120;
        } else if (exp != 0) {
            if (mant == 0 && (exp += 114688) > 115712) {
                return Float.intBitsToFloat((shortBits & 0x8000) << 16 | exp << 13 | 0x3FF);
            }
        } else if (mant != 0) {
            exp = 115712;
            do {
                exp -= 1024;
            } while (((mant <<= 1) & 0x400) == 0);
            mant &= 0x3FF;
        }
        return Float.intBitsToFloat((shortBits & 0x8000) << 16 | (exp | mant) << 13);
    }

    public float getFloat() {
        return Float.intBitsToFloat(this.getInt());
    }

    public double getDouble() {
        return Double.longBitsToDouble(this.getLong());
    }

    public String getString(int length) {
        return this.getString(length, StandardCharsets.UTF_8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getString(int len, Charset charset) {
        if (len == -1) {
            return null;
        }
        if (len == 0) {
            return "";
        }
        if (len < 0) {
            throw new IllegalArgumentException(String.valueOf(len));
        }
        this.rRequire(len);
        try {
            String string = new String(this.bytes, this.offset + this.rp, len, charset);
            return string;
        }
        finally {
            this.rp += len;
        }
    }

    public String getString() {
        return this.getString(StandardCharsets.UTF_8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getString(Charset charset) {
        int len = this.getVarInt32();
        if (len == -1) {
            return null;
        }
        if (len == 0) {
            return "";
        }
        if (len < 0) {
            throw new IllegalArgumentException(String.valueOf(len));
        }
        this.rRequire(len);
        try {
            String string = new String(this.bytes, this.offset + this.rp, len, charset);
            return string;
        }
        finally {
            this.rp += len;
        }
    }

    public void getBytes(Bytes wrapper, int len) {
        if (len == -1) {
            return;
        }
        if (len < 0) {
            throw new IllegalArgumentException(String.valueOf(len));
        }
        if (len == 0) {
            wrapper.reset();
            return;
        }
        this.rRequire(len);
        try {
            wrapper.reset(this.bytes, this.offset + this.rp, len, false);
        }
        finally {
            this.rp += len;
        }
    }

    public Bytes getBytes(int len) {
        if (len == -1) {
            return null;
        }
        if (len == 0) {
            return Bytes.EMPTY;
        }
        if (len < 0) {
            throw new IllegalArgumentException(String.valueOf(len));
        }
        this.rRequire(len);
        try {
            Bytes bytes = new Bytes(this.bytes, this.offset + this.rp, len, false, false);
            return bytes;
        }
        finally {
            this.rp += len;
        }
    }

    public Bytes getBytes() {
        int len = this.getVarInt32();
        if (len == -1) {
            return null;
        }
        if (len == 0) {
            return Bytes.EMPTY;
        }
        if (len < 0) {
            throw new IllegalArgumentException(String.valueOf(len));
        }
        this.rRequire(len);
        try {
            Bytes bytes = new Bytes(this.bytes, this.offset + this.rp, len, false, false);
            return bytes;
        }
        finally {
            this.rp += len;
        }
    }

    public int write(byte element) {
        this.wRequire(1);
        this.bytes[this.offset + this.wp++] = element;
        return 1;
    }

    public int write(int element) {
        this.wRequire(1);
        this.bytes[this.offset + this.wp++] = (byte)element;
        return 1;
    }

    public int write(byte[] src) {
        return this.write(src, 0, src.length);
    }

    public int write(Bytes bytes) {
        return this.write(bytes.bytes(), bytes.offset(), bytes.length());
    }

    public int write(byte[] src, int off, int len) {
        if (len == 0) {
            return 0;
        }
        if (len < 0) {
            throw new IllegalArgumentException(String.valueOf(len));
        }
        this.wRequire(len);
        if (len == 1) {
            this.bytes[this.offset + this.wp++] = src[off];
        } else {
            System.arraycopy(src, off, this.bytes, this.offset + this.wp, len);
            this.wp += len;
        }
        return len;
    }

    public int transferFrom(InputStream input, int len) throws IOException {
        int gets;
        if (len == 0) {
            return 0;
        }
        if (len < 0) {
            throw new IllegalArgumentException(String.valueOf(len));
        }
        this.wRequire(len);
        int total = 0;
        while (len > 0 && (gets = input.read(this.bytes, this.offset + this.wp, len)) != -1) {
            len -= gets;
            total += gets;
            this.wp += gets;
        }
        if (total == 0) {
            return -1;
        }
        return total;
    }

    public int writeChar(String src) {
        return this.writeChar(src, StandardCharsets.UTF_8);
    }

    public int writeChar(String src, Charset charset) {
        int len = src.length();
        if (len == 0) {
            return 0;
        }
        int markPointer = this.wp;
        this.wRequire(len);
        for (int i = 0; i < len; ++i) {
            char c = src.charAt(i);
            if (c > '\u007f') {
                this.wp = markPointer;
                return this.write(src.getBytes(charset));
            }
            this.bytes[this.offset + this.wp++] = (byte)c;
        }
        return len;
    }

    public int writeChar(boolean value) {
        if (value) {
            this.wRequire(4);
            this.bytes[this.offset + this.wp++] = 116;
            this.bytes[this.offset + this.wp++] = 114;
            this.bytes[this.offset + this.wp++] = 117;
            this.bytes[this.offset + this.wp++] = 101;
            return 4;
        }
        this.wRequire(5);
        this.bytes[this.offset + this.wp++] = 102;
        this.bytes[this.offset + this.wp++] = 97;
        this.bytes[this.offset + this.wp++] = 108;
        this.bytes[this.offset + this.wp++] = 115;
        this.bytes[this.offset + this.wp++] = 101;
        return 5;
    }

    public int writeChar(int value) {
        this.wRequire(ASCIIUtility.decimalStringLength(value));
        int length = ASCIIUtility.toASCII(value, this.bytes, this.offset + this.wp);
        this.wp += length;
        return length;
    }

    public int writeChar(long value) {
        this.wRequire(ASCIIUtility.decimalStringLength(value));
        int length = ASCIIUtility.toASCII(value, this.bytes, this.offset + this.wp);
        this.wp += length;
        return length;
    }

    public int writeChar(double value) {
        return this.writeChar(value, null);
    }

    public int writeChar(double value, DecimalFormat formatter) {
        if (value == 0.0) {
            this.wRequire(1);
            this.bytes[this.offset + this.wp++] = 48;
            return 1;
        }
        if (Double.isNaN(value)) {
            this.wRequire(3);
            this.bytes[this.offset + this.wp++] = 78;
            this.bytes[this.offset + this.wp++] = 97;
            this.bytes[this.offset + this.wp++] = 78;
            return 3;
        }
        if (formatter == null) {
            return this.write(ASCIIUtility.toASCII(value));
        }
        return this.putString(formatter.format(value), StandardCharsets.US_ASCII, false);
    }

    public int putBoolean(boolean booleanValue) {
        this.wRequire(1);
        this.bytes[this.offset + this.wp++] = booleanValue ? (byte)1 : 0;
        return 1;
    }

    public int putByte(byte b) {
        this.wRequire(1);
        this.bytes[this.offset + this.wp++] = b;
        return 1;
    }

    public int putShort(short value) {
        this.wRequire(2);
        this.bytes[this.offset + this.wp++] = (byte)(value & 0xFF);
        this.bytes[this.offset + this.wp++] = (byte)(value >> 8 & 0xFF);
        return 2;
    }

    public int putInt(int value) {
        this.wRequire(4);
        this.bytes[this.offset + this.wp++] = (byte)(value & 0xFF);
        this.bytes[this.offset + this.wp++] = (byte)(value >> 8 & 0xFF);
        this.bytes[this.offset + this.wp++] = (byte)(value >> 16 & 0xFF);
        this.bytes[this.offset + this.wp++] = (byte)(value >> 24 & 0xFF);
        return 4;
    }

    public int putLong(long value) {
        this.wRequire(8);
        this.bytes[this.offset + this.wp++] = (byte)(value & 0xFFL);
        this.bytes[this.offset + this.wp++] = (byte)(value >> 8 & 0xFFL);
        this.bytes[this.offset + this.wp++] = (byte)(value >> 16 & 0xFFL);
        this.bytes[this.offset + this.wp++] = (byte)(value >> 24 & 0xFFL);
        this.bytes[this.offset + this.wp++] = (byte)(value >> 32 & 0xFFL);
        this.bytes[this.offset + this.wp++] = (byte)(value >> 40 & 0xFFL);
        this.bytes[this.offset + this.wp++] = (byte)(value >> 48 & 0xFFL);
        this.bytes[this.offset + this.wp++] = (byte)(value >> 56 & 0xFFL);
        return 8;
    }

    public int putLong(long value, int len) {
        boolean negative;
        if (len < 0) {
            throw new IllegalArgumentException(String.valueOf(len));
        }
        if (len == 0) {
            return 0;
        }
        this.wRequire(len);
        boolean bl = negative = value < 0L;
        if (negative) {
            value ^= 0xFFFFFFFFFFFFFFFFL;
        }
        for (int i = 0; i < len; ++i) {
            this.bytes[this.offset + this.wp + i] = (byte)(value >> (i << 3) & 0xFFL);
        }
        if (negative) {
            int n = this.offset + this.wp + len - 1;
            this.bytes[n] = (byte)(this.bytes[n] | 0x80);
        }
        this.wp += len;
        return len;
    }

    public int putHalfFloat(double value) {
        return this.putHalfFloat((float)value);
    }

    public int putHalfFloat(float value) {
        int fbits = Float.floatToIntBits(value);
        int sign = fbits >>> 16 & 0x8000;
        int val = (fbits & Integer.MAX_VALUE) + 4096;
        if (val >= 1199570944) {
            if ((fbits & Integer.MAX_VALUE) >= 1199570944) {
                if (val < 2139095040) {
                    return this.putShort((short)(sign | 0x7C00));
                }
                return this.putShort((short)(sign | 0x7C00 | (fbits & 0x7FFFFF) >>> 13));
            }
            return this.putShort((short)(sign | 0x7BFF));
        }
        if (val >= 0x38800000) {
            return this.putShort((short)(sign | val - 0x38000000 >>> 13));
        }
        if (val < 0x33000000) {
            return this.putShort((short)sign);
        }
        val = (fbits & Integer.MAX_VALUE) >>> 23;
        return this.putShort((short)(sign | (fbits & 0x7FFFFF | 0x800000) + (0x800000 >>> val - 102) >>> 126 - val));
    }

    public int putFloat(float value) {
        return this.putInt(Float.floatToIntBits(value));
    }

    public int putDouble(double value) {
        return this.putLong(Double.doubleToLongBits(value));
    }

    public int putString(String string, boolean withLength) {
        return this.putString(string, StandardCharsets.UTF_8, withLength);
    }

    public int putString(String string, Charset charset, boolean withLength) {
        if (withLength) {
            if (string == null) {
                return this.putVarInt32(-1);
            }
            if (string.length() == 0) {
                return this.putVarInt32(0);
            }
            int markPointer = this.wp;
            this.wRequire(string.length() + 5);
            this.putVarInt32(string.length());
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (c > '\u007f') {
                    this.wp = markPointer;
                    byte[] data = ASCIIUtility.toASCII(string, charset);
                    return this.putVarInt32(data.length) + this.write(data);
                }
                this.bytes[this.offset + this.wp++] = (byte)c;
            }
            return this.wp - markPointer;
        }
        return this.writeChar(string, charset);
    }

    public int putBytes(Bytes bytes, boolean withLength) {
        if (withLength) {
            if (bytes == null) {
                return this.putVarInt32(-1);
            }
            if (bytes.length() == 0) {
                return this.putVarInt32(0);
            }
            return this.putVarInt32(bytes.length()) + this.write(bytes);
        }
        return this.write(bytes);
    }

    public int putVarInt32(int longValue) {
        this.wRequire(5);
        int length = VarIntCodec.encodeTo(longValue, this.bytes, this.offset + this.wp);
        this.wp += length;
        return length;
    }

    public int putVarInt64(long value) {
        this.wRequire(9);
        int length = VarIntCodec.encodeTo(value, this.bytes, this.offset + this.wp);
        this.wp += length;
        return length;
    }

    public void wRequire(int n) {
        int remaining = this.wRemaining();
        if (remaining < n) {
            if (this.extensible) {
                if (this.bytes.length == 0x7FFFFFFD) {
                    throw new OutOfMemoryError("Cannot allocate more space: requested array size exceeds JVM limit (maximum length is 2147483645)");
                }
                long exactSize = this.bytes.length + (n - remaining);
                exactSize = exactSize <= 0x100000L ? (exactSize *= 2L) : (exactSize <= 0x8000000L ? (exactSize += exactSize >> 1) : (exactSize += exactSize >> 2));
                byte[] newBytes = new byte[(int)ValueUtils.valueOf(exactSize, 8L, 0x7FFFFFFDL)];
                System.arraycopy(this.bytes, 0, newBytes, 0, this.bytes.length);
                this.bytes = newBytes;
            } else {
                throw new IndexOutOfBoundsException("Requested space " + n + " exceeds available space " + remaining + ", and the array is not extensible");
            }
        }
    }

    public void rRequire(int n) {
        int remaining = this.wp - this.rp;
        if (remaining < n) {
            throw new IndexOutOfBoundsException("Requested " + n + " bytes, but only " + remaining + " bytes remaining");
        }
    }

    public ByteStream clear() {
        this.offset = 0;
        this.wp = 0;
        this.rp = 0;
        return this;
    }

    public void close() {
        this.offset = 0;
        this.wp = 0;
        this.rp = 0;
        this.bytes = EmptyArray.BYTE;
    }
}

