/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.bytecode;

import edu.sysu.pmglab.bytecode.ASCIIUtility;
import edu.sysu.pmglab.bytecode.ByteStream;
import edu.sysu.pmglab.bytecode.BytesSplitter;
import edu.sysu.pmglab.bytecode.VarIntCodec;
import edu.sysu.pmglab.container.array.EmptyArray;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.gtb.genome.genotype.Genotype;
import edu.sysu.pmglab.utils.Assert;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;

public final class Bytes {
    public static final Bytes EMPTY = new Bytes(0);
    private static final Bytes[] ASCII_BUFFER = new Bytes[256];
    private final boolean modifiable;
    private int offset;
    private int length;
    private byte[] bytes;

    public Bytes() {
        this.bytes = EmptyArray.BYTE;
        this.offset = 0;
        this.length = 0;
        this.modifiable = true;
    }

    public Bytes(int size) {
        if (size == 0) {
            this.bytes = EmptyArray.BYTE;
            this.length = 0;
        } else {
            this.bytes = new byte[size];
            this.length = this.bytes.length;
        }
        this.offset = 0;
        this.modifiable = false;
    }

    public Bytes(int size, boolean modifiable) {
        if (size == 0) {
            this.bytes = EmptyArray.BYTE;
            this.length = 0;
        } else {
            this.bytes = new byte[size];
            this.length = this.bytes.length;
        }
        this.offset = 0;
        this.modifiable = modifiable;
    }

    public Bytes(byte[] bytes) {
        this.bytes = bytes;
        this.offset = 0;
        this.length = bytes.length;
        this.modifiable = false;
    }

    public Bytes(byte[] bytes, int offset, int length) {
        Assert.checkByteArrayBounds(bytes, offset, length);
        this.bytes = bytes;
        this.offset = offset;
        this.length = length;
        this.modifiable = false;
    }

    public Bytes(byte[] bytes, int offset, int length, boolean detach, boolean modifiable) {
        Assert.checkByteArrayBounds(bytes, offset, length);
        if (bytes.length == 0) {
            this.bytes = EmptyArray.BYTE;
            this.offset = 0;
            this.length = 0;
        } else if (detach) {
            if (length == 0) {
                this.bytes = EmptyArray.BYTE;
                this.offset = 0;
                this.length = 0;
            } else {
                byte[] copy = new byte[length];
                System.arraycopy(bytes, offset, copy, 0, length);
                this.bytes = copy;
                this.offset = 0;
                this.length = length;
            }
        } else {
            this.bytes = bytes;
            this.offset = offset;
            this.length = length;
        }
        this.modifiable = modifiable;
    }

    public Bytes(String string) {
        if (string.length() == 0) {
            this.bytes = EmptyArray.BYTE;
            this.offset = 0;
            this.length = 0;
        } else if (string.length() == 1) {
            char c = string.charAt(0);
            if (c <= '\u007f') {
                Bytes bytes = Bytes.byteToBytes((byte)c);
                this.bytes = bytes.bytes;
                this.offset = 0;
                this.length = 1;
            } else {
                this.bytes = ASCIIUtility.toASCII(string, StandardCharsets.UTF_8);
                this.offset = 0;
                this.length = this.bytes.length;
            }
        } else {
            this.bytes = ASCIIUtility.toASCII(string, StandardCharsets.UTF_8);
            this.offset = 0;
            this.length = this.bytes.length;
        }
        this.modifiable = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Bytes byteToBytes(byte b) {
        int index = b & 0xFF;
        if (ASCII_BUFFER[index] != null) return ASCII_BUFFER[index];
        Bytes[] bytesArray = ASCII_BUFFER;
        synchronized (ASCII_BUFFER) {
            if (ASCII_BUFFER[index] != null) return ASCII_BUFFER[index];
            Bytes.ASCII_BUFFER[index] = new Bytes(new byte[]{b});
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return ASCII_BUFFER[index];
        }
    }

    public Bytes reset() {
        return this.reset(EMPTY);
    }

    public Bytes reset(byte[] bytes) {
        if (bytes == null) {
            return this.reset(EMPTY);
        }
        return this.reset(bytes, 0, bytes.length);
    }

    public Bytes reset(int offset, int length) {
        return this.reset(this.bytes, offset, length, false);
    }

    public Bytes reset(byte[] bytes, boolean detach) {
        return this.reset(bytes, 0, bytes.length, detach);
    }

    public Bytes reset(byte[] bytes, int offset, int length) {
        return this.reset(bytes, offset, length, false);
    }

    public Bytes reset(byte[] bytes, int offset, int length, boolean detach) {
        if (this.modifiable) {
            Assert.checkByteArrayBounds(bytes, offset, length);
            if (bytes.length == 0) {
                this.bytes = EmptyArray.BYTE;
                this.offset = 0;
                this.length = 0;
            } else if (detach) {
                if (length == 0) {
                    this.bytes = EmptyArray.BYTE;
                    this.offset = 0;
                    this.length = 0;
                } else {
                    byte[] copy = new byte[length];
                    System.arraycopy(bytes, offset, copy, 0, length);
                    this.bytes = copy;
                    this.offset = 0;
                    this.length = length;
                }
            } else {
                this.bytes = bytes;
                this.offset = offset;
                this.length = length;
            }
        } else {
            throw new IllegalStateException("Unmodifiable bytes object");
        }
        return this;
    }

    public Bytes reset(Bytes bytes) {
        return this.reset0(bytes.bytes, bytes.offset, bytes.length);
    }

    public Bytes reset(Bytes bytes, boolean detach) {
        if (detach) {
            return this.reset(bytes.bytes, bytes.offset, bytes.length, true);
        }
        return this.reset0(bytes.bytes, bytes.offset, bytes.length);
    }

    Bytes reset0(byte[] bytes, int offset, int length) {
        if (this.modifiable) {
            if (bytes.length == 0) {
                this.bytes = EmptyArray.BYTE;
                this.offset = 0;
                this.length = 0;
            } else {
                this.bytes = bytes;
                this.offset = offset;
                this.length = length;
            }
        } else {
            throw new IllegalStateException("Unmodifiable bytes object");
        }
        return this;
    }

    public byte[] bytes() {
        return this.bytes;
    }

    public int capacity() {
        return this.bytes.length;
    }

    public int offset() {
        return this.offset;
    }

    public int length() {
        return this.length;
    }

    public byte fastByteAt(int index) {
        return this.bytes[this.offset + index];
    }

    public byte fastLastByteAt(int index) {
        return this.bytes[this.offset + this.length - index - 1];
    }

    public byte byteAt(int index) {
        if (index >= 0 && index < this.length) {
            return this.bytes[this.offset + index];
        }
        throw new IndexOutOfBoundsException("Bytes index out of range: " + index);
    }

    public byte lastByteAt(int index) {
        if (index >= 0 && index < this.length) {
            return this.bytes[this.offset + this.length - index - 1];
        }
        throw new IndexOutOfBoundsException("Bytes index out of range: " + (this.offset + this.length - index - 1));
    }

    public byte rawByteAt(int index) {
        return this.bytes[index];
    }

    public byte lastRawByteAt(int index) {
        return this.bytes[this.bytes.length - index - 1];
    }

    public Bytes trim() {
        int start;
        if (this.length == 0) {
            return this;
        }
        int end = this.offset + this.length - 1;
        for (start = this.offset; start <= end && (this.bytes[start] & 0xFF) <= 32; ++start) {
        }
        while (end >= start && (this.bytes[end] & 0xFF) <= 32) {
            --end;
        }
        if (start == this.offset && end == this.offset + this.length - 1) {
            return this;
        }
        return new Bytes(this.bytes, start, end - start + 1, false, this.modifiable);
    }

    public int valueCount(byte value) {
        int count = 0;
        int l = this.offset + this.length;
        for (int i = this.offset; i < l; ++i) {
            if (this.bytes[i] != value) continue;
            ++count;
        }
        return count;
    }

    public int splitTo(byte separator, List<Bytes> container) {
        int mark = 0;
        int count = 0;
        for (int i = 0; i < this.length; ++i) {
            if (this.bytes[this.offset + i] != separator) continue;
            container.add(this.subBytes(mark, i));
            ++count;
            mark = i + 1;
        }
        container.add(this.subBytes(mark));
        return ++count;
    }

    public Iterator<Bytes> split(byte separator) {
        return new BytesSplitter(separator).init(this);
    }

    public Bytes subBytes(int beginIndex) {
        if (beginIndex < 0) {
            throw new IndexOutOfBoundsException("Bytes index out of range: " + beginIndex);
        }
        int subLen = this.length - beginIndex;
        if (subLen < 0) {
            throw new IndexOutOfBoundsException("Bytes index out of range: " + subLen);
        }
        return new Bytes(this.bytes, this.offset + beginIndex, subLen, false, false);
    }

    public Bytes subBytes(int beginIndex, int endIndex) {
        if (beginIndex < 0) {
            throw new IndexOutOfBoundsException("Bytes index out of range: " + beginIndex);
        }
        if (endIndex > this.length) {
            throw new IndexOutOfBoundsException("Bytes index out of range: " + endIndex);
        }
        int subLen = endIndex - beginIndex;
        if (subLen < 0) {
            throw new IndexOutOfBoundsException("Bytes index out of range: " + subLen);
        }
        return new Bytes(this.bytes, this.offset + beginIndex, subLen, false, false);
    }

    public void subBytesTo(int beginIndex, Bytes bytes) {
        if (beginIndex < 0) {
            throw new IndexOutOfBoundsException("Bytes index out of range: " + beginIndex);
        }
        int subLen = this.length - beginIndex;
        if (subLen < 0) {
            throw new IndexOutOfBoundsException("Bytes index out of range: " + subLen);
        }
        bytes.reset(this.bytes, this.offset + beginIndex, subLen);
    }

    public void subBytesTo(int beginIndex, int endIndex, Bytes bytes) {
        if (beginIndex < 0) {
            throw new IndexOutOfBoundsException("Bytes index out of range: " + beginIndex);
        }
        if (endIndex > this.length) {
            throw new IndexOutOfBoundsException("Bytes index out of range: " + endIndex);
        }
        int subLen = endIndex - beginIndex;
        if (subLen < 0) {
            throw new IndexOutOfBoundsException("Bytes index out of range: " + subLen);
        }
        bytes.reset(this.bytes, this.offset + beginIndex, subLen);
    }

    public ByteStream toByteStream() {
        return new ByteStream(this.bytes, this.offset, this.length, false);
    }

    public boolean valueEquals(byte b) {
        if (this.length == 1) {
            return this.bytes[this.offset] == b;
        }
        return false;
    }

    public boolean valueEquals(Bytes bytes) {
        if (this == bytes) {
            return true;
        }
        return this.valueEquals(bytes.bytes, bytes.offset, bytes.length);
    }

    public boolean valueEquals(byte[] bytes) {
        return this.valueEquals(bytes, 0, bytes.length);
    }

    public boolean valueEquals(ByteStream stream) {
        return this.valueEquals(stream.bytes(), stream.offset(), stream.length());
    }

    public boolean valueEquals(byte[] bytes, int off, int len) {
        if (len == 1) {
            return this.length == 1 && this.bytes[this.offset] == bytes[off];
        }
        if (this.length == len) {
            if (this.bytes == bytes && this.offset == off) {
                return true;
            }
            for (int i = 0; i < this.length; ++i) {
                if (this.bytes[this.offset + i] == bytes[off + i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean equalsIgnoreCase(byte b) {
        if (this.length != 1) {
            return false;
        }
        byte code = this.bytes[this.offset];
        if (code != b) {
            if (code >= 65 && code <= 90) {
                code = (byte)(code + 32);
            }
            if (b >= 65 && b <= 90) {
                b = (byte)(b + 32);
            }
            return b == code;
        }
        return true;
    }

    public boolean equalsIgnoreCase(Bytes bytes) {
        return this.equalsIgnoreCase(bytes.bytes, bytes.offset, bytes.length);
    }

    public boolean equalsIgnoreCase(byte[] bytes) {
        return this.equalsIgnoreCase(bytes, 0, bytes.length);
    }

    public boolean equalsIgnoreCase(byte[] bytes, int off, int len) {
        if (this.length != len) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            byte code1 = this.bytes[this.offset + i];
            byte code2 = bytes[off + i];
            if (code1 == code2) continue;
            if (code1 >= 65 && code1 <= 90) {
                code1 = (byte)(code1 + 32);
            }
            if (code2 >= 65 && code2 <= 90) {
                code2 = (byte)(code2 + 32);
            }
            if (code1 == code2) continue;
            return false;
        }
        return true;
    }

    public boolean startsWith(byte b) {
        if (this.length == 0) {
            return false;
        }
        return this.bytes[this.offset] == b;
    }

    public boolean startsWith(byte[] bytes) {
        return this.startsWith(bytes, 0, bytes.length);
    }

    public boolean startsWith(Bytes bytes) {
        return this.startsWith(bytes.bytes, bytes.offset, bytes.length);
    }

    public boolean startsWith(byte[] bytes, int off, int len) {
        if (this.length < len) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (this.bytes[this.offset + i] == bytes[off + i]) continue;
            return false;
        }
        return true;
    }

    public boolean endsWith(byte b) {
        if (this.length == 0) {
            return false;
        }
        return this.bytes[this.offset + this.length - 1] == b;
    }

    public boolean endsWith(byte[] bytes) {
        return this.endsWith(bytes, 0, bytes.length);
    }

    public boolean endsWith(Bytes bytes) {
        return this.endsWith(bytes.bytes, bytes.offset, bytes.length);
    }

    public boolean endsWith(byte[] bytes, int off, int len) {
        if (this.length < len) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (this.bytes[this.offset + this.length - 1 - i] == bytes[off + len - 1 - i]) continue;
            return false;
        }
        return true;
    }

    public int indexOf(byte b) {
        for (int i = 0; i < this.length; ++i) {
            if (this.bytes[this.offset + i] != b) continue;
            return i;
        }
        return -1;
    }

    public int indexOf(byte[] bytes) {
        return this.indexOf(bytes, 0, bytes.length);
    }

    public int indexOf(Bytes bytes) {
        return this.indexOf(bytes.bytes, bytes.offset, bytes.length);
    }

    public int indexOf(byte[] bytes, int off, int len) {
        if (len == 1) {
            return this.indexOf(bytes[off]);
        }
        int l = this.length - len;
        block0: for (int i = 0; i <= l; ++i) {
            for (int j = 0; j < len; ++j) {
                if (this.bytes[this.offset + i + j] != bytes[off + j]) continue block0;
            }
            return i;
        }
        return -1;
    }

    public int lastIndexOf(byte b) {
        for (int i = this.length - 1; i >= 0; --i) {
            if (this.bytes[this.offset + i] != b) continue;
            return i;
        }
        return -1;
    }

    public boolean toBoolean() {
        return ASCIIUtility.toBoolean(this.bytes, this.offset, this.length);
    }

    public byte toByte() {
        return ASCIIUtility.toByte(this.bytes, this.offset, this.length);
    }

    public boolean decodeBoolean() {
        this.require(1);
        byte byteValue = this.bytes[this.offset];
        if (byteValue == 0) {
            return false;
        }
        if (byteValue == 1) {
            return true;
        }
        throw new NumberFormatException("Failed to convert '" + byteValue + "' to a boolean value");
    }

    public byte decodeByte() {
        this.require(1);
        return this.bytes[this.offset];
    }

    public short toShort() {
        return ASCIIUtility.toShort(this.bytes, this.offset, this.length);
    }

    public short decodeShort() {
        this.require(2);
        return (short)(this.bytes[this.offset] & 0xFF | (this.bytes[this.offset + 1] & 0xFF) << 8);
    }

    public int toInt() {
        return ASCIIUtility.toInt(this.bytes, this.offset, this.length);
    }

    public int decodeInt() {
        this.require(4);
        return this.bytes[this.offset] & 0xFF | (this.bytes[this.offset + 1] & 0xFF) << 8 | (this.bytes[this.offset + 2] & 0xFF) << 16 | (this.bytes[this.offset + 3] & 0xFF) << 24;
    }

    public long toLong() {
        return ASCIIUtility.toLong(this.bytes, this.offset, this.length);
    }

    public long decodeLong() {
        this.require(8);
        return (long)this.bytes[this.offset] & 0xFFL | ((long)this.bytes[this.offset + 1] & 0xFFL) << 8 | ((long)this.bytes[this.offset + 2] & 0xFFL) << 16 | ((long)this.bytes[this.offset + 3] & 0xFFL) << 24 | ((long)this.bytes[this.offset + 4] & 0xFFL) << 32 | ((long)this.bytes[this.offset + 5] & 0xFFL) << 40 | ((long)this.bytes[this.offset + 6] & 0xFFL) << 48 | ((long)this.bytes[this.offset + 7] & 0xFFL) << 56;
    }

    public float toFloat() {
        return ASCIIUtility.toFloat(this.bytes, this.offset, this.length);
    }

    public float decodeHalfFloat() {
        short shortBits = this.decodeShort();
        int mant = shortBits & 0x3FF;
        int exp = shortBits & 0x7C00;
        if (exp == 31744) {
            exp = 261120;
        } else if (exp != 0) {
            if (mant == 0 && (exp += 114688) > 115712) {
                return Float.intBitsToFloat((shortBits & 0x8000) << 16 | exp << 13 | 0x3FF);
            }
        } else if (mant != 0) {
            exp = 115712;
            do {
                exp -= 1024;
            } while (((mant <<= 1) & 0x400) == 0);
            mant &= 0x3FF;
        }
        return Float.intBitsToFloat((shortBits & 0x8000) << 16 | (exp | mant) << 13);
    }

    public float decodeFloat() {
        return Float.intBitsToFloat(this.decodeInt());
    }

    public double toDouble() {
        return ASCIIUtility.toDouble(this.bytes, this.offset, this.length);
    }

    public double decodeDouble() {
        return Double.longBitsToDouble(this.decodeLong());
    }

    public int decodeVarInt32() {
        long value = this.decodeVarInt64();
        if (value >= Integer.MIN_VALUE && value <= Integer.MAX_VALUE) {
            return (int)value;
        }
        throw new NumberFormatException("Failed to convert '" + this + "' to a varInt32 value: value overflow");
    }

    public long decodeVarInt64() {
        return VarIntCodec.decode(this.bytes, this.offset, this.length);
    }

    public Genotype toGenotype() {
        return ASCIIUtility.toDiploidGenotype(this.bytes, this.offset, this.length);
    }

    public int hashCode() {
        int hash = 0;
        if (this.length > 0) {
            for (int i = 0; i < this.length; ++i) {
                hash = 31 * hash + this.bytes[this.offset + i];
            }
        }
        return hash;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.valueEquals((Bytes)o);
    }

    public String toString() {
        return this.toString(null);
    }

    public String toString(Charset charset) {
        if (this.length == 0) {
            return "";
        }
        if (charset == null) {
            charset = StandardCharsets.UTF_8;
        }
        return new String(this.bytes, this.offset, this.length, charset);
    }

    private void require(int n) {
        if (this.length != n) {
            throw new IndexOutOfBoundsException("Requested " + n + " bytes, but only " + n + " bytes were provided");
        }
    }

    public Bytes detach() {
        if (this.length == 0) {
            return EMPTY;
        }
        if (this.length == 1) {
            return Bytes.byteToBytes(this.bytes[this.offset]);
        }
        return new Bytes(this.bytes, this.offset, this.length, true, this.modifiable);
    }
}

