/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.bytecode;

import edu.sysu.pmglab.bytecode.Bytes;
import edu.sysu.pmglab.utils.ValueUtils;
import java.util.Iterator;
import java.util.NoSuchElementException;

public final class BytesSplitter
implements Iterator<Bytes> {
    final Bytes container = new Bytes();
    final Bytes data = new Bytes();
    final byte separator;
    final int minLength;
    int pointer = -1;

    public BytesSplitter(byte separator) {
        this.minLength = 0;
        this.separator = separator;
    }

    public BytesSplitter(int minLength, byte separator) {
        this.minLength = ValueUtils.valueOf(minLength, 0, Integer.MAX_VALUE);
        this.separator = separator;
    }

    public BytesSplitter init(Bytes bytes) {
        this.data.reset(bytes);
        this.container.reset(bytes);
        this.pointer = 0;
        return this;
    }

    public BytesSplitter init(byte[] src) {
        this.data.reset(src);
        this.container.reset(src);
        this.pointer = 0;
        return this;
    }

    public BytesSplitter init(byte[] src, int offset, int length) {
        this.data.reset(src, offset, length);
        this.container.reset0(src, offset, length);
        this.pointer = 0;
        return this;
    }

    @Override
    public boolean hasNext() {
        return this.pointer <= this.data.length();
    }

    @Override
    public Bytes next() {
        for (int i = this.pointer + this.minLength; i < this.data.length(); ++i) {
            if (this.data.fastByteAt(i) != this.separator) continue;
            this.container.reset0(this.data.bytes(), this.data.offset() + this.pointer, i - this.pointer);
            this.pointer = i + 1;
            return this.container;
        }
        if (this.data.length() - this.pointer >= 0) {
            this.container.reset0(this.data.bytes(), this.data.offset() + this.pointer, this.data.length() - this.pointer);
            this.pointer = this.data.length() + 1;
            return this.container;
        }
        throw new NoSuchElementException();
    }

    public void clear() {
        this.pointer = -1;
    }
}

