/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.bytecode;

import edu.sysu.pmglab.bytecode.Bytes;
import edu.sysu.pmglab.utils.ValueUtils;
import java.util.NoSuchElementException;

public class GroupSplitter {
    final Bytes container = new Bytes();
    final Bytes data = new Bytes();
    final byte groupSeparator;
    final byte valueSeparator;
    final int minLength;
    int pointer = -1;
    boolean groupStart = false;

    public GroupSplitter(byte groupSeparator, byte valueSeparator) {
        if (groupSeparator == valueSeparator) {
            throw new IllegalArgumentException("Duplicated separator: " + groupSeparator);
        }
        this.minLength = 0;
        this.groupSeparator = groupSeparator;
        this.valueSeparator = valueSeparator;
    }

    public GroupSplitter(int minLength, byte groupSeparator, byte valueSeparator) {
        if (groupSeparator == valueSeparator) {
            throw new IllegalArgumentException("Duplicated separator: " + groupSeparator);
        }
        this.minLength = ValueUtils.valueOf(minLength, 0, Integer.MAX_VALUE);
        this.groupSeparator = groupSeparator;
        this.valueSeparator = valueSeparator;
    }

    public GroupSplitter init(Bytes bytes) {
        this.data.reset(bytes);
        this.container.reset(bytes);
        this.pointer = 0;
        this.groupStart = true;
        return this;
    }

    public GroupSplitter init(byte[] src) {
        this.data.reset(src);
        this.container.reset(src);
        this.pointer = 0;
        this.groupStart = true;
        return this;
    }

    public GroupSplitter init(byte[] src, int off, int len) {
        this.data.reset(src, off, len);
        this.container.reset0(src, off, len);
        this.pointer = 0;
        this.groupStart = true;
        return this;
    }

    public boolean hasNext() {
        if (this.pointer == this.data.length()) {
            return true;
        }
        if (this.pointer < this.data.length()) {
            if (this.groupStart) {
                return true;
            }
            return this.data.fastByteAt(this.pointer) != this.groupSeparator;
        }
        return false;
    }

    public Bytes next() {
        for (int i = this.pointer; i < this.data.length(); ++i) {
            if (this.data.fastByteAt(i) == this.valueSeparator) {
                int len = i - this.pointer;
                if (len < this.minLength) continue;
                this.container.reset0(this.data.bytes(), this.data.offset() + this.pointer, len);
                this.pointer = i + 1;
                this.groupStart = true;
                return this.container;
            }
            if (this.data.fastByteAt(i) != this.groupSeparator) continue;
            if (!this.groupStart) {
                throw new NoSuchElementException();
            }
            this.container.reset0(this.data.bytes(), this.data.offset() + this.pointer, i - this.pointer);
            this.pointer = i;
            this.groupStart = false;
            return this.container;
        }
        if (this.data.length() - this.pointer >= 0) {
            this.container.reset0(this.data.bytes(), this.data.offset() + this.pointer, this.data.length() - this.pointer);
            this.pointer = this.data.length() + 1;
            this.groupStart = false;
            return this.container;
        }
        throw new NoSuchElementException();
    }

    public void clear() {
        this.pointer = -1;
        this.groupStart = false;
    }

    public boolean nextGroup() {
        if (this.pointer < this.data.length()) {
            if (this.data.fastByteAt(this.pointer) == this.groupSeparator) {
                ++this.pointer;
                this.groupStart = true;
                return true;
            }
            for (int i = this.pointer; i < this.data.length(); ++i) {
                if (this.data.fastByteAt(i) != this.groupSeparator) continue;
                this.pointer = i + 1;
                this.groupStart = true;
                return true;
            }
            this.pointer = this.data.length() + 1;
            this.groupStart = false;
            return false;
        }
        this.pointer = this.data.length() + 1;
        this.groupStart = false;
        return false;
    }
}

