/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.bytecode;

import edu.sysu.pmglab.utils.ValueUtils;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class StringSplitter
implements Iterator<String> {
    final char separator;
    final int minLength;
    String values = null;
    int pointer = -1;

    public StringSplitter(char separator) {
        this.minLength = 0;
        this.separator = separator;
    }

    public StringSplitter(int minLength, char separator) {
        this.minLength = ValueUtils.valueOf(minLength, 0, Integer.MAX_VALUE);
        this.separator = separator;
    }

    public StringSplitter init(String bytes) {
        this.values = bytes;
        this.pointer = 0;
        return this;
    }

    @Override
    public boolean hasNext() {
        return this.pointer <= this.values.length();
    }

    @Override
    public String next() {
        for (int i = this.pointer + this.minLength; i < this.values.length(); ++i) {
            if (this.values.charAt(i) != this.separator) continue;
            String returns = this.values.substring(this.pointer, i);
            this.pointer = i + 1;
            return returns;
        }
        try {
            String i = this.values.substring(this.pointer);
            return i;
        }
        catch (StringIndexOutOfBoundsException e) {
            throw new NoSuchElementException();
        }
        finally {
            this.pointer = this.values.length() + 1;
        }
    }

    public void clear() {
        this.values = null;
        this.pointer = -1;
    }
}

