/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.bytecode;

import java.io.IOException;
import java.io.InputStream;

public class VarIntCodec {
    private static final int[] PRE_CODE = new int[]{0, 1, 3, 7, 15, 31, 63, 127, 255};
    private static final byte NEGATIVE_MASK = -128;
    private static final byte[] ONE_BYTE_ENCODER = new byte[]{-2, -4, -6, -8, -10, -12, -14, -16, -18, -20, -22, -24, -26, -28, -30, -32, -34, -36, -38, -40, -42, -44, -46, -48, -50, -52, -54, -56, -58, -60, -62, -64, -66, -68, -70, -72, -74, -76, -78, -80, -82, -84, -86, -88, -90, -92, -94, -96, -98, -100, -102, -104, -106, -108, -110, -112, -114, -116, -118, -120, -122, -124, -126, -128, 0, 2, 4, 6, 8, 10, 12, 14, 16, 18, 20, 22, 24, 26, 28, 30, 32, 34, 36, 38, 40, 42, 44, 46, 48, 50, 52, 54, 56, 58, 60, 62, 64, 66, 68, 70, 72, 74, 76, 78, 80, 82, 84, 86, 88, 90, 92, 94, 96, 98, 100, 102, 104, 106, 108, 110, 112, 114, 116, 118, 120, 122, 124, 126};
    private static final byte[] ONE_BYTE_DECODER = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, -1, -2, -3, -4, -5, -6, -7, -8, -9, -10, -11, -12, -13, -14, -15, -16, -17, -18, -19, -20, -21, -22, -23, -24, -25, -26, -27, -28, -29, -30, -31, -32, -33, -34, -35, -36, -37, -38, -39, -40, -41, -42, -43, -44, -45, -46, -47, -48, -49, -50, -51, -52, -53, -54, -55, -56, -57, -58, -59, -60, -61, -62, -63, -64};

    private VarIntCodec() {
        throw new UnsupportedOperationException("Cannot instantiate utility class");
    }

    public static byte[] encode(long value) {
        if (value >= -64L && value <= 63L) {
            return new byte[]{ONE_BYTE_ENCODER[(int)(value + 64L)]};
        }
        int length = VarIntCodec.getEncodedLength(value);
        if (length == 9) {
            return new byte[]{-1, (byte)(value & 0xFFL), (byte)(value >> 8 & 0xFFL), (byte)(value >> 16 & 0xFFL), (byte)(value >> 24 & 0xFFL), (byte)(value >> 32 & 0xFFL), (byte)(value >> 40 & 0xFFL), (byte)(value >> 48 & 0xFFL), (byte)(value >> 56 & 0xFFL)};
        }
        boolean negative = value < 0L;
        byte[] cache = new byte[length];
        if (value < 0L) {
            value = -(value + 1L);
        }
        value = (long)PRE_CODE[length - 1] | value << length;
        for (int i = 0; i < length; ++i) {
            cache[i] = (byte)(value >> (i << 3));
        }
        if (negative) {
            int n = cache.length - 1;
            cache[n] = (byte)(cache[n] | 0xFFFFFF80);
        }
        return cache;
    }

    public static int encodeTo(long value, byte[] cache) {
        return VarIntCodec.encodeTo(value, cache, 0);
    }

    public static int encodeTo(long value, byte[] cache, int off) {
        if (value >= -64L && value <= 63L) {
            cache[off] = ONE_BYTE_ENCODER[(int)(value + 64L)];
            return 1;
        }
        int length = VarIntCodec.getEncodedLength(value);
        if (length == 9) {
            cache[off] = -1;
            cache[off + 1] = (byte)(value & 0xFFL);
            cache[off + 2] = (byte)(value >> 8 & 0xFFL);
            cache[off + 3] = (byte)(value >> 16 & 0xFFL);
            cache[off + 4] = (byte)(value >> 24 & 0xFFL);
            cache[off + 5] = (byte)(value >> 32 & 0xFFL);
            cache[off + 6] = (byte)(value >> 40 & 0xFFL);
            cache[off + 7] = (byte)(value >> 48 & 0xFFL);
            cache[off + 8] = (byte)(value >> 56 & 0xFFL);
        } else {
            boolean negative;
            boolean bl = negative = value < 0L;
            if (value < 0L) {
                value = -(value + 1L);
            }
            value = (long)PRE_CODE[length - 1] | value << length;
            for (int i = 0; i < length; ++i) {
                cache[off + i] = (byte)(value >> (i << 3));
            }
            if (negative) {
                int n = off + length - 1;
                cache[n] = (byte)(cache[n] | 0xFFFFFF80);
            }
        }
        return length;
    }

    public static long decode(byte[] bytes) {
        return VarIntCodec.decode(bytes, 0, bytes.length, false);
    }

    public static long decode(byte[] bytes, boolean allowExtraneousBytes) {
        return VarIntCodec.decode(bytes, 0, bytes.length, allowExtraneousBytes);
    }

    public static long decode(byte[] bytes, int off) {
        return VarIntCodec.decode(bytes, off, bytes.length - off, false);
    }

    public static long decode(byte[] bytes, int off, boolean allowExtraneousBytes) {
        return VarIntCodec.decode(bytes, off, bytes.length - off, allowExtraneousBytes);
    }

    public static long decode(byte[] bytes, int off, int len) {
        return VarIntCodec.decode(bytes, off, len, false);
    }

    public static long decode(byte[] bytes, int off, int len, boolean allowExtraneousBytes) {
        if (len <= 0) {
            throw new IllegalArgumentException("The length of the input byte array (" + len + ") does not match the expected decoded length (>= 1)");
        }
        if (off < 0 || off >= bytes.length) {
            throw new IndexOutOfBoundsException(String.valueOf(off));
        }
        int length = VarIntCodec.getDecodedLength(bytes[off]);
        if (length != len) {
            if (!allowExtraneousBytes) {
                throw new IllegalArgumentException("The length of the input byte array (" + len + ") does not match the expected decoded length (" + length + ")");
            }
            if (len < length) {
                throw new IllegalArgumentException("The length of the input byte array (" + len + ") does not match the expected decoded length (>= " + length + ")");
            }
        }
        return VarIntCodec.decode0(bytes, off, length);
    }

    static long decode0(byte[] bytes, int off, int decodeLength) {
        long value = 0L;
        if (decodeLength == 1) {
            return ONE_BYTE_DECODER[(bytes[off] & 0xFF) >> 1];
        }
        if (decodeLength == 9) {
            for (int i = 0; i < 8; ++i) {
                value |= ((long)bytes[off + i + 1] & 0xFFL) << (i << 3);
            }
        } else {
            for (int i = 0; i < decodeLength - 1; ++i) {
                value |= ((long)bytes[off + i] & 0xFFL) << (i << 3);
            }
            byte lastByte = bytes[off + decodeLength - 1];
            value |= ((long)lastByte & 0x7FL) << (decodeLength - 1 << 3);
            value >>= decodeLength;
            if ((lastByte & 0x80) == 128) {
                value = -value - 1L;
            }
        }
        return value;
    }

    public static long decode(InputStream stream) throws IOException {
        return VarIntCodec.decode(stream, null);
    }

    public static long decode(InputStream stream, byte[] cache) throws IOException {
        int firstByte = stream.read();
        if (firstByte == -1) {
            throw new IllegalArgumentException("The length of the input stream (0) does not match the expected decoded length (>= 1)");
        }
        int length = VarIntCodec.getDecodedLength((byte)firstByte);
        if (length == 1) {
            return ONE_BYTE_DECODER[(firstByte & 0xFF) >> 1];
        }
        if (cache == null || cache.length < length) {
            long value = 0L;
            if (length == 9) {
                for (int i = 0; i < 8; ++i) {
                    int b = stream.read();
                    if (b == -1) {
                        throw new IllegalArgumentException("The length of the input stream (" + i + 1 + ") does not match the expected decoded length (9)");
                    }
                    value |= ((long)b & 0xFFL) << (i << 3);
                }
            } else {
                value |= (long)firstByte & 0xFFL;
                for (int i = 1; i < length - 1; ++i) {
                    int b = stream.read();
                    if (b == -1) {
                        throw new IllegalArgumentException("The length of the input stream (" + (i + 1) + ") does not match the expected decoded length (" + length + ")");
                    }
                    value |= ((long)b & 0xFFL) << (i << 3);
                }
                int lastByte = stream.read();
                if (lastByte == -1) {
                    throw new IllegalArgumentException("The length of the input stream (" + (length - 1) + ") does not match the expected decoded length (" + length + ")");
                }
                value |= ((long)lastByte & 0x7FL) << (length - 1 << 3);
                value >>= length;
                if ((lastByte & 0x80) == 128) {
                    value = -value - 1L;
                }
            }
            return value;
        }
        cache[0] = (byte)firstByte;
        int requiredLength = length - 1;
        int offerLength = stream.read(cache, 1, requiredLength);
        if (offerLength != requiredLength) {
            throw new IllegalArgumentException("The length of the input stream (" + (offerLength + 1) + ") does not match the expected decoded length (" + length + ")");
        }
        long value = 0L;
        if (length == 9) {
            for (int i = 0; i < 8; ++i) {
                value |= ((long)cache[i + 1] & 0xFFL) << (i << 3);
            }
        } else {
            for (int i = 0; i < length - 1; ++i) {
                value |= ((long)cache[i] & 0xFFL) << (i << 3);
            }
            byte lastByte = cache[length - 1];
            value |= ((long)lastByte & 0x7FL) << (length - 1 << 3);
            value >>= length;
            if ((lastByte & 0x80) == 128) {
                value = -value - 1L;
            }
        }
        return value;
    }

    public static int getEncodedLength(long value) {
        if (value < 0L) {
            value = -(value + 1L);
        }
        if (value <= 63L) {
            return 1;
        }
        if (value <= 8191L) {
            return 2;
        }
        if (value <= 1048575L) {
            return 3;
        }
        if (value <= 0x7FFFFFFL) {
            return 4;
        }
        if (value <= 0x3FFFFFFFFL) {
            return 5;
        }
        if (value <= 0x1FFFFFFFFFFL) {
            return 6;
        }
        if (value <= 0xFFFFFFFFFFFFL) {
            return 7;
        }
        if (value <= 0x7FFFFFFFFFFFFFL) {
            return 8;
        }
        return 9;
    }

    public static int getEncodedLength(int value) {
        if (value < 0) {
            value = -(value + 1);
        }
        if (value <= 63) {
            return 1;
        }
        if (value <= 8191) {
            return 2;
        }
        if (value <= 1048575) {
            return 3;
        }
        if (value <= 0x7FFFFFF) {
            return 4;
        }
        return 5;
    }

    public static int getDecodedLength(byte magic) {
        if (magic == -1) {
            return 9;
        }
        if (magic == 127) {
            return 8;
        }
        if ((magic & 1) == 0) {
            return 1;
        }
        if ((magic & 3) == 1) {
            return 2;
        }
        if ((magic & 7) == 3) {
            return 3;
        }
        if ((magic & 0xF) == 7) {
            return 4;
        }
        if ((magic & 0x1F) == 15) {
            return 5;
        }
        if ((magic & 0x3F) == 31) {
            return 6;
        }
        if ((magic & 0x7F) == 63) {
            return 7;
        }
        return -1;
    }
}

