/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.ccf;

import edu.sysu.pmglab.RuntimeProperty;
import edu.sysu.pmglab.ccf.compressor.ICompressor;
import edu.sysu.pmglab.ccf.compressor.IDecompressor;
import gnu.trove.map.TObjectIntMap;
import gnu.trove.map.hash.TObjectIntHashMap;

public class CCFConfiguration {
    private final TObjectIntMap<String> levels = new TObjectIntHashMap<String>(0);
    private int MAX_RECORDS_PER_BLOCK = RuntimeProperty.DEFAULT_MAX_RECORDS_PER_BLOCK;
    private int MAX_MEMORY_PER_BLOCK = RuntimeProperty.DEFAULT_MAX_MEMORY_PER_BLOCK;
    private int MIN_MEMORY_TO_FLUSH = RuntimeProperty.DEFAULT_MIN_MEMORY_TO_FLUSH;
    private Class<? extends ICompressor> compressor = RuntimeProperty.DEFAULT_COMPRESSOR;
    private Class<? extends IDecompressor> decompressor = RuntimeProperty.DEFAULT_DECOMPRESSOR;
    private int defaultCompressionLevel = RuntimeProperty.DEFAULT_COMPRESSION_LEVEL;

    public int getMaxRecordsPerBlock() {
        return this.MAX_RECORDS_PER_BLOCK;
    }

    public CCFConfiguration setMaxRecordsPerBlock(int maxRecords) {
        if (maxRecords < 32 || maxRecords > 262144) {
            throw new IllegalArgumentException("Max records per block must be between 32 and 262144");
        }
        this.MAX_RECORDS_PER_BLOCK = maxRecords;
        return this;
    }

    public int getMaxMemoryPerBlock() {
        return this.MAX_MEMORY_PER_BLOCK;
    }

    public CCFConfiguration setMaxMemoryPerBlock(int maxMemoryBytes) {
        if (maxMemoryBytes < 0x100000 || maxMemoryBytes > 0x10000000) {
            throw new IllegalArgumentException("Max memory per block must be between 1MB and 256MB");
        }
        this.MAX_MEMORY_PER_BLOCK = maxMemoryBytes;
        return this;
    }

    public int getMinMemoryToFlush() {
        return this.MIN_MEMORY_TO_FLUSH;
    }

    public CCFConfiguration setMinMemoryToFlush(int minMemoryBytes) {
        if (minMemoryBytes < 65536 || minMemoryBytes > 0x10000000) {
            throw new IllegalArgumentException("Min memory to flush must be between 64KB and 256MB");
        }
        this.MIN_MEMORY_TO_FLUSH = minMemoryBytes;
        return this;
    }

    public CCFConfiguration setCompressor(String path) throws ClassNotFoundException {
        this.compressor = Class.forName(path);
        return this;
    }

    public CCFConfiguration setCompressor(Class<? extends ICompressor> compressor) {
        this.compressor = compressor;
        return this;
    }

    public CCFConfiguration setDecompressor(String path) throws ClassNotFoundException {
        this.decompressor = Class.forName(path);
        return this;
    }

    public CCFConfiguration setDecompressor(Class<? extends IDecompressor> decompressor) {
        this.decompressor = decompressor;
        return this;
    }

    public CCFConfiguration setDefaultCompressionLevel(int level) {
        this.defaultCompressionLevel = level;
        return this;
    }

    public CCFConfiguration setCompressorLevel(String group, int level) {
        if (level == -1) {
            this.levels.remove(group);
        } else {
            this.levels.put(group, level);
        }
        return this;
    }

    public int getCompressorLevel(String group) {
        return this.levels.containsKey(group) ? this.levels.get(group) : this.defaultCompressionLevel;
    }
}

