/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.ccf;

import edu.sysu.pmglab.ccf.Decompressor;
import edu.sysu.pmglab.ccf.exception.CCFComponentException;
import edu.sysu.pmglab.ccf.field.FieldGroupMeta;
import edu.sysu.pmglab.ccf.field.FieldMeta;
import edu.sysu.pmglab.ccf.header.CCFHeader;
import edu.sysu.pmglab.ccf.header.CCFHeaders;
import edu.sysu.pmglab.ccf.record.IRecord;
import edu.sysu.pmglab.ccf.type.Box;
import edu.sysu.pmglab.objectpool.LinkedObjectPool;
import gnu.trove.map.hash.THashMap;
import java.io.IOException;

class CCFFieldGroupDecoder {
    final CCFHeaders blocks;
    final FieldGroupMeta selected;
    final Decompressor decompressor;
    final THashMap<FieldMeta, LinkedObjectPool<?>> activeFieldData;
    CCFHeader activeBlock = CCFHeader.FAKE_BLOCK;
    int activeBlockIndex = -1;

    CCFFieldGroupDecoder(CCFHeaders blocks, FieldGroupMeta selected, Decompressor decompressor) {
        this.blocks = blocks;
        this.selected = selected;
        this.decompressor = decompressor;
        this.activeFieldData = new THashMap();
        for (FieldMeta field : this.selected) {
            this.activeFieldData.put(field, new LinkedObjectPool<Object>(() -> field.type().newBox()));
        }
    }

    void read(long recordIndex, IRecord record) {
        if (!this.activeBlock.contains(recordIndex)) {
            int recordBlockIndex = this.activeBlock.getMaxRecordIndex() < recordIndex ? this.blocks.getBlockIndexByRecordIndex(recordIndex, this.activeBlockIndex + 1) : this.blocks.getBlockIndexByRecordIndex(recordIndex, this.activeBlockIndex - 1);
            this.fill(recordBlockIndex);
        }
        int relativeIndex = (int)(recordIndex - this.activeBlock.getMinRecordIndex());
        for (FieldMeta field : this.selected) {
            LinkedObjectPool<?> values2;
            int index = record.indexOf(field);
            if (index == -1 || (values2 = this.activeFieldData.get(field)) == null) continue;
            Box box = (Box)values2.fastGet(relativeIndex);
            record.setFromBox(index, box);
        }
    }

    boolean fill(int blockIndex) {
        try {
            if (this.activeBlockIndex == blockIndex) {
                return true;
            }
            this.activeBlock = this.blocks.getBlock(blockIndex);
            this.activeBlockIndex = blockIndex;
            this.decompressor.decompress(this.blocks.getAllFields(), this.selected, this.activeBlock.tell(), this.activeBlock.length(), this.activeFieldData);
            return true;
        }
        catch (IOException e) {
            this.activeBlockIndex = -1;
            this.activeBlock = CCFHeader.FAKE_BLOCK;
            throw new CCFComponentException("Error thrown when parsing: " + this.blocks.getFieldGroupName());
        }
    }

    void close() throws IOException {
        this.activeBlockIndex = -1;
        if (this.activeFieldData != null) {
            for (LinkedObjectPool<?> data : this.activeFieldData.values()) {
                data.close();
            }
            this.activeFieldData.clear();
        }
        this.activeBlock = null;
        this.decompressor.close();
    }
}

