/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.ccf;

import edu.sysu.pmglab.RuntimeProperty;
import edu.sysu.pmglab.ccf.Compressor;
import edu.sysu.pmglab.ccf.field.FieldGroupMeta;
import edu.sysu.pmglab.ccf.field.FieldMeta;
import edu.sysu.pmglab.ccf.header.CCFLiteHeader;
import edu.sysu.pmglab.ccf.record.IRecord;
import edu.sysu.pmglab.ccf.type.Box;
import edu.sysu.pmglab.ccf.type.encoder.Encoder;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.io.writer.ChannelWriterStream;
import java.io.IOException;

class CCFFieldGroupEncoder {
    final List<CCFLiteHeader> blocks;
    final Compressor compressor;
    final ChannelWriterStream channel;
    final FieldGroupMeta group;
    final List<FieldEncoder> encoders;
    int currentRecordCount = 0;
    int currentMemoryUsage = 0;

    CCFFieldGroupEncoder(FieldGroupMeta fields, Compressor compressor, ChannelWriterStream channel, List<CCFLiteHeader> blocks) {
        this.compressor = compressor;
        this.channel = channel;
        this.blocks = blocks;
        this.group = fields;
        this.encoders = new List(fields.numOfFields());
        for (FieldMeta field : fields) {
            this.encoders.add(new FieldEncoder(field));
        }
    }

    void write(IRecord record) throws IOException {
        for (FieldEncoder encoder : this.encoders) {
            this.currentMemoryUsage += encoder.encode(record);
        }
        ++this.currentRecordCount;
        if (this.currentMemoryUsage >= RuntimeProperty.DEFAULT_MAX_MEMORY_PER_BLOCK) {
            this.flush();
        } else if (this.currentRecordCount >= RuntimeProperty.DEFAULT_MAX_RECORDS_PER_BLOCK && (this.currentMemoryUsage >= RuntimeProperty.DEFAULT_MIN_MEMORY_TO_FLUSH || this.currentRecordCount >= 262144)) {
            this.flush();
        }
    }

    void flush() throws IOException {
        if (this.currentRecordCount == 0) {
            return;
        }
        int length = 0;
        long pointer = this.channel.tell();
        for (FieldEncoder encoder : this.encoders) {
            length += this.compressor.compress(encoder.encoder, this.channel);
        }
        this.blocks.add(new CCFLiteHeader(pointer, this.currentRecordCount, length));
        this.currentMemoryUsage = 0;
        this.currentRecordCount = 0;
        this.channel.flush();
    }

    void close() throws IOException {
        this.flush();
        for (FieldEncoder encoder : this.encoders) {
            encoder.close();
        }
    }

    static class FieldEncoder {
        final FieldMeta field;
        final Box<?, ?> box;
        final Encoder encoder;

        public FieldEncoder(FieldMeta field) {
            this.field = field;
            this.box = field.type().newBox();
            this.encoder = this.box.getEncoder();
        }

        public void close() {
            this.encoder.close();
            this.box.init();
        }

        public int encode(IRecord record) {
            record.setToBox(this.field, this.box);
            return this.encoder.encode(this.box);
        }
    }
}

