/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.ccf;

import edu.sysu.pmglab.ccf.CCFFieldGroupDecoder;
import edu.sysu.pmglab.ccf.CCFTable;
import edu.sysu.pmglab.ccf.Decompressor;
import edu.sysu.pmglab.ccf.IReaderOption;
import edu.sysu.pmglab.ccf.ReaderOption;
import edu.sysu.pmglab.ccf.field.IFieldCollection;
import edu.sysu.pmglab.ccf.record.BoxRecord;
import edu.sysu.pmglab.ccf.record.IRecord;
import edu.sysu.pmglab.ccf.record.Record;
import edu.sysu.pmglab.container.interval.LongInterval;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.container.pointer.Pointer;
import edu.sysu.pmglab.io.file.LiveFile;
import gnu.trove.map.hash.THashMap;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.Map;

public final class CCFReader
implements Closeable,
AutoCloseable {
    final IReaderOption<?> option;
    final IFieldCollection fields;
    final Map<String, CCFFieldGroupDecoder> readers = new THashMap<String, CCFFieldGroupDecoder>();
    final Decompressor decompressor;
    final BoxRecord record;
    final Pointer pointer;
    private volatile boolean closed = false;

    public CCFReader(String input) throws IOException {
        this((IReaderOption<?>)new ReaderOption(new CCFTable(input), new String[0]).addAllFields());
    }

    public CCFReader(File input) throws IOException {
        this((IReaderOption<?>)new ReaderOption(new CCFTable(input), new String[0]).addAllFields());
    }

    public CCFReader(LiveFile input) throws IOException {
        this((IReaderOption<?>)new ReaderOption(new CCFTable(input), new String[0]).addAllFields());
    }

    public CCFReader(CCFTable input) throws IOException {
        this((IReaderOption<?>)new ReaderOption(input, new String[0]).addAllFields());
    }

    public CCFReader(IReaderOption<?> options) throws IOException {
        this(options, null);
    }

    private CCFReader(IReaderOption<?> options, Pointer pointer) throws IOException {
        this.option = options.asUnmodifiable();
        this.decompressor = new Decompressor(options.getTable());
        this.fields = this.option.getAllFields();
        for (String group : this.fields.getAllFieldGroupNames()) {
            this.readers.put(group, new CCFFieldGroupDecoder(options.getTable().getFieldGroupBlocks(group), this.fields.getFieldGroup(group), this.decompressor));
        }
        this.record = new BoxRecord(this.fields);
        this.pointer = pointer == null ? new Pointer(this.option.numOfRecords()) : pointer;
    }

    public CCFTable getTable() {
        return this.option.getTable();
    }

    public IReaderOption<?> getReaderOption() {
        return this.option;
    }

    public IRecord read() throws IOException {
        if (this.closed) {
            throw new IllegalStateException("IO Stream closed");
        }
        if (this.hasNext()) {
            Record record = new Record(this.record.keys());
            for (CCFFieldGroupDecoder reader : this.readers.values()) {
                reader.read(this.pointer.tell(), record);
            }
            this.pointer.next();
            return record;
        }
        return null;
    }

    public boolean read(IRecord record) throws IOException {
        if (this.closed) {
            throw new IllegalStateException("IO Stream closed");
        }
        if (this.hasNext()) {
            for (String group : this.fields.getAllFieldGroupNames()) {
                if (!record.containsGroup(group)) continue;
                this.readers.get(group).read(this.pointer.tell(), record);
            }
            this.pointer.next();
            return true;
        }
        return false;
    }

    public BoxRecord getRecord() {
        return new BoxRecord(this.record.keys());
    }

    public LongInterval available() {
        return this.pointer.available();
    }

    public Pointer getPointer() {
        return this.pointer.clone();
    }

    public long tell() {
        return this.pointer.tell();
    }

    public boolean hasNext() {
        return this.pointer.hasNext();
    }

    public long remaining() {
        return this.closed ? 0L : this.pointer.remaining();
    }

    public boolean seek(long pointer) throws IOException {
        this.pointer.seek(pointer);
        return true;
    }

    public CCFReader clearLimit() {
        this.pointer.clearLimit();
        return this;
    }

    public CCFReader limit(long min, long max) {
        this.pointer.limit(min, max);
        return this;
    }

    public CCFReader limit(LongInterval interval) {
        this.pointer.limit(interval);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        CCFReader cCFReader = this;
        synchronized (cCFReader) {
            if (this.closed) {
                return;
            }
            this.closed = true;
        }
        try {
            for (CCFFieldGroupDecoder reader : this.readers.values()) {
                reader.close();
            }
        }
        finally {
            this.decompressor.close();
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CCFReader> part(int nParts) throws IOException {
        try {
            List<Pointer> pointers = this.pointer.part(nParts);
            List<CCFReader> readers = new List<CCFReader>();
            for (Pointer pointer : pointers) {
                readers.add(new CCFReader(this.option, pointer));
            }
            List<CCFReader> list = readers;
            return list;
        }
        finally {
            this.close();
        }
    }

    public long numOfRecords() {
        return this.option.numOfRecords();
    }

    public int numOfFields() {
        return this.option.numOfFields();
    }

    public IFieldCollection getAllFields() {
        return this.fields;
    }
}

