/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.ccf;

import edu.sysu.pmglab.RuntimeProperty;
import edu.sysu.pmglab.ccf.field.FieldGroupMeta;
import edu.sysu.pmglab.ccf.field.IFieldCollection;
import edu.sysu.pmglab.ccf.header.CCFHeaders;
import edu.sysu.pmglab.ccf.loader.CCFLoader;
import edu.sysu.pmglab.ccf.loader.Loader;
import edu.sysu.pmglab.ccf.meta.ICCFMeta;
import edu.sysu.pmglab.ccf.meta.ICCFOptions;
import edu.sysu.pmglab.container.circle.ConcurrentCircularMap;
import edu.sysu.pmglab.io.file.LiveFile;
import edu.sysu.pmglab.io.file.LocalFile;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;

public class CCFTable
implements IFieldCollection {
    private static final CCFLoader CCF_LOADER = new CCFLoader();
    private static final ConcurrentCircularMap<LiveFile, CCFTable> BUFFER = new ConcurrentCircularMap(RuntimeProperty.CCF_TABLE_BUFFER);
    final LiveFile file;
    final IFieldCollection fields;
    final Map<String, CCFHeaders> blocks;
    final ICCFMeta meta;
    final ICCFOptions options;
    final long records;

    public CCFTable(File file) throws IOException {
        this(new LocalFile(file), null);
    }

    public CCFTable(File file, Loader loader) throws IOException {
        this(new LocalFile(file), loader);
    }

    public CCFTable(String file) throws IOException {
        this(LiveFile.of(file), null);
    }

    public CCFTable(String file, Loader loader) throws IOException {
        this(LiveFile.of(file), loader);
    }

    public CCFTable(LiveFile file) throws IOException {
        this(file, null);
    }

    public CCFTable(LiveFile file, Loader loader) throws IOException {
        if (loader != null) {
            Object[] objects = loader.load(file);
            this.file = file;
            this.meta = (ICCFMeta)objects[0];
            this.options = (ICCFOptions)objects[1];
            this.fields = (IFieldCollection)objects[2];
            this.blocks = (Map)objects[3];
            this.records = (Long)objects[4];
        } else {
            CCFTable table = BUFFER.get(file);
            if (table == null) {
                Object[] objects = CCF_LOADER.load(file);
                this.file = file;
                this.meta = (ICCFMeta)objects[0];
                this.options = (ICCFOptions)objects[1];
                this.fields = (IFieldCollection)objects[2];
                this.blocks = (Map)objects[3];
                this.records = (Long)objects[4];
                if (BUFFER.capacity() > 0) {
                    BUFFER.put(file, this);
                }
            } else {
                this.file = file;
                this.meta = table.meta;
                this.options = table.options;
                this.fields = table.fields;
                this.blocks = table.blocks;
                this.records = table.records;
            }
        }
    }

    public static void gc() {
        BUFFER.clear();
        System.gc();
    }

    public LiveFile getFile() {
        return this.file;
    }

    public long numOfRecords() {
        return this.records;
    }

    public ICCFMeta getMeta() {
        return this.meta;
    }

    public ICCFOptions getOptions() {
        return this.options;
    }

    public <T> T getOption(String key) {
        return this.options.get(key);
    }

    public <T> T getOption(String key, T defaults) {
        return this.options.getOrDefault(key, defaults);
    }

    public CCFHeaders getFieldGroupBlocks(String name) {
        return this.blocks.get(name);
    }

    public int hashCode() {
        return this.file.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CCFTable table = (CCFTable)o;
        return Objects.equals(this.file, table.file);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("Summary of CCF File:");
        builder.append("\n    CCF File Name: " + this.file);
        builder.append("\n    CCF File Size: " + this.file.formatLength("#.###"));
        builder.append("\n    CCF File Last Modify Time: " + this.file.formatLastModifyTime(null));
        builder.append("\n    Dimension of Value: " + this.fields.numOfFields() + " field" + (this.fields.numOfFields() <= 1 ? "" : "s") + " and " + this.numOfRecords() + " record" + (this.numOfRecords() <= 1L ? "" : "s"));
        builder.append("\n    Fields in FieldGroup (" + this.fields.numOfFieldGroups() + " in total):");
        for (FieldGroupMeta group : this.fields.getAllFieldGroups()) {
            builder.append("\n        ").append(group);
        }
        return builder.toString();
    }

    @Override
    public IFieldCollection getAllFields() {
        return this.fields;
    }
}

