/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.ccf;

import edu.sysu.pmglab.RuntimeProperty;
import edu.sysu.pmglab.bytecode.ByteStream;
import edu.sysu.pmglab.ccf.CCFConfiguration;
import edu.sysu.pmglab.ccf.CCFFieldGroupEncoder;
import edu.sysu.pmglab.ccf.Compressor;
import edu.sysu.pmglab.ccf.field.FieldMeta;
import edu.sysu.pmglab.ccf.field.HybridFieldGroupMetas;
import edu.sysu.pmglab.ccf.field.IFieldCollection;
import edu.sysu.pmglab.ccf.header.CCFLiteHeader;
import edu.sysu.pmglab.ccf.loader.FieldGroupDataCodec;
import edu.sysu.pmglab.ccf.loader.FieldGroupMetaCodec;
import edu.sysu.pmglab.ccf.loader.MetaCodec;
import edu.sysu.pmglab.ccf.loader.OptionCodec;
import edu.sysu.pmglab.ccf.meta.CCFMeta;
import edu.sysu.pmglab.ccf.meta.CCFMetaItem;
import edu.sysu.pmglab.ccf.meta.CCFOptions;
import edu.sysu.pmglab.ccf.meta.ICCFMeta;
import edu.sysu.pmglab.ccf.meta.ICCFOptions;
import edu.sysu.pmglab.ccf.record.BoxRecord;
import edu.sysu.pmglab.ccf.record.IRecord;
import edu.sysu.pmglab.ccf.type.IFieldType;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.io.FileUtils;
import edu.sysu.pmglab.io.reader.ChannelReaderStream;
import edu.sysu.pmglab.io.reader.IReaderStream;
import edu.sysu.pmglab.io.reader.ISeekableReaderStream;
import edu.sysu.pmglab.io.writer.ChannelWriterStream;
import edu.sysu.pmglab.io.writer.IWriterStream;
import edu.sysu.pmglab.io.writer.WriterStream;
import edu.sysu.pmglab.utils.Configurator;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.THashMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystemException;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;

public class CCFWriter {
    final File file;
    final HybridFieldGroupMetas fields;
    final ICCFMeta meta = new CCFMeta();
    final ICCFOptions options = new CCFOptions();
    final AtomicBoolean closed = new AtomicBoolean(false);
    final PartEncoder[] writers;
    final CCFConfiguration configuration;

    private CCFWriter(File output, HybridFieldGroupMetas fields, CCFConfiguration configuration, int nParts) {
        this.file = output;
        this.fields = fields;
        this.configuration = configuration;
        this.writers = new PartEncoder[nParts];
    }

    public static Builder setOutput(String output) {
        return new Builder(new File(output), null);
    }

    public static Builder setOutput(File output) {
        return new Builder(output, null);
    }

    public static Builder setOutput(String output, IFieldCollection fields) {
        return new Builder(new File(output), fields);
    }

    public static Builder setOutput(File output, IFieldCollection fields) {
        return new Builder(output, fields);
    }

    public File getFile() {
        return this.file;
    }

    public IFieldCollection getAllFields() {
        return this.fields;
    }

    public IFieldCollection getAllMandatoryFields() {
        return this.fields.getAllMandatoryFields();
    }

    public IFieldCollection getAllSupplementaryFields() {
        return this.fields.getAllSupplementaryFields();
    }

    public int numOfFields() {
        return this.fields.numOfFields();
    }

    public BoxRecord getRecord() {
        return new BoxRecord(this.fields);
    }

    public ICCFMeta getMeta() {
        return this.meta.asUnmodifiable();
    }

    public ICCFOptions getOptions() {
        return this.options.asUnmodifiable();
    }

    public boolean isClosed() {
        return this.closed.get();
    }

    public void write(IRecord record) throws IOException {
        this.write(0, record);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(int partIndex, IRecord record) throws IOException {
        if (this.closed.get()) {
            throw new IllegalStateException("IO Stream closed");
        }
        if (record == null) {
            return;
        }
        if (this.writers[partIndex] == null) {
            CCFWriter cCFWriter = this;
            synchronized (cCFWriter) {
                if (this.writers[partIndex] == null) {
                    this.writers[partIndex] = new PartEncoder(this, this.configuration);
                }
            }
        }
        this.writers[partIndex].write(record);
    }

    public CCFWriter addOption(CCFMetaItem option) {
        if (this.closed.get()) {
            throw new IllegalStateException("IO Stream closed");
        }
        this.options.add(option);
        return this;
    }

    public CCFWriter addOptions(Iterable<CCFMetaItem> options) {
        if (this.closed.get()) {
            throw new IllegalStateException("IO Stream closed");
        }
        this.options.adds(options);
        return this;
    }

    public CCFWriter addMeta(CCFMetaItem meta) {
        if (this.closed.get()) {
            throw new IllegalStateException("IO Stream closed");
        }
        this.meta.add(meta);
        return this;
    }

    public CCFWriter addMeta(Iterable<CCFMetaItem> metas) {
        if (this.closed.get()) {
            throw new IllegalStateException("IO Stream closed");
        }
        this.meta.adds(metas);
        return this;
    }

    public CCFWriter finish(int partIndex) throws IOException {
        if (this.writers[partIndex] != null) {
            this.writers[partIndex].close();
        }
        return this;
    }

    public synchronized void close() throws IOException {
        if (this.closed.get()) {
            return;
        }
        this.closed.set(true);
        if (this.file.exists()) {
            FileUtils.deleteFile(this.file);
            if (this.file.exists()) {
                throw new FileSystemException("Readonly file stream: " + this.file);
            }
        }
        try (WriterStream output = new WriterStream(this.file, WriterStream.Option.DEFAULT);){
            MetaCodec.saveTo(this.meta, output);
            OptionCodec.saveTo(this.options, (IWriterStream)output);
            FieldGroupMetaCodec.saveTo(this.fields, output);
            for (PartEncoder writer : this.writers) {
                if (writer == null) continue;
                writer.close();
            }
            int groupIndex = 0;
            for (String groupName : this.fields.getAllFieldGroupNames()) {
                ByteStream temp = ByteStream.getThreadInstance();
                temp.putVarInt32(groupIndex++);
                temp.putVarInt32(0);
                int numOfBlocks = 0;
                for (PartEncoder writer : this.writers) {
                    if (writer == null) continue;
                    numOfBlocks += writer.getBlocks().get(groupName).size();
                }
                temp.putVarInt32(numOfBlocks);
                long length = 0L;
                for (PartEncoder writer : this.writers) {
                    if (writer == null) continue;
                    for (CCFLiteHeader block : writer.getBlocks().get(groupName)) {
                        temp.putVarInt32(block.numOfRecords());
                        temp.putVarInt32(block.length());
                        length += (long)block.length();
                    }
                }
                output.write(FieldGroupDataCodec.getType().ordinal());
                output.writeLong((long)temp.length() + length, 8);
                output.write(temp.bytes(), temp.offset(), temp.length());
                for (PartEncoder writer : this.writers) {
                    if (writer == null) continue;
                    ChannelReaderStream reader = new ChannelReaderStream(writer.getChannel());
                    for (CCFLiteHeader block : writer.getBlocks().get(groupName)) {
                        int byteToWrite;
                        ((ISeekableReaderStream)reader).seek(block.pointer());
                        for (int count = block.length(); count > 0; count -= byteToWrite) {
                            byteToWrite = ((IReaderStream)reader).read(temp.bytes(), 0, Math.min(temp.capacity(), count));
                            output.write(temp.bytes(), 0, byteToWrite);
                        }
                    }
                    ((IReaderStream)reader).close();
                }
            }
        }
        catch (IOException e) {
            throw new IOException("Failed to close CCFWriter", e);
        }
    }

    public int numOfParts() {
        return this.writers.length;
    }

    public long numOfRecords() {
        long count = 0L;
        for (PartEncoder writer : this.writers) {
            if (writer == null) continue;
            count += writer.numOfRecords();
        }
        return count;
    }

    private static class PartEncoder
    implements AutoCloseable,
    Closeable {
        final ChannelWriterStream channel;
        final TIntObjectMap<Compressor> compressors;
        final CCFFieldGroupEncoder[] encoders;
        final Map<String, List<CCFLiteHeader>> blocks = new THashMap<String, List<CCFLiteHeader>>();
        final AtomicLong counter = new AtomicLong(0L);
        final AtomicBoolean closed = new AtomicBoolean(false);

        PartEncoder(CCFWriter parent, CCFConfiguration configuration) throws IOException {
            this.channel = new ChannelWriterStream(RuntimeProperty.createTempFile());
            this.compressors = new TIntObjectHashMap<Compressor>();
            this.encoders = new CCFFieldGroupEncoder[parent.fields.numOfFieldGroups()];
            int index = 0;
            for (String group : parent.getAllFields().getAllFieldGroupNames()) {
                int level = configuration.getCompressorLevel(group);
                if (!this.compressors.containsKey(level)) {
                    this.compressors.put(level, new Compressor(level));
                }
                List<CCFLiteHeader> blocks = new List<CCFLiteHeader>();
                this.blocks.put(group, blocks);
                this.encoders[index++] = new CCFFieldGroupEncoder(parent.getAllFields().getFieldGroup(group), this.compressors.get(level), this.channel, blocks);
            }
        }

        void write(IRecord record) throws IOException {
            if (this.closed.get()) {
                throw new IllegalStateException("Partial IO Stream closed");
            }
            for (CCFFieldGroupEncoder encoder : this.encoders) {
                encoder.write(record);
            }
            this.counter.addAndGet(1L);
        }

        @Override
        public synchronized void close() throws IOException {
            if (!this.closed.get()) {
                this.closed.set(true);
                for (CCFFieldGroupEncoder encoder : this.encoders) {
                    encoder.close();
                }
                for (int level : this.compressors.keys()) {
                    this.compressors.get(level).close();
                }
                this.channel.close();
            }
        }

        long numOfRecords() {
            return this.counter.get();
        }

        Map<String, List<CCFLiteHeader>> getBlocks() {
            return this.blocks;
        }

        File getChannel() {
            return this.channel.getFile();
        }
    }

    public static final class Builder {
        final File file;
        final HybridFieldGroupMetas fields;
        final CCFConfiguration configuration = new CCFConfiguration();

        private Builder(File file, IFieldCollection mandatoryFields) {
            if (file == null) {
                throw new NullPointerException("Illegal file path: null");
            }
            this.file = file;
            this.fields = new HybridFieldGroupMetas(mandatoryFields);
        }

        public Builder addField(FieldMeta field) {
            this.fields.addField(field);
            return this;
        }

        public Builder addField(String name, IFieldType type) {
            return this.addField(FieldMeta.of(name, type));
        }

        public Builder addField(String group, String name, IFieldType type) {
            return this.addField(FieldMeta.of(group, name, type));
        }

        public Builder addFields(FieldMeta ... fields) {
            if (fields != null) {
                for (FieldMeta field : fields) {
                    this.addField(field);
                }
            } else {
                this.addField(null);
            }
            return this;
        }

        public Builder addFields(Iterable<FieldMeta> fields) {
            if (fields != null) {
                for (FieldMeta field : fields) {
                    this.addField(field);
                }
            } else {
                this.addField(null);
            }
            return this;
        }

        public int numOfFields() {
            return this.fields.numOfFields();
        }

        public Builder clearFields() {
            this.fields.clear();
            return this;
        }

        public IFieldCollection getAllFields() {
            return this.fields;
        }

        public boolean isModifiable() {
            return this.fields.isModifiable();
        }

        public IFieldCollection getAllMandatoryFields() {
            return this.fields.getAllMandatoryFields();
        }

        public IFieldCollection getAllSupplementaryFields() {
            return this.fields.getAllSupplementaryFields();
        }

        public Builder configureFileOptions(Configurator<CCFConfiguration> consumer) {
            if (!this.fields.isModifiable()) {
                throw new IllegalStateException("This object is immutable");
            }
            if (consumer != null) {
                consumer.configure(this.configuration);
            }
            return this;
        }

        public File getFile() {
            return this.file;
        }

        public CCFWriter instance() {
            return this.instance(1);
        }

        public CCFWriter instance(int nParts) {
            this.fields.asUnmodifiable();
            return new CCFWriter(this.file, this.fields, this.configuration, nParts);
        }
    }
}

