/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.ccf;

import edu.sysu.pmglab.RuntimeProperty;
import edu.sysu.pmglab.bytecode.ByteStream;
import edu.sysu.pmglab.ccf.compressor.ICompressor;
import edu.sysu.pmglab.ccf.type.encoder.Encoder;
import java.io.IOException;
import java.io.OutputStream;

class Compressor {
    final ICompressor compressor;
    final ByteStream sizer = new ByteStream(8);

    public Compressor() {
        this.compressor = ICompressor.getInstance(RuntimeProperty.DEFAULT_COMPRESSOR, RuntimeProperty.DEFAULT_COMPRESSION_LEVEL);
    }

    public Compressor(int level) {
        this.compressor = ICompressor.getInstance(RuntimeProperty.DEFAULT_COMPRESSOR, level);
    }

    public int compress(Encoder<?> encoder, OutputStream output) throws IOException {
        ByteStream container = ByteStream.getThreadInstance();
        this.sizer.clear();
        this.compressor.compress(encoder.flush(), container);
        this.sizer.putVarInt32(container.length());
        output.write(this.sizer.bytes(), this.sizer.offset(), this.sizer.length());
        output.write(container.bytes(), container.offset(), container.length());
        return this.sizer.length() + container.length();
    }

    public void close() throws IOException {
        this.compressor.close();
        this.sizer.close();
    }
}

