/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.ccf;

import edu.sysu.pmglab.RuntimeProperty;
import edu.sysu.pmglab.bytecode.ByteStream;
import edu.sysu.pmglab.bytecode.Bytes;
import edu.sysu.pmglab.ccf.CCFTable;
import edu.sysu.pmglab.ccf.compressor.IDecompressor;
import edu.sysu.pmglab.ccf.field.FieldGroupMeta;
import edu.sysu.pmglab.ccf.field.FieldMeta;
import edu.sysu.pmglab.io.reader.ReaderStream;
import edu.sysu.pmglab.objectpool.LinkedObjectPool;
import gnu.trove.map.hash.THashMap;
import java.io.IOException;

class Decompressor {
    private static final ThreadLocal<ByteStream> readInCaches = ThreadLocal.withInitial(ByteStream::new);
    private static final ThreadLocal<ByteStream> decompressedCaches = ThreadLocal.withInitial(ByteStream::new);
    final IDecompressor decompressor = IDecompressor.getInstance(RuntimeProperty.DEFAULT_DECOMPRESSOR);
    final ReaderStream reader;
    final Bytes wrapper = new Bytes();

    Decompressor(CCFTable table) throws IOException {
        this.reader = new ReaderStream(table.getFile().openAsBinary(), 1024);
    }

    boolean decompress(FieldGroupMeta fullFields, FieldGroupMeta subfields, long blockSeek, int blockDataLength, THashMap<FieldMeta, LinkedObjectPool<?>> values2) throws IOException {
        ByteStream readInCache = readInCaches.get().clear();
        ByteStream decompressedCache = decompressedCaches.get().clear();
        readInCache.clear();
        this.reader.seek(blockSeek);
        int count = 0;
        int requires = subfields.numOfFields();
        if (subfields.numOfFields() == fullFields.numOfFields() || blockDataLength < 1024) {
            this.reader.read(readInCache, blockDataLength);
            for (FieldMeta field : fullFields) {
                int length = readInCache.getVarInt32();
                if (subfields.containsField(field)) {
                    decompressedCache.clear();
                    readInCache.getBytes(this.wrapper, length);
                    this.decompressor.decompress(this.wrapper, decompressedCache);
                    decompressedCache.toBytes(this.wrapper);
                    LinkedObjectPool<?> boxes = values2.get(field);
                    boxes.clear();
                    field.type().getSeqDecoder().decodeTo(this.wrapper, boxes);
                    if (requires != ++count) continue;
                    break;
                }
                readInCache.rSkip(length);
            }
        } else {
            for (FieldMeta field : fullFields) {
                int length = this.reader.readVarInt32();
                if (subfields.containsField(field)) {
                    readInCache.clear();
                    this.reader.read(readInCache, length);
                    decompressedCache.clear();
                    readInCache.getBytes(this.wrapper, length);
                    this.decompressor.decompress(this.wrapper, decompressedCache);
                    decompressedCache.toBytes(this.wrapper);
                    LinkedObjectPool<?> boxes = values2.get(field);
                    boxes.clear();
                    field.type().getSeqDecoder().decodeTo(this.wrapper, boxes);
                    if (requires != ++count) continue;
                    break;
                }
                this.reader.skip(length);
            }
        }
        return true;
    }

    void close() throws IOException {
        this.decompressor.close();
        this.reader.close();
        this.wrapper.reset(Bytes.EMPTY);
    }
}

