/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.ccf;

import edu.sysu.pmglab.ccf.CCFTable;
import edu.sysu.pmglab.ccf.field.FieldGroupMeta;
import edu.sysu.pmglab.ccf.field.FieldMeta;
import edu.sysu.pmglab.ccf.field.HybridFieldGroupMetas;
import edu.sysu.pmglab.ccf.field.IFieldCollection;
import edu.sysu.pmglab.io.file.LiveFile;
import java.io.File;
import java.io.IOException;

public abstract class IReaderOption<T extends IReaderOption<T>>
implements IFieldCollection {
    final CCFTable table;
    final HybridFieldGroupMetas fields;

    public IReaderOption(File table, String ... mandatory) throws IOException {
        if (table == null) {
            throw new NullPointerException("Invalid input file: null");
        }
        this.table = new CCFTable(table);
        this.fields = new HybridFieldGroupMetas(this.table.subsetFields(mandatory));
    }

    public IReaderOption(CCFTable table, String ... mandatory) {
        if (table == null) {
            throw new NullPointerException("Invalid input file: null");
        }
        this.table = table;
        this.fields = new HybridFieldGroupMetas(this.table.subsetFields(mandatory));
    }

    public IReaderOption(CCFTable table, IFieldCollection mandatory) {
        if (table == null) {
            throw new NullPointerException("Invalid input file: null");
        }
        this.table = table;
        this.fields = new HybridFieldGroupMetas(this.table.getAllFields().intersectFields(mandatory));
    }

    public final CCFTable getTable() {
        return this.table;
    }

    public final LiveFile getFile() {
        return this.table.getFile();
    }

    public final T clearFields() {
        this.fields.clear();
        return (T)this;
    }

    public final T addAllFields() {
        this.fields.clear();
        for (FieldMeta field : this.table.getAllFields()) {
            this.addField(field);
        }
        return (T)this;
    }

    public final T addField(String field) {
        if (field == null) {
            return (T)this;
        }
        this.addField(this.table.getField(field));
        return (T)this;
    }

    public T addField(FieldMeta field) {
        if (field == null) {
            return (T)this;
        }
        if (this.table.containsField(field)) {
            this.fields.addField(field);
        }
        return (T)this;
    }

    public final T addFields(String ... fields) {
        if (fields == null) {
            return (T)this;
        }
        for (String name : fields) {
            if (name == null) continue;
            FieldMeta field = this.table.getField(name);
            this.addField(field);
        }
        return (T)this;
    }

    public final T addFields(IFieldCollection fields) {
        if (fields == null || fields == this.fields) {
            return (T)this;
        }
        for (FieldMeta field : fields) {
            this.addField(field);
        }
        return (T)this;
    }

    public final T addFields(FieldMeta ... fields) {
        if (fields == null) {
            return (T)this;
        }
        for (FieldMeta field : fields) {
            this.addField(field);
        }
        return (T)this;
    }

    public final T addFields(Iterable<String> fields) {
        if (fields == null) {
            return (T)this;
        }
        for (String name : fields) {
            if (name == null) continue;
            FieldMeta field = this.table.getField(name);
            this.addField(field);
        }
        return (T)this;
    }

    public final T addFieldGroup(String groupName) {
        FieldGroupMeta group = this.table.getFieldGroup(groupName);
        if (group != null) {
            for (FieldMeta field : group) {
                this.addField(field);
            }
        }
        return (T)this;
    }

    public final T addFieldGroups(String ... groups2) {
        if (groups2 == null) {
            return (T)this;
        }
        for (String groupName : groups2) {
            FieldGroupMeta group = this.table.getFieldGroup(groupName);
            if (group == null) continue;
            for (FieldMeta field : group) {
                this.addField(field);
            }
        }
        return (T)this;
    }

    public final T addFieldGroups(Iterable<String> groups2) {
        if (groups2 == null) {
            return (T)this;
        }
        for (String groupName : groups2) {
            FieldGroupMeta group = this.table.getFieldGroup(groupName);
            if (group == null) continue;
            for (FieldMeta field : group) {
                this.addField(field);
            }
        }
        return (T)this;
    }

    @Override
    public final IFieldCollection getAllFields() {
        return this.fields.getAllFields();
    }

    @Override
    public int numOfFields() {
        return this.fields.numOfFields();
    }

    @Override
    public int numOfFieldGroups() {
        return this.fields.numOfFieldGroups();
    }

    @Override
    public final boolean isModifiable() {
        return this.fields.isModifiable();
    }

    public final T asUnmodifiable() {
        this.fields.asUnmodifiable();
        return (T)this;
    }

    public final IFieldCollection getAllMandatoryFields() {
        return this.fields.getAllMandatoryFields();
    }

    public final IFieldCollection getAllSupplementaryFields() {
        return this.fields.getAllSupplementaryFields();
    }

    public final long numOfRecords() {
        return this.table.numOfRecords();
    }

    public abstract T clone();
}

