/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.ccf;

import edu.sysu.pmglab.bytecode.ByteStream;
import edu.sysu.pmglab.bytecode.Bytes;
import edu.sysu.pmglab.ccf.exception.CCFCodingException;
import edu.sysu.pmglab.ccf.exception.CCFComponentException;
import edu.sysu.pmglab.ccf.field.FieldGroupMeta;
import edu.sysu.pmglab.ccf.field.IFieldCollection;
import edu.sysu.pmglab.ccf.meta.CCFMeta;
import edu.sysu.pmglab.ccf.meta.CCFMetaItem;
import edu.sysu.pmglab.ccf.meta.ICCFMeta;
import edu.sysu.pmglab.ccf.record.IRecord;
import edu.sysu.pmglab.ccf.record.MapRecord;
import edu.sysu.pmglab.ccf.record.Record;
import edu.sysu.pmglab.ccf.toolkit.filter.IFilter;
import edu.sysu.pmglab.ccf.type.Box;
import edu.sysu.pmglab.ccf.type.IFieldType;
import edu.sysu.pmglab.ccf.type.encoder.Encoder;
import edu.sysu.pmglab.container.list.List;
import gnu.trove.map.hash.THashMap;
import java.util.Comparator;
import java.util.function.Function;

public class LiteTable
implements IFieldCollection {
    private static final LiteTable EMPTY = new LiteTable((String)null).asUnmodifiable();
    final FieldGroupMeta fields;
    final List<IRecord> records;
    final ICCFMeta meta;

    public LiteTable() {
        this.fields = new FieldGroupMeta();
        this.records = new List();
        this.meta = new CCFMeta();
    }

    public LiteTable(String group) {
        this.fields = new FieldGroupMeta(group);
        this.records = new List();
        this.meta = new CCFMeta();
    }

    public LiteTable(FieldGroupMeta fields) {
        this.fields = fields;
        this.records = new List();
        this.meta = new CCFMeta();
    }

    private LiteTable(FieldGroupMeta fields, List<IRecord> records, ICCFMeta metas) {
        this.fields = fields;
        this.records = records;
        this.meta = metas;
    }

    public static LiteTable decode(Bytes codec) {
        int i;
        if (codec == null || codec.length() == 0) {
            return EMPTY;
        }
        ByteStream reader = codec.toByteStream();
        ICCFMeta metas = ICCFMeta.decode(reader.getBytes());
        FieldGroupMeta fields = FieldGroupMeta.load(reader.getBytes());
        int numOfRecords = reader.getVarInt32();
        if (numOfRecords == 0) {
            if (reader.rRemaining() > 0) {
                throw new CCFCodingException("Invalid input length");
            }
            reader.close();
            return new LiteTable(fields, List.EMPTY(), metas);
        }
        List<IRecord> records = new List<IRecord>(numOfRecords);
        if (fields.numOfFields() == 0) {
            for (i = 0; i < numOfRecords; ++i) {
                records.add(IRecord.EMPTY);
            }
        } else {
            for (i = 0; i < numOfRecords; ++i) {
                records.add(new Record(fields));
            }
        }
        for (i = 0; i < fields.numOfFields(); ++i) {
            Object[] values2 = fields.getField(i).type().decodeSeq(reader.getBytes());
            if (values2.length != numOfRecords) {
                throw new CCFComponentException("LiteTable '" + fields.groupName() + "' contains a record count inconsistent with the expected quantity of " + numOfRecords);
            }
            for (int j = 0; j < numOfRecords; ++j) {
                ((IRecord)records.fastGet(j)).set(i, values2[j]);
            }
        }
        if (reader.rRemaining() > 0) {
            throw new CCFCodingException("Invalid input length");
        }
        reader.close();
        return new LiteTable(fields, records.apply(IRecord::asUnmodifiable).asUnmodifiable(), metas);
    }

    public Bytes encode() {
        ByteStream container = new ByteStream();
        container.putBytes(this.meta.encode(), true);
        container.putBytes(this.fields.save(), true);
        container.putVarInt32(this.records.size());
        if (this.records.size() > 0) {
            THashMap encoders = new THashMap();
            THashMap boxes = new THashMap();
            for (int i = 0; i < this.numOfFields(); ++i) {
                Box box;
                Encoder encoder;
                IFieldType type = this.getFieldType(i);
                if (!encoders.containsKey(type)) {
                    encoder = type.getSeqEncoder();
                    encoders.put(type, encoder);
                    box = type.newBox();
                    boxes.put(type, box);
                } else {
                    encoder = (Encoder)encoders.get(type);
                    box = (Box)boxes.get(type);
                }
                for (IRecord record : this.records) {
                    encoder.encode(box.set(record.get(i)));
                }
                container.putBytes(encoder.flush(), true);
            }
            for (Encoder encoder : encoders.values()) {
                encoder.close();
            }
            encoders.clear();
            boxes.clear();
        }
        return container.toBytes();
    }

    public LiteTable addField(String simple, IFieldType type) {
        this.fields.addField(this.fields.groupName(), simple, type);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRecord alloc() {
        if (!this.fields.isModifiable()) {
            if (this.fields.numOfFields() == 0) {
                LiteTable liteTable = this;
                synchronized (liteTable) {
                    this.records.add(IRecord.EMPTY);
                }
                return IRecord.EMPTY;
            }
            Record record = new Record(this.fields);
            LiteTable liteTable = this;
            synchronized (liteTable) {
                this.records.add(record);
            }
            return record;
        }
        MapRecord record = new MapRecord(this.fields);
        LiteTable liteTable = this;
        synchronized (liteTable) {
            this.records.add(record);
        }
        return record;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRecord addRecord(IRecord source2) {
        if (source2 == null) {
            throw new NullPointerException();
        }
        if (!this.fields.isModifiable()) {
            if (this.fields.numOfFields() == 0) {
                LiteTable liteTable = this;
                synchronized (liteTable) {
                    this.records.add(IRecord.EMPTY);
                }
                return IRecord.EMPTY;
            }
            Record record = new Record(this.fields);
            LiteTable liteTable = this;
            synchronized (liteTable) {
                this.records.add(record);
            }
            record.setFrom(source2, false);
            return record;
        }
        MapRecord target = new MapRecord(this.fields);
        LiteTable liteTable = this;
        synchronized (liteTable) {
            this.records.add(target);
        }
        target.setFrom(source2, false);
        return target;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LiteTable addRecords(Iterable<IRecord> records) {
        if (records == null) {
            return this;
        }
        LiteTable liteTable = this;
        synchronized (liteTable) {
            if (!this.fields.isModifiable()) {
                if (this.fields.numOfFields() == 0) {
                    for (IRecord source2 : records) {
                        this.records.add(IRecord.EMPTY);
                    }
                } else {
                    for (IRecord source3 : records) {
                        if (source3 == null) continue;
                        Record target = new Record(this.fields);
                        this.records.add(target);
                        target.setFrom(source3, false);
                    }
                }
            } else {
                for (IRecord source4 : records) {
                    if (source4 == null) continue;
                    MapRecord target = new MapRecord(this.fields);
                    this.records.add(target);
                    target.setFrom(source4, false);
                }
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRecord alloc(Object ... values2) {
        if (!this.fields.isModifiable()) {
            if (this.fields.numOfFields() == 0) {
                this.records.add(IRecord.EMPTY);
                return IRecord.EMPTY;
            }
            Record record = new Record(this.fields);
            LiteTable liteTable = this;
            synchronized (liteTable) {
                this.records.add(record);
            }
            int l = Math.min(this.fields.numOfFields(), values2.length);
            for (int i = 0; i < l; ++i) {
                if (values2[i] == null) continue;
                ((IRecord)record).set(i, values2[i]);
            }
            return record;
        }
        MapRecord record = new MapRecord(this.fields);
        LiteTable i = this;
        synchronized (i) {
            this.records.add(record);
        }
        int l = Math.min(this.fields.numOfFields(), values2.length);
        for (int i2 = 0; i2 < l; ++i2) {
            if (values2[i2] == null) continue;
            record.set(i2, values2[i2]);
        }
        return record;
    }

    public IRecord get(int recordIndex) {
        return this.records.get(recordIndex);
    }

    public <V> V get(int recordIndex, String field) {
        return (V)this.records.get(recordIndex).get(field);
    }

    public <V> V get(int recordIndex, int fieldIndex) {
        return (V)this.records.get(recordIndex).get(fieldIndex);
    }

    public <V> LiteTable set(int recordIndex, String field, V value) {
        this.records.get(recordIndex).set(field, value);
        return this;
    }

    public <V> LiteTable set(int recordIndex, int fieldIndex, V value) {
        this.records.get(recordIndex).set(fieldIndex, value);
        return this;
    }

    public int numOfRecords() {
        return this.records.size();
    }

    @Override
    public FieldGroupMeta getAllFields() {
        return this.fields;
    }

    @Override
    public boolean isModifiable() {
        return this.records.isModifiable();
    }

    @Override
    public LiteTable asUnmodifiable() {
        if (this.records.isModifiable()) {
            return new LiteTable(this.fields.asUnmodifiable(), this.records.apply(IRecord::asUnmodifiable).asUnmodifiable(), this.meta.asUnmodifiable());
        }
        return this;
    }

    public String getName() {
        return this.fields.groupName();
    }

    public LiteTable clear() {
        this.fields.clear();
        this.records.clear();
        this.meta.clear();
        return this;
    }

    public LiteTable clearRecords() {
        this.records.clear();
        return this;
    }

    public LiteTable clearMetas() {
        this.meta.clear();
        return this;
    }

    public void sort(Comparator<IRecord> comparator) {
        if (comparator != null) {
            this.records.sort(comparator);
        }
    }

    public <T> List<T> apply(Function<IRecord, T> function) {
        return this.apply(function, null);
    }

    public <T> List<T> apply(Function<IRecord, T> function, IFilter<T> filter) {
        List<T> returns = new List<T>(this.numOfRecords());
        for (IRecord field : this.records) {
            T object = function.apply(field);
            if (filter != null && !filter.filter(object)) continue;
            returns.add(object);
        }
        return returns;
    }

    public ICCFMeta getMeta() {
        return this.meta.asUnmodifiable();
    }

    public LiteTable addMeta(CCFMetaItem meta) {
        this.meta.add(meta);
        return this;
    }

    public LiteTable addMeta(Iterable<CCFMetaItem> metas) {
        this.meta.adds(metas);
        return this;
    }

    public LiteTable dropDuplicateMeta() {
        this.meta.dropDuplicates();
        return this;
    }

    public List<CCFMetaItem> getMeta(String key) {
        return this.meta.get(key);
    }

    public <T> List<T> getMetaValues(String key) {
        return this.meta.getValues(key);
    }

    public Iterable<CCFMetaItem> getMeta(IFilter<CCFMetaItem> filter) {
        return this.meta.filter(filter);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.meta.size() > 0) {
            for (CCFMetaItem meta : this.meta) {
                builder.append("##");
                builder.append(meta);
                builder.append("\n");
            }
        }
        builder.append("#INDEX");
        int l = this.numOfFields();
        for (int i = 0; i < l; ++i) {
            builder.append("\t").append(this.getField(i).simpleName());
        }
        int index = 0;
        for (IRecord data : this.records) {
            builder.append("\n").append(index++);
            int l2 = this.numOfFields();
            for (int i = 0; i < l2; ++i) {
                Object value = data.get(i);
                if (value == null) {
                    builder.append("\t").append("NA");
                    continue;
                }
                builder.append("\t").append(value);
            }
        }
        return builder.toString();
    }

    public Iterable<IRecord> records() {
        return this.records;
    }
}

