/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.ccf.command;

import edu.sysu.pmglab.LogBackOptions;
import edu.sysu.pmglab.ccf.command.GUIProgram;
import edu.sysu.pmglab.commandParser.CommandOptions;
import edu.sysu.pmglab.commandParser.ICommandProgram;
import edu.sysu.pmglab.commandParser.annotation.option.EntryOption;
import edu.sysu.pmglab.commandParser.annotation.usage.OptionUsage;
import edu.sysu.pmglab.commandParser.annotation.usage.Parser;
import edu.sysu.pmglab.commandParser.annotation.usage.UsageItem;
import edu.sysu.pmglab.commandParser.example.DownloaderProgram;
import edu.sysu.pmglab.commandParser.example.MD5Program;
import edu.sysu.pmglab.gtb.command.GBCEntry;
import edu.sysu.pmglab.gtb.genome.coordinate.Chromosome;
import edu.sysu.pmglab.io.file.Channel;
import edu.sysu.pmglab.runtimecompiler.JavaCompiler;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Parser(usage="ccf [options]", usage_item={@UsageItem(key="Version", value={"stable-4 (last edited on 2025.06.01)"})}, delegation={JavaCompiler.class, Channel.class, LogBackOptions.class, Chromosome.class})
public class CCFEntry
extends ICommandProgram {
    private static final Logger LOGGER = LoggerFactory.getLogger(CCFEntry.class);
    @EntryOption(value={"build"})
    @OptionUsage(description={"Compress and build a Columnar Chunked Format (CCF) file from one or more input files."}, format="build <file> <file> ... [options]")
    String[] build;
    @EntryOption(value={"export"})
    @OptionUsage(description={"Convert records from one or more Columnar Chunked Format (CCF) files into a single text file."}, format="export <input> <input> ... [options]")
    String[] export;
    @EntryOption(value={"gui"})
    @OptionUsage(description={"Display the *.ccf file in the visualization software window."}, format="gui <input> [options]")
    String[] gui;
    @EntryOption(value={"mat-gui"})
    @OptionUsage(description={"Display the *.mat file in the visualization software window."}, format="mat-gui <input> [options]")
    String[] matGui;
    @EntryOption(value={"inspect"})
    @OptionUsage(description={"Display detailed information on one *.ccf."}, format="inspect <input> [options]")
    String[] inspect;
    @EntryOption(value={"make-litetable"})
    @OptionUsage(description={"Create a LiteTable, an advanced README file storage structure for storing table-style metadata and auxiliary information."}, format="make-litetable <input> [options]")
    String[] makeLitetable;
    @EntryOption(value={"gbc"}, retain=false)
    @OptionUsage(description={"Compress, decompress, access, manage, annotate and compute large-scale genotypes (or genomic information) using the Genotype Block Compressor (GBC, implemented based on CCF)."}, group="Extension Toolkit Options", format="gbc [options]")
    String[] gbc;
    @EntryOption(value={"batch"})
    @OptionUsage(description={""}, group="Extension Toolkit Options", format="batch [options]")
    String[] batch;
    @EntryOption(value={"download"})
    @OptionUsage(description={"Download resource files from specified DOCKER/SFTP/HTTP/HTTPS address."}, group="Extension Toolkit Options", format="download <url> [options]")
    String[] download;
    @EntryOption(value={"md5"})
    @OptionUsage(description={"Calculate the message digest fingerprint (checksum) for the specified file(s)."}, group="Extension Toolkit Options", format="md5 <input> <input> ... [options]")
    String[] md5;
    @EntryOption(value={"bgzip"})
    @OptionUsage(description={"Calculate the message digest fingerprint (checksum) for the specified file(s)."}, group="Extension Toolkit Options", format="gzip2bgzip <input> <input> ... [options]")
    String[] gzip2bgzip;

    public static void main(String[] args) throws IOException {
        LogBackOptions.init();
        CCFEntry program = new CCFEntry();
        CommandOptions options = program.parse(args);
        if (options.isHelp()) {
            LOGGER.info("\n{}", (Object)options.usage());
            return;
        }
        if (options.passed("build")) {
            return;
        }
        if (options.passed("export")) {
            return;
        }
        if (options.passed("gui")) {
            GUIProgram.main((String[])options.value("gui"));
            return;
        }
        if (options.passed("inspect")) {
            return;
        }
        if (options.passed("make-litetable")) {
            return;
        }
        if (options.passed("batch")) {
            return;
        }
        if (options.passed("gbc")) {
            GBCEntry.main((String[])options.value("gbc"));
            return;
        }
        if (options.passed("download")) {
            DownloaderProgram.main((String[])options.value("download"));
            return;
        }
        if (options.passed("md5")) {
            MD5Program.main((String[])options.value("md5"));
            return;
        }
        if (options.passed("mat-gui")) {
            return;
        }
    }
}

