/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.ccf.command;

import edu.sysu.pmglab.ccf.CCFTable;
import edu.sysu.pmglab.ccf.IReaderOption;
import edu.sysu.pmglab.ccf.ReaderOption;
import edu.sysu.pmglab.ccf.filter.CCFFilter;
import edu.sysu.pmglab.ccf.type.FieldType;
import edu.sysu.pmglab.ccf.viewer.CCFViewer;
import edu.sysu.pmglab.ccf.viewer.CCFViewerReader;
import edu.sysu.pmglab.commandParser.CommandOptions;
import edu.sysu.pmglab.commandParser.ICommandProgram;
import edu.sysu.pmglab.commandParser.annotation.option.Container;
import edu.sysu.pmglab.commandParser.annotation.option.Option;
import edu.sysu.pmglab.commandParser.annotation.usage.OptionUsage;
import edu.sysu.pmglab.commandParser.annotation.usage.Parser;
import edu.sysu.pmglab.commandParser.annotation.usage.UsageItem;
import edu.sysu.pmglab.commandParser.validator.range.Int_0_RangeValidator;
import edu.sysu.pmglab.container.interval.LongInterval;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.io.file.LiveFile;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Parser(usage="gui <file> [options]", usage_item={@UsageItem(key="API", value={"edu.sysu.pmglab.ccf.viewer.CCFViewer"}), @UsageItem(key="About", value={"Display the *.ccf file in the visualization software window."})})
class GUIProgram
extends ICommandProgram {
    private static final Logger LOGGER = LoggerFactory.getLogger(GUIProgram.class);
    @Option(names={"gui"}, type=FieldType.livefile, required=true)
    LiveFile input;
    @Option(names={"--field", "-f"}, type=FieldType.string, container=Container.LIST)
    @OptionUsage(description={"Specify the fields to be read from the input file.", "If not specified, all fields will be read."}, format="--field <string> <string> ...")
    List<String> fields = null;
    @Option(names={"--index-range", "-ir"}, type=FieldType.longInterval)
    @OptionUsage(description={"Retrieve records within a specified range of record indices from 'min' (inclusive) to 'max' (exclusive)."}, format="--index-range <min>~<max>")
    LongInterval range = null;
    @Option(names={"--page-size", "-s"}, type=FieldType.varInt32, validator=Int_0_RangeValidator.class)
    @OptionUsage(description={"Set the number of records displayed per page."}, format="--page-size <int, >=10>")
    int pagesize = 100;
    @Option(names={"--compat-mode", "-c"}, type=FieldType.NULL)
    @OptionUsage(description={"Display the graphical window in compatibility mode (use when the table layout is abnormal)."})
    boolean compat = false;

    GUIProgram() {
    }

    public static void main(String[] args) throws IOException {
        String[] stringArray;
        GUIProgram program = new GUIProgram();
        if (args.length == 1 && args[0].equals("gui")) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "--help";
        } else {
            stringArray = args;
        }
        CommandOptions options = program.parse(stringArray);
        if (options.isHelp()) {
            LOGGER.info("\n{}", (Object)options.usage());
            return;
        }
        CCFTable table = new CCFTable(program.input);
        CCFFilter filter = null;
        if (options.passed("--index-range")) {
            filter = new CCFFilter(new ReaderOption(table, false)).limit(program.range);
        }
        if (program.fields == null) {
            new CCFViewer(new CCFViewerReader((IReaderOption<?>)new ReaderOption(table, new String[0]).addAllFields(), filter), program.pagesize, program.compat);
        } else {
            new CCFViewer(new CCFViewerReader((IReaderOption<?>)new ReaderOption(table, new String[0]).addFields(program.fields), filter), program.pagesize, program.compat);
        }
    }
}

