/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.ccf.compressor;

import edu.sysu.pmglab.bytecode.ByteStream;
import edu.sysu.pmglab.ccf.compressor.ICompressor;
import edu.sysu.pmglab.ccf.compressor.gzip.GZIPCompressor;
import edu.sysu.pmglab.ccf.compressor.zstd.ZstdCompressor;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.utils.Assert;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;

public class Estimator {
    final ByteStream outputCache = new ByteStream(0x10000000);
    final Random random = new Random();
    final ICompressor compressor;
    final List<Map.Entry<Number, Number>> data = new List(1024);

    public Estimator(Class<? extends ICompressor> compressor, int compressionLevel) {
        this(ICompressor.getInstance(compressor, compressionLevel));
    }

    public Estimator(ICompressor compressor) {
        this.compressor = compressor;
    }

    public static void main(String[] args) throws IOException {
        for (Class compressor : new Class[]{ZstdCompressor.class, GZIPCompressor.class}) {
            for (int level = ICompressor.getMinCompressionLevel(compressor); level < ICompressor.getMaxCompressionLevel(compressor); ++level) {
                long start = System.currentTimeMillis();
                Estimator estimator = new Estimator(compressor, level);
                estimator.setRandomSeed(0L);
                estimator.addTrainingSets(new Range<Integer>(0, 8192, 1));
                estimator.addTrainingSets(new Range<Integer>(8192, 0x100000, 1024));
                estimator.addTrainingSets(new Range<Integer>(0x100000, 0x4000000, 0x100000));
                Model<Double> optimize = estimator.optimize();
                System.out.println(estimator.compressor.getClass() + " level " + level + "\n - Estimate " + optimize + ", loss = " + estimator.lossFunction(optimize) + ", time = " + (float)(System.currentTimeMillis() - start) / 1000.0f + " s");
            }
        }
    }

    public void setRandomSeed(long seed) {
        this.random.setSeed(seed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends Number> void addTrainingSets(Range<T> range) throws IOException {
        ICompressor iCompressor = this.compressor;
        synchronized (iCompressor) {
            ByteStream input = this.generateRandomData(((Number)range.end).intValue());
            input.wSeek(0);
            while (range.hasNext()) {
                T currentSize = range.getNext();
                this.outputCache.clear();
                int size = this.compressor.compress(input.bytes(), 0, ((Number)currentSize).intValue(), this.outputCache);
                this.data.add((Map.Entry<Number, Number>)new AbstractMap.SimpleImmutableEntry<T, Integer>(currentSize, size));
            }
        }
    }

    @SafeVarargs
    public final <T extends Number> Model<T> optimize(Range<T> ... parameters) {
        Assert.that(parameters.length >= 2);
        Model optimizeValue = null;
        double loss = Double.MAX_VALUE;
        while (parameters[0].hasNext()) {
            T currentAlpha = parameters[0].getNext();
            parameters[1].reset();
            while (parameters[1].hasNext()) {
                Number[] numberArray = new Number[]{currentAlpha, parameters[1].getNext()};
                Model model = new Model(numberArray);
                double modelLoss = this.lossFunction(model);
                if (!(modelLoss < loss)) continue;
                optimizeValue = model;
                loss = modelLoss;
            }
        }
        return optimizeValue;
    }

    public Model<Double> optimize() {
        return this.optimize(new Range<Double>(1.0, 1.05, 1.0E-4), new Range<Double>(512.0, 8192.0, 512.0));
    }

    public <T extends Number> double lossFunction(Model<T> model) {
        double loss = 0.0;
        for (Map.Entry<Number, Number> entry : this.data) {
            loss += (double)(model.fit(entry.getKey().intValue()) < entry.getValue().doubleValue() ? 1 : 0);
        }
        return loss + ((Model)model).parameters[0].doubleValue() + ((Model)model).parameters[1].doubleValue() / 1.048576E7;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteStream generateRandomData(int length) {
        ByteStream vbs = new ByteStream(length);
        Random random = this.random;
        synchronized (random) {
            this.random.nextBytes(vbs.bytes());
        }
        return vbs;
    }

    static class Range<T extends Number>
    implements Iterable<Number> {
        public final T start;
        public final T end;
        public final T step;
        private T currentValue;

        public Range(T start, T end, T step) {
            this.start = start;
            this.end = end;
            this.step = step;
            this.currentValue = start;
        }

        public void reset() {
            this.currentValue = this.start;
        }

        public T getNext() {
            T returns;
            Assert.that(this.hasNext(), "end of range");
            try {
                returns = this.currentValue;
            }
            finally {
                if (this.currentValue instanceof Byte) {
                    this.currentValue = new Byte((byte)(((Number)this.currentValue).byteValue() + ((Number)this.step).byteValue()));
                } else if (this.currentValue instanceof Short) {
                    this.currentValue = new Short((short)(((Number)this.currentValue).shortValue() + ((Number)this.step).shortValue()));
                } else if (this.currentValue instanceof Integer) {
                    this.currentValue = new Integer(((Number)this.currentValue).intValue() + ((Number)this.step).intValue());
                } else if (this.currentValue instanceof Long) {
                    this.currentValue = new Long(((Number)this.currentValue).longValue() + ((Number)this.step).longValue());
                } else if (this.currentValue instanceof Float) {
                    this.currentValue = new Float(((Number)this.currentValue).floatValue() + ((Number)this.step).floatValue());
                } else if (this.currentValue instanceof Double) {
                    this.currentValue = new Double(((Number)this.currentValue).doubleValue() + ((Number)this.step).doubleValue());
                }
            }
            return returns;
        }

        public boolean hasNext() {
            return ((Comparable)this.currentValue).compareTo(this.end) < 0;
        }

        @Override
        public Iterator<Number> iterator() {
            return new Iterator<Number>(){

                @Override
                public boolean hasNext() {
                    return this.hasNext();
                }

                @Override
                public Number next() {
                    return this.getNext();
                }
            };
        }
    }

    public static class Model<T extends Number> {
        private final T[] parameters;

        @SafeVarargs
        Model(T ... parameters) {
            this.parameters = parameters;
        }

        public double fit(int length) {
            Assert.that(length >= 0 && length <= 0x7FFFFFFD);
            return Math.max(((Number)this.parameters[0]).doubleValue() * (double)length, ((Number)this.parameters[1]).doubleValue());
        }

        public String toString() {
            return String.format("Model: %.6f * l + %d", Float.valueOf(((Number)this.parameters[0]).floatValue()), ((Number)this.parameters[1]).intValue());
        }
    }
}

